/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.log;

import io.github.wycst.wast.log.FileHandlerHolder;
import io.github.wycst.wast.log.Log;
import io.github.wycst.wast.log.LoggerManagerHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;

public class LogFactory {
    private static Map<Class<?>, Log> loggers = new ConcurrentHashMap();
    public static final String LOG_ON_CONSOLE = "java.util.logging.console";
    private static Map<String, FileHandlerHolder> fileHandlerHolders = new ConcurrentHashMap<String, FileHandlerHolder>();

    void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getLog(Class<?> logCls) {
        Class<?> clazz = logCls;
        synchronized (clazz) {
            Log log = loggers.get(logCls);
            if (log == null) {
                log = new Log(logCls);
                List<Handler> handlers = LoggerManagerHandler.matchHandlers(logCls);
                Level level = LoggerManagerHandler.matchLevel(logCls);
                if (level != null) {
                    log.setLevel(level);
                }
                for (Handler handler : handlers) {
                    log.addHandler(handler);
                }
                loggers.put(logCls, log);
            }
            return log;
        }
    }

    public static void setConsoleLevel(String consoleLevel) {
        Level levelValue = Level.parse(consoleLevel);
        LoggerManagerHandler.setConsoleLevel(levelValue);
    }

    static {
        LoggerManagerHandler.init();
    }
}

