/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.client;

import io.github.wycst.wast.clients.redis.client.CommandRuntimeEnv;
import io.github.wycst.wast.clients.redis.commands.HashCommander;
import io.github.wycst.wast.clients.redis.commands.KeyCommander;
import io.github.wycst.wast.clients.redis.commands.ListCommander;
import io.github.wycst.wast.clients.redis.commands.PubSubCommander;
import io.github.wycst.wast.clients.redis.commands.SetCommander;
import io.github.wycst.wast.clients.redis.commands.SortedSetCommander;
import io.github.wycst.wast.clients.redis.commands.StringCommander;
import io.github.wycst.wast.clients.redis.commands.TransactionCommander;
import io.github.wycst.wast.clients.redis.connection.RedisConnection;
import io.github.wycst.wast.clients.redis.data.future.RedisFuture;
import io.github.wycst.wast.clients.redis.exception.RedisException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientCommander
implements KeyCommander,
HashCommander,
StringCommander,
ListCommander,
SetCommander,
SortedSetCommander,
PubSubCommander,
TransactionCommander {
    private RedisConnection sharedConnection;
    private static ThreadLocal<CommandRuntimeEnv> runtimEnvHolder = new ThreadLocal();

    protected abstract RedisConnection getConnection();

    protected abstract RedisConnection createConnection();

    protected final synchronized RedisConnection getSharedConnection() {
        if (this.sharedConnection == null) {
            this.sharedConnection = this.createConnection();
        }
        return this.sharedConnection;
    }

    public final KeyCommander keyCommander() {
        return this;
    }

    public final HashCommander hashCommander() {
        return this;
    }

    public final StringCommander stringCommander() {
        return this;
    }

    public final ListCommander listCommander() {
        return this;
    }

    public final SetCommander setCommander() {
        return this;
    }

    public final PubSubCommander pubsubCommander() {
        return this;
    }

    private CommandRuntimeEnv getCommandRuntimeEnv() {
        CommandRuntimeEnv commandRuntimeEnv = runtimEnvHolder.get();
        if (commandRuntimeEnv == null) {
            commandRuntimeEnv = new CommandRuntimeEnv();
            runtimEnvHolder.set(commandRuntimeEnv);
        }
        return commandRuntimeEnv;
    }

    public final ClientCommander pipeline() {
        this.getCommandRuntimeEnv().setPipelined(true);
        this.getConnection().pipeline();
        return this;
    }

    public final ClientCommander closeSync() {
        this.getCommandRuntimeEnv().setSynchronized(false);
        this.getConnection().closeSync();
        return this;
    }

    public final ClientCommander sync() {
        this.getCommandRuntimeEnv().setSynchronized(true);
        this.getConnection().sync();
        return this;
    }

    protected final boolean isPipelined() {
        return this.getCommandRuntimeEnv().isPipelined();
    }

    protected final boolean isSynchronized() {
        return this.getCommandRuntimeEnv().isSynchronized();
    }

    protected final boolean isMulti() {
        return this.getCommandRuntimeEnv().isMulti();
    }

    public void executePipeline() {
        if (this.isPipelined()) {
            this.getConnection().executePipeline();
            this.getCommandRuntimeEnv().setPipelined(false);
        }
    }

    protected final void beginMulti() {
        this.getCommandRuntimeEnv().setMulti(true);
    }

    protected final void endMulti() {
        this.getCommandRuntimeEnv().setMulti(false);
    }

    public void cancelPipeline() {
        this.getConnection().cancelPipeline();
        this.getCommandRuntimeEnv().setPipelined(false);
    }

    public void close() {
        this.getConnection().close();
    }

    protected boolean validateCommand(String command) {
        return command != null && command.trim().length() > 0;
    }

    protected String[] commands(String ... commands) {
        return commands;
    }

    RedisFuture executeRedisCommand(String[] commands) {
        RedisConnection redisConnection = this.getConnection();
        redisConnection.write(commands);
        if (!this.isPipelined()) {
            return redisConnection.flush();
        }
        return null;
    }

    <E> E executeRedisCommand(String[] commands, Class<E> returnType, E asyncDefaultVal) {
        RedisFuture redisFuture = this.executeRedisCommand(commands);
        if (redisFuture != null && this.isSynchronized()) {
            Object result = redisFuture.getResult();
            if (this.isMulti()) {
                return asyncDefaultVal;
            }
            this.checkIfTypeError(result, returnType);
            return result;
        }
        return asyncDefaultVal;
    }

    private void checkIfTypeError(Object result, Class type) {
        if (result != null && !type.isInstance(result)) {
            throw new RedisException("Error Type:" + result.toString());
        }
    }
}

