/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.client;

import io.github.wycst.wast.clients.redis.client.ClientCommander;
import io.github.wycst.wast.clients.redis.connection.RedisConnection;
import io.github.wycst.wast.clients.redis.data.entry.KeyValueEntry;
import io.github.wycst.wast.clients.redis.data.entry.ScanEntry;
import io.github.wycst.wast.clients.redis.data.entry.UnionSortedSet;
import io.github.wycst.wast.clients.redis.data.entry.ZSetMember;
import io.github.wycst.wast.clients.redis.exception.RedisException;
import io.github.wycst.wast.clients.redis.exception.RedisInvalidException;
import io.github.wycst.wast.clients.redis.listener.Subscriber;
import io.github.wycst.wast.clients.redis.options.Aggregate;
import io.github.wycst.wast.clients.redis.options.CommandOptions;
import io.github.wycst.wast.clients.redis.options.ScoreOptions;
import io.github.wycst.wast.clients.redis.options.SetOptions;
import io.github.wycst.wast.clients.redis.options.SortOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RedisClient
extends ClientCommander {
    public void auth(String password) {
        RedisConnection redisConnection = this.getConnection();
        redisConnection.auth(password);
    }

    public void select(int database) {
        RedisConnection redisConnection = this.getConnection();
        redisConnection.select(database);
    }

    @Override
    public long hashSet(String key, String field, Object value) {
        this.checkIfNull(key, field);
        String[] commands = this.commands("HSET", key, field, this.ifNullValue(value, ""));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public boolean hashSetnx(String key, String field, Object value) {
        this.checkIfNull(key, field);
        String[] commands = this.commands("HSETNX", key, field, this.ifNullValue(value, ""));
        return this.executeRedisCommand(commands, Long.class, 0L) == 1L;
    }

    @Override
    public void hashMultiSet(String key, Map<String, ? extends Object> values) {
        this.checkIfNull(key);
        if (values == null || values.size() == 0) {
            return;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("HMSET");
        commandList.add(key);
        String[] commands = this.appendCommands(commandList, values);
        this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public String hashGet(String key, String field) {
        this.checkIfNull(key, field);
        String[] commands = this.commands("HGET", key, field);
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public List<String> hashMultiGet(String key, String ... fields) {
        this.checkIfNull(key);
        int fieldCount = fields.length;
        if (fieldCount == 0) {
            this.ifThrowException(new RedisInvalidException("[hashMultiGet] call error: ERR wrong number of arguments for 'hmget' command"));
        }
        String[] commands = new String[fieldCount + 2];
        commands[0] = "HMGET";
        commands[1] = key;
        System.arraycopy(fields, 0, commands, 2, fieldCount);
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public Map<String, String> hashGetAll(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("HGETALL", key);
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        List outLines = this.executeRedisCommand(commands, List.class, null);
        if (outLines == null) {
            return null;
        }
        int size = outLines.size();
        if (size % 2 == 1) {
            throw new RedisException("Data return exception");
        }
        for (int i = 0; i < size; i += 2) {
            values.put((String)outLines.get(i), (String)outLines.get(i + 1));
        }
        return values;
    }

    @Override
    public List<String> hashKeys(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("HKEYS", key);
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public List<String> hashVals(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("HVALS", key);
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public long hashLen(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("HLEN", key);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long hashDel(String key, String ... fields) {
        this.checkIfNull(key);
        int fieldCount = fields.length;
        if (fieldCount == 0) {
            this.ifThrowException(new RedisInvalidException("[hashDel] call error: ERR wrong number of arguments for 'hdel' command"));
        }
        String[] commands = new String[fieldCount + 2];
        commands[0] = "HDEL";
        commands[1] = key;
        System.arraycopy(fields, 0, commands, 2, fieldCount);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public boolean hashExists(String key, String field) {
        this.checkIfNull(key);
        String[] commands = this.commands("HEXISTS", key, field);
        return this.executeRedisCommand(commands, Long.class, 0L) == 1L;
    }

    @Override
    public long hashIncrby(String key, String field, long increment) {
        this.checkIfNull(key, field);
        String[] commands = this.commands("HASHINCRBY", key, field, String.valueOf(increment));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public double hashIncrbyfloat(String key, String field, double increment) {
        this.checkIfNull(key, field);
        String[] commands = this.commands("HASHINCRBYFLOAT", key, field, String.valueOf(increment));
        return this.executeRedisCommand(commands, Double.class, 0.0);
    }

    @Override
    public ScanEntry hashScan(String key, long cursor) {
        return this.doScanOperation("HSCAN", key, cursor);
    }

    @Override
    public ScanEntry hashScan(String key, long cursor, String pattern, long count) {
        return this.doScanOperation("HSCAN", key, cursor, pattern, count);
    }

    @Override
    public String dump(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("DUMP", key);
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public void restore(String key, long ttl, String value) {
        this.checkIfNull(key, value);
        String[] commands = this.commands("RESTORE", key, String.valueOf(ttl), value);
        String result = this.executeRedisCommand(commands, String.class, null);
        if (result != null && !"OK".equals(result)) {
            throw new RedisException(result);
        }
    }

    @Override
    public List<String> sort(String key, SortOptions sortOptions) {
        this.checkIfNull(key);
        List<String> commandList = null;
        int optionLength = 0;
        if (sortOptions != null) {
            commandList = sortOptions.buildCommands();
            optionLength = commandList.size();
        }
        String[] commands = new String[2 + optionLength];
        commands[0] = "SORT";
        commands[1] = key;
        if (optionLength > 0) {
            System.arraycopy(commandList.toArray(), 0, commands, 2, optionLength);
        }
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public String type(String key) {
        this.checkIfNull(key);
        return this.executeRedisCommand(this.commands("TYPE", key), String.class, null);
    }

    @Override
    public List<String> keys(String pattern) {
        this.checkIfNull(pattern);
        String[] commands = this.commands("KEYS", pattern);
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public ScanEntry scan(long cursor) {
        ScanEntry scanEntry = null;
        String[] commands = this.commands("SCAN", String.valueOf(cursor));
        List list = this.executeRedisCommand(commands, List.class, null);
        if (list != null && list.size() == 2) {
            scanEntry = new ScanEntry(Long.parseLong(list.get(0).toString()), (List)list.get(1));
        }
        return scanEntry;
    }

    @Override
    public ScanEntry scan(long cursor, String pattern, long count) {
        String[] commands;
        List list;
        ScanEntry scanEntry = null;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("SCAN");
        commandList.add(String.valueOf(cursor));
        if (this.validateCommand(pattern)) {
            commandList.add("MATCH");
            commandList.add(pattern);
        }
        if (count > 0L) {
            commandList.add("COUNT");
            commandList.add(String.valueOf(count));
        }
        if ((list = (List)this.executeRedisCommand(commands = commandList.toArray(new String[commandList.size()]), List.class, null)) != null && list.size() == 2) {
            scanEntry = new ScanEntry(Long.parseLong(list.get(0).toString()), (List)list.get(1));
        }
        return scanEntry;
    }

    @Override
    public void migrate(String host, int port, String key, int dbIndex, int timeout, boolean copySource, boolean replaceDestination) {
        throw new RedisException("\u4e0d\u652f\u6301MIGRATE\u547d\u4ee4");
    }

    @Override
    public long move(String key, int dbIndex) {
        this.checkIfNull(key);
        String[] commands = this.commands("MOVE", key, String.valueOf(dbIndex));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public void migrate(String host, int port, String key, int dbIndex, int timeout) {
        this.migrate(host, port, key, dbIndex, timeout, false, false);
    }

    @Override
    public <E> E object(CommandOptions<E> commandOptions, String key) {
        Integer defaultVal;
        this.checkIfNull(key);
        if (commandOptions == null) {
            throw new RedisInvalidException("[object] call error: ERR Unknown subcommand or wrong number of arguments for 'object' command");
        }
        String[] commands = this.commands("OBJECT", commandOptions.getCode(), key);
        Class<E> typeCls = commandOptions.getTypeCls();
        boolean typeNumber = Number.class.isAssignableFrom(typeCls);
        Integer def = defaultVal = Number.class.isAssignableFrom(typeCls) ? Integer.valueOf(-1) : null;
        Integer result = this.executeRedisCommand(commands, commandOptions.getTypeCls(), def);
        if (result == null && typeNumber) {
            return (E)def;
        }
        return (E)result;
    }

    @Override
    public long persist(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("PERSIST", key);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long del(String ... keys) {
        this.checkIfNull(keys);
        int keyCount = keys.length;
        if (keyCount == 0) {
            this.ifThrowException(new RedisInvalidException("[del] call error: ERR wrong number of arguments for 'del' command"));
        }
        String[] commands = new String[keyCount + 1];
        commands[0] = "DEL";
        System.arraycopy(keys, 0, commands, 1, keyCount);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public boolean exists(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("EXISTS", key);
        return this.executeRedisCommand(commands, Long.class, 0L) == 1L;
    }

    @Override
    public boolean rename(String oldKey, String newKey) {
        this.checkIfNull(oldKey, newKey);
        String[] commands = this.commands("RENAME", oldKey, newKey);
        return "OK".equals(this.executeRedisCommand(commands, String.class, null));
    }

    @Override
    public boolean renamenx(String key, String newKey) {
        this.checkIfNull(key, newKey);
        String[] commands = this.commands("RENAMENX", key, newKey);
        return this.executeRedisCommand(commands, Long.class, 0L) == 1L;
    }

    @Override
    public String randomKey() {
        String[] commands = this.commands("RANDOMKEY");
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public long expire(String key, long seconds) {
        this.checkIfNull(key);
        String[] commands = this.commands("EXPIRE", key, String.valueOf(seconds));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long expireAt(String key, long secondTimestamp) {
        this.checkIfNull(key);
        String[] commands = this.commands("EXPIREAT", key, String.valueOf(secondTimestamp));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long pexpire(String key, long milliseconds) {
        this.checkIfNull(key);
        String[] commands = this.commands("PEXPIRE", key, String.valueOf(milliseconds));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long pexpireAt(String key, long millisecondTimestamp) {
        this.checkIfNull(key);
        String[] commands = this.commands("PEXPIREAT", key, String.valueOf(millisecondTimestamp));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long ttl(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("TTL", key);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long pttl(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("PTTL", key);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public void set(String key, Object value) {
        this.checkIfNull(key);
        String[] commands = this.commands("SET", key, this.ifNullValue(value, ""));
        this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public void set(String key, Object value, long milliseconds) {
        this.checkIfNull(key);
        String[] commands = this.commands("SET", key, this.ifNullValue(value, ""), "PX", String.valueOf(milliseconds));
        this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public void set(String key, Object value, long count, TimeUnit timeUnit) {
        this.checkIfNull(key);
        String[] commands = this.commands("SET", key, this.ifNullValue(value, ""), timeUnit == TimeUnit.SECONDS ? "EX" : "PX", String.valueOf(count));
        this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public boolean set(String key, Object value, SetOptions setOptions) {
        this.checkIfNull(key);
        List<String> commandList = null;
        int optionLength = 0;
        if (setOptions != null) {
            commandList = setOptions.buildCommands();
            optionLength = commandList.size();
        }
        String[] commands = new String[3 + optionLength];
        commands[0] = "SET";
        commands[1] = key;
        commands[2] = this.ifNullValue(value, "");
        if (optionLength > 0) {
            System.arraycopy(commandList.toArray(), 0, commands, 3, optionLength);
        }
        String resultValue = this.executeRedisCommand(commands, String.class, null);
        return "OK".equals(resultValue);
    }

    @Override
    public void psetex(String key, Object value, long milliseconds) {
        this.checkIfNull(key);
        String result = this.executeRedisCommand(this.commands("PSETEX", key, String.valueOf(milliseconds), this.ifNullValue(value, "")), String.class, null);
        if (result != null && "OK".equals(result)) {
            this.ifThrowException(new RedisException(result));
        }
    }

    @Override
    public void setex(String key, Object value, long seconds) {
        this.checkIfNull(key);
        String result = this.executeRedisCommand(this.commands("SETEX", key, String.valueOf(seconds), this.ifNullValue(value, "")), String.class, null);
        if (result != null && "OK".equals(result)) {
            this.ifThrowException(new RedisException(result));
        }
    }

    @Override
    public long append(String key, Object value) {
        this.checkIfNull(key);
        String[] commands = this.commands("APPEND", key, this.ifNullValue(value, ""));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public String getset(String key, Object value) {
        this.checkIfNull(key);
        String[] commands = this.commands("GET", key, this.ifNullValue(value, ""));
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public long strLen(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("STRLEN", key);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public String get(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("GET", key);
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public String getRange(String key, int fromIndex, int toIndex) {
        this.checkIfNull(key);
        String[] commands = this.commands("GETRANGE", key, String.valueOf(fromIndex), String.valueOf(toIndex));
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public void mset(Map<String, ? extends Object> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("MSET");
        String[] commands = this.appendCommands(commandList, values);
        this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public boolean msetnx(Map<String, ? extends Object> values) {
        if (values == null || values.size() == 0) {
            return false;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("MSETNX");
        String[] commands = this.appendCommands(commandList, values);
        return 1L == this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public List<String> mget(String ... keys) {
        this.checkIfNull(keys);
        int keyCount = keys.length;
        if (keyCount == 0) {
            this.ifThrowException(new RedisInvalidException("[mget] call error: ERR wrong number of arguments for 'mget' command"));
        }
        String[] commands = new String[keyCount + 1];
        commands[0] = "MGET";
        System.arraycopy(keys, 0, commands, 1, keyCount);
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public long bitcount(String key) {
        return this.bitcount(key, 0, -1);
    }

    @Override
    public long bitcount(String key, int start, int end) {
        this.checkIfNull(key);
        String[] commands = this.commands("BITCOUNT", String.valueOf(start), String.valueOf(end));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long bitopAnd(String destkey, String ... keys) {
        return this.doBitop("AND", destkey, keys);
    }

    @Override
    public long bitopOr(String destkey, String ... keys) {
        return this.doBitop("OR", destkey, keys);
    }

    @Override
    public long bitopXor(String destkey, String ... keys) {
        return this.doBitop("XOR", destkey, keys);
    }

    @Override
    public long bitopNot(String destkey, String key) {
        return this.doBitop("NOT", destkey, key);
    }

    private long doBitop(String op, String destkey, String ... keys) {
        this.checkIfNull(destkey);
        this.checkIfNull(keys);
        int keysLength = keys.length;
        if (keysLength == 0) {
            this.ifThrowException(new RedisInvalidException("[BITOP " + op + "] call error: ERR wrong number of arguments for 'BITOP " + op + "' command"));
        }
        String[] commands = new String[keysLength + 3];
        commands[0] = "BITOP";
        commands[1] = op;
        commands[2] = destkey;
        System.arraycopy(keys, 0, commands, 3, keysLength);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long setbit(String key, int offset, int value) {
        this.checkIfNull(key);
        if (offset < 0) {
            this.ifThrowException(new RedisInvalidException("ERR setbit offset[" + offset + "] is out of range for Less than 0 "));
        }
        if (value < 0 || value > 1) {
            this.ifThrowException(new RedisInvalidException("ERR setbit value[" + value + "] is out of range,The Value Can only be 0 or 1 "));
        }
        String[] commands = this.commands("SETBIT", key, String.valueOf(offset), String.valueOf(value));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long getbit(String key, int offset) {
        this.checkIfNull(key);
        if (offset < 0) {
            this.ifThrowException(new RedisInvalidException("ERR setbit offset[" + offset + "] is out of range for Less than 0 "));
        }
        String[] commands = this.commands("GETBIT", key, String.valueOf(offset));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long decr(String key) {
        this.checkIfNull(key);
        return this.executeRedisCommand(this.commands("DECR", key), Long.class, 0L);
    }

    @Override
    public long incr(String key) {
        this.checkIfNull(key);
        return this.executeRedisCommand(this.commands("INCR", key), Long.class, 0L);
    }

    @Override
    public long decrby(String key, long decrement) {
        this.checkIfNull(key);
        return this.executeRedisCommand(this.commands("DECRBY", key, String.valueOf(decrement)), Long.class, 0L);
    }

    @Override
    public long incrby(String key, long increment) {
        this.checkIfNull(key);
        return this.executeRedisCommand(this.commands("INCRBY", key, String.valueOf(increment)), Long.class, 0L);
    }

    @Override
    public double incrbyfloat(String key, double increment) {
        this.checkIfNull(key);
        String result = this.executeRedisCommand(this.commands("INCRBYFLOAT", key, String.valueOf(increment)), String.class, null);
        if (result != null) {
            try {
                return Double.parseDouble(result);
            }
            catch (NumberFormatException exception) {
                this.ifThrowException(new RedisException(result));
            }
        }
        return 0.0;
    }

    @Override
    public String lpop(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("LPOP", key);
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public String rpop(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("RPOP", key);
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public long lpush(String key, String ... values) {
        return this.push("LPUSH", key, values);
    }

    @Override
    public long rpush(String key, String ... values) {
        return this.push("RPUSH", key, values);
    }

    @Override
    public long lpushx(String key, String value) {
        return this.pushx("LPUSHX", key, value);
    }

    @Override
    public long rpushx(String key, String value) {
        return this.pushx("RPUSHX", key, value);
    }

    private long push(String pushCommand, String key, String[] values) {
        this.checkIfNull(key);
        this.checkIfNull(values);
        int valueCount = values.length;
        if (valueCount == 0) {
            this.ifThrowException(new RedisInvalidException("[push] call error: ERR wrong number of arguments for '" + pushCommand + "' command"));
        }
        String[] commands = new String[valueCount + 2];
        commands[0] = pushCommand;
        commands[1] = key;
        System.arraycopy(values, 0, commands, 2, valueCount);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    private long pushx(String pushxCommand, String key, String value) {
        this.checkIfNull(key, value);
        String[] commands = this.commands(pushxCommand, key, value);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public String lindex(String key, int index) {
        this.checkIfNull(key);
        String[] commands = this.commands("LINDEX", key, String.valueOf(index));
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public long linsert(String key, int direct, String pivot, String value) {
        this.checkIfNull(key);
        String[] commands = this.commands("LINSERT", key, direct == 0 ? "BEFORE" : "AFTER", pivot, this.ifNullValue(value, ""));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long llen(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("LLEN", key);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public List<String> lrange(String key, int start, int stop) {
        this.checkIfNull(key);
        String[] commands = this.commands("LRANGE", key, String.valueOf(start), String.valueOf(stop));
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public long lrem(String key, int count, String value) {
        this.checkIfNull(key);
        String[] commands = this.commands("LREM", key, String.valueOf(count), this.ifNullValue(value, ""));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public void lset(String key, int index, String value) {
        this.checkIfNull(key);
        String[] commands = this.commands("LSET", key, String.valueOf(index), this.ifNullValue(value, ""));
        String result = this.executeRedisCommand(commands, String.class, null);
        if (result != null && !"OK".equals(result)) {
            throw new RedisException(result);
        }
    }

    @Override
    public void ltrim(String key, int start, int stop) {
        this.checkIfNull(key);
        String[] commands = this.commands("LTRIM", key, String.valueOf(start), String.valueOf(stop));
        this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public String rpoplpush(String source, String destination) {
        this.checkIfNull(source, destination);
        String[] commands = this.commands("RPOPLPUSH", source, destination);
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public KeyValueEntry blpop(String ... keys) {
        return this.blpop(keys, 0);
    }

    @Override
    public KeyValueEntry blpop(Collection<String> keys) {
        return this.blpop(keys, 0);
    }

    @Override
    public KeyValueEntry blpop(String[] keys, int timeout) {
        this.checkIfNull(keys);
        int keyCount = keys.length;
        if (keyCount == 0) {
            throw new RedisInvalidException("[blpop] call error: ERR wrong number of arguments for 'blpop' command");
        }
        String[] commands = new String[2 + keyCount];
        commands[0] = "BLPOP";
        System.arraycopy(keys, 0, commands, 1, keyCount);
        commands[keyCount + 1] = String.valueOf(timeout);
        List returnVal = this.executeRedisCommand(commands, List.class, null);
        if (returnVal == null) {
            return null;
        }
        if (returnVal.size() != 2) {
            throw new RedisException("Data return exception");
        }
        KeyValueEntry keyValueEntry = new KeyValueEntry((String)returnVal.get(0), (String)returnVal.get(1));
        return keyValueEntry;
    }

    @Override
    public KeyValueEntry blpop(Collection<String> keys, int timeout) {
        if (keys != null) {
            return this.blpop(keys.toArray(new String[keys.size()]), timeout);
        }
        return null;
    }

    @Override
    public long sAdd(String key, String ... values) {
        this.checkIfNull(key);
        int valueCount = values.length;
        if (valueCount == 0) {
            this.ifThrowException(new RedisInvalidException("[SAdd] call error: ERR wrong number of arguments for 'SAdd' command"));
        }
        String[] commands = new String[valueCount + 2];
        commands[0] = "SADD";
        commands[1] = key;
        System.arraycopy(values, 0, commands, 2, valueCount);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long sCard(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("SCARD", key);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public List<String> sDiff(String key, String ... keys) {
        return this.doSetOperation("SDIFF", key, keys);
    }

    @Override
    public long sDiffStore(String destination, String key, String ... keys) {
        return this.doSetOperationStore("SDIFFSTORE", destination, key, keys);
    }

    @Override
    public List<String> sInter(String key, String ... keys) {
        return this.doSetOperation("SINTER", key, keys);
    }

    @Override
    public long sInterStore(String destination, String key, String ... keys) {
        return this.doSetOperationStore("SINTERSTORE", destination, key, keys);
    }

    @Override
    public boolean sIsMember(String key, String member) {
        this.checkIfNull(key);
        String[] commands = this.commands("SISMEMBER", key, member);
        long result = this.executeRedisCommand(commands, Long.class, 0L).intValue();
        return result == 1L;
    }

    @Override
    public List<String> sMembers(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("SMEMBERS", key);
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public boolean sMove(String source, String destination, String member) {
        this.checkIfNull(source, destination, member);
        String[] commands = this.commands("SMOVE", source, destination, member);
        long result = this.executeRedisCommand(commands, Long.class, 0L);
        return result == 1L;
    }

    @Override
    public String sPop(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("SPOP", key);
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public String sRandMember(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("SRANDMEMBER", key);
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public List<String> sRandMember(String key, int count) {
        this.checkIfNull(key);
        String[] commands = this.commands("SRANDMEMBER", key, String.valueOf(count));
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public long sRem(String key, String member, String ... members) {
        this.checkIfNull(key);
        int length = members.length;
        String[] commands = new String[length + 2];
        commands[0] = "SREM";
        commands[1] = key;
        commands[2] = member;
        if (length > 0) {
            System.arraycopy(members, 0, commands, 3, length);
        }
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public List<String> sUnion(String key, String ... keys) {
        return this.doSetOperation("SUNION", key, keys);
    }

    @Override
    public long sUnionStore(String destination, String key, String ... keys) {
        return this.doSetOperationStore("SUNIONSTORE", destination, key, keys);
    }

    @Override
    public ScanEntry sScan(String key, long cursor) {
        return this.doScanOperation("SSCAN", key, cursor);
    }

    @Override
    public ScanEntry sScan(String key, long cursor, String pattern, long count) {
        return this.doScanOperation("SSCAN", key, cursor, pattern, count);
    }

    private ScanEntry doScanOperation(String operation, String key, long cursor) {
        this.checkIfNull(key);
        ScanEntry scanEntry = null;
        String[] commands = this.commands(operation, key, String.valueOf(cursor));
        List list = this.executeRedisCommand(commands, List.class, null);
        if (list != null && list.size() == 2) {
            scanEntry = new ScanEntry(Long.parseLong(list.get(0).toString()), (List)list.get(1));
        }
        return scanEntry;
    }

    private ScanEntry doScanOperation(String operation, String key, long cursor, String pattern, long count) {
        String[] commands;
        List list;
        this.checkIfNull(key);
        ScanEntry scanEntry = null;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(operation);
        commandList.add(key);
        commandList.add(String.valueOf(cursor));
        if (this.validateCommand(pattern)) {
            commandList.add("MATCH");
            commandList.add(pattern);
        }
        if (count > 0L) {
            commandList.add("COUNT");
            commandList.add(String.valueOf(count));
        }
        if ((list = (List)this.executeRedisCommand(commands = commandList.toArray(new String[commandList.size()]), List.class, null)) != null && list.size() == 2) {
            scanEntry = new ScanEntry(Long.parseLong(list.get(0).toString()), (List)list.get(1));
        }
        return scanEntry;
    }

    private List<String> doSetOperation(String operation, String key, String[] keys) {
        this.checkIfNull(key);
        int keysCount = keys.length;
        String[] commands = new String[keysCount + 2];
        commands[0] = operation;
        commands[1] = key;
        if (keysCount > 0) {
            System.arraycopy(keys, 0, commands, 2, keysCount);
        }
        return this.executeRedisCommand(commands, List.class, null);
    }

    private long doSetOperationStore(String operation, String destination, String key, String ... keys) {
        this.checkIfNull(destination, key);
        int keysCount = keys.length;
        String[] commands = new String[keysCount + 3];
        commands[0] = operation;
        commands[1] = destination;
        commands[2] = key;
        if (keysCount > 0) {
            System.arraycopy(keys, 0, commands, 3, keysCount);
        }
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long zAdd(String key, double score, String member) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZADD", key, String.valueOf(score), this.ifNullValue(member, ""));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long zAdd(String key, ZSetMember member, ZSetMember ... members) {
        this.checkIfNull(key);
        if (member == null) {
            this.ifThrowException(new RedisInvalidException("[zadd] call error: ERR wrong number of arguments for 'zadd' command"));
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("ZADD");
        commandList.add(key);
        commandList.add(String.valueOf(member.getScore()));
        commandList.add(this.ifNullValue(member.getMember(), ""));
        for (ZSetMember zmember : members) {
            commandList.add(String.valueOf(zmember.getScore()));
            commandList.add(this.ifNullValue(zmember.getMember(), ""));
        }
        String[] commands = commandList.toArray(new String[commandList.size()]);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long zCard(String key) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZCARD", key);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long zCount(String key, double min, double max) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZCOUNT", key, String.valueOf(min), String.valueOf(max));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public String zIncrby(String key, double increment, String member) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZINCRBY", key, String.valueOf(increment), this.ifNullValue(member, ""));
        return this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public List<String> zRange(String key, long start, long stop) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZRANGE", key, String.valueOf(start), String.valueOf(stop));
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public List<? extends Object> zRange(String key, long start, long stop, boolean withscores) {
        if (!withscores) {
            return this.zRange(key, start, stop);
        }
        return this.doRangeWithScore("ZRANGE", key, start, stop);
    }

    @Override
    public List<? extends Object> zRangeByScore(String key, double min, double max, ScoreOptions scoreOptions) {
        return this.zRangeByScore(key, String.valueOf(min), String.valueOf(max), scoreOptions);
    }

    @Override
    public List<? extends Object> zRangeByScore(String key, String minExpr, String maxExpr, ScoreOptions scoreOptions) {
        List results;
        this.checkIfNull(key);
        List<String> commandList = null;
        int optionLength = 0;
        boolean withscores = false;
        if (scoreOptions != null) {
            withscores = scoreOptions.isWithscores();
            commandList = scoreOptions.buildCommands();
            optionLength = commandList.size();
        }
        String[] commands = new String[4 + optionLength];
        commands[0] = "ZRANGEBYSCORE";
        commands[1] = key;
        commands[2] = minExpr;
        commands[3] = maxExpr;
        if (optionLength > 0) {
            System.arraycopy(commandList.toArray(), 0, commands, 4, optionLength);
        }
        if ((results = (List)this.executeRedisCommand(commands, List.class, null)) == null || !withscores) {
            return results;
        }
        return this.toZSetMembers(results);
    }

    @Override
    public long zRank(String key, String member) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZRANK", key, member);
        Long value = this.executeRedisCommand(commands, Long.class, null);
        return value == null ? -1L : value;
    }

    @Override
    public long zRem(String key, String member, String ... members) {
        this.checkIfNull(key);
        String[] baseCommands = this.commands("ZREM", key, this.ifNullValue(member, ""));
        String[] commands = new String[3 + members.length];
        System.arraycopy(baseCommands, 0, commands, 0, 3);
        System.arraycopy(members, 0, commands, 3, members.length);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long zRemRangeByRank(String key, long start, long stop) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZREMRANGEBYRANK", key, String.valueOf(start), String.valueOf(stop));
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public long zRemRangeByScore(String key, double min, double max) {
        return this.zRemRangeByScore(key, String.valueOf(min), String.valueOf(max));
    }

    @Override
    public long zRemRangeByScore(String key, String minExpr, String maxExpr) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZREMRANGEBYSCORE", key, minExpr, maxExpr);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public List<String> zRevRange(String key, long start, long stop) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZREVRANGE", key, String.valueOf(start), String.valueOf(stop));
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public List<? extends Object> zRevRange(String key, long start, long stop, boolean withscores) {
        if (!withscores) {
            return this.zRevRange(key, start, stop);
        }
        return this.doRangeWithScore("ZREVRANGE", key, start, stop);
    }

    @Override
    public List<? extends Object> zRevRangeByScore(String key, double min, double max, ScoreOptions scoreOptions) {
        return this.zRevRangeByScore(key, String.valueOf(min), String.valueOf(max), scoreOptions);
    }

    @Override
    public List<? extends Object> zRevRangeByScore(String key, String minExpr, String maxExpr, ScoreOptions scoreOptions) {
        List results;
        this.checkIfNull(key);
        List<String> commandList = null;
        int optionLength = 0;
        boolean withscores = false;
        if (scoreOptions != null) {
            withscores = scoreOptions.isWithscores();
            commandList = scoreOptions.buildCommands();
            optionLength = commandList.size();
        }
        String[] commands = new String[4 + optionLength];
        commands[0] = "ZREVRANGEBYSCORE";
        commands[1] = key;
        commands[2] = minExpr;
        commands[3] = maxExpr;
        if (optionLength > 0) {
            System.arraycopy(commandList.toArray(), 0, commands, 4, optionLength);
        }
        if ((results = (List)this.executeRedisCommand(commands, List.class, null)) == null || !withscores) {
            return results;
        }
        return this.toZSetMembers(results);
    }

    @Override
    public long zRevRank(String key, String member) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZREVRANK", key, this.ifNullValue(member, ""));
        Long value = this.executeRedisCommand(commands, Long.class, null);
        return value == null ? -1L : value;
    }

    @Override
    public String zScore(String key, String member) {
        this.checkIfNull(key);
        String[] commands = this.commands("ZSCORE", key, this.ifNullValue(member, ""));
        String value = this.executeRedisCommand(commands, String.class, null);
        return value;
    }

    @Override
    public long zUnionStore(String destination, List<UnionSortedSet> unionSortedSets, Aggregate aggregate) {
        return this.doZStore("ZUNIONSTORE", destination, unionSortedSets, aggregate);
    }

    @Override
    public long zInterStore(String destination, List<UnionSortedSet> unionSortedSets, Aggregate aggregate) {
        return this.doZStore("ZINTERSTORE", destination, unionSortedSets, aggregate);
    }

    @Override
    public ScanEntry zScan(String key, long cursor) {
        return this.doScanOperation("ZSCAN", key, cursor);
    }

    @Override
    public ScanEntry zScan(String key, long cursor, String pattern, long count) {
        return this.doScanOperation("ZSCAN", key, cursor, pattern, count);
    }

    private long doZStore(String storeCmd, String destination, List<UnionSortedSet> unionSortedSets, Aggregate aggregate) {
        this.checkIfNull(destination);
        if (unionSortedSets == null || unionSortedSets.size() == 0) {
            return 0L;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(storeCmd);
        commandList.add(destination);
        commandList.add(String.valueOf(unionSortedSets.size()));
        ArrayList<String> weights = new ArrayList<String>();
        for (UnionSortedSet unionSortedSet : unionSortedSets) {
            String key = unionSortedSet.getKey();
            this.checkIfNull(key);
            commandList.add(key);
            weights.add(String.valueOf(unionSortedSet.getWeight()));
        }
        commandList.add("WEIGHTS");
        commandList.addAll(weights);
        if (aggregate != null) {
            commandList.add("AGGREGATE");
            commandList.add(aggregate.toString());
        }
        String[] commands = commandList.toArray(new String[commandList.size()]);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    private List<ZSetMember> doRangeWithScore(String command, String key, long start, long stop) {
        this.checkIfNull(key);
        String[] commands = this.commands(command, key, String.valueOf(start), String.valueOf(stop), "WITHSCORES");
        List results = this.executeRedisCommand(commands, List.class, null);
        if (results != null) {
            return this.toZSetMembers(results);
        }
        return null;
    }

    private List<ZSetMember> toZSetMembers(List<String> results) {
        ArrayList<ZSetMember> zSetMembers = new ArrayList<ZSetMember>();
        ZSetMember zSetMember = null;
        for (int i = 0; i < results.size(); i += 2) {
            String member = results.get(i);
            String score = results.get(i + 1);
            zSetMember = new ZSetMember();
            zSetMember.setMember(member);
            zSetMember.setScore(Double.parseDouble(score));
            zSetMembers.add(zSetMember);
        }
        return zSetMembers;
    }

    @Override
    public long publish(String topic, String message) {
        this.checkIfNull(topic);
        String[] commands = this.commands("PUBLISH", topic, message);
        return this.executeRedisCommand(commands, Long.class, 0L);
    }

    @Override
    public void subscribe(Subscriber subscriber) {
        this.doSubscribe("SUBSCRIBE", subscriber);
    }

    @Override
    public void psubscribe(Subscriber subscriber) {
        this.doSubscribe("PSUBSCRIBE", subscriber);
    }

    public void doSubscribe(String subCommand, Subscriber subscriber) {
        String[] channels = subscriber.getChannels();
        this.checkIfNull(channels);
        RedisConnection connection = this.getSharedConnection();
        if (connection.isPipelined()) {
            throw new RedisException("Unsupported operation[" + subCommand + "] because pipeline is running... ");
        }
        String[] commands = new String[channels.length + 1];
        commands[0] = subCommand;
        System.arraycopy(channels, 0, commands, 1, channels.length);
        connection.subscribe(commands, subscriber);
    }

    @Override
    public void unsubscribe(String ... channels) {
        this.doUnsubscribe("UNSUBSCRIBE", channels);
    }

    @Override
    public void punsubscribe(String ... channelPatterns) {
        this.doUnsubscribe("PUNSUBSCRIBE", channelPatterns);
    }

    private void doUnsubscribe(String command, String ... channels) {
        this.checkIfNull(channels);
        RedisConnection connection = this.getSharedConnection();
        if (connection.isPipelined()) {
            throw new RedisException("Unsupported operation[" + command + "] because pipeline is running... ");
        }
        connection.unsubscribe(command, channels);
    }

    @Override
    public List<String> pubsubChannels(String pattern) {
        String[] commands = this.commands("PUBSUB", "CHANNELS", this.ifNullValue(pattern, "*"));
        return this.executeRedisCommand(commands, List.class, null);
    }

    @Override
    public Map<String, Long> pubsubNumsub(String ... channels) {
        this.checkIfNull(channels);
        String[] commands = new String[channels.length + 2];
        commands[0] = "PUBSUB";
        commands[1] = "NUMSUB";
        System.arraycopy(channels, 0, commands, 2, channels.length);
        LinkedHashMap<String, Long> channelNums = new LinkedHashMap<String, Long>();
        List results = this.executeRedisCommand(commands, List.class, null);
        if (results != null) {
            int size = results.size();
            if (size % 2 == 1) {
                throw new RedisException("Data return exception");
            }
            for (int i = 0; i < size; i += 2) {
                channelNums.put((String)results.get(i), (Long)results.get(i + 1));
            }
        }
        return channelNums;
    }

    @Override
    public long pubsubNumpat() {
        return this.executeRedisCommand(this.commands("PUBSUB", "NUMPAT"), Long.class, 0L);
    }

    @Override
    public void multi() {
        this.beginMulti();
        this.executeRedisCommand(this.commands("MULTI"), String.class, null);
    }

    @Override
    public Object exec() {
        this.endMulti();
        return this.executeRedisCommand(this.commands("EXEC"), List.class, null);
    }

    @Override
    public void discard() {
        this.endMulti();
        this.executeRedisCommand(this.commands("DISCARD"), String.class, null);
    }

    @Override
    public void watch(String ... keys) {
        this.checkIfNull(keys);
        int keyCount = keys.length;
        if (keyCount == 0) {
            this.ifThrowException(new RedisInvalidException("[watch] call error: ERR wrong number of arguments for 'watch' command"));
        }
        String[] commands = new String[keyCount + 1];
        commands[0] = "WATCH";
        System.arraycopy(keys, 0, commands, 1, keyCount);
        this.executeRedisCommand(commands, String.class, null);
    }

    @Override
    public void unwatch() {
        this.executeRedisCommand(this.commands("UNWATCH"), String.class, null);
    }

    private String ifNullValue(Object value, String defaultValue) {
        return value == null ? defaultValue : String.valueOf(value).trim();
    }

    private void checkIfNull(String ... commands) {
        for (String command : commands) {
            if (this.validateCommand(command)) continue;
            this.ifThrowException(new RedisInvalidException("Invalid Redis Key ['" + command + "']"));
        }
    }

    private void ifThrowException(RuntimeException exception) {
        if (!this.isMulti()) {
            throw exception;
        }
    }

    private String[] appendCommands(List<String> commandList, Map<String, ? extends Object> values) {
        if (values != null) {
            for (String entryKey : values.keySet()) {
                Object entryValue = values.get(entryKey);
                if (!this.validateCommand(entryKey)) continue;
                commandList.add(entryKey);
                if (entryValue instanceof byte[]) {
                    commandList.add(new String((byte[])entryValue));
                    continue;
                }
                commandList.add(this.ifNullValue(entryValue, ""));
            }
        }
        return commandList.toArray(new String[commandList.size()]);
    }
}

