/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.connection;

import io.github.wycst.wast.clients.redis.connection.RedisConnection;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import java.util.concurrent.CountDownLatch;

class PooledRedisConnection
extends RedisConnection {
    private CountDownLatch nextCountDownLatch;
    private ChannelPool channelPool;

    PooledRedisConnection(Channel channel, boolean await) {
        super(channel, await);
    }

    public final boolean recycleable() {
        return !this.recycled();
    }

    private boolean recycled() {
        return this.isClosed();
    }

    void setNextCountDownLatch(CountDownLatch nextCountDownLatch) {
        this.nextCountDownLatch = nextCountDownLatch;
    }

    void setChannelPool(ChannelPool channelPool) {
        this.channelPool = channelPool;
    }

    protected void afterQueueResponse() {
        super.afterQueueResponse();
        if (this.nextCountDownLatch != null) {
            this.nextCountDownLatch.countDown();
        }
    }

    public void close() {
        Channel channel = this.getChannel();
        if (channel.isActive()) {
            this.channelPool.release(channel);
        } else {
            channel.close();
        }
        this.nextCountDownLatch = null;
        this.channelPool = null;
        super.close();
    }
}

