/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.data.future;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RedisFuture<E>
implements Future<E> {
    private LockResult lockResult = new LockResult();
    private boolean done = false;
    private boolean waitingDone = false;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public void set(Object result) {
        this.lockResult.set(result);
        this.lockResult.unlock();
        this.waitingDone = false;
        this.done = true;
    }

    public void sync() throws InterruptedException {
        this.waitingDone = true;
        this.lockResult.sync();
    }

    @Override
    public E get() throws InterruptedException, ExecutionException {
        return (E)this.lockResult.get();
    }

    @Override
    public E get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (E)this.lockResult.get(timeout, unit);
    }

    public abstract boolean isKeepAlive();

    public E getResult() {
        try {
            return this.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    private class LockResult {
        private CountDownLatch countDownLatch = new CountDownLatch(1);
        private Object result;

        private LockResult() {
        }

        public void unlock() {
            this.countDownLatch.countDown();
        }

        public void set(Object result) {
            this.result = result;
        }

        public Object get() throws InterruptedException {
            this.countDownLatch.await();
            return this.result;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException {
            this.countDownLatch.await(timeout, unit);
            return this.result;
        }

        public void sync() throws InterruptedException {
            this.countDownLatch.await();
        }
    }
}

