/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.netty;

import io.github.wycst.wast.clients.redis.exception.RedisConnectionException;
import io.github.wycst.wast.clients.redis.netty.RedisChannelHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.redis.RedisArrayAggregator;
import io.netty.handler.codec.redis.RedisBulkStringAggregator;
import io.netty.handler.codec.redis.RedisDecoder;
import io.netty.handler.codec.redis.RedisEncoder;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class RedisBootstrap
extends Bootstrap {
    private EventLoopGroup group = new NioEventLoopGroup();
    private static RedisBootstrap redisBootstrap;

    private RedisBootstrap() {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new RedisDecoder()});
                pipeline.addLast(new ChannelHandler[]{new RedisBulkStringAggregator()});
                pipeline.addLast(new ChannelHandler[]{new RedisArrayAggregator()});
                pipeline.addLast(new ChannelHandler[]{new RedisEncoder()});
                pipeline.addLast(new ChannelHandler[]{new RedisChannelHandler()});
            }
        });
    }

    public static synchronized RedisBootstrap bootstrap() {
        if (redisBootstrap == null) {
            redisBootstrap = new RedisBootstrap();
        }
        return redisBootstrap;
    }

    public Channel channel(String host, int port) {
        return this.channel(host, port, 0L);
    }

    public Channel channel(String host, int port, long timeout) {
        try {
            ChannelFuture channelFuture = this.connect(new InetSocketAddress(host, port));
            if (timeout >= 200L) {
                channelFuture.get(timeout, TimeUnit.MILLISECONDS);
                return channelFuture.channel();
            }
            return channelFuture.sync().channel();
        }
        catch (Throwable e) {
            throw new RedisConnectionException(e.getMessage(), e);
        }
    }

    public void shutdown() {
        this.group.shutdownGracefully();
        redisBootstrap = null;
    }
}

