/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import java.nio.charset.Charset;
import java.util.Arrays;

public class ByteBuffer {
    protected byte[] buf;
    protected int writeIndex;
    protected int readIndex;

    public ByteBuffer() {
        this.buf = new byte[16];
    }

    ByteBuffer(byte[] buf) {
        this.buf = buf;
        this.writeIndex = buf.length;
    }

    public static ByteBuffer of(byte[] buf) {
        return new ByteBuffer(buf);
    }

    public void writeByte(byte value) {
        this.checkIfExpandCapacity(1);
        this.buf[this.writeIndex++] = value;
    }

    public byte readByte() {
        return this.buf[this.readIndex++];
    }

    public byte readByteKeepIndex() {
        return this.buf[this.readIndex];
    }

    public void writeBytes(byte ... values) {
        int len = values.length;
        this.checkIfExpandCapacity(len);
        System.arraycopy(values, 0, this.buf, this.writeIndex, len);
        this.writeIndex += len;
    }

    public void readBytes(byte[] bytes) {
        int len = bytes.length;
        System.arraycopy(this.buf, this.readIndex, bytes, 0, len);
        this.readIndex += len;
    }

    public void writeBoolean(boolean value) {
        this.checkIfExpandCapacity(1);
        this.buf[this.writeIndex++] = value ? (byte)1 : 0;
    }

    public boolean readBoolean() {
        return this.buf[this.readIndex++] != 0;
    }

    public boolean readBooleanKeepIndex() {
        return this.buf[this.readIndex] != 0;
    }

    public void writeChar(char value) {
        this.checkIfExpandCapacity(2);
        this.buf[this.writeIndex++] = (byte)(value >> 8 & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value & 0xFF);
    }

    public char readChar() {
        byte b1 = this.buf[this.readIndex++];
        byte b2 = this.buf[this.readIndex++];
        int value = (b1 & 0xFF) << 8;
        return (char)(value |= b2 & 0xFF);
    }

    public void writeLEChar(char value) {
        this.checkIfExpandCapacity(2);
        this.buf[this.writeIndex++] = (byte)(value & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value >> 8 & 0xFF);
    }

    public char readLEChar() {
        byte b1 = this.buf[this.readIndex++];
        byte b2 = this.buf[this.readIndex++];
        int value = (b2 & 0xFF) << 8;
        return (char)(value |= b1 & 0xFF);
    }

    public void writeShort(short value) {
        this.checkIfExpandCapacity(2);
        this.buf[this.writeIndex++] = (byte)(value >> 8 & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value & 0xFF);
    }

    public short readShort() {
        return (short)this.readChar();
    }

    public void writeLEShort(short value) {
        this.checkIfExpandCapacity(2);
        this.buf[this.writeIndex++] = (byte)(value & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value >> 8 & 0xFF);
    }

    public short readLEShort() {
        return (short)this.readLEChar();
    }

    public void writeInt(int value) {
        this.checkIfExpandCapacity(4);
        this.buf[this.writeIndex++] = (byte)(value >> 24 & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value >> 16 & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value >> 8 & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value & 0xFF);
    }

    public int readInt() {
        int value = 0;
        value |= (this.buf[this.readIndex++] & 0xFF) << 24;
        value |= (this.buf[this.readIndex++] & 0xFF) << 16;
        value |= (this.buf[this.readIndex++] & 0xFF) << 8;
        return value |= this.buf[this.readIndex++] & 0xFF;
    }

    public int readIntKeepIndex() {
        int value = this.readInt();
        this.readIndex -= 4;
        return value;
    }

    public void writeLEInt(int value) {
        this.checkIfExpandCapacity(4);
        this.buf[this.writeIndex++] = (byte)(value & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value >> 8 & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value >> 16 & 0xFF);
        this.buf[this.writeIndex++] = (byte)(value >> 24 & 0xFF);
    }

    public int readLEInt() {
        int value = 0;
        value |= this.buf[this.readIndex++] & 0xFF;
        value |= (this.buf[this.readIndex++] & 0xFF) << 8;
        value |= (this.buf[this.readIndex++] & 0xFF) << 16;
        return value |= (this.buf[this.readIndex++] & 0xFF) << 24;
    }

    public int readLEIntKeepIndex() {
        int value = this.readLEInt();
        this.readIndex -= 4;
        return value;
    }

    public void writeFloat(float value) {
        int fv = Float.floatToIntBits(value);
        this.writeInt(fv);
    }

    public void writeLEFloat(float value) {
        int fv = Float.floatToIntBits(value);
        this.writeLEInt(fv);
    }

    public void writeLong(long value) {
        this.checkIfExpandCapacity(8);
        this.buf[this.writeIndex++] = (byte)(value >> 56 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 48 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 40 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 32 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 24 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 16 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 8 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value & 0xFFL);
    }

    public void writeLELong(long value) {
        this.checkIfExpandCapacity(8);
        this.buf[this.writeIndex++] = (byte)(value & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 8 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 16 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 24 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 32 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 40 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 48 & 0xFFL);
        this.buf[this.writeIndex++] = (byte)(value >> 56 & 0xFFL);
    }

    public void writeDouble(double value) {
        long dv = Double.doubleToLongBits(value);
        this.writeLong(dv);
    }

    public void writeLEDouble(double value) {
        long dv = Double.doubleToLongBits(value);
        this.writeLELong(dv);
    }

    public void writeString(String value) {
        byte[] bytes = value.getBytes(Charset.forName("UTF-8"));
        int len = bytes.length;
        this.checkIfExpandCapacity(len);
        System.arraycopy(bytes, 0, this.buf, this.writeIndex, len);
        this.writeIndex += len;
    }

    public String readString(int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.buf, this.readIndex, bytes, 0, length);
        return new String(bytes, Charset.forName("UTF-8"));
    }

    private void checkIfExpandCapacity(int len) {
        int newWriteIndex = this.writeIndex + len;
        if (newWriteIndex > this.buf.length) {
            this.expandCapacity(Math.max(this.buf.length << 1, this.buf.length + newWriteIndex));
        }
    }

    void expandCapacity(int capacity) {
        this.buf = Arrays.copyOf(this.buf, capacity);
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.buf, this.writeIndex);
    }

    public void setWriteIndex(int writeIndex) {
        this.writeIndex = writeIndex;
    }

    public void setReadIndex(int readIndex) {
        this.readIndex = readIndex;
    }
}

