/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.AbstractCharSource;
import io.github.wycst.wast.common.beans.CharSource;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;

public class CharArraySource
extends AbstractCharSource
implements CharSource {
    private final char[] source;

    CharArraySource(char[] source) {
        super(0, source.length);
        this.source = source;
    }

    public static CharArraySource of(char[] source) {
        return new CharArraySource(source);
    }

    public char[] charArray() {
        return this.source;
    }

    public byte[] byteArray() {
        throw new UnsupportedOperationException();
    }

    public char charAt(int index) {
        return this.source[index];
    }

    public String getString(int offset, int len) {
        return new String(this.source, offset, len);
    }

    public void writeTo(Writer writer, int offset, int len) throws IOException {
        writer.write(this.source, offset, len);
    }

    public void appendTo(StringBuffer stringBuffer, int offset, int len) {
        stringBuffer.append(this.source, offset, len);
    }

    public void appendTo(StringBuilder stringBuilder, int offset, int len) {
        stringBuilder.append(this.source, offset, len);
    }

    public void copy(int srcOff, char[] target, int tarOff, int len) {
        System.arraycopy(this.source, srcOff, target, tarOff, len);
    }

    public BigDecimal ofBigDecimal(int fromIndex, int len) {
        return new BigDecimal(this.source, fromIndex, len);
    }

    public int indexOf(char ch, int beginIndex) {
        throw new UnsupportedOperationException();
    }

    public String substring(int beginIndex, int endIndex) {
        throw new UnsupportedOperationException();
    }

    public String input() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new String(this.source, this.fromIndex(), this.length());
    }
}

