/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.beans.GeneralDate;
import java.io.Serializable;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Date
extends GeneralDate
implements Serializable,
Comparable<Date> {
    public static final GeneralDate MIN_DATE = GeneralDate.of(1, 1, 1, 0, 0, 0, 0);
    protected int dayOfWeek;
    protected int weekOfMonth;
    protected int weekOfYear;

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long timeMills) {
        this(timeMills, (TimeZone)null);
    }

    public Date(TimeZone timeZone) {
        this(System.currentTimeMillis(), timeZone);
    }

    public Date(long timeMills, TimeZone timeZone) {
        super(timeZone);
        this.setTime(timeMills);
    }

    public Date(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0, null);
    }

    public Date(int year, int month, int day, int hour, int minute, int second, int millsecond) {
        this(year, month, day, hour, minute, second, millsecond, null);
    }

    public Date(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        super(timeZone);
        this.set(year, month, day, hour, minute, second, millisecond, timeZone);
    }

    public static Date parse(String dateStr) {
        GeneralDate generalDate = Date.parseGeneralDate(dateStr, null);
        return new Date(generalDate.year, generalDate.month, generalDate.dayOfMonth, generalDate.hourOfDay, generalDate.minute, generalDate.second, 0);
    }

    public static Date parse(String dateStr, String template) {
        if (template == null) {
            return Date.parse(dateStr);
        }
        char[] dateBuf = dateStr.toCharArray();
        return Date.parse(dateBuf, 0, dateBuf.length, template);
    }

    public static Date parse(char[] buf, int offset, int len, String template) {
        DateTemplate dateTemplate = new DateTemplate(template);
        return Date.parse(buf, offset, len, dateTemplate);
    }

    public static Date parse(char[] buf, int offset, int len, DateTemplate dateTemplate) {
        dateTemplate.getClass();
        return dateTemplate.parse(buf, offset, len);
    }

    public Date add(int type, int count) {
        switch (type) {
            case 1: {
                this.year += count;
                this.updateTime();
                break;
            }
            case 2: {
                this.month += count;
                this.updateTime();
                break;
            }
            case 3: {
                long timeMills = this.timeMills + (long)count * 24L * 3600L * 1000L;
                this.setTime(timeMills);
                break;
            }
        }
        return this;
    }

    public long interval(Date target) {
        return target.getTime() - this.timeMills;
    }

    public long intervalDays(Date target) {
        return (target.getTime() - this.timeMills) / 86400000L;
    }

    public long intervalHours(Date target) {
        return (target.getTime() - this.timeMills) / 3600000L;
    }

    public Date set(int year, int month, int day) {
        return this.set(year, month, day, this.hourOfDay, this.minute, this.second, this.millisecond, null);
    }

    public Date set(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return this.set(year, month, day, hour, minute, second, millisecond, null);
    }

    public Date set(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        this.ofTimeZone(timeZone);
        this.year = year;
        this.month = month;
        this.dayOfMonth = day;
        this.hourOfDay = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
        this.updateTime();
        return this;
    }

    @Override
    protected void updateTime() {
        super.updateTime();
        int dayOfWeek = (int)((5L + this.currentDays - 719164L - 1L) % 7L + 1L);
        if (dayOfWeek <= 0) {
            dayOfWeek += 7;
        }
        this.dayOfWeek = dayOfWeek;
        int n = this.weekOfYear = this.daysOfYear % 7 == 0 ? this.daysOfYear / 7 : this.daysOfYear / 7 + 1;
        if (!this.validate()) {
            this.setTime(this.timeMills, true);
        }
        this.weekOfMonth = this.dayOfMonth % 7 == 0 ? this.dayOfMonth / 7 : this.dayOfMonth / 7 + 1;
        this.afterDateChange();
    }

    protected void afterDateChange() {
    }

    private boolean validate() {
        if (this.month < 1 || this.month > 12 || this.dayOfMonth < 1 || this.dayOfMonth > 31 || this.hourOfDay < 0 || this.hourOfDay > 23 || this.minute < 0 || this.minute > 59 || this.second < 0 || this.second > 59 || this.millisecond < 0 || this.millisecond > 999) {
            return false;
        }
        if (this.month == 4 || this.month == 6 || this.month == 9 || this.month == 11) {
            if (this.dayOfMonth == 31) {
                return false;
            }
        } else if (this.month == 2) {
            if (this.dayOfMonth > 29) {
                return false;
            }
            if (!this.leapYear && this.dayOfMonth == 29) {
                return false;
            }
        }
        return true;
    }

    public Date setYear(int year) {
        if (this.year == year) {
            return this;
        }
        this.year = year;
        this.updateTime();
        return this;
    }

    public Date setMonth(int month) {
        if (this.month == month) {
            return this;
        }
        this.month = month;
        this.updateTime();
        return this;
    }

    public Date setDay(int day) {
        if (this.dayOfMonth == day) {
            return this;
        }
        this.dayOfMonth = day;
        this.updateTime();
        return this;
    }

    public Date setHourOfDay(int hourOfDay) {
        if (this.hourOfDay == hourOfDay) {
            return this;
        }
        this.hourOfDay = hourOfDay;
        this.updateTime();
        return this;
    }

    public Date setMinute(int minute) {
        if (this.minute == minute) {
            return this;
        }
        this.minute = minute;
        this.updateTime();
        return this;
    }

    public Date setSecond(int second) {
        if (this.second == second) {
            return this;
        }
        this.second = second;
        this.updateTime();
        return this;
    }

    public Date setMillisecond(int millisecond) {
        if (this.millisecond == millisecond) {
            return this;
        }
        this.millisecond = millisecond;
        this.updateTime();
        return this;
    }

    public int getDaysOfYear() {
        return this.daysOfYear;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public boolean isLeapYear() {
        return this.leapYear;
    }

    @Override
    public void setTime(long timeMills, boolean reset) {
        if (this.timeMills == timeMills && !reset) {
            return;
        }
        super.setTime(timeMills, reset);
        int dayOfWeek = (int)((5L + this.currentDays - 719164L - 1L) % 7L + 1L);
        if (dayOfWeek <= 0) {
            dayOfWeek += 7;
        }
        this.dayOfWeek = dayOfWeek;
        this.weekOfMonth = this.dayOfMonth % 7 == 0 ? this.dayOfMonth / 7 : this.dayOfMonth / 7 + 1;
        this.weekOfYear = this.daysOfYear % 7 == 0 ? this.daysOfYear / 7 : this.daysOfYear / 7 + 1;
        this.afterDateChange();
    }

    public void setTime(long timeMills) {
        this.setTime(timeMills, false);
    }

    public static boolean isSameDay(long sourceTimemills, long targetTimeMills) {
        return (sourceTimemills + 62135769600000L + Date.getDefaultOffset()) / 86400000L == (targetTimeMills + 62135769600000L + Date.getDefaultOffset()) / 86400000L;
    }

    public String toString() {
        return this.format('-', ':');
    }

    public String toDateString() {
        return this.year + "-" + this.month + "-" + this.dayOfMonth + " " + this.hourOfDay + ":" + this.minute + ":" + this.second + "." + this.millisecond;
    }

    public String format() {
        return this.toString();
    }

    public String format(char dateSyntax, char timeSyntax) {
        StringBuilder buff = new StringBuilder();
        int year = this.year;
        if (year < 0) {
            buff.append("-");
            year = -year;
        }
        if (year < 10) {
            buff.append("000");
        } else if (year < 100) {
            buff.append("00");
        } else if (year < 1000) {
            buff.append("0");
        }
        buff.append(year);
        if (this.month > 0) {
            buff.append(dateSyntax);
            if (this.month < 10) {
                buff.append(0);
            }
            buff.append(this.month);
        }
        if (this.dayOfMonth > 0) {
            buff.append(dateSyntax);
            if (this.dayOfMonth < 10) {
                buff.append(0);
            }
            buff.append(this.dayOfMonth);
        }
        buff.append(' ');
        if (this.hourOfDay < 10) {
            buff.append(0);
        }
        buff.append(this.hourOfDay).append(timeSyntax);
        if (this.minute < 10) {
            buff.append(0);
        }
        buff.append(this.minute).append(timeSyntax);
        if (this.second < 10) {
            buff.append(0);
        }
        buff.append(this.second);
        return buff.toString();
    }

    public String format(String template) {
        if (template == null) {
            return this.format();
        }
        StringBuilder writer = new StringBuilder();
        this.formatTo(template, writer);
        return writer.toString();
    }

    public void formatTo(String template, Appendable appendable) {
        DateTemplate.formatTo(this.year, this.month, this.dayOfMonth, this.hourOfDay, this.minute, this.second, this.millisecond, this.dayOfWeek, this.daysOfYear, this.weekOfMonth, this.weekOfYear, this.timeZone, template, appendable);
    }

    public void formatTo(String template, Appendable appendable, boolean escapeQuot) {
        DateTemplate.formatTo(this.year, this.month, this.dayOfMonth, this.hourOfDay, this.minute, this.second, this.millisecond, this.dayOfWeek, this.daysOfYear, this.weekOfMonth, this.weekOfYear, this.timeZone, template, appendable, escapeQuot);
    }

    @Override
    public int compareTo(Date o) {
        if (this.timeMills == o.timeMills) {
            return 0;
        }
        return this.timeMills > o.timeMills ? 1 : -1;
    }

    public static void main(String[] args) {
        System.out.println(new Date((int)2199, (int)12, (int)31, (int)0, (int)0, (int)0, (int)0).timeMills);
        GeneralDate date = null;
        long l1 = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            date = new GeneralDate(l1, (TimeZone)null);
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l1);
        System.out.println(date);
        System.out.println(new Date().format("YYYY/MM/dd HH:mm:ss"));
    }
}

