/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.functions.BuiltInFunction;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluateEnvironment {
    private Map<String, ExprFunction> functionMap = new HashMap<String, ExprFunction>();
    private Object context;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private boolean useVariables;
    private boolean autoParseStringAsDouble;
    private Map<String, Method> staticMethods = new HashMap<String, Method>();
    private Set<Class> staticClassSet = new HashSet<Class>();
    private static Map<String, Method> builtInStaticMethods = new HashMap<String, Method>();
    private Map<String, ExprFunction> tempFunctionMap = new HashMap<String, ExprFunction>();

    public void setAutoParseStringAsDouble(boolean autoParseStringAsDouble) {
        this.autoParseStringAsDouble = autoParseStringAsDouble;
    }

    public boolean isAutoParseStringAsDouble() {
        return this.autoParseStringAsDouble;
    }

    private static void registerStaticMethods(boolean global, Class<?> functionClass, Map<String, Method> staticMethods) {
        Method[] methods;
        String className = functionClass.getSimpleName();
        for (Method method : methods = functionClass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            method.setAccessible(true);
            String methodName = method.getName();
            staticMethods.put(global ? methodName : className + "." + methodName, method);
        }
    }

    protected EvaluateEnvironment() {
        this.staticMethods.putAll(builtInStaticMethods);
    }

    public Object getEvaluateContext() {
        return this.useVariables ? this.variables : this.context;
    }

    public static EvaluateEnvironment create() {
        EvaluateEnvironment environment = new EvaluateEnvironment();
        environment.useVariables = true;
        return environment;
    }

    public static EvaluateEnvironment create(Object context) {
        if (context instanceof EvaluateEnvironment) {
            return (EvaluateEnvironment)context;
        }
        EvaluateEnvironment environment = new EvaluateEnvironment();
        environment.context = context;
        return environment;
    }

    public EvaluateEnvironment registerFunction(String name, ExprFunction function) {
        this.functionMap.put(name.trim(), function);
        return this;
    }

    public EvaluateEnvironment registerStaticMethods(Class<?> ... classList) {
        return this.registerStaticMethods(false, classList);
    }

    public EvaluateEnvironment registerStaticMethods(boolean global, Class<?> ... classList) {
        for (Class<?> clazz : classList) {
            if (!this.staticClassSet.add(clazz)) continue;
            EvaluateEnvironment.registerStaticMethods(global, clazz, this.staticMethods);
        }
        return this;
    }

    protected Map<String, ExprFunction> getFunctionMap() {
        return this.functionMap;
    }

    protected ExprFunction getFunction(String functionName) {
        if (this.functionMap.containsKey(functionName = functionName.trim())) {
            return this.functionMap.get(functionName);
        }
        if (this.tempFunctionMap.containsKey(functionName)) {
            return this.tempFunctionMap.get(functionName);
        }
        if (this.staticMethods.containsKey(functionName)) {
            MethodFunction exprFunction = new MethodFunction(functionName, this.staticMethods.get(functionName));
            this.tempFunctionMap.put(functionName, exprFunction);
            return exprFunction;
        }
        return null;
    }

    public EvaluateEnvironment bindings(Map<String, Object> vars) {
        this.variables.putAll(vars);
        return this;
    }

    public EvaluateEnvironment binding(String key, Object value) {
        if (this.useVariables) {
            this.variables.put(key, value);
        }
        return this;
    }

    public EvaluateEnvironment clearFunctions() {
        this.functionMap.clear();
        this.staticMethods.clear();
        this.staticClassSet.clear();
        return this;
    }

    public EvaluateEnvironment clearVariables() {
        this.variables.clear();
        return this;
    }

    public boolean isEmptyContext() {
        return this.useVariables ? this.variables.isEmpty() : this.context == null;
    }

    static {
        EvaluateEnvironment.registerStaticMethods(true, BuiltInFunction.class, builtInStaticMethods);
    }

    private class MethodFunction
    implements ExprFunction {
        private String name;
        private Method method;
        private Class[] parameterTypes;
        private int parameterLength;

        MethodFunction(String name, Method method) {
            this.name = name;
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
            this.parameterLength = this.parameterTypes.length;
        }

        public Object call(Object ... params) {
            try {
                if (this.parameterLength == 1 && this.parameterTypes[0].isArray()) {
                    Class<?> componentType = this.parameterTypes[0].getComponentType();
                    Object arrParam = Array.newInstance(componentType, params.length);
                    int i = 0;
                    for (Object param : params) {
                        Array.set(arrParam, i++, param);
                    }
                    return this.method.invoke(null, arrParam);
                }
                return this.method.invoke(null, params);
            }
            catch (Throwable e) {
                throw new ExpressionException(" method['@" + this.method + "'] invoke error: " + e.getMessage(), e);
            }
        }
    }
}

