/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.ObjectUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ExprParser
extends Expression {
    public static final int GROUP_TOKEN_OPS = 1;
    public static final int GROUP_TOKEN_VALUE = 2;
    public static final int RESET_TOKEN = 0;
    public static final int OPS_TOKEN = 1;
    public static final int VAR_TOKEN = 2;
    public static final int NUM_TOKEN = 3;
    public static final int BRACKET_TOKEN = 4;
    public static final int BRACKET_END_TOKEN = 6;
    public static final int STR_TOKEN = 7;
    public static final int ARR_TOKEN = 8;
    public static final int FUN_TOKEN = 9;
    public static final int NEGATE_TOKEN = 10;
    public static final int NOT_TOKEN = 11;
    private String exprSource;
    private char[] sourceChars;
    private int offset;
    private int count;
    private int readIndex;
    private StringBuilder tokenBuffer = new StringBuilder();
    private int prevTokenType;
    private int tokenType;
    private int numberRadix = 10;
    private int opsType;
    private int opsLevel;
    private int bracketCount;
    private ExprEvaluator exprEvaluator = this.createExprEvaluator();

    protected ExprParser(String exprSource) {
        this.init(exprSource);
        this.parse();
    }

    ExprParser(char[] buffers, int offset, int count) {
        this.init(buffers, offset, count);
        this.parse();
    }

    protected ExprParser() {
    }

    protected ExprEvaluator createExprEvaluator() {
        return new ExprEvaluator();
    }

    protected ExprEvaluator getEvaluator() {
        return this.exprEvaluator;
    }

    protected String getSource() {
        return this.exprSource;
    }

    public int length() {
        return this.count;
    }

    private void init(String exprSource) {
        this.exprSource = exprSource;
        this.count = exprSource.length();
        this.sourceChars = ExprParser.getChars(exprSource);
    }

    private void init(char[] buffers, int offset, int count) {
        this.sourceChars = buffers;
        this.offset = offset;
        this.count = count;
    }

    protected static final char[] getChars(String value) {
        return UnsafeHelper.getChars(value);
    }

    protected void parse() {
        this.parseNext(this.exprEvaluator, false, false);
        this.displacement(this.exprEvaluator);
        this.merge();
    }

    private void merge() {
    }

    private void displacement(ExprEvaluator exprEvaluator) {
        this.displacementSplit(exprEvaluator);
        this.displacementSplit(exprEvaluator);
    }

    private void displacementSplit(ExprEvaluator exprEvaluator) {
        if (exprEvaluator == null) {
            return;
        }
        String ops = exprEvaluator.getOps();
        int opsType = exprEvaluator.getOpsType();
        int level = exprEvaluator.getLevel();
        int evalType = exprEvaluator.getEvalType();
        ExprEvaluator left = exprEvaluator.getLeft();
        ExprEvaluator right = exprEvaluator.getRight();
        if (right == null) {
            return;
        }
        int rLevel = right.getLevel();
        if (rLevel <= 0) {
            return;
        }
        if (level > rLevel) {
            this.mergeRight(right, level);
            rLevel = right.getLevel();
        }
        String rOps = right.getOps();
        int rEvalType = right.getEvalType();
        ExprEvaluator rLeft = right.getLeft();
        ExprEvaluator rRight = right.getRight();
        if (level <= rLevel) {
            ExprEvaluator newLeft = this.createExprEvaluator();
            newLeft.setEvalType(evalType);
            newLeft.setOps(ops, opsType, level);
            newLeft.setNegate(exprEvaluator.negate);
            newLeft.setLogicalNot(exprEvaluator.logicalNot);
            newLeft.setLeft(left);
            newLeft.setRight(rLeft);
            exprEvaluator.setOps(rOps, right.getOpsType(), rLevel);
            exprEvaluator.setNegate(right.isNegate());
            exprEvaluator.setLogicalNot(right.logicalNot);
            exprEvaluator.setEvalType(rEvalType);
            exprEvaluator.setLeft(newLeft);
            exprEvaluator.setRight(rRight);
            this.displacementSplit(exprEvaluator);
        } else {
            if (rLevel == 1) {
                this.displacement(right.getRight().getLeft());
            }
            this.displacementSplit(right);
        }
    }

    private void mergeRight(ExprEvaluator exprEvaluator, int targetLevel) {
        if (exprEvaluator == null) {
            return;
        }
        String ops = exprEvaluator.getOps();
        int evalType = exprEvaluator.getEvalType();
        int level = exprEvaluator.getLevel();
        if (level >= targetLevel) {
            return;
        }
        ExprEvaluator left = exprEvaluator.getLeft();
        ExprEvaluator right = exprEvaluator.getRight();
        if (right == null) {
            return;
        }
        int rLevel = right.getLevel();
        if (rLevel <= 0) {
            return;
        }
        String rOps = right.getOps();
        int rEvalType = right.getEvalType();
        ExprEvaluator rLeft = right.getLeft();
        ExprEvaluator rRight = right.getRight();
        if (level <= rLevel) {
            ExprEvaluator newLeft = this.createExprEvaluator();
            newLeft.setEvalType(evalType);
            newLeft.setOps(ops, exprEvaluator.getOpsType(), exprEvaluator.getLevel());
            newLeft.setNegate(exprEvaluator.isNegate());
            newLeft.setLogicalNot(exprEvaluator.logicalNot);
            newLeft.setLeft(left);
            newLeft.setRight(rLeft);
            exprEvaluator.setOps(rOps, right.getOpsType(), right.getLevel());
            exprEvaluator.setNegate(right.isNegate());
            exprEvaluator.setLogicalNot(right.logicalNot);
            exprEvaluator.setEvalType(rEvalType);
            exprEvaluator.setLeft(newLeft);
            exprEvaluator.setRight(rRight);
            this.mergeRight(exprEvaluator, targetLevel);
        }
    }

    private void parseNext(ExprEvaluator evaluator, boolean negate, boolean logicalNot) {
        this.parseNextToken();
        if (this.tokenType == 0) {
            return;
        }
        if (this.tokenType == 2) {
            ExprEvaluator left = this.createExprEvaluator();
            left.setEvalType(6);
            left.setNegate(negate);
            left.setLogicalNot(logicalNot);
            left.setVarValue(this.tokenBuffer.toString());
            evaluator.setLeft(left);
            this.parseNext(evaluator, false, false);
        } else if (this.tokenType == 7) {
            ExprEvaluator left = this.createExprEvaluator();
            left.setEvalType(7);
            left.setNegate(negate);
            left.setLogicalNot(logicalNot);
            left.setStrValue(this.tokenBuffer.toString());
            evaluator.setLeft(left);
            this.parseNext(evaluator, false, false);
        } else if (this.tokenType == 3) {
            ExprEvaluator left = this.createExprEvaluator();
            left.setEvalType(3);
            left.setNegate(negate);
            left.setLogicalNot(logicalNot);
            left.setNumberValue(this.tokenBuffer, this.numberRadix);
            evaluator.setLeft(left);
            this.parseNext(evaluator, false, false);
        } else if (this.tokenType == 8) {
            ExprEvaluator left = this.createExprEvaluator();
            left.setEvalType(8);
            left.setNegate(negate);
            left.setLogicalNot(logicalNot);
            left.setArrayValue(this.tokenBuffer.substring(1, this.tokenBuffer.length() - 1));
            evaluator.setLeft(left);
            this.parseNext(evaluator, false, false);
        } else if (this.tokenType == 9) {
            ExprEvaluator left = this.createExprEvaluator();
            left.setEvalType(9);
            left.setNegate(negate);
            left.setLogicalNot(logicalNot);
            left.setFunction(this.tokenBuffer.toString());
            evaluator.setLeft(left);
            this.parseNext(evaluator, false, false);
        } else if (this.tokenType == 4) {
            evaluator.setOps(null, this.opsType, this.opsLevel);
            evaluator.setNegate(negate);
            evaluator.setLogicalNot(logicalNot);
            ExprEvaluator child = this.createExprEvaluator();
            this.parseNext(child, false, false);
            if (this.tokenType != 6) {
                throw new ExpressionException("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u4f4d\u7f6e\uff1a " + this.readIndex + "\uff0c\u7f3a\u5c11\u7ed3\u675f\u7b26\u53f7')'");
            }
            this.displacementSplit(child);
            ExprEvaluator right = this.createExprEvaluator();
            evaluator.setEvalType(5);
            evaluator.setRight(right);
            right.setLeft(child);
            if (this.readable()) {
                this.parseNext(right, false, false);
            }
        } else if (this.tokenType == 1) {
            evaluator.setEvalType(1);
            ExprEvaluator right = this.createExprEvaluator();
            if (this.opsType == 12) {
                evaluator.setOps(null, 11, 100);
                negate = true;
            } else {
                evaluator.setOps(null, this.opsType, this.opsLevel);
            }
            evaluator.setRight(right);
            this.parseNext(right, negate, logicalNot);
        } else if (this.tokenType == 10) {
            this.parseNext(evaluator, !negate, logicalNot);
        } else if (this.tokenType == 11) {
            this.parseNext(evaluator, negate, !logicalNot);
        }
        if (!this.readable()) {
            return;
        }
    }

    private boolean readable() {
        return this.readIndex < this.length();
    }

    private char read() {
        return this.sourceChars[this.offset + this.readIndex];
    }

    private char read(int index) {
        return this.sourceChars[this.offset + index];
    }

    private void parseNextToken() {
        this.resetToken();
        if (!this.readable()) {
            return;
        }
        while (this.readable() && this.isWhitespace(this.read())) {
            ++this.readIndex;
        }
        if (!this.readable()) {
            return;
        }
        char currentChar = this.read();
        int opsSymbolIndex = -1;
        boolean isMinusSymbol = false;
        if ((Character.isDigit(currentChar) || (isMinusSymbol = currentChar == '-')) && this.getTokenTypeGroup(this.prevTokenType) != 2) {
            this.tokenBuffer.append(currentChar);
            ++this.readIndex;
            int readIndex = this.readIndex;
            int numberRadix = 10;
            char firstDigitChar = '\u0000';
            char secondeDigitChar = '\u0000';
            if (isMinusSymbol) {
                if (readIndex + 1 < this.length()) {
                    firstDigitChar = this.read(readIndex++);
                    secondeDigitChar = this.read(readIndex++);
                }
            } else {
                firstDigitChar = currentChar;
                if (readIndex < this.length()) {
                    secondeDigitChar = this.read(readIndex++);
                }
            }
            if (firstDigitChar == '0') {
                if (secondeDigitChar == 'x' || secondeDigitChar == 'X') {
                    numberRadix = 16;
                    this.readIndex = readIndex;
                } else if (Character.isDigit(secondeDigitChar)) {
                    numberRadix = 8;
                    this.readIndex = readIndex;
                    this.tokenBuffer.append(secondeDigitChar);
                }
            }
            int prevChar = 0;
            while (this.readable() && this.isDigit(currentChar = this.read(), numberRadix) && (currentChar != '-' || prevChar == 69 || prevChar == 101)) {
                this.tokenBuffer.append(currentChar);
                ++this.readIndex;
                prevChar = currentChar;
                if (this.readIndex < this.length()) continue;
            }
            if (this.tokenBuffer.length() == 1 && isMinusSymbol) {
                if (this.prevTokenType == 1) {
                    this.tokenType = 10;
                } else {
                    this.tokenType = 1;
                    this.opsType = 12;
                    this.opsLevel = 100;
                }
            } else {
                this.tokenType = 3;
                this.numberRadix = numberRadix;
            }
            this.checkTokenSyntaxError();
        } else if (this.prevTokenType != 1 && (opsSymbolIndex = this.getOpsSymbolIndex(currentChar)) > -1) {
            char firstMatchChar = currentChar;
            ++this.readIndex;
            this.tokenType = 1;
            if (this.readable() && !this.isWhitespace(currentChar = this.read())) {
                if (currentChar == '*' && opsSymbolIndex == 1) {
                    this.opsType = 4;
                    this.opsLevel = 9;
                    ++this.readIndex;
                } else if (opsSymbolIndex == 31) {
                    if (currentChar == '&') {
                        ++this.readIndex;
                        this.opsType = 61;
                        this.opsLevel = 600;
                    } else {
                        this.tokenBuffer.append(firstMatchChar).append(currentChar);
                        this.throwOperationNotSupported();
                    }
                } else if (opsSymbolIndex == 33) {
                    if (currentChar == '|') {
                        ++this.readIndex;
                        this.opsType = 62;
                        this.opsLevel = 600;
                    } else {
                        this.tokenBuffer.append(firstMatchChar).append(currentChar);
                        this.throwOperationNotSupported();
                    }
                } else if (opsSymbolIndex == 43) {
                    if (currentChar == '=') {
                        ++this.readIndex;
                        this.opsType = 56;
                        this.opsLevel = 500;
                    } else if (currentChar == '!') {
                        this.tokenType = 11;
                    } else {
                        if (this.getOpsSymbolIndex(currentChar) > -1) {
                            this.tokenBuffer.append(firstMatchChar).append(currentChar);
                            this.throwOperationNotSupported();
                        }
                        this.tokenType = 11;
                    }
                } else if (opsSymbolIndex == 51) {
                    if (currentChar == '>') {
                        ++this.readIndex;
                        this.opsType = 21;
                        this.opsLevel = 200;
                    } else if (currentChar == '=') {
                        ++this.readIndex;
                        this.opsType = 54;
                        this.opsLevel = 500;
                    } else if (this.getOpsSymbolIndex(currentChar) > -1) {
                        this.tokenBuffer.append(firstMatchChar).append(currentChar);
                        this.throwOperationNotSupported();
                    }
                } else if (opsSymbolIndex == 52) {
                    if (currentChar == '<') {
                        ++this.readIndex;
                        this.opsType = 22;
                        this.opsLevel = 200;
                    } else if (currentChar == '=') {
                        ++this.readIndex;
                        this.opsType = 55;
                        this.opsLevel = 500;
                    } else if (this.getOpsSymbolIndex(currentChar) > -1) {
                        this.tokenBuffer.append(firstMatchChar).append(currentChar);
                        this.throwOperationNotSupported();
                    }
                } else if (opsSymbolIndex == 53) {
                    if (currentChar == '=') {
                        ++this.readIndex;
                        this.opsType = 53;
                        this.opsLevel = 500;
                    } else {
                        this.tokenBuffer.append(firstMatchChar).append(currentChar);
                        this.throwOperationNotSupported();
                    }
                }
            } else if (opsSymbolIndex == 53) {
                this.tokenBuffer.append(firstMatchChar);
                this.throwOperationNotSupported();
            }
            this.checkTokenSyntaxError();
        } else if (currentChar == '!') {
            ++this.readIndex;
            this.tokenType = 11;
        } else if (this.isBracketSymbol(currentChar)) {
            this.opsType = 5;
            this.opsLevel = 1;
            ++this.readIndex;
            if (currentChar == '(') {
                this.tokenType = 4;
                ++this.bracketCount;
                this.checkBeforeBracketTokenSyntaxError();
            } else {
                --this.bracketCount;
                this.tokenType = 6;
                if (this.bracketCount < 0) {
                    this.tokenBuffer.append(')');
                    this.throwOperationNotSupported();
                }
                this.checkBeforeBracketEndTokenSyntaxError();
            }
        } else if (this.isIdentifierStart(currentChar)) {
            this.tokenBuffer.append(currentChar);
            ++this.readIndex;
            while (this.readable() && this.isIdentifierAppend(currentChar = this.read())) {
                this.tokenBuffer.append(currentChar);
                ++this.readIndex;
            }
            this.tokenType = 2;
            this.checkIfBuiltInKeywords();
            this.checkTokenSyntaxError();
        } else if (currentChar == '\'') {
            ++this.readIndex;
            int prevCh = 0;
            while (this.readable() && ((currentChar = this.read()) != '\'' || prevCh == 92)) {
                this.tokenBuffer.append(currentChar);
                ++this.readIndex;
                if (!this.readable()) continue;
                prevCh = currentChar;
            }
            if (currentChar != '\'' || prevCh == 92) {
                throw new ExpressionException("\u8bed\u6cd5\u9519\u8bef: \u4f4d\u7f6e: " + this.readIndex + "\uff0c\u672a\u627e\u5230\u7ed3\u675f\u5b57\u7b26\"'\"");
            }
            ++this.readIndex;
            this.tokenType = 7;
            this.checkTokenSyntaxError();
        } else if (currentChar == '{') {
            ++this.readIndex;
            this.tokenBuffer.append(currentChar);
            while (this.readable() && (currentChar = this.read()) != '}') {
                this.tokenBuffer.append(currentChar);
                ++this.readIndex;
                if (this.readIndex < this.length()) continue;
            }
            if (currentChar != '}') {
                throw new ExpressionException("\u8868\u8fbe\u5f0f\u9519\u8bef\uff0c \u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'{'\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 '}'");
            }
            this.tokenBuffer.append(currentChar);
            ++this.readIndex;
            this.tokenType = 8;
            this.checkTokenSyntaxError();
        } else if (currentChar == '@') {
            ++this.readIndex;
            if (this.readable()) {
                char identifierStart = this.read();
                ++this.readIndex;
                if (Character.isJavaIdentifierStart(identifierStart)) {
                    this.tokenBuffer.append(identifierStart);
                } else {
                    throw new ExpressionException(" Expression syntax error, position:" + this.readIndex + ",unexpected function start char  : '" + identifierStart + "'");
                }
            }
            while (this.readable() && this.isIdentifierAppend(currentChar = this.read())) {
                this.tokenBuffer.append(currentChar);
                ++this.readIndex;
                if (this.readIndex < this.length()) continue;
            }
            while (this.readable() && this.isWhitespace(currentChar = this.read())) {
                ++this.readIndex;
            }
            if (currentChar != '(') {
                String readSource = this.exprSource.substring(0, this.readIndex);
                throw new ExpressionException(" Expression syntax error, position:" + this.readIndex + ", source: '" + readSource + "' function start symbol '(' not found !");
            }
            ++this.readIndex;
            this.tokenBuffer.append('@');
            int bracketCount = 1;
            while (this.readable()) {
                currentChar = this.read();
                ++this.readIndex;
                if (currentChar == ')') {
                    --bracketCount;
                } else if (currentChar == '(') {
                    ++bracketCount;
                }
                if (bracketCount == 0) break;
                this.tokenBuffer.append(currentChar);
            }
            this.tokenType = 9;
            this.checkTokenSyntaxError();
        } else {
            throw new ExpressionException("\u8868\u8fbe\u5f0f\u4e2d\u672a\u9884\u671f\u51fa\u73b0\u7684token\u5b57\u7b26 '" + currentChar + "', pos " + this.readIndex + ", source: " + new String(this.sourceChars, this.offset, this.length()));
        }
    }

    private void checkIfBuiltInKeywords() {
        int length = this.tokenBuffer.length();
        char charFir = this.tokenBuffer.charAt(0);
        if (length == 2) {
            char charSec = this.tokenBuffer.charAt(1);
            if (charFir == 'i' && charSec == 'n' || charFir == 'I' && charSec == 'N') {
                this.opsType = 63;
                this.opsLevel = 600;
                this.tokenType = 1;
            }
        } else if (length == 3 && this.tokenBuffer.indexOf("out") == 0) {
            this.opsType = 64;
            this.opsLevel = 600;
            this.tokenType = 1;
        }
    }

    private int getTokenTypeGroup(int tokenType) {
        if (tokenType == 1) {
            return 1;
        }
        if (tokenType == 3 || tokenType == 7 || tokenType == 2 || tokenType == 8) {
            return 2;
        }
        return 0;
    }

    private void checkTokenSyntaxError() {
        int groupValue;
        int preGroupValue = this.getTokenTypeGroup(this.prevTokenType);
        if (preGroupValue == (groupValue = this.getTokenTypeGroup(this.tokenType))) {
            if (preGroupValue == 1) {
                String readSource = this.exprSource.substring(0, this.readIndex);
                throw new ExpressionException(" Expression syntax error, position:" + this.readIndex + ",Duplicate operation type: '" + readSource + "'");
            }
            if (preGroupValue == 2) {
                String readSource = this.exprSource.substring(0, this.readIndex);
                throw new ExpressionException(" Expression syntax error, position:" + this.readIndex + ",Missing operation symbol: '" + readSource + "'");
            }
        } else {
            if (groupValue == 2 && this.prevTokenType == 6) {
                String readSource = this.exprSource.substring(0, this.readIndex);
                throw new ExpressionException(" Expression syntax error, position:" + this.readIndex + ",unexpected symbol : '" + readSource + "'");
            }
            if (groupValue == 1 && this.prevTokenType == 4) {
                String readSource = this.exprSource.substring(0, this.readIndex);
                throw new ExpressionException(" Expression syntax error, position:" + this.readIndex + ",unexpected symbol : '" + readSource + "'");
            }
        }
    }

    private void checkBeforeBracketEndTokenSyntaxError() {
        int preGroupValue = this.getTokenTypeGroup(this.prevTokenType);
        if (this.prevTokenType == 4 || preGroupValue == 1) {
            String readSource = this.exprSource.substring(0, this.readIndex);
            throw new ExpressionException(" Expression syntax error, position:" + this.readIndex + ",unexpected symbol : '" + readSource + "'");
        }
    }

    private void checkBeforeBracketTokenSyntaxError() {
        int preGroupValue = this.getTokenTypeGroup(this.prevTokenType);
        if (this.prevTokenType == 6 && preGroupValue == 2) {
            String readSource = this.exprSource.substring(0, this.readIndex);
            throw new ExpressionException(" Expression syntax error, position:" + this.readIndex + ",unexpected symbol : '" + readSource + "'");
        }
    }

    private void throwOperationNotSupported() {
        throw new ExpressionException(" Expression parsing failed at position: " + this.readIndex + ", unexpected symbol '" + this.tokenBuffer.toString() + "'");
    }

    private boolean isWhitespace(char c) {
        return c <= ' ';
    }

    protected boolean isIdentifierStart(char c) {
        return c == '_' || c == '$' || Character.isLetter(c);
    }

    protected boolean isIdentifierAppend(char c) {
        return c == '_' || c == '$' || c == '.' || Character.isLetter(c) || this.isDigit(c);
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9' || c == '.' || c == 'E' || c == 'e';
    }

    private boolean isDigit(char c, int numberRadix) {
        if (numberRadix == 10) {
            return c >= '0' && c <= '9' || c == '.' || c == 'E' || c == 'e' || c == '-' || c == 'D' || c == 'd';
        }
        if (numberRadix == 16) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }
        return c >= '0' && c <= '7';
    }

    private void resetToken() {
        this.prevTokenType = this.tokenType;
        if (this.tokenBuffer.length() > 0) {
            this.tokenBuffer.setLength(0);
        }
        this.tokenType = 0;
        this.opsType = 0;
        this.opsLevel = 0;
    }

    private int getOpsSymbolIndex(char c) {
        switch (c) {
            case '*': {
                this.opsType = 1;
                this.opsLevel = 10;
                return this.opsType;
            }
            case '/': {
                this.opsType = 2;
                this.opsLevel = 10;
                return this.opsType;
            }
            case '%': {
                this.opsType = 3;
                this.opsLevel = 10;
                return this.opsType;
            }
            case '+': {
                this.opsType = 11;
                this.opsLevel = 100;
                return this.opsType;
            }
            case '-': {
                this.opsType = 12;
                this.opsLevel = 100;
                return this.opsType;
            }
            case '&': {
                this.opsType = 31;
                this.opsLevel = 300;
                return this.opsType;
            }
            case '^': {
                this.opsType = 32;
                this.opsLevel = 301;
                return this.opsType;
            }
            case '|': {
                this.opsType = 33;
                this.opsLevel = 302;
                return this.opsType;
            }
            case '!': {
                this.opsType = 43;
                return this.opsType;
            }
            case '>': {
                this.opsType = 51;
                this.opsLevel = 500;
                return this.opsType;
            }
            case '<': {
                this.opsType = 52;
                this.opsLevel = 500;
                return this.opsType;
            }
            case '=': {
                this.opsType = 53;
                this.opsLevel = 500;
                return this.opsType;
            }
            case ':': {
                this.opsType = 70;
                this.opsLevel = 700;
                return this.opsType;
            }
            case '?': {
                this.opsType = 71;
                this.opsLevel = 701;
                return this.opsType;
            }
        }
        return -1;
    }

    private boolean isBracketSymbol(char c) {
        return c == '(' || c == ')';
    }

    public Object evaluate() {
        return this.exprEvaluator.evaluate(EvaluateEnvironment.create());
    }

    public Object evaluate(Object context) {
        return this.evaluate(EvaluateEnvironment.create(context));
    }

    public Object evaluate(EvaluateEnvironment evaluateEnvironment) {
        return this.exprEvaluator.evaluate(evaluateEnvironment);
    }

    public class ExprEvaluator {
        private int evalType;
        private String ops;
        private int opsType;
        private ExprEvaluator left;
        private ExprEvaluator right;
        private int level = -1;
        private String value;
        private boolean negate;
        private boolean logicalNot;
        private boolean isStatic;
        private Object result;
        private String functionName;
        private String[] paramExprs;
        private int paramLength;
        private Expression[] paramExpressions;

        public boolean isStaticExpr() {
            if (this.left == null && this.right == null) {
                return this.isStatic;
            }
            if (this.left == null) {
                return this.right.isStaticExpr();
            }
            if (this.right == null) {
                return this.left.isStaticExpr();
            }
            return this.left.isStaticExpr() && this.right.isStaticExpr();
        }

        public String getValue() {
            return this.value;
        }

        public int getEvalType() {
            return this.evalType;
        }

        public void setEvalType(int evalType) {
            this.evalType = evalType;
        }

        public String getOps() {
            return this.ops;
        }

        public void setOps(String ops, int opsType, int level) {
            this.opsType = opsType;
            this.level = level;
        }

        public int getOpsType() {
            return this.opsType;
        }

        public ExprEvaluator getLeft() {
            return this.left;
        }

        public void setLeft(ExprEvaluator left) {
            this.left = left;
        }

        public ExprEvaluator getRight() {
            return this.right;
        }

        public void setRight(ExprEvaluator right) {
            this.right = right;
        }

        protected Number parseNumber(CharSequence chars, int radix, boolean useNegate) {
            double powValue;
            int i = 0;
            int endIndex = chars.length();
            double value = 0.0;
            int decimalCount = 0;
            char ch = chars.charAt(0);
            boolean negative = false;
            if (ch == '-') {
                negative = true;
                ++i;
            }
            int mode = 0;
            int expValue = 0;
            boolean expNegative = false;
            while (i < endIndex) {
                int digit;
                ch = chars.charAt(i);
                if (radix == 10) {
                    if (ch == '.') {
                        if (mode != 0) {
                            throw new NumberFormatException("For input string: \"" + chars + "\"");
                        }
                        mode = 1;
                        if (++i < endIndex) {
                            ch = chars.charAt(i);
                        }
                    } else if (ch == 'E' || ch == 'e') {
                        if (mode == 2) {
                            throw new NumberFormatException("For input string: \"" + chars + "\"");
                        }
                        mode = 2;
                        if (++i < endIndex) {
                            ch = chars.charAt(i);
                        }
                        if (ch == '-') {
                            expNegative = true;
                            if (++i < endIndex) {
                                ch = chars.charAt(i);
                            }
                        }
                    }
                }
                if ((digit = Character.digit(ch, radix)) == -1 && (ch != 'd' && ch != 'D' || i < endIndex - 1)) {
                    throw new NumberFormatException("For input string: \"" + chars + "\"");
                }
                switch (mode) {
                    case 0: {
                        value *= (double)radix;
                        value += (double)digit;
                        break;
                    }
                    case 1: {
                        value *= (double)radix;
                        value += (double)digit;
                        ++decimalCount;
                        break;
                    }
                    case 2: {
                        expValue *= 10;
                        expValue += digit;
                    }
                }
                ++i;
            }
            boolean useDouble = decimalCount > 0 || expValue != 0;
            int n = expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
            if (expValue > 0) {
                powValue = Math.pow(radix, expValue);
                value *= powValue;
            } else if (expValue < 0) {
                powValue = Math.pow(radix, -expValue);
                value /= powValue;
            }
            double numberVal = negative ? -value : value;
            double d = numberVal = useNegate ? -numberVal : numberVal;
            if (!useDouble && numberVal >= -9.223372036854776E18 && numberVal <= 9.223372036854776E18) {
                return (long)numberVal;
            }
            return numberVal;
        }

        public void setNumberValue(CharSequence value, int numberRadix) {
            this.result = this.parseNumber(value, numberRadix, this.negate);
            this.isStatic = true;
        }

        public void setVarValue(String value) {
            if ("true".equals(value)) {
                this.isStatic = true;
                this.result = !this.logicalNot;
            } else if ("false".equals(value)) {
                this.isStatic = true;
                this.result = this.logicalNot;
            } else if ("null".equals(value)) {
                this.isStatic = true;
                this.result = null;
            } else {
                this.value = value;
            }
        }

        public void setStrValue(String value) {
            this.isStatic = true;
            this.result = value;
        }

        private String[] parseStringArr(String splitStr, AtomicInteger atomicInteger, AtomicBoolean strArr, AtomicBoolean doubleArr) {
            int length = splitStr.length();
            boolean isStrArr = false;
            boolean isDoubleArr = false;
            String[] strings = new String[10];
            int beginIndex = 0;
            int arrLen = 0;
            int bracketCount = 0;
            int bigBracketCount = 0;
            for (int i = 0; i < length; ++i) {
                char ch = splitStr.charAt(i);
                if (!(isStrArr || ch != '\"' && ch != '\'')) {
                    isStrArr = true;
                }
                if (!isDoubleArr && ch == '.') {
                    isDoubleArr = true;
                }
                if (ch == '(') {
                    ++bracketCount;
                    continue;
                }
                if (ch == ')') {
                    --bracketCount;
                    continue;
                }
                if (ch == '{') {
                    ++bigBracketCount;
                    continue;
                }
                if (ch == '}') {
                    --bigBracketCount;
                    continue;
                }
                if (bracketCount != 0 || bigBracketCount != 0 || ch != ',') continue;
                if (arrLen == strings.length) {
                    String[] tmp = strings;
                    strings = new String[strings.length << 1];
                    System.arraycopy(tmp, 0, strings, 0, tmp.length);
                }
                String val = splitStr.substring(beginIndex, i).trim();
                strings[arrLen++] = val;
                beginIndex = i + 1;
            }
            if (arrLen == strings.length) {
                String[] tmp = strings;
                strings = new String[strings.length << 1];
                System.arraycopy(tmp, 0, strings, 0, tmp.length);
            }
            strings[arrLen++] = splitStr.substring(beginIndex, length).trim();
            atomicInteger.set(arrLen);
            strArr.set(isStrArr);
            doubleArr.set(isDoubleArr);
            return strings;
        }

        public void setArrayValue(String splitStr) {
            this.isStatic = true;
            int length = (splitStr = splitStr.trim()).length();
            if (length == 0) {
                this.result = new Object[0];
                return;
            }
            AtomicInteger atomicInteger = new AtomicInteger();
            AtomicBoolean strArr = new AtomicBoolean();
            AtomicBoolean doubleArr = new AtomicBoolean();
            String[] strings = this.parseStringArr(splitStr, atomicInteger, strArr, doubleArr);
            int arrLen = atomicInteger.get();
            boolean isStrArr = strArr.get();
            boolean isDoubleArr = doubleArr.get();
            Object[] result = isStrArr ? new String[arrLen] : (isDoubleArr ? new Double[arrLen] : new Long[arrLen]);
            for (int i = 0; i < arrLen; ++i) {
                String val = strings[i];
                if (isStrArr) {
                    if (val.startsWith("'") && val.endsWith("'")) {
                        val = val.substring(1, val.length() - 1);
                    } else if (val.startsWith("\"") && val.endsWith("\"")) {
                        val = val.substring(1, val.length() - 1);
                    } else {
                        throw new ExpressionException("\u65e0\u6548\u7684\u6570\u7ec4\u5143\u7d20: '" + val + "', \u6570\u7ec4\u7247\u6bb5\uff1a '" + splitStr + "'");
                    }
                    result[i] = val;
                    continue;
                }
                result[i] = isDoubleArr ? (Number)Double.parseDouble(val) : (Number)Long.parseLong(val);
            }
            this.result = result;
        }

        public void setFunction(String functionToken) {
            int atIndex = functionToken.indexOf(64);
            String funName = functionToken.substring(0, atIndex);
            String params = functionToken.substring(atIndex + 1).trim();
            if (params.isEmpty()) {
                this.paramLength = 0;
                this.paramExprs = new String[0];
                return;
            }
            AtomicInteger atomicInteger = new AtomicInteger();
            AtomicBoolean strArr = new AtomicBoolean(true);
            AtomicBoolean doubleArr = new AtomicBoolean(true);
            String[] paramExprs = this.parseStringArr(params, atomicInteger, strArr, doubleArr);
            this.functionName = funName.trim();
            this.paramExprs = paramExprs;
            this.paramLength = atomicInteger.get();
            Expression[] paramExpressions = new Expression[this.paramLength];
            for (int i = 0; i < this.paramLength; ++i) {
                paramExpressions[i] = Expression.parse(paramExprs[i]);
            }
            this.paramExpressions = paramExpressions;
        }

        public boolean isNegate() {
            return this.negate;
        }

        public void setNegate(boolean negate) {
            this.negate = negate;
        }

        public void setLogicalNot(boolean logicalNot) {
            this.logicalNot = logicalNot;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public Object evaluate() {
            return this.evaluate(null);
        }

        public Object evaluate(EvaluateEnvironment evaluateEnvironment) {
            if (this.isStatic) {
                return this.result;
            }
            if (this.evalType == 1) {
                Object leftValue = this.left.evaluate(evaluateEnvironment);
                if (this.right == null) {
                    this.isStatic = this.left.isStatic;
                    this.result = leftValue;
                    return this.result;
                }
                Object rightValue = null;
                if (this.opsType == 71) {
                    Object result = this.right.evaluateTernary(evaluateEnvironment, (Boolean)leftValue, this.left.isStatic);
                    boolean bl = this.isStatic = this.left.isStatic && this.right.isStatic;
                    if (this.isStatic) {
                        this.result = result;
                    }
                    return result;
                }
                rightValue = this.right.evaluate(evaluateEnvironment);
                if (evaluateEnvironment.isAutoParseStringAsDouble()) {
                    if (leftValue instanceof String) {
                        leftValue = Double.parseDouble(leftValue.toString());
                    }
                    if (rightValue instanceof String) {
                        rightValue = Double.parseDouble(rightValue.toString());
                    }
                }
                this.isStatic = this.left.isStatic && this.right.isStatic;
                boolean isDouble = leftValue instanceof Double || rightValue instanceof Double;
                switch (this.opsType) {
                    case 1: {
                        this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() * ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() * ((Number)rightValue).longValue());
                        return this.result;
                    }
                    case 2: {
                        this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() / ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() / ((Number)rightValue).longValue());
                        return this.result;
                    }
                    case 3: {
                        this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() % ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() % ((Number)rightValue).longValue());
                        return this.result;
                    }
                    case 4: {
                        this.result = isDouble ? Double.valueOf(Math.pow(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue())) : Double.valueOf(Math.pow(((Number)leftValue).longValue(), ((Number)rightValue).longValue()));
                        return this.result;
                    }
                    case 11: {
                        if (leftValue instanceof Number && rightValue instanceof Number) {
                            this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() + ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() + ((Number)rightValue).longValue());
                            return this.result;
                        }
                        return leftValue + String.valueOf(rightValue);
                    }
                    case 12: {
                        this.result = ((Number)leftValue).doubleValue() - ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case 21: {
                        this.result = ((Number)leftValue).longValue() >> (int)((Number)rightValue).longValue();
                        return this.result;
                    }
                    case 22: {
                        this.result = ((Number)leftValue).longValue() << (int)((Number)rightValue).longValue();
                        return this.result;
                    }
                    case 31: {
                        this.result = ((Number)leftValue).longValue() & ((Number)rightValue).longValue();
                        return this.result;
                    }
                    case 32: {
                        this.result = ((Number)leftValue).longValue() ^ ((Number)rightValue).longValue();
                        return this.result;
                    }
                    case 33: {
                        this.result = ((Number)leftValue).longValue() | ((Number)rightValue).longValue();
                        return this.result;
                    }
                    case 51: {
                        this.result = ((Number)leftValue).doubleValue() > ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case 52: {
                        this.result = ((Number)leftValue).doubleValue() < ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case 53: {
                        if (leftValue instanceof Number && rightValue instanceof Number) {
                            this.result = ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
                            return this.result;
                        }
                        if (leftValue == rightValue) {
                            this.result = true;
                            return this.result;
                        }
                        this.result = leftValue != null && leftValue.equals(rightValue);
                        return this.result;
                    }
                    case 54: {
                        this.result = ((Number)leftValue).doubleValue() >= ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case 55: {
                        this.result = ((Number)leftValue).doubleValue() <= ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case 56: {
                        if (leftValue instanceof Number && rightValue instanceof Number) {
                            this.result = ((Number)leftValue).doubleValue() != ((Number)rightValue).doubleValue();
                            return this.result;
                        }
                        if (leftValue == rightValue) {
                            this.result = false;
                            return this.result;
                        }
                        this.result = leftValue == null || !leftValue.equals(rightValue);
                        return this.result;
                    }
                    case 61: {
                        this.result = (Boolean)leftValue != false && (Boolean)rightValue != false;
                        return this.result;
                    }
                    case 62: {
                        this.result = (Boolean)leftValue != false || (Boolean)rightValue != false;
                        return this.result;
                    }
                    case 63: {
                        return this.evaluateIn(leftValue, rightValue);
                    }
                    case 64: {
                        return !this.evaluateIn(leftValue, rightValue);
                    }
                    case 70: {
                        throw new ExpressionException(" \u4e0d\u652f\u6301\u5355\u72ec\u4f7f\u7528\u5192\u53f7\u8fd0\u7b97\u7b26: ':'");
                    }
                    case 71: {
                        return this.right.evaluateTernary(evaluateEnvironment, (Boolean)leftValue, this.left.isStatic);
                    }
                }
            } else {
                if (this.evalType == 5) {
                    Object bracketValue = this.right.evaluate(evaluateEnvironment);
                    this.isStatic = this.right.isStatic;
                    if (this.negate) {
                        if (bracketValue instanceof Double) {
                            this.result = -((Double)bracketValue).doubleValue();
                            return this.result;
                        }
                        if (bracketValue instanceof Long) {
                            this.result = -((Long)bracketValue).longValue();
                            return this.result;
                        }
                        this.result = -((Number)bracketValue).doubleValue();
                        return this.result;
                    }
                    if (this.logicalNot) {
                        this.result = bracketValue == Boolean.FALSE || bracketValue == null;
                        return this.result;
                    }
                    this.result = bracketValue;
                    return this.result;
                }
                if (this.evalType == 6) {
                    if (evaluateEnvironment == null || evaluateEnvironment.isEmptyContext()) {
                        throw new ExpressionException("Unresolved property or variable:'" + this.value + "', context is null or empty !");
                    }
                    Object context = evaluateEnvironment.getEvaluateContext();
                    Object obj = ObjectUtils.get(context, this.value);
                    if (obj == null && !ObjectUtils.contains(context, this.value)) {
                        throw new ExpressionException("Unresolved property or variable:'" + this.value + "' by context");
                    }
                    if (evaluateEnvironment.isAutoParseStringAsDouble() && obj instanceof String) {
                        obj = Double.parseDouble((String)obj);
                    }
                    if (this.negate) {
                        Number number = (Number)obj;
                        if (number instanceof Double || number instanceof Float) {
                            return -number.doubleValue();
                        }
                        if (number instanceof Integer) {
                            return -number.intValue();
                        }
                        return -number.longValue();
                    }
                    if (this.logicalNot) {
                        return obj == Boolean.FALSE || obj == null;
                    }
                    return obj;
                }
                if (this.evalType == 7) {
                    return this.result;
                }
                if (this.evalType == 9) {
                    Object functionValue = this.evaluateFunction(evaluateEnvironment);
                    if (this.logicalNot) {
                        return functionValue == Boolean.FALSE || functionValue == null;
                    }
                    return functionValue;
                }
                this.result = this.left.evaluate(evaluateEnvironment);
                this.isStatic = this.left.isStatic;
                return this.result;
            }
            return null;
        }

        private Object evaluateFunction(EvaluateEnvironment evaluateEnvironment) {
            Object[] params = new Object[this.paramLength];
            for (int i = 0; i < this.paramLength; ++i) {
                params[i] = this.paramExpressions[i].evaluate(evaluateEnvironment);
            }
            ExprFunction exprFunction = evaluateEnvironment.getFunction(this.functionName);
            if (exprFunction == null) {
                throw new ExpressionException("function '" + this.functionName + "' is not register !");
            }
            return exprFunction.call(params);
        }

        private boolean evaluateIn(Object leftValue, Object rightValue) {
            if (leftValue == null || rightValue == null) {
                return false;
            }
            if (rightValue instanceof Collection) {
                Collection collection = (Collection)rightValue;
                for (Object value : collection) {
                    boolean isEqual = this.execEquals(value, leftValue);
                    if (!isEqual) continue;
                    return true;
                }
            } else if (rightValue.getClass().isArray()) {
                int length = Array.getLength(rightValue);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(rightValue, i);
                    boolean isEqual = this.execEquals(value, leftValue);
                    if (!isEqual) continue;
                    return true;
                }
            } else {
                if (rightValue instanceof Number || rightValue instanceof CharSequence) {
                    return false;
                }
                return ObjectUtils.contains(rightValue, String.valueOf(leftValue));
            }
            return false;
        }

        private boolean execEquals(Object value, Object leftValue) {
            if (value instanceof Number && leftValue instanceof Number && ((Number)value).doubleValue() == ((Number)leftValue).doubleValue()) {
                return true;
            }
            return value == leftValue || String.valueOf(leftValue).equals(String.valueOf(value));
        }

        private Object evaluateTernary(EvaluateEnvironment evaluateEnvironment, Boolean bool, boolean isStatic) {
            if (this.isStatic) {
                return this.result;
            }
            Object result = null;
            if (bool == null || bool == Boolean.FALSE) {
                this.isStatic = isStatic && this.right.isStatic;
                result = this.right.evaluate(evaluateEnvironment);
            } else {
                this.isStatic = isStatic && this.left.isStatic;
                result = this.left.evaluate(evaluateEnvironment);
            }
            if (this.isStatic) {
                this.result = result;
            }
            return result;
        }
    }
}

