/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprParser;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression {
    public static Expression parse(String expr) {
        return new ExprParser(expr);
    }

    public static Object eval(String expr, EvaluateEnvironment evaluateEnvironment) {
        return Expression.parse(expr).evaluate(evaluateEnvironment);
    }

    public static <T> T evalResult(String expr, EvaluateEnvironment evaluateEnvironment, Class<T> targetClass) {
        return Expression.toResult(Expression.parse(expr).evaluate(evaluateEnvironment), targetClass);
    }

    public static Object eval(String expr) {
        return Expression.parse(expr).evaluate();
    }

    public static <T> T evalResult(String expr, Class<T> targetClass) {
        return Expression.parse(expr).evaluateResult(targetClass);
    }

    public static Object eval(String expr, Object context) {
        return Expression.parse(expr).evaluate(context);
    }

    public static Object[] eval(String[] exprs, Object context) {
        if (exprs == null) {
            return null;
        }
        Object[] objects = new Object[exprs.length];
        int i = 0;
        for (String expr : exprs) {
            objects[i++] = Expression.parse(expr).evaluate(context);
        }
        return objects;
    }

    public static <T> List<T> evalResult(String[] exprs, Object context, Class<T> targetClass) {
        if (exprs == null) {
            return null;
        }
        ArrayList<T> objects = new ArrayList<T>(exprs.length);
        boolean i = false;
        for (String expr : exprs) {
            objects.add(Expression.parse(expr).evaluateResult(context, targetClass));
        }
        return objects;
    }

    public static <T> T evalResult(String expr, Object context, Class<T> targetClass) {
        return Expression.parse(expr).evaluateResult(context, targetClass);
    }

    public abstract Object evaluate();

    public abstract Object evaluate(Object var1);

    public abstract Object evaluate(EvaluateEnvironment var1);

    public final <T> T evaluateResult(Class<T> targetClass) {
        return Expression.toResult(this.evaluate(), targetClass);
    }

    public final <T> T evaluateResult(Object context, Class<T> targetClass) {
        return Expression.toResult(this.evaluate(context), targetClass);
    }

    static <T> T toResult(Object result, Class<T> targetClass) {
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            if (targetClass == Double.class || targetClass == Double.TYPE) {
                result = ((Number)result).doubleValue();
                return (T)result;
            }
            if (targetClass == Long.class || targetClass == Long.TYPE) {
                result = ((Number)result).longValue();
                return (T)result;
            }
            if (targetClass == Integer.class || targetClass == Integer.TYPE) {
                result = ((Number)result).intValue();
                return (T)result;
            }
            if (targetClass == Float.class || targetClass == Float.TYPE) {
                result = Float.valueOf(((Number)result).floatValue());
                return (T)result;
            }
        }
        if (!targetClass.isPrimitive() && !targetClass.isInstance(result)) {
            throw new ClassCastException(String.format("%s cannot be cast to %s", result.getClass().toString(), targetClass.toString()));
        }
        return (T)result;
    }

    public static String renderTemplate(String template, Object context) {
        return Expression.renderTemplate(template, "${", "}", context);
    }

    public static String renderTemplate(String template, String prefix, String suffix, Object context) {
        if (template == null || prefix == null || suffix == null) {
            return null;
        }
        int prefixLen = prefix.length();
        int suffixLen = suffix.length();
        if (prefixLen == 0 || suffixLen == 0) {
            return template;
        }
        StringBuilder builder = new StringBuilder();
        char[] buffers = template.toCharArray();
        int length = buffers.length;
        int fromIndex = 0;
        int suffixIndex = template.indexOf(suffix);
        int prefixIndex = -1;
        while (suffixIndex > 0) {
            prefixIndex = template.lastIndexOf(prefix, suffixIndex - 1);
            if (prefixIndex > fromIndex - 1) {
                builder.append(buffers, fromIndex, prefixIndex - fromIndex);
                ExprParser exprParser = new ExprParser(buffers, prefixIndex + prefixLen, suffixIndex - prefixIndex - prefixLen);
                builder.append(exprParser.evaluate(context));
            }
            fromIndex = suffixIndex + suffixLen;
            suffixIndex = template.indexOf(suffix, fromIndex);
        }
        if (fromIndex < length) {
            builder.append(buffers, fromIndex, length - fromIndex);
        }
        return builder.toString();
    }
}

