/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprFunction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileEnvironment
extends EvaluateEnvironment {
    private boolean skipParse;
    private boolean enableSystem;
    private boolean disableSecurityCheck;
    private Set<String> disableKeys = new HashSet<String>();
    private Map<String, String> typeClassMap = new HashMap<String, String>();

    protected CompileEnvironment() {
    }

    protected Map<String, String> getTypeClassMap() {
        return this.typeClassMap;
    }

    public void setVariableType(Class<?> type, String ... vars) {
        for (String var : vars) {
            if (type == System.class || type == Runtime.class) continue;
            this.typeClassMap.put(var, type.getName());
        }
    }

    public String getVariableType(String type) {
        if (this.typeClassMap.containsKey(type)) {
            return this.typeClassMap.get(type) + ".class";
        }
        return null;
    }

    public boolean isSkipParse() {
        return this.skipParse;
    }

    public void setSkipParse(boolean skipParse) {
        this.skipParse = skipParse;
    }

    public boolean isEnableSystem() {
        return this.enableSystem;
    }

    public void setEnableSystem(boolean enableSystem) {
        this.enableSystem = enableSystem;
    }

    public boolean isDisableSecurityCheck() {
        return this.disableSecurityCheck;
    }

    public void setDisableSecurityCheck(boolean disableSecurityCheck) {
        this.disableSecurityCheck = disableSecurityCheck;
    }

    @Override
    protected Map<String, ExprFunction> getFunctionMap() {
        return super.getFunctionMap();
    }

    @Override
    protected ExprFunction getFunction(String functionName) {
        return super.getFunction(functionName);
    }

    public void setKeyBlacklist(String ... keys) {
        for (String key : keys) {
            this.disableKeys.add(key);
        }
    }

    public void setKeyBlacklist(Collection keys) {
        if (keys != null) {
            this.disableKeys.addAll(keys);
        }
    }

    public Set<String> getDisableKeys() {
        return this.disableKeys;
    }
}

