/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.expression.ExprParser;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.compile.CompileEnvironment;

public final class ExprParserCompiler
extends ExprParser {
    protected ExprParserCompiler(String exprSource) {
        super(exprSource);
    }

    protected ExprParserCompiler() {
    }

    protected ExprParser.ExprEvaluator createExprEvaluator() {
        return new ExprEvaluatorCompiler();
    }

    String generateCode(CompileEnvironment environment) {
        ExprEvaluatorCompiler exprEvaluatorCompiler = (ExprEvaluatorCompiler)this.getEvaluator();
        return exprEvaluatorCompiler.generateCode(environment);
    }

    public final class ExprEvaluatorCompiler
    extends ExprParser.ExprEvaluator {
        public ExprEvaluatorCompiler() {
            super(ExprParserCompiler.this);
        }

        public String generateCode(CompileEnvironment environment) {
            int evalType = this.getEvalType();
            int opsType = this.getOpsType();
            boolean negate = this.isNegate();
            String value = this.getValue();
            ExprEvaluatorCompiler left = (ExprEvaluatorCompiler)this.getLeft();
            ExprEvaluatorCompiler right = (ExprEvaluatorCompiler)this.getRight();
            if (this.isStaticExpr()) {
                Object result = this.evaluate();
                if (result instanceof String) {
                    return '\"' + String.valueOf(result) + '\"';
                }
                return String.valueOf(result);
            }
            if (evalType == 1) {
                String leftGenerateCode = left.generateCode(environment);
                if (right == null) {
                    return leftGenerateCode;
                }
                String rightGenerateCode = right.generateCode(environment);
                String template = "%s%s %s %s%s";
                if (!left.isStaticExpr()) {
                    leftGenerateCode = "(" + leftGenerateCode + ")";
                }
                if (!right.isStaticExpr()) {
                    rightGenerateCode = "(" + rightGenerateCode + ")";
                }
                switch (opsType) {
                    case 1: {
                        return String.format(template, "", leftGenerateCode, "*", "", rightGenerateCode);
                    }
                    case 2: {
                        return String.format(template, "", leftGenerateCode, "/", "", rightGenerateCode);
                    }
                    case 3: {
                        return String.format(template, "", leftGenerateCode, "%", "", rightGenerateCode);
                    }
                    case 4: {
                        return String.format("Math.pow((double)(%s), (double)(%s))", leftGenerateCode, rightGenerateCode);
                    }
                    case 11: {
                        return String.format(template, "", leftGenerateCode, "+", "", rightGenerateCode);
                    }
                    case 12: {
                        return String.format(template, "", leftGenerateCode, "-", "", rightGenerateCode);
                    }
                    case 21: {
                        return String.format(template, "long", leftGenerateCode, ">>", "long", rightGenerateCode);
                    }
                    case 22: {
                        return String.format(template, "long", leftGenerateCode, "<<", "long", rightGenerateCode);
                    }
                    case 31: {
                        return String.format(template, "long", leftGenerateCode, "&", "long", rightGenerateCode);
                    }
                    case 32: {
                        return String.format(template, "long", leftGenerateCode, "^", "long", rightGenerateCode);
                    }
                    case 33: {
                        return String.format(template, "long", leftGenerateCode, "|", "long", rightGenerateCode);
                    }
                    case 51: {
                        return String.format(template, "", leftGenerateCode, ">", "", rightGenerateCode);
                    }
                    case 52: {
                        return String.format(template, "", leftGenerateCode, "<", "", rightGenerateCode);
                    }
                    case 53: {
                        return String.format(template, "", leftGenerateCode, "==", "", rightGenerateCode);
                    }
                    case 54: {
                        return String.format(template, "", leftGenerateCode, ">=", "", rightGenerateCode);
                    }
                    case 55: {
                        return String.format(template, "", leftGenerateCode, "<=", "", rightGenerateCode);
                    }
                    case 56: {
                        return String.format(template, "Object", leftGenerateCode, "!=", "Object", rightGenerateCode);
                    }
                    case 61: {
                        return String.format(template, "", leftGenerateCode, "&&", "", rightGenerateCode);
                    }
                    case 62: {
                        return String.format(template, "", leftGenerateCode, "||", "", rightGenerateCode);
                    }
                    case 63: {
                        throw new ExpressionException("\u6682\u65f6\u4e0d\u652f\u6301'in'\u7b26\u53f7\u7f16\u8bd1");
                    }
                    case 64: {
                        throw new ExpressionException("\u6682\u65f6\u4e0d\u652f\u6301'out'\u7b26\u53f7\u7f16\u8bd1");
                    }
                    case 70: {
                        return String.format("%s ? %s", leftGenerateCode, rightGenerateCode);
                    }
                    case 71: {
                        return String.format("%s : %s", leftGenerateCode, rightGenerateCode);
                    }
                }
            } else {
                if (evalType == 5) {
                    if (negate) {
                        return "-(" + right.generateCode(environment) + ")";
                    }
                    return "(" + right.generateCode(environment) + ")";
                }
                if (evalType == 6) {
                    String typeName = environment.getVariableType(value);
                    if (typeName == null) {
                        if (negate) {
                            return "-(ObjectUtils.get(context, \"" + value + "\", Number.class)).doubleValue()";
                        }
                        return "ObjectUtils.get(context, \"" + value + "\", Number.class).doubleValue()";
                    }
                    if (negate) {
                        return "-(ObjectUtils.get(context, \"" + value + "\", " + typeName + "))";
                    }
                    return "ObjectUtils.get(context, \"" + value + "\", " + typeName + ")";
                }
                return "(" + left.generateCode(environment) + ")";
            }
            return null;
        }
    }
}

