/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.compiler.MemoryClassLoader;
import io.github.wycst.wast.common.compiler.MemoryJavaFileManager;
import io.github.wycst.wast.common.compiler.MemoryJavaFileObject;
import io.github.wycst.wast.common.exceptions.ParserException;
import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.compile.CompileEnvironment;
import io.github.wycst.wast.common.expression.compile.ExprParserCompiler;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionCompiler
extends Expression {
    private static final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private static final StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
    private static final AtomicLong ATOMIC_LONG = new AtomicLong(0L);
    private static final String PACKAGE_NAME = ExpressionCompiler.class.getPackage().getName();
    private String sourceCode;

    public static CompileEnvironment createEnvironment() {
        return new CompileEnvironment();
    }

    public static Expression compile(String expr) {
        return ExpressionCompiler.compile(expr, new CompileEnvironment());
    }

    public static Expression compile(String expr, boolean skipParse) {
        CompileEnvironment compileEnvironment = new CompileEnvironment();
        compileEnvironment.setSkipParse(skipParse);
        return ExpressionCompiler.compile(expr, compileEnvironment);
    }

    public static Expression compile(String expr, CompileEnvironment environment) {
        String sourceCode;
        boolean skipParse = environment.isSkipParse();
        ExprParserCompiler exprParserCompiler = null;
        String exprCode = null;
        String expressionClassName = String.format("ExpressionCompiler$_%d", ATOMIC_LONG.getAndIncrement());
        if (skipParse) {
            ExpressionCompiler.checkSecurityCode(expr, environment);
            sourceCode = ExpressionCompiler.generateNativeCode(expr, expressionClassName, environment);
        } else {
            exprParserCompiler = new ExprParserCompiler(expr);
            exprCode = exprParserCompiler.generateCode(environment);
            sourceCode = ExpressionCompiler.generateJavaSourceCode(expressionClassName, null, new String[]{exprCode}, environment);
        }
        String javaCode = sourceCode;
        try {
            MemoryJavaFileManager javaFileManager = new MemoryJavaFileManager(fileManager);
            JavaFileObject javaFileObject = javaFileManager.createJavaFileObject(expressionClassName + ".java", javaCode);
            JavaCompiler.CompilationTask task = compiler.getTask(null, javaFileManager, null, Arrays.asList("-encoding", "UTF-8"), null, Arrays.asList(javaFileObject));
            boolean bl = task.call();
            if (bl) {
                MemoryJavaFileObject memoryJavaFileObject = javaFileManager.getMemoryJavaFileObject();
                MemoryClassLoader memoryClassLoader = new MemoryClassLoader(memoryJavaFileObject);
                Class<?> clazz = memoryClassLoader.loadClass(PACKAGE_NAME + "." + expressionClassName);
                Constructor<?> clazzConstructor = clazz.getConstructor(ExprParserCompiler.class, CompileEnvironment.class);
                clazzConstructor.setAccessible(true);
                ExpressionCompiler expressionCompiler = (ExpressionCompiler)clazzConstructor.newInstance(exprParserCompiler, environment);
                expressionCompiler.sourceCode = sourceCode;
                return expressionCompiler;
            }
        }
        catch (Throwable e) {
            throw new ParserException(" parse exception :" + e.getMessage(), e);
        }
        return null;
    }

    private static void checkSecurityCode(String expr, CompileEnvironment environment) {
        if (!environment.isDisableSecurityCheck()) {
            String[] lines;
            Set<String> disableKeys = environment.getDisableKeys();
            String codeExpr = expr.replaceAll("\".*?\"", "");
            for (String line : lines = codeExpr.split(";")) {
                if (!environment.isEnableSystem() && line.indexOf("System.") > -1) {
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a 'System', code: '%s'", expr));
                }
                if (line.indexOf("Runtime.") > -1) {
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a 'Runtime', code: '%s'", expr));
                }
                for (String key : disableKeys) {
                    if (line.indexOf(key) <= -1) continue;
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a '%s', code: '%s'", key, expr));
                }
            }
        }
    }

    private static String generateNativeCode(String source, String expressionClassName, CompileEnvironment environment) {
        Map<String, String> typeClassMap = environment.getTypeClassMap();
        Set<Map.Entry<String, String>> entrySet = typeClassMap.entrySet();
        String[] defines = new String[typeClassMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : entrySet) {
            String defineJavaIdentifier = entry.getKey().replace('.', '_');
            defines[i++] = String.format("%s %s = ObjectUtils.get(context, \"%s\", %s.class)", entry.getValue(), defineJavaIdentifier, entry.getKey(), entry.getValue());
            source = source.replace(entry.getKey(), defineJavaIdentifier);
        }
        String[] codeLines = source.split(";");
        return ExpressionCompiler.generateJavaSourceCode(expressionClassName, defines, codeLines, environment);
    }

    private static String generateJavaSourceCode(String className, String[] defines, String[] lines, CompileEnvironment environment) {
        StringBuffer javaCodeBuffer = new StringBuffer();
        javaCodeBuffer.append("package " + PACKAGE_NAME + ";\r\n");
        javaCodeBuffer.append("import io.github.wycst.wast.common.utils.*;\r\n");
        javaCodeBuffer.append("import io.github.wycst.wast.common.expression.ExprFunction;\r\n");
        javaCodeBuffer.append("public class ").append(className).append(" extends ExpressionCompiler {\r\n");
        javaCodeBuffer.append("\r\n");
        javaCodeBuffer.append("\tprivate ExprParserCompiler exprParserCompiler;\r\n");
        javaCodeBuffer.append("\tprivate CompileEnvironment environment;\r\n\r\n");
        javaCodeBuffer.append("\tpublic ").append(className).append("(ExprParserCompiler exprParserCompiler, CompileEnvironment environment){\r\n");
        javaCodeBuffer.append("\t\tthis.exprParserCompiler = exprParserCompiler;\r\n");
        javaCodeBuffer.append("\t\tthis.environment = environment;\r\n");
        javaCodeBuffer.append("\t}\r\n\r\n");
        Map<String, ExprFunction> functionMap = environment.getFunctionMap();
        if (functionMap.size() > 0) {
            for (String functionName : functionMap.keySet()) {
                ExprFunction function = functionMap.get(functionName);
                Class<?> actualReturnCls = ExpressionCompiler.getImplementActualType(function.getClass());
                javaCodeBuffer.append("\t@SuppressWarnings(\"unchecked\")\r\n");
                javaCodeBuffer.append("\tpublic  " + actualReturnCls.getName() + " " + functionName + "(Object...params) {\r\n");
                javaCodeBuffer.append("\t\tExprFunction<" + actualReturnCls.getName() + "> function = environment.getFunction(\"" + functionName + "\");\r\n");
                javaCodeBuffer.append("\t\treturn function.call(params);\r\n");
                javaCodeBuffer.append("\t}\r\n");
            }
        }
        javaCodeBuffer.append("\tpublic Object evaluate() {\r\n");
        javaCodeBuffer.append("\t\treturn evaluate(null);\r\n");
        javaCodeBuffer.append("\t}\r\n\r\n");
        javaCodeBuffer.append("\tpublic Object evaluate(Object context) {\r\n");
        if (defines != null) {
            for (String defLine : defines) {
                javaCodeBuffer.append("\t\t").append(defLine).append(";\r\n");
            }
            javaCodeBuffer.append("\r\n");
        }
        int i = 0;
        int length = lines.length;
        for (String line : lines) {
            line = line.trim();
            if (i++ == length - 1 && !line.startsWith("return ")) {
                javaCodeBuffer.append("\t\treturn ").append(line).append(";\r\n");
                continue;
            }
            javaCodeBuffer.append("\t\t").append(line).append(";\r\n");
        }
        javaCodeBuffer.append("\t}\r\n\r\n");
        javaCodeBuffer.append("}");
        return javaCodeBuffer.toString();
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    private static Class<?> getImplementActualType(Class<?> targetClass) {
        Type[] typeArray;
        int n;
        int n2;
        Type[] implementTypes = targetClass.getGenericInterfaces();
        if (implementTypes.length == 0) {
            Class parentCls = (Class)targetClass.getGenericSuperclass();
            implementTypes = parentCls.getGenericInterfaces();
        }
        if ((n2 = 0) < (n = (typeArray = implementTypes).length)) {
            ParameterizedType parameterizedType;
            Type[] types;
            Type implementType = typeArray[n2];
            if (implementType instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)implementType).getActualTypeArguments()) != null && types.length > 0 && types[0] instanceof Class) {
                return (Class)types[0];
            }
            return null;
        }
        return null;
    }

    @Override
    public final Object evaluate(EvaluateEnvironment evaluateEnvironment) {
        if (evaluateEnvironment == null) {
            evaluateEnvironment = EvaluateEnvironment.create();
        }
        return this.evaluate(evaluateEnvironment.getEvaluateContext());
    }
}

