/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.idgenerate.providers;

import io.github.wycst.wast.common.idgenerate.entity.IdInfo;
import io.github.wycst.wast.common.idgenerate.providers.SnowflakeIdGeneratorProvider;
import java.io.InputStream;
import java.util.Properties;

public abstract class IdGenerator {
    private static String ID_GENERATOR_ALGORITHM;
    public static final String ID_GENERATOR_ALGORITHM_SNOWFLAKE = "snowflake";
    private static int ID_GENERATOR_SNOWFLAKE_BIT_TYPE;
    private static boolean ID_GENERATOR_SNOWFLAKE_INSTANCE_AUTODISCOVER;
    private static int ID_GENERATOR_SNOWFLAKE_INSTANCE;
    private static IdGenerator instance;

    public static IdGenerator getInstance() {
        return instance;
    }

    public static IdGenerator getInstance(int bitType, int instance) {
        return new SnowflakeIdGeneratorProvider(bitType, instance);
    }

    public abstract long generateId();

    public abstract IdInfo expId(long var1);

    public abstract IdInfo expId(String var1);

    public String generateHexString() {
        return Long.toHexString(this.generateId());
    }

    public String generateBinaryString() {
        return Long.toBinaryString(this.generateId());
    }

    static {
        try {
            Properties props = new Properties();
            InputStream is = IdGenerator.class.getResourceAsStream("/generate.properties");
            if (is != null) {
                props.load(is);
            }
            if (ID_GENERATOR_ALGORITHM_SNOWFLAKE.equals(ID_GENERATOR_ALGORITHM = props.getProperty("id.generate.algorithm"))) {
                ID_GENERATOR_SNOWFLAKE_BIT_TYPE = props.containsKey("id.generate.snowflake.bit.type") ? Integer.parseInt(props.getProperty("id.generate.snowflake.bit.type").trim()) : 0;
                ID_GENERATOR_SNOWFLAKE_INSTANCE_AUTODISCOVER = props.containsKey("id.generate.snowflake.instance.auto-discover") ? "true".equals(props.getProperty("id.generate.snowflake.instance.auto-discover").trim()) : false;
                ID_GENERATOR_SNOWFLAKE_INSTANCE = props.containsKey("id.generate.snowflake.instance") ? Integer.parseInt(props.getProperty("id.generate.snowflake.instance").trim()) : 0;
                instance = ID_GENERATOR_SNOWFLAKE_INSTANCE_AUTODISCOVER ? new SnowflakeIdGeneratorProvider(ID_GENERATOR_SNOWFLAKE_BIT_TYPE, true) : new SnowflakeIdGeneratorProvider(ID_GENERATOR_SNOWFLAKE_BIT_TYPE, ID_GENERATOR_SNOWFLAKE_INSTANCE);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (instance == null) {
            instance = new SnowflakeIdGeneratorProvider();
        }
    }
}

