/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.GetterMethodInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.reflect.SetterMethodInfo;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassStructureWrapper {
    private static Map<Class<?>, ClassStructureWrapper> classStructureWarppers = new ConcurrentHashMap();
    private static String[] USE_GETTER_METHOD_TYPE_NAME_LIST = new String[0];
    private static Class[] USE_GETTER_METHOD_TYPE_LIST = new Class[]{Throwable.class, Error.class};
    private static final int MAX_STRUCTURE_COUNT = 10000;
    private Class<?> sourceClass;
    private ClassWrapperType classWrapperType = ClassWrapperType.Normal;
    private boolean javaBuiltInModule;
    private boolean forceUseFields;
    private boolean record;
    private boolean temporal;
    private int fieldCount;
    private boolean assignableFromMap;
    private Map<String, SetterInfo> setterInfos = new LinkedHashMap<String, SetterInfo>();
    private List<GetterInfo> getterInfos;
    private List<GetterInfo> getterInfoOfFields;
    private Object[] constructorArgs;
    private Constructor<?> defaultConstructor;
    static final Field modifierField;
    static final Method getParametersMethod;

    private ClassStructureWrapper() {
    }

    public List<GetterInfo> getGetterInfos() {
        return this.getterInfos;
    }

    public List<GetterInfo> getGetterInfos(boolean fieldAgent) {
        if (fieldAgent || this.javaBuiltInModule) {
            return this.getterInfoOfFields;
        }
        return this.getterInfos;
    }

    public SetterInfo getSetterInfo(String name) {
        return this.setterInfos.get(name);
    }

    public boolean containsSetterKey(String fieldName) {
        return this.setterInfos.containsKey(fieldName);
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public Object newInstance() throws Exception {
        return this.defaultConstructor.newInstance(this.constructorArgs);
    }

    public Object newInstance(Object[] constructorArgs) throws Exception {
        return this.defaultConstructor.newInstance(constructorArgs);
    }

    public boolean isAssignableFromMap() {
        return this.assignableFromMap;
    }

    public boolean isRecord() {
        return this.record;
    }

    public boolean isTemporal() {
        return this.temporal;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public boolean isForceUseFields() {
        return this.forceUseFields;
    }

    public ClassWrapperType getClassWrapperType() {
        return this.classWrapperType;
    }

    public Object[] createConstructorArgs() {
        Object[] constructorArgs = new Object[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            constructorArgs[i] = this.constructorArgs[i];
        }
        return constructorArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassStructureWrapper get(Class<?> sourceClass) {
        if (sourceClass == null) {
            throw new IllegalArgumentException("sourceClass is null");
        }
        ClassStructureWrapper wrapper = classStructureWarppers.get(sourceClass);
        if (wrapper != null) {
            return wrapper;
        }
        if (sourceClass.isInterface() || sourceClass.isEnum() || sourceClass.isArray() || sourceClass.isPrimitive()) {
            return null;
        }
        if (wrapper == null) {
            Class<?> clazz = sourceClass;
            synchronized (clazz) {
                if (classStructureWarppers.containsKey(sourceClass)) {
                    return classStructureWarppers.get(sourceClass);
                }
                wrapper = new ClassStructureWrapper();
                wrapper.sourceClass = sourceClass;
                wrapper.assignableFromMap = Map.class.isAssignableFrom(sourceClass);
                wrapper.checkClassStructure();
                Type genericSuperclass = sourceClass.getGenericSuperclass();
                HashMap superGenericClassMap = new HashMap();
                if (genericSuperclass instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
                    Type[] types = parameterizedType.getActualTypeArguments();
                    Class superclass = (Class)parameterizedType.getRawType();
                    TypeVariable<Class<T>>[] typeParameters = superclass.getTypeParameters();
                    int i = 0;
                    for (TypeVariable typeVariable : typeParameters) {
                        Type actualTypeArgument;
                        String name = typeVariable.getName();
                        if (!((actualTypeArgument = types[i++]) instanceof Class)) continue;
                        superGenericClassMap.put(name, (Class)actualTypeArgument);
                    }
                }
                if (wrapper.record) {
                    ClassStructureWrapper.wrapperWithRecordConstructor(wrapper, superGenericClassMap);
                } else {
                    ClassStructureWrapper.wrapperWithMethodAndField(wrapper, superGenericClassMap);
                }
                classStructureWarppers.put(sourceClass, wrapper);
            }
        }
        return wrapper;
    }

    private static void wrapperWithRecordConstructor(ClassStructureWrapper wrapper, Map<String, Class<?>> superGenericClassMap) {
        Class<?> sourceClass = wrapper.sourceClass;
        Constructor<?>[] constructors = sourceClass.getDeclaredConstructors();
        if (constructors.length == 0) {
            return;
        }
        Constructor<?> constructor = constructors[0];
        wrapper.defaultConstructor = constructor;
        ArrayList<GetterInfo> getterInfoOfFields = new ArrayList<GetterInfo>();
        wrapper.getterInfoOfFields = getterInfoOfFields;
        wrapper.getterInfos = getterInfoOfFields;
        try {
            int len;
            Object parameters = getParametersMethod.invoke(constructor, new Object[0]);
            wrapper.fieldCount = len = Array.getLength(parameters);
            Method parameterNameMethod = null;
            Type[] genericParameterTypes = constructor.getGenericParameterTypes();
            Object[] constructorArgs = new Object[len];
            wrapper.constructorArgs = constructorArgs;
            for (int i = 0; i < len; ++i) {
                Object parameter = Array.get(parameters, i);
                if (parameterNameMethod == null) {
                    parameterNameMethod = parameter.getClass().getMethod("getName", new Class[0]);
                    ClassStructureWrapper.setAccessible(parameterNameMethod);
                }
                String name = (String)parameterNameMethod.invoke(parameter, new Object[0]);
                Field nameField = sourceClass.getDeclaredField(name);
                Method nameMethod = sourceClass.getDeclaredMethod(name, new Class[0]);
                ClassStructureWrapper.setAccessible(nameField);
                ClassStructureWrapper.setAccessible(nameMethod);
                Class<?> fieldType = nameField.getType();
                constructorArgs[i] = ClassStructureWrapper.defaulTypeValue(fieldType);
                GetterInfo getterInfo = new GetterInfo();
                getterInfo.setField(nameField);
                getterInfo.setName(name);
                HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
                ClassStructureWrapper.addAnnotations(annotationMap, nameMethod.getAnnotations());
                getterInfo.setAnnotations(annotationMap);
                getterInfoOfFields.add(getterInfo);
                SetterInfo setterInfo = new SetterInfo();
                setterInfo.setName(name);
                setterInfo.setField(nameField);
                setterInfo.setParameterType(fieldType);
                setterInfo.setIndex(i);
                Type genericType = genericParameterTypes[i];
                Class<?> declaringClass = nameField.getDeclaringClass();
                ClassStructureWrapper.parseSetterGenericType(superGenericClassMap, sourceClass, declaringClass, setterInfo, genericType, fieldType);
                setterInfo.setAnnotations(annotationMap);
                wrapper.setterInfos.put(name, setterInfo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void wrapperWithMethodAndField(ClassStructureWrapper wrapper, Map<String, Class<?>> superGenericClassMap) {
        Method[] methods;
        Class<?> sourceClass = wrapper.sourceClass;
        Constructor<?>[] constructors = sourceClass.getDeclaredConstructors();
        Constructor<?> defaultConstructor = null;
        int minParamCount = -1;
        Class<?>[] constructorParameterTypes = null;
        block4: for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int parameterCount = parameterTypes.length;
            if (minParamCount == -1 || minParamCount > parameterCount) {
                minParamCount = parameterCount;
                defaultConstructor = constructor;
                constructorParameterTypes = parameterTypes;
            }
            if (minParamCount == 0) break;
            if (minParamCount != parameterCount) continue;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameterTypes[i].isPrimitive() || constructorParameterTypes[i].isPrimitive()) continue;
                defaultConstructor = constructor;
                constructorParameterTypes = parameterTypes;
                continue block4;
            }
        }
        ClassStructureWrapper.setAccessible(defaultConstructor);
        Object[] args = new Object[minParamCount];
        for (int i = 0; i < minParamCount; ++i) {
            void type = constructorParameterTypes[i];
            args[i] = ClassStructureWrapper.defaulTypeValue(type);
        }
        wrapper.defaultConstructor = defaultConstructor;
        wrapper.constructorArgs = args;
        ArrayList<GetterMethodInfo> getterInfos = new ArrayList<GetterMethodInfo>();
        for (Method method : methods = sourceClass.getMethods()) {
            boolean startsWithGet;
            boolean isVoid;
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) continue;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean bl = isVoid = returnType == Void.TYPE;
            if (parameterTypes.length == 0 && ((startsWithGet = methodName.startsWith("get")) || methodName.startsWith("is")) && !isVoid) {
                int startIndex;
                int n = startIndex = startsWithGet ? 3 : 2;
                if (methodName.length() == startIndex) continue;
                ClassStructureWrapper.setAccessible(method);
                GetterMethodInfo getterInfo = new GetterMethodInfo(method);
                String fieldName = methodName.substring(startIndex, startIndex + 1).toLowerCase() + methodName.substring(startIndex + 1);
                getterInfo.setName(fieldName);
                getterInfo.setUnderlineName(StringUtils.camelCaseToSymbol(fieldName));
                HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
                ClassStructureWrapper.addAnnotations(annotationMap, method.getAnnotations());
                try {
                    Field field = sourceClass.getDeclaredField(fieldName);
                    if (!Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers()) && ClassStructureWrapper.setAccessible(field) && field.getType().isAssignableFrom(returnType)) {
                        getterInfo.setField(field);
                    }
                    ClassStructureWrapper.addAnnotations(annotationMap, field.getAnnotations());
                }
                catch (Exception field) {
                    // empty catch block
                }
                getterInfo.setAnnotations(annotationMap);
                getterInfos.add(getterInfo);
                continue;
            }
            if (parameterTypes.length != 1 || !methodName.startsWith("set") || !isVoid || methodName.length() == 3) continue;
            ClassStructureWrapper.setAccessible(method);
            SetterMethodInfo setterInfo = new SetterMethodInfo(method);
            String setFieldName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            wrapper.setterInfos.put(setFieldName, setterInfo);
            String underlineName = StringUtils.camelCaseToSymbol(setFieldName);
            wrapper.setterInfos.put(underlineName, setterInfo);
            setterInfo.setName(setFieldName);
            Class<?> parameterType = parameterTypes[0];
            setterInfo.setParameterType(parameterType);
            Type genericType = method.getGenericParameterTypes()[0];
            ClassStructureWrapper.parseSetterGenericType(superGenericClassMap, sourceClass, declaringClass, setterInfo, genericType, parameterType);
            HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
            Annotation[] methodAnnotations = method.getAnnotations();
            ClassStructureWrapper.addAnnotations(annotationMap, methodAnnotations);
            try {
                Field field = sourceClass.getDeclaredField(setFieldName);
                if (!Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers())) {
                    if (ClassStructureWrapper.setAccessible(field) && field.getType().isAssignableFrom(parameterType)) {
                        setterInfo.setField(field);
                    } else {
                        setterInfo.setFieldDisabled(true);
                    }
                }
                Annotation[] fieldAnnotations = field.getAnnotations();
                ClassStructureWrapper.addAnnotations(annotationMap, fieldAnnotations);
            }
            catch (Exception exception) {
                // empty catch block
            }
            setterInfo.setAnnotations(annotationMap);
        }
        ClassStructureWrapper.parseWrapperFields(wrapper, sourceClass, superGenericClassMap);
        Collections.sort(getterInfos, new Comparator<GetterInfo>(){

            @Override
            public int compare(GetterInfo o1, GetterInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        wrapper.getterInfos = Collections.unmodifiableList(getterInfos);
        wrapper.setterInfos = Collections.unmodifiableMap(wrapper.setterInfos);
        if (wrapper.getterInfos.size() == 0 && wrapper.getterInfoOfFields != null && wrapper.getterInfoOfFields.size() > 0) {
            wrapper.forceUseFields = true;
        }
    }

    private static Object defaulTypeValue(Class<?> type) {
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type.isPrimitive()) {
            if (type == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (type == Byte.TYPE) {
                return (byte)0;
            }
            if (type == Short.TYPE) {
                return (short)0;
            }
            return 0;
        }
        if (type == String.class) {
            return "";
        }
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        return null;
    }

    private void checkClassStructure() {
        String pckName = this.sourceClass.getPackage().getName();
        if (pckName.startsWith("java.") || pckName.startsWith("sun.")) {
            this.javaBuiltInModule = true;
        }
        if (this.sourceClass.getSuperclass().getName().equals("java.lang.Record")) {
            this.record = true;
            this.javaBuiltInModule = true;
            this.classWrapperType = ClassWrapperType.Record;
        }
        if (this.javaBuiltInModule) {
            String className;
            this.forceUseFields = true;
            for (Class superClass : USE_GETTER_METHOD_TYPE_LIST) {
                if (!superClass.isAssignableFrom(this.sourceClass)) continue;
                this.forceUseFields = false;
                break;
            }
            if ((className = this.sourceClass.getName()).equals("java.time.LocalDate")) {
                this.classWrapperType = ClassWrapperType.TemporalLocalDate;
                this.temporal = true;
            } else if (className.equals("java.time.LocalTime")) {
                this.classWrapperType = ClassWrapperType.TemporalLocalTime;
                this.temporal = true;
            } else if (className.equals("java.time.LocalDateTime")) {
                this.classWrapperType = ClassWrapperType.TemporalLocalDateTime;
                this.temporal = true;
            } else if (className.equals("java.time.Instant")) {
                this.classWrapperType = ClassWrapperType.TemporalInstant;
                this.temporal = true;
            } else if (className.equals("java.time.ZonedDateTime")) {
                this.classWrapperType = ClassWrapperType.TemporalZonedDateTime;
                this.temporal = true;
            }
        }
    }

    private static void parseSetterGenericType(Map<String, Class<?>> superGenericClassMap, Class<?> sourceClass, Class<?> declaringClass, SetterInfo setterInfo, Type genericType, Class<?> parameterType) {
        GenericParameterizedType<?> genericParameterizedType = null;
        if (Collection.class.isAssignableFrom(parameterType)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type type = pt.getActualTypeArguments()[0];
                if (type instanceof Class) {
                    setterInfo.setActualTypeArgument((Class)type);
                }
                genericParameterizedType = GenericParameterizedType.genericCollectionType(parameterType, type);
            } else {
                genericParameterizedType = GenericParameterizedType.newActualType(parameterType);
            }
        } else if (parameterType.isArray()) {
            Class<?> componentType = parameterType.getComponentType();
            setterInfo.setActualTypeArgument(componentType);
            if (genericType instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)genericType;
                Type genericComponentType = genericArrayType.getGenericComponentType();
                genericParameterizedType = GenericParameterizedType.genericArrayType(genericComponentType);
            } else {
                genericParameterizedType = GenericParameterizedType.arrayType(componentType);
            }
        } else if (Map.class.isAssignableFrom(parameterType)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pt.getActualTypeArguments();
                if (actualTypeArguments.length == 2) {
                    genericParameterizedType = GenericParameterizedType.genericMapType(parameterType, actualTypeArguments[0], actualTypeArguments[1]);
                }
            } else {
                genericParameterizedType = GenericParameterizedType.newActualType(parameterType);
            }
        } else {
            if ((parameterType.isInterface() || Modifier.isAbstract(parameterType.getModifiers())) && !parameterType.isPrimitive()) {
                setterInfo.setNonInstanceType(true);
            }
            if (genericType instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)genericType;
                String name = typeVariable.getName();
                if (declaringClass != sourceClass) {
                    Class<?> superGenericClass = superGenericClassMap.get(name);
                    genericParameterizedType = GenericParameterizedType.newActualType(superGenericClass);
                } else {
                    genericParameterizedType = GenericParameterizedType.genericEntityType(parameterType, typeVariable.getName());
                }
            } else if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pt.getActualTypeArguments();
                if (actualTypeArguments.length == 1) {
                    Type actualTypeArgument = actualTypeArguments[0];
                    genericParameterizedType = actualTypeArgument instanceof Class ? GenericParameterizedType.entityType(parameterType, (Class)actualTypeArgument) : GenericParameterizedType.newActualType(parameterType);
                } else {
                    TypeVariable<Class<?>>[] typeParameters = parameterType.getTypeParameters();
                    int i = 0;
                    HashMap genericClassMap = new HashMap();
                    for (TypeVariable<Class<?>> typeVariable : typeParameters) {
                        Type actualTypeArgument;
                        String name = typeVariable.getName();
                        if (!((actualTypeArgument = actualTypeArguments[i++]) instanceof Class)) continue;
                        genericClassMap.put(name, (Class)actualTypeArgument);
                    }
                    genericParameterizedType = GenericParameterizedType.entityType(parameterType, genericClassMap);
                }
            } else {
                genericParameterizedType = GenericParameterizedType.newActualType(parameterType);
            }
        }
        if (genericParameterizedType != null) {
            setterInfo.setGenericParameterizedType(genericParameterizedType);
        }
    }

    private static void parseWrapperFields(ClassStructureWrapper wrapper, Class<?> sourceClass, Map<String, Class<?>> superGenericClassMap) {
        HashSet<String> fieldNames = new HashSet<String>();
        ArrayList<GetterInfo> getterInfoOfFields = new ArrayList<GetterInfo>();
        for (Class<?> target = sourceClass; target != Object.class; target = target.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = target.getDeclaredFields()) {
                String fieldName;
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || !fieldNames.add(fieldName = field.getName())) continue;
                ClassStructureWrapper.setAccessible(field);
                ClassStructureWrapper.clearFinalModifiers(field);
                Class<?> fieldType = field.getType();
                GetterInfo getterInfo = new GetterInfo();
                getterInfo.setField(field);
                getterInfo.setName(fieldName);
                HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
                ClassStructureWrapper.addAnnotations(annotationMap, field.getAnnotations());
                getterInfo.setAnnotations(annotationMap);
                getterInfoOfFields.add(getterInfo);
                SetterInfo setterInfo = new SetterInfo();
                setterInfo.setName(fieldName);
                setterInfo.setField(field);
                setterInfo.setParameterType(fieldType);
                Type genericType = field.getGenericType();
                Class<?> declaringClass = field.getDeclaringClass();
                ClassStructureWrapper.parseSetterGenericType(superGenericClassMap, sourceClass, declaringClass, setterInfo, genericType, fieldType);
                setterInfo.setAnnotations(annotationMap);
                SetterInfo oldSetterInfo = wrapper.setterInfos.get(fieldName);
                if (oldSetterInfo != null && oldSetterInfo.isFieldDisabled()) continue;
                wrapper.setterInfos.put(fieldName, setterInfo);
            }
        }
        wrapper.getterInfoOfFields = Collections.unmodifiableList(getterInfoOfFields);
    }

    private static void clearFinalModifiers(Field field) {
        if (modifierField != null) {
            try {
                modifierField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean setAccessible(AccessibleObject accessibleObject) {
        try {
            boolean accessible = UnsafeHelper.setAccessible(accessibleObject);
            if (accessible) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            accessibleObject.setAccessible(true);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Set<String> setterNames() {
        return this.setterInfos.keySet();
    }

    private static void addAnnotations(Map<Class<? extends Annotation>, Annotation> annotationMap, Annotation[] annotationArr) {
        if (annotationMap == null || annotationArr == null) {
            return;
        }
        for (Annotation annotation : annotationArr) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
    }

    static {
        Field field = null;
        try {
            field = Field.class.getDeclaredField("modifiers");
            ClassStructureWrapper.setAccessible(field);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modifierField = field;
        Method parametersMethod = null;
        try {
            parametersMethod = Method.class.getMethod("getParameters", new Class[0]);
            parametersMethod.setAccessible(true);
            ClassStructureWrapper.setAccessible(parametersMethod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        getParametersMethod = parametersMethod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClassWrapperType {
        Normal,
        Record,
        TemporalLocalDate,
        TemporalLocalDateTime,
        TemporalLocalTime,
        TemporalInstant,
        TemporalZonedDateTime;

    }
}

