/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteUtils {
    public static byte[] memset(int c, int length) {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)c;
        }
        return buffer;
    }

    public static byte[] memcpy(byte[] src, int start, int len) {
        byte[] buffer = new byte[len];
        System.arraycopy(src, start, buffer, 0, len);
        return buffer;
    }

    public static String toString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int len = bytes.length;
        for (int i = 0; i < len && bytes[i] != 0; ++i) {
            sb.append((char)bytes[i]);
        }
        return sb.toString();
    }

    public static byte[] toBytes(String str, int size) {
        int len = str == null ? 0 : str.length();
        byte[] bytes = new byte[size];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)str.charAt(i);
            }
        }
        return bytes;
    }

    public static boolean differByte(byte[] a, byte[] b, int count) {
        int length;
        boolean flag = false;
        int n = length = a.length < b.length ? a.length : b.length;
        if (count <= length) {
            for (int i = 0; i < count; ++i) {
                if (a[i] == b[i]) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static byte[] int2bytes(int num) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(num >>> 24 - i * 8);
        }
        return b;
    }

    public static byte[] int2bytesReverse(int num) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[3 - i] = (byte)(num >>> 24 - i * 8);
        }
        return b;
    }

    public static int bytes2int(byte[] b) {
        int s = 0;
        for (int i = 0; i < b.length; ++i) {
            s |= (b[i] & 0xFF) << (b.length - i - 1) * 8;
        }
        return s;
    }

    public static int bytes2intReverse(byte[] b) {
        byte[] tmp = new byte[4];
        for (int i = 0; i < 4; ++i) {
            tmp[i] = b[3 - i];
        }
        return ByteUtils.bytes2int(tmp);
    }

    public static String printHexString(byte[] b) {
        return ByteUtils.printHexString(b, '\u0000');
    }

    public static String printHexString(byte[] b, char splitChar) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                builder.append('0');
            }
            builder.append(hex.toUpperCase());
            if (splitChar <= '\u0000') continue;
            builder.append(splitChar);
        }
        return builder.toString();
    }

    public static byte[] hexString2Bytes(String hexString) {
        char[] chars = hexString.toCharArray();
        return ByteUtils.hexString2Bytes(chars, 0, chars.length);
    }

    public static byte[] hexString2Bytes(char[] chars, int offset, int len) {
        byte[] bytes = new byte[len / 2];
        int byteLength = 0;
        int b = -1;
        int count = offset + len;
        for (int i = offset; i < count; ++i) {
            int numIndex;
            char ch = Character.toUpperCase(chars[i]);
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) continue;
            if (b == -1) {
                b = numIndex << 4;
                continue;
            }
            bytes[byteLength++] = (byte)(b += numIndex);
            b = -1;
        }
        if (byteLength == bytes.length) {
            return bytes;
        }
        return ByteUtils.memcpy(bytes, 0, byteLength);
    }

    public static byte[] readStreamBytes(InputStream is) throws IOException {
        return ByteUtils.readStreamBytes(is, true);
    }

    private static byte[] readStreamBytes(InputStream is, boolean closed) throws IOException {
        int b;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((b = is.read()) > -1) {
            byteArrayOutputStream.write(b);
        }
        if (closed) {
            is.close();
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

