/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    public static <T> int indexOf(T[] arr, T obj) {
        return CollectionUtils.indexOf(arr, obj, 0);
    }

    public static <T> int indexOf(T[] arr, T obj, int fromIndex) {
        if (arr == null || obj == null) {
            return -1;
        }
        for (int i = fromIndex; i < arr.length; ++i) {
            T e = arr[i];
            if (e != obj && !obj.equals(e)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] arr, T obj, int fromIndex, int toIndex) {
        if (arr == null || obj == null) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            T e = arr[i];
            if (e != obj && !obj.equals(e)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] arr, int j) {
        return CollectionUtils.indexOf(arr, j, 0);
    }

    public static int indexOf(int[] arr, int j, int fromIndex) {
        if (arr == null) {
            return -1;
        }
        for (int i = fromIndex; i < arr.length; ++i) {
            if (arr[i] != j) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] arr, int j, int fromIndex, int toIndex) {
        if (arr == null) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (arr[i] != j) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] arr, char j) {
        return CollectionUtils.indexOf(arr, j, 0, arr.length);
    }

    public static int indexOf(char[] arr, char j, int fromIndex) {
        return CollectionUtils.indexOf(arr, j, fromIndex, arr.length);
    }

    public static int indexOf(char[] arr, char j, int fromIndex, int toIndex) {
        if (arr == null) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (arr[i] != j) continue;
            return i;
        }
        return -1;
    }

    public static boolean isCollection(Object target) {
        if (target == null) {
            return false;
        }
        if (target.getClass().isArray()) {
            return true;
        }
        return target instanceof Collection;
    }

    public static String join(Object[] arr, String delimiter) {
        if (arr == null) {
            return null;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuffer buffer = new StringBuffer();
        boolean appendDelimiterFlag = false;
        for (Object val : arr) {
            buffer.append(val).append(delimiter);
            appendDelimiterFlag = true;
        }
        if (appendDelimiterFlag) {
            buffer.delete(buffer.length() - delimiter.length(), buffer.length());
        }
        return buffer.toString();
    }

    public static boolean contains(Object[] arr, Object obj) {
        return CollectionUtils.indexOf(arr, obj) > -1;
    }

    public static boolean isEmpty(Collection groups) {
        return groups == null || groups.size() == 0;
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static int getSize(Object target) {
        if (target == null) {
            return 0;
        }
        if (target instanceof Collection) {
            return ((Collection)target).size();
        }
        return ((Object[])target).length;
    }

    public static Object getElement(Object target, int index) {
        if (target == null) {
            return null;
        }
        Object[] arr = null;
        arr = target instanceof Collection ? ((Collection)target).toArray() : (Object[])target;
        return arr[index];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setElement(Object target, int index, Object value) {
        if (target == null) {
            return;
        }
        if (target instanceof Collection) {
            if (!(target instanceof List)) throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u96c6\u5408\u8d4b\u503c\u64cd\u4f5c");
            ((List)target).set(index, value);
            return;
        } else {
            Object[] arr = null;
            arr = (Object[])target;
            arr[index] = value;
        }
    }
}

