/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import java.util.Arrays;

public class IOUtils {
    public static final char[] readUTF8Bytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        char[] chars = new char[len];
        int charLen = IOUtils.readUTF8Bytes(bytes, chars);
        if (charLen != len) {
            chars = Arrays.copyOf(chars, charLen);
        }
        return chars;
    }

    public static final int readUTF8Bytes(byte[] bytes, char[] chars) {
        return IOUtils.readUTF8Bytes(bytes, 0, bytes.length, chars, 0);
    }

    public static final int readUTF8Bytes(byte[] bytes, int offset, int len, char[] chars, int cOffset) {
        if (bytes == null) {
            return 0;
        }
        int charLen = cOffset;
        int max = offset + len;
        block5: for (int j = offset; j < max; ++j) {
            byte b = bytes[j];
            if (b >= 0) {
                chars[charLen++] = (char)b;
                continue;
            }
            int s = b >> 4;
            switch (s) {
                case -1: {
                    byte b2;
                    byte b1;
                    if (j < max - 3) {
                        byte b3;
                        int a;
                        b1 = bytes[++j];
                        ++j;
                        b2 = bytes[j];
                        if (Character.isSupplementaryCodePoint(a = (b & 7) << 18 | (b1 & 0x3F) << 12 | (b2 & 0x3F) << 6 | (b3 = bytes[++j]) & 0x3F)) {
                            chars[charLen++] = (char)((a >>> 10) + 55232);
                            chars[charLen++] = (char)((a & 0x3FF) + 56320);
                            continue block5;
                        }
                        chars[charLen++] = (char)a;
                        continue block5;
                    }
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
                case -2: {
                    byte b2;
                    byte b1;
                    if (j < max - 2) {
                        b1 = bytes[++j];
                        b2 = bytes[++j];
                        int a = (b & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F;
                        chars[charLen++] = (char)a;
                        continue block5;
                    }
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
                case -4: 
                case -3: {
                    byte b1;
                    if (j < max - 1) {
                        b1 = bytes[++j];
                        int a = (b & 0x1F) << 6 | b1 & 0x3F;
                        chars[charLen++] = (char)a;
                        continue block5;
                    }
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
                default: {
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
            }
        }
        return charLen;
    }
}

