/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

public class NumberUtils {
    public static double parseDouble(char[] chars, int offset, int len) {
        int i = offset;
        int endIndex = len + offset;
        double value = 0.0;
        int radix = 10;
        int decimalCount = 0;
        char ch = chars[offset];
        boolean negative = false;
        if (ch == '-') {
            negative = true;
            ++i;
        }
        int mode = 0;
        int expValue = 0;
        boolean expNegative = false;
        while (i < endIndex) {
            int digit;
            ch = chars[i];
            if (ch == '.') {
                if (mode != 0) {
                    throw new NumberFormatException("For input string: \"" + new String(chars, offset, len) + "\"");
                }
                mode = 1;
                if (++i < endIndex) {
                    ch = chars[i];
                }
            } else if (ch == 'E') {
                if (mode == 2) {
                    throw new NumberFormatException("For input string: \"" + new String(chars, offset, len) + "\"");
                }
                mode = 2;
                if (++i < endIndex) {
                    ch = chars[i];
                }
                if (ch == '-') {
                    expNegative = true;
                    if (++i < endIndex) {
                        ch = chars[i];
                    }
                }
            }
            if ((digit = Character.digit(ch, radix)) == -1 && (ch != 'd' && ch != 'D' || i < endIndex - 1)) {
                throw new NumberFormatException("For input string: \"" + new String(chars, offset, len) + "\"");
            }
            switch (mode) {
                case 0: {
                    value *= (double)radix;
                    value += (double)digit;
                    break;
                }
                case 1: {
                    value *= (double)radix;
                    value += (double)digit;
                    ++decimalCount;
                    break;
                }
                case 2: {
                    expValue *= 10;
                    expValue += digit;
                }
            }
            ++i;
        }
        int n = expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
        if (expValue > 0) {
            double powValue = Math.pow(radix, expValue);
            value *= powValue;
        } else if (expValue < 0) {
            double powValue = Math.pow(radix, -expValue);
            value /= powValue;
        }
        return negative ? -value : value;
    }

    public static int digitDecimal(int ch) {
        switch (ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return ch - 48;
            }
        }
        return -1;
    }

    public static final int parseIntWithin5(char[] buf, int fromIndex, int n) throws NumberFormatException {
        switch (n) {
            case 1: {
                return NumberUtils.parseInt1(buf, fromIndex);
            }
            case 2: {
                return NumberUtils.parseInt2(buf, fromIndex);
            }
            case 3: {
                return NumberUtils.parseInt3(buf, fromIndex);
            }
            case 4: {
                return NumberUtils.parseInt4(buf, fromIndex);
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, n) + "\"");
    }

    public static final int parseIntWithin5(byte[] bytes, int fromIndex, int n) throws NumberFormatException {
        switch (n) {
            case 1: {
                return NumberUtils.parseInt1(bytes[fromIndex]);
            }
            case 2: {
                return NumberUtils.parseInt2(bytes[fromIndex++], (int)bytes[fromIndex]);
            }
            case 3: {
                return NumberUtils.parseInt3(bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex]);
            }
            case 4: {
                return NumberUtils.parseInt4(bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex]);
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(bytes, fromIndex, n) + "\"");
    }

    public static final int parseInt4(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf[fromIndex++], buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static final int parseInt4(byte[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf[fromIndex++], buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static final int parseInt4(int c1, int c2, int c3, int c4) {
        int v4;
        int v3;
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2)) | (v3 = NumberUtils.digitDecimal(c3)) | (v4 = NumberUtils.digitDecimal(c4))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2, (char)c3, (char)c4}) + "\"");
        }
        return v1 * 1000 + v2 * 100 + v3 * 10 + v4;
    }

    public static final int parseInt3(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt3(buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static final int parseInt3(int c1, int c2, int c3) throws NumberFormatException {
        int v3;
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2)) | (v3 = NumberUtils.digitDecimal(c3))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2, (char)c3}) + "\"");
        }
        return v1 * 100 + v2 * 10 + v3;
    }

    public static final int parseInt2(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf[fromIndex++], (int)buf[fromIndex]);
    }

    public static final int parseInt2(byte[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf[fromIndex++], (int)buf[fromIndex]);
    }

    public static final int parseInt2(int c1, int c2) throws NumberFormatException {
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2}) + "\"");
        }
        return v1 * 10 + v2;
    }

    public static final int parseInt1(char[] buf, int fromIndex) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(buf[fromIndex]);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, 1) + "\"");
        }
        return v1;
    }

    public static final int parseInt1(byte[] buf, int fromIndex) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(buf[fromIndex]);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, 1) + "\"");
        }
        return v1;
    }

    public static final int parseInt1(int ch) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(ch);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + ch + "\"");
        }
        return v1;
    }
}

