/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.exceptions.LogicNullPointerException;
import io.github.wycst.wast.common.exceptions.TypeNotMatchExecption;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.CollectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtils {
    public static boolean contains(Object target, String key) {
        if (target == null) {
            throw new LogicNullPointerException(" target is null !");
        }
        if (target instanceof Map) {
            return ((Map)target).containsKey(key);
        }
        ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(target.getClass());
        List<GetterInfo> getterInfos = classStructureWrapper.getGetterInfos();
        for (GetterInfo getterInfo : getterInfos) {
            if (!getterInfo.getName().equals(key.trim())) continue;
            return true;
        }
        return false;
    }

    public static <E> E getContext(Object context, String exprKey, Class<E> clazz) {
        Object result = ObjectUtils.get(context, exprKey);
        if (result == null) {
            return null;
        }
        if (clazz != null && !clazz.isInstance(result)) {
            throw new TypeNotMatchExecption(" type is not match, expect " + clazz + ", but get " + result.getClass());
        }
        return (E)result;
    }

    public static <E> E get(Object target, String key, Class<E> clazz) {
        Object result = ObjectUtils.get(target, key);
        if (result == null) {
            return null;
        }
        try {
            return (E)result;
        }
        catch (Throwable throwable) {
            throw new TypeNotMatchExecption(" type is not match, expect " + clazz + ", but get " + result.getClass());
        }
    }

    public static Object get(Object target, String key) {
        if (target == null) {
            return null;
        }
        if (key == null) {
            throw new LogicNullPointerException(" key is null !");
        }
        key = key.trim();
        int dotIndex = key.indexOf(46);
        if (target instanceof Map) {
            Map mapTarget = (Map)target;
            if (mapTarget.containsKey(key)) {
                return mapTarget.get(key);
            }
            if (dotIndex > -1) {
                String topKey = key.substring(0, dotIndex);
                String nextKey = key.substring(dotIndex + 1);
                Object nextTarget = mapTarget.get(topKey);
                return ObjectUtils.get(nextTarget, nextKey);
            }
        } else {
            if (dotIndex > -1) {
                String topKey = key.substring(0, dotIndex);
                String nextKey = key.substring(dotIndex + 1);
                Object nextTarget = ObjectUtils.get(target, topKey);
                return ObjectUtils.get(nextTarget, nextKey);
            }
            if (CollectionUtils.isCollection(target)) {
                if ("size".equals(key) || "length".equals(key)) {
                    return CollectionUtils.getSize(target);
                }
                if (key.startsWith("[") && key.endsWith("]")) {
                    return CollectionUtils.getElement(target, Integer.parseInt(key.substring(1, key.length() - 1)));
                }
                throw new TypeNotMatchExecption("context property '" + key + "' is invalid ");
            }
            ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(target.getClass());
            List<GetterInfo> getterInfos = classStructureWrapper.getGetterInfos();
            for (GetterInfo getterInfo : getterInfos) {
                if (!getterInfo.getName().equals(key.trim())) continue;
                return getterInfo.invoke(target);
            }
        }
        return null;
    }

    public static void set(Object target, String key, Object value) {
        ObjectUtils.set(target, key, value, false);
    }

    public static void set(Object target, String key, Object value, boolean createIfMapNull) {
        if (target == null) {
            return;
        }
        if (key == null) {
            throw new LogicNullPointerException(" key is null !");
        }
        key = key.trim();
        int dotIndex = key.indexOf(46);
        if (target instanceof Map) {
            Map mapTarget = (Map)target;
            if (mapTarget.containsKey(key)) {
                mapTarget.put(key, value);
            } else if (dotIndex > -1) {
                String topKey = key.substring(0, dotIndex);
                String nextKey = key.substring(dotIndex + 1);
                Object nextTarget = mapTarget.get(topKey);
                if (createIfMapNull && nextTarget == null) {
                    nextTarget = new LinkedHashMap();
                    mapTarget.put(topKey, nextTarget);
                }
                ObjectUtils.set(nextTarget, nextKey, value, createIfMapNull);
            } else {
                mapTarget.put(key, value);
            }
        } else if (dotIndex > -1) {
            String topKey = key.substring(0, dotIndex);
            String nextKey = key.substring(dotIndex + 1);
            Object nextTarget = ObjectUtils.get(target, topKey);
            ObjectUtils.set(nextTarget, nextKey, value, createIfMapNull);
        } else {
            if (CollectionUtils.isCollection(target)) {
                if (key.startsWith("[") && key.endsWith("]")) {
                    CollectionUtils.setElement(target, Integer.parseInt(key.substring(1, key.length() - 1)), value);
                }
                throw new TypeNotMatchExecption("context property '" + key + "' is invalid ");
            }
            ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(target.getClass());
            SetterInfo setterInfo = classStructureWrapper.getSetterInfo(key);
            if (setterInfo != null) {
                setterInfo.invoke(target, value);
            }
        }
    }

    public static Object[] get(Object target, List<String> keys) {
        if (keys == null) {
            throw new LogicNullPointerException(" keys is null !");
        }
        Object[] values = new Object[keys.size()];
        int index = 0;
        for (String key : keys) {
            values[index++] = ObjectUtils.get(target, key);
        }
        return values;
    }

    public static Map<String, Object> toMap(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Map) {
            return (Map)target;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(target.getClass());
        List<GetterInfo> getterInfos = classStructureWrapper.getGetterInfos();
        for (GetterInfo getterInfo : getterInfos) {
            map.put(getterInfo.getName(), getterInfo.invoke(target));
        }
        return map;
    }

    public static List<String> getNonEmptyFields(Object target) {
        if (target == null) {
            return null;
        }
        ArrayList<String> fields = new ArrayList<String>();
        if (target instanceof Map) {
            Map map = (Map)target;
            for (String field : map.keySet()) {
                Object val = map.get(field);
                if (val == null || val.equals("")) continue;
                fields.add(field);
            }
        } else {
            ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(target.getClass());
            List<GetterInfo> getterInfos = classStructureWrapper.getGetterInfos();
            for (GetterInfo getterInfo : getterInfos) {
                Object val = getterInfo.invoke(target);
                if (val == null || val.equals("") || val.toString().equals("0")) continue;
                fields.add(getterInfo.getName());
            }
        }
        return fields;
    }

    public static boolean methodWeakEquals(Method source, Method target) {
        Class<?>[] params2;
        if (!source.getName().equals(target.getName())) {
            return false;
        }
        if (!source.getReturnType().equals(target.getReturnType())) {
            return false;
        }
        Class<?>[] params1 = source.getParameterTypes();
        if (params1.length == (params2 = target.getParameterTypes()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Iterable<Object> getIterable(Object context, String key) {
        Object target = ObjectUtils.get(context, key);
        if (target == null) {
            throw new TypeNotMatchExecption("context property '" + key + "' is null or not iterable ");
        }
        if (target instanceof Iterable) {
            return (Iterable)target;
        }
        if (target.getClass().isArray()) {
            Object[] array = (Object[])target;
            return Arrays.asList(array);
        }
        throw new TypeNotMatchExecption("context property '" + key + "' is not array or iterable ");
    }
}

