/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.utils.ByteUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.RegexUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static String getCamelCase(String columnName) {
        return StringUtils.getCamelCase(columnName, false);
    }

    public static String getCamelCase(String columnName, boolean upperCaseFirstChar) {
        if (columnName == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (columnName.indexOf("_") == -1) {
            char[] chars = columnName.toCharArray();
            chars[0] = upperCaseFirstChar ? Character.toUpperCase(chars[0]) : Character.toLowerCase(chars[0]);
            return new String(chars);
        }
        columnName = columnName.toLowerCase();
        String[] elements = columnName.split("_");
        int i = 0;
        for (String element : elements) {
            if (i++ > 0) {
                if (element.length() > 1) {
                    buffer.append(element.substring(0, 1).toUpperCase() + element.substring(1));
                    continue;
                }
                buffer.append(element.toUpperCase());
                continue;
            }
            buffer.append(element);
        }
        if (buffer.length() > 0 && upperCaseFirstChar) {
            char ch = buffer.charAt(0);
            buffer.setCharAt(0, Character.toUpperCase(ch));
        }
        return buffer.toString();
    }

    public static String camelCaseToSymbol(String camelCase) {
        return StringUtils.camelCaseToSymbol(camelCase, "_");
    }

    public static String camelCaseToSymbol(String camelCase, String symbol) {
        if (camelCase == null) {
            return null;
        }
        return camelCase.replaceAll("([A-Z])", symbol + "$1").toLowerCase();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String regexGroupExprReplace(String source, String groupRegex, String prefix, Object context) {
        List<String> groups = RegexUtils.getMatcherGroups(source, groupRegex, false);
        HashSet<String> hashGroups = new HashSet<String>(groups);
        String result = source;
        if (hashGroups != null && hashGroups.size() > 0) {
            for (String group : hashGroups) {
                Object value = ObjectUtils.get(context, group.trim());
                if (value == null) continue;
                result = result.replace(prefix + "{" + group + "}", value.toString());
            }
        }
        return result;
    }

    public static String replacePlaceholder(String message, String placeholder, Object[] parameters) {
        int parameterCount;
        if (StringUtils.isEmpty(placeholder) || parameters == null || (parameterCount = parameters.length) == 0) {
            return message;
        }
        int placeholderIndex = -1;
        placeholderIndex = message.indexOf(placeholder);
        if (placeholderIndex == -1) {
            return message;
        }
        StringBuffer buffer = new StringBuffer();
        int fromIndex = 0;
        int placeholderLen = placeholder.length();
        int i = 0;
        while (placeholderIndex > -1) {
            buffer.append(message, fromIndex, placeholderIndex);
            if (i < parameterCount) {
                buffer.append(parameters[i++]);
            } else {
                buffer.append(placeholder);
            }
            fromIndex = placeholderIndex + placeholderLen;
            placeholderIndex = message.indexOf(placeholder, fromIndex);
        }
        if (fromIndex < message.length()) {
            buffer.append(message, fromIndex, message.length());
        }
        return buffer.toString();
    }

    public static String replaceGroupRegex(String message, Object context) {
        return StringUtils.replaceGroupRegex(message, "[$][{](.*?)[}]", context);
    }

    public static String replaceGroupRegex(String message, Object context, boolean emptyIfNull) {
        return StringUtils.replaceGroupRegex(message, "[$][{]([ ]*[0-9a-zA-Z_.$]+[ ]*)[}]", context, emptyIfNull);
    }

    public static String replaceGroupRegex(String message, String groupRegex, Object context) {
        return StringUtils.replaceGroupRegex(message, groupRegex, context, false);
    }

    public static String replaceGroupRegex(String message, String groupRegex, Object context, boolean emptyIfNull) {
        if (StringUtils.isEmpty(groupRegex) || context == null) {
            return message;
        }
        if (groupRegex.indexOf(")") <= groupRegex.indexOf("(") || groupRegex.indexOf("(") == -1) {
            return message;
        }
        StringBuffer buffer = new StringBuffer();
        Pattern pattern = RegexUtils.getPattern(groupRegex);
        Matcher matcher = pattern.matcher(message);
        int beginIndex = 0;
        while (matcher.find()) {
            int newBeginIndex = matcher.start(0);
            if (message.charAt(newBeginIndex - 1) == '\\') {
                buffer.append(message, beginIndex, newBeginIndex - 1);
                buffer.append(matcher.group(0));
            } else {
                String key = matcher.group(1).trim();
                buffer.append(message, beginIndex, newBeginIndex);
                Object value = ObjectUtils.get(context, key);
                if (value != null || !emptyIfNull) {
                    buffer.append(value);
                }
            }
            beginIndex = matcher.end(0);
        }
        buffer.append(message, beginIndex, message.length());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThrowableContent(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
        finally {
            pw.close();
        }
    }

    public static String escapeHtml(String value) {
        if (value == null) {
            return value;
        }
        value = value.replace("&", "&amp;");
        value = value.replaceAll("[<](.*?)[>]", "&lt;$1&gt;").replaceAll("[(](.*?)[)]", "&#40;$1&#41;");
        value = value.replaceAll("=([ ]*)\"", "=$1&quot;");
        value = value.replace("'", "&#39;").replace(" ", "&nbsp;");
        return value;
    }

    public static String htmlUnescape(String value) {
        if (value == null) {
            return value;
        }
        value = value.replace("&#39;", "'").replace("&nbsp;", " ");
        value = value.replaceAll("=([ ]*)&quot;", "=$1\"");
        value = value.replaceAll("&lt;(.*?)&gt;", "<$1>").replaceAll("&#40;(.*?)&#41;", "($1)");
        value = value.replace("&amp;", "&");
        return value;
    }

    public static boolean contains(String[] arr, String element) {
        if (arr == null || element == null) {
            return false;
        }
        for (String str : arr) {
            if (!element.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static String formatMappingPath(String ... paths) {
        StringBuffer pathBuffer = new StringBuffer("/");
        for (String path : paths) {
            if (path == null || path.length() == 0) continue;
            pathBuffer.append(path);
            if (path.endsWith("/")) continue;
            pathBuffer.append("/");
        }
        String path = pathBuffer.toString().trim();
        if (path.indexOf("\\") > -1) {
            path = path.replace("\\", "/");
        }
        path = path.replaceAll("(/)+", "$1");
        return path;
    }

    public static String fromResource(String resource) {
        if (resource == null) {
            return null;
        }
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        InputStream is = StringUtils.class.getResourceAsStream(resource);
        return StringUtils.fromStream(is);
    }

    public static String fromStream(InputStream is) {
        try {
            byte[] bytes = ByteUtils.readStreamBytes(is);
            return new String(bytes);
        }
        catch (IOException e) {
            return null;
        }
    }
}

