/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONStringWriter;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONGeneral {
    protected static final char[] NULL;
    protected static final char[] EMPTY_ARRAY;
    protected static final char[] EMPTY_OBJECT;
    protected static final byte Zero = 0;
    protected static final byte Comma = 44;
    protected static final byte DoubleQuotation = 34;
    protected static final byte EndArray = 93;
    protected static final byte EndObject = 125;
    protected static final byte WhiteSpace = 32;
    protected static final String[] escapes;
    protected static final boolean[] needEscapes;
    protected static final String[] MONTH_ABBR;
    protected static final boolean StringCoder;
    protected static final float JDK_VERSION;
    protected static final boolean JDK_17_ABOVE;
    protected static final boolean JDK_9_ABOVE;
    protected static final char[] DigitOnes;
    protected static final char[] DigitTens;
    static final double[] PositiveDecimalPower;
    protected static final int DIRECT_READ_BUFFER_SIZE = 8192;
    protected static final Map<String, TimeZone> GMT_TIME_ZONE_MAP;
    public static final TimeZone ZERO_TIME_ZONE;
    protected static final ThreadLocal<char[]> CachedChars_20;
    protected static final ThreadLocal<char[]> CachedCharsDate_19;

    JSONGeneral() {
    }

    public static String toEscapeString(int ch) {
        return String.format("\\u%04x", ch);
    }

    protected static double getDecimalPowerValue(int expValue) {
        if (expValue < PositiveDecimalPower.length) {
            return PositiveDecimalPower[expValue];
        }
        return Math.pow(10.0, expValue);
    }

    protected static final int parseInt2(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf, fromIndex);
    }

    protected static final int parseInt4(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf, fromIndex);
    }

    protected static final int parseIntWithin5(char[] buf, int fromIndex, int n) throws NumberFormatException {
        return NumberUtils.parseIntWithin5(buf, fromIndex, n);
    }

    protected static final int escapeNext(char[] buf, char next, int i, int beginIndex, JSONStringWriter writer, JSONParseContext jsonParseContext) {
        switch (next) {
            case '\"': 
            case '\'': {
                if (i > beginIndex) {
                    writer.write(buf, beginIndex, i - beginIndex + 1);
                    writer.setCharAt(writer.size() - 1, next);
                } else {
                    writer.append(next);
                }
                beginIndex = ++i + 1;
                break;
            }
            case 'n': {
                int len = i - beginIndex;
                writer.write(buf, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\n');
                beginIndex = ++i + 1;
                break;
            }
            case 'r': {
                int len = i - beginIndex;
                writer.write(buf, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\r');
                beginIndex = ++i + 1;
                break;
            }
            case 't': {
                int len = i - beginIndex;
                writer.write(buf, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\t');
                beginIndex = ++i + 1;
                break;
            }
            case 'b': {
                int len = i - beginIndex;
                writer.write(buf, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\b');
                beginIndex = ++i + 1;
                break;
            }
            case 'f': {
                int len = i - beginIndex;
                writer.write(buf, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\f');
                beginIndex = ++i + 1;
                break;
            }
            case 'u': {
                int len = i - beginIndex;
                writer.write(buf, beginIndex, len + 1);
                int c = JSONGeneral.hex4(buf, i + 2);
                writer.setCharAt(writer.size() - 1, (char)c);
                i += 4;
                beginIndex = ++i + 1;
                break;
            }
            default: {
                int len = i - beginIndex;
                writer.write(buf, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, next);
                beginIndex = ++i + 1;
            }
        }
        jsonParseContext.setEndIndex(i);
        return beginIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String parseEscapeString(String str) {
        str.getClass();
        int beginIndex = str.indexOf(92);
        if (beginIndex == -1) {
            return str;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        JSONStringWriter writer = JSONGeneral.getContextWriter(jsonParseContext);
        try {
            char[] chars = JSONGeneral.getChars(str);
            char next = chars[beginIndex + 1];
            beginIndex = JSONGeneral.escapeNext(chars, next, beginIndex, 0, writer, jsonParseContext);
            int max = chars.length;
            for (int i = beginIndex + 1; i < max; ++i) {
                if (chars[i] != '\\') continue;
                next = chars[i + 1];
                beginIndex = JSONGeneral.escapeNext(chars, next, i, beginIndex, writer, jsonParseContext);
                i = jsonParseContext.getEndIndex();
            }
            writer.write(chars, beginIndex, max - beginIndex);
            String string = writer.toString();
            return string;
        }
        finally {
            jsonParseContext.clear();
        }
    }

    protected static final int hex4(int i1, int i2, int i3, int i4) {
        return JSONGeneral.hex(i1) << 12 | JSONGeneral.hex(i2) << 8 | JSONGeneral.hex(i3) << 4 | JSONGeneral.hex(i4);
    }

    protected static int hex(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return c - 48;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return c - 97 + 10;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return c - 65 + 10;
            }
        }
        throw new IllegalArgumentException("invalid character: '" + (char)c + "', expected character in '0123456789abcdef(ABCDEF)'");
    }

    protected static int hex4(char[] buf, int fromIndex) {
        int j = fromIndex;
        try {
            int c1 = JSONGeneral.hex(buf[j++]);
            int c2 = JSONGeneral.hex(buf[j++]);
            int c3 = JSONGeneral.hex(buf[j++]);
            int c4 = JSONGeneral.hex(buf[j++]);
            return c1 << 12 | c2 << 8 | c3 << 4 | c4;
        }
        catch (Throwable throwable) {
            String errorContextTextAt = JSONGeneral.createErrorContextText(buf, j - 1);
            throw new JSONException("Syntax error, from pos " + fromIndex + ", context text by '" + errorContextTextAt + "', " + throwable.getMessage());
        }
    }

    protected static int digitDecimal(int ch) {
        return NumberUtils.digitDecimal(ch);
    }

    static final java.util.Date matchDate(char[] buf, int from, int to, String timezone, Class<? extends java.util.Date> dateCls) {
        int len = to - from;
        String timezoneIdAt = timezone;
        if (len > 19) {
            char ch;
            int j = to;
            while (j > from && (ch = buf[--j]) != '.' && ch != ' ') {
                if (ch != '+' && ch != '-' && ch != 'Z') continue;
                timezoneIdAt = new String(buf, j, to - j);
                to = j;
                len = to - from;
                break;
            }
        }
        switch (len) {
            case 8: {
                int month;
                int year3;
                try {
                    if (dateCls != null && Time.class.isAssignableFrom(dateCls)) {
                        int hour = JSONGeneral.parseInt2(buf, from);
                        int minute = JSONGeneral.parseInt2(buf, from + 3);
                        int second = JSONGeneral.parseInt2(buf, from + 6);
                        return JSONGeneral.parseDate(1970, 1, 1, hour, minute, second, 0, timezoneIdAt, dateCls);
                    }
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 4);
                    int day = JSONGeneral.parseInt2(buf, from + 6);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year2) {
                    return null;
                }
            }
            case 10: {
                int month;
                int year3;
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year3) {
                    return null;
                }
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                int month;
                int year3;
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 4);
                    int day = JSONGeneral.parseInt2(buf, from + 6);
                    int hour = JSONGeneral.parseInt2(buf, from + 8);
                    int minute = JSONGeneral.parseInt2(buf, from + 10);
                    int second = JSONGeneral.parseInt2(buf, from + 12);
                    int millsecond = 0;
                    if (len > 14) {
                        millsecond = JSONGeneral.parseIntWithin5(buf, from + 14, len - 14);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year) {
                    return null;
                }
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                int month;
                int year3;
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    int hour = JSONGeneral.parseInt2(buf, from + 11);
                    int minute = JSONGeneral.parseInt2(buf, from + 14);
                    int second = JSONGeneral.parseInt2(buf, from + 17);
                    int millsecond = 0;
                    if (len > 20) {
                        millsecond = JSONGeneral.parseIntWithin5(buf, from + 20, len - 20);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year) {
                    return null;
                }
            }
            case 28: {
                int year3;
                try {
                    year3 = JSONGeneral.parseInt4(buf, from + 24);
                    String monthAbbr = new String(buf, from + 4, 3);
                    int month = JSONGeneral.getMonthAbbrIndex(monthAbbr) + 1;
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    int hour = JSONGeneral.parseInt2(buf, from + 11);
                    int minute = JSONGeneral.parseInt2(buf, from + 14);
                    int second = JSONGeneral.parseInt2(buf, from + 17);
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
        return null;
    }

    protected static Object parseDateValueOfString(char[] buf, int from, int to, String pattern, int patternType, DateTemplate dateTemplate, String timezone, Class<? extends java.util.Date> dateCls) {
        int realFrom = from;
        String timezoneIdAt = timezone;
        try {
            switch (patternType) {
                case 0: {
                    return JSONGeneral.matchDate(buf, from + 1, to - 1, timezone, dateCls);
                }
                case 1: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 6);
                    int day = JSONGeneral.parseInt2(buf, from + 9);
                    int hour = JSONGeneral.parseInt2(buf, from + 12);
                    int minute = JSONGeneral.parseInt2(buf, from + 15);
                    int second = JSONGeneral.parseInt2(buf, from + 18);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                case 2: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 6);
                    int day = JSONGeneral.parseInt2(buf, from + 9);
                    return JSONGeneral.parseDate(year, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                case 3: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 7);
                    int hour = JSONGeneral.parseInt2(buf, from + 9);
                    int minute = JSONGeneral.parseInt2(buf, from + 11);
                    int second = JSONGeneral.parseInt2(buf, from + 13);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
            }
            TimeZone timeZone = JSONGeneral.getTimeZone(timezoneIdAt);
            long time = dateTemplate.parseTime(buf, from + 1, to - from - 2, timeZone);
            if (dateCls == java.util.Date.class) {
                return new java.util.Date(time);
            }
            Constructor<? extends java.util.Date> constructor = dateCls.getConstructor(Long.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(time);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            String dateSource = new String(buf, from + 1, to - from - 2);
            if (patternType > 0) {
                throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch date pattern '" + pattern + "'");
            }
            throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch any date format.");
        }
    }

    static final java.util.Date matchDate(byte[] buf, int from, int to, String timezone, Class<? extends java.util.Date> dateCls) {
        int len = to - from;
        String timezoneIdAt = timezone;
        if (len > 19) {
            byte ch;
            int j = to;
            while (j > from && (ch = buf[--j]) != 46 && ch != 32) {
                if (ch != 43 && ch != 45 && ch != 90) continue;
                timezoneIdAt = new String(buf, j, to - j);
                to = j;
                len = to - from;
                break;
            }
        }
        switch (len) {
            case 8: {
                int month;
                int year3;
                try {
                    if (dateCls != null && Time.class.isAssignableFrom(dateCls)) {
                        int hour = NumberUtils.parseInt2(buf, from);
                        int minute = NumberUtils.parseInt2(buf, from + 3);
                        int second = NumberUtils.parseInt2(buf, from + 6);
                        return JSONGeneral.parseDate(1970, 1, 1, hour, minute, second, 0, timezoneIdAt, dateCls);
                    }
                    year3 = NumberUtils.parseInt4(buf, from);
                    month = NumberUtils.parseInt2(buf, from + 4);
                    int day = NumberUtils.parseInt2(buf, from + 6);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year2) {
                    return null;
                }
            }
            case 10: {
                int month;
                int year3;
                try {
                    year3 = NumberUtils.parseInt4(buf, from);
                    month = NumberUtils.parseInt2(buf, from + 5);
                    int day = NumberUtils.parseInt2(buf, from + 8);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year3) {
                    return null;
                }
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                int month;
                int year3;
                try {
                    year3 = NumberUtils.parseInt4(buf, from);
                    month = NumberUtils.parseInt2(buf, from + 4);
                    int day = NumberUtils.parseInt2(buf, from + 6);
                    int hour = NumberUtils.parseInt2(buf, from + 8);
                    int minute = NumberUtils.parseInt2(buf, from + 10);
                    int second = NumberUtils.parseInt2(buf, from + 12);
                    int millsecond = 0;
                    if (len > 14) {
                        millsecond = NumberUtils.parseIntWithin5(buf, from + 14, len - 14);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year) {
                    return null;
                }
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                int month;
                int year3;
                try {
                    year3 = NumberUtils.parseInt4(buf, from);
                    month = NumberUtils.parseInt2(buf, from + 5);
                    int day = NumberUtils.parseInt2(buf, from + 8);
                    int hour = NumberUtils.parseInt2(buf, from + 11);
                    int minute = NumberUtils.parseInt2(buf, from + 14);
                    int second = NumberUtils.parseInt2(buf, from + 17);
                    int millsecond = 0;
                    if (len > 20) {
                        millsecond = NumberUtils.parseIntWithin5(buf, from + 20, len - 20);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year) {
                    return null;
                }
            }
            case 28: {
                int year3;
                try {
                    year3 = NumberUtils.parseInt4(buf, from + 24);
                    String monthAbbr = new String(buf, from + 4, 3);
                    int month = JSONGeneral.getMonthAbbrIndex(monthAbbr) + 1;
                    int day = NumberUtils.parseInt2(buf, from + 8);
                    int hour = NumberUtils.parseInt2(buf, from + 11);
                    int minute = NumberUtils.parseInt2(buf, from + 14);
                    int second = NumberUtils.parseInt2(buf, from + 17);
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
        return null;
    }

    protected static Object parseDateValueOfString(byte[] bytes, int from, int to, String pattern, int patternType, DateTemplate dateTemplate, String timezone, Class<? extends java.util.Date> dateCls) {
        int realFrom = from;
        String timezoneIdAt = timezone;
        try {
            switch (patternType) {
                case 0: {
                    return JSONGeneral.matchDate(bytes, from + 1, to - 1, timezone, dateCls);
                }
                case 1: {
                    int year = NumberUtils.parseInt4(bytes, from + 1);
                    int month = NumberUtils.parseInt2(bytes, from + 6);
                    int day = NumberUtils.parseInt2(bytes, from + 9);
                    int hour = NumberUtils.parseInt2(bytes, from + 12);
                    int minute = NumberUtils.parseInt2(bytes, from + 15);
                    int second = NumberUtils.parseInt2(bytes, from + 18);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                case 2: {
                    int year = NumberUtils.parseInt4(bytes, from + 1);
                    int month = NumberUtils.parseInt2(bytes, from + 6);
                    int day = NumberUtils.parseInt2(bytes, from + 9);
                    return JSONGeneral.parseDate(year, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                case 3: {
                    int year = NumberUtils.parseInt4(bytes, from + 1);
                    int month = NumberUtils.parseInt2(bytes, from + 5);
                    int day = NumberUtils.parseInt2(bytes, from + 7);
                    int hour = NumberUtils.parseInt2(bytes, from + 9);
                    int minute = NumberUtils.parseInt2(bytes, from + 11);
                    int second = NumberUtils.parseInt2(bytes, from + 13);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
            }
            TimeZone timeZone = JSONGeneral.getTimeZone(timezoneIdAt);
            long time = dateTemplate.parseTime(bytes, from + 1, to - from - 2, timeZone);
            if (dateCls == java.util.Date.class) {
                return new java.util.Date(time);
            }
            Constructor<? extends java.util.Date> constructor = dateCls.getConstructor(Long.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(time);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            String dateSource = new String(bytes, from + 1, to - from - 2);
            if (patternType > 0) {
                throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch date pattern '" + pattern + "'");
            }
            throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch any date format.");
        }
    }

    protected static Object parseDateValue(int from, int to, char[] buf, String pattern, String timezone, Class<? extends java.util.Date> dateCls) {
        int realFrom = from;
        int realTo = to;
        int start = 34;
        while (from < to && (start = buf[from]) <= 32) {
            ++from;
        }
        int end = 34;
        while (to > from && (end = buf[to - 1]) <= 32) {
            --to;
        }
        if (start == 34 && end == 34) {
            return JSONGeneral.parseDateValueOfString(buf, from, to, pattern, pattern == null ? 0 : 4, pattern == null ? null : new DateTemplate(pattern), timezone, dateCls);
        }
        try {
            long timestamp = Long.parseLong(new String(buf, from, to - from));
            return JSONGeneral.parseDate(timestamp, dateCls);
        }
        catch (Exception e) {
            String timestampStr = new String(buf, from, to - from);
            throw new JSONException("fromIndex " + realFrom + ", toIndex " + realTo + " str " + timestampStr + " error !");
        }
    }

    protected static final int clearCommentAndWhiteSpaces(char[] buf, int beginIndex, int toIndex, JSONParseContext jsonParseContext) {
        int i = beginIndex;
        if (i >= toIndex) {
            throw new JSONException("Syntax error, unexpected token character '/', position " + (beginIndex - 1));
        }
        char ch = buf[beginIndex];
        if (ch == '/') {
            while (i < toIndex && buf[i] != '\n') {
                ++i;
            }
            ch = '\u0000';
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            }
        } else if (ch == '*') {
            char prev = '\u0000';
            boolean matched = false;
            while (i + 1 < toIndex) {
                if ((ch = buf[++i]) == '/' && prev == '*') {
                    matched = true;
                    break;
                }
                prev = ch;
            }
            if (!matched) {
                throw new JSONException("Syntax error, not found the close comment '*/' util the end ");
            }
            ch = '\u0000';
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            }
        } else {
            throw new JSONException("Syntax error, unexpected token character '" + ch + "', position " + beginIndex);
        }
        return i;
    }

    protected static final void writeFormatSymbolOut(Writer content, int level, boolean formatOut) throws IOException {
        if (formatOut && level > -1) {
            String symbol = "\n\t\t\t\t\t\t\t\t\t\t";
            int symbolLen = 11;
            if (symbolLen - 1 > level) {
                content.write(symbol, 0, level + 1);
            } else {
                content.append(symbol);
                int appendTabLen = level - symbolLen + 1;
                while (appendTabLen-- > 0) {
                    content.append('\t');
                }
            }
        }
    }

    private static int getMonthAbbrIndex(String monthAbbr) {
        int len = MONTH_ABBR.length;
        for (int i = 0; i < len; ++i) {
            if (!MONTH_ABBR[i].equals(monthAbbr)) continue;
            return i;
        }
        return -1;
    }

    private static java.util.Date parseDate(int year, int month, int day, int hour, int minute, int second, int millsecond, String timeZoneId, Class<? extends java.util.Date> dateCls) {
        TimeZone timeZone = JSONGeneral.getTimeZone(timeZoneId);
        long timeInMillis = io.github.wycst.wast.common.beans.Date.getTime(year, month, day, hour, minute, second, millsecond, timeZone);
        return JSONGeneral.parseDate(timeInMillis, dateCls);
    }

    static TimeZone getTimeZone(String timeZoneId) {
        TimeZone timeZone = null;
        if (timeZoneId != null && timeZoneId.trim().length() > 0) {
            if (GMT_TIME_ZONE_MAP.containsKey(timeZoneId)) {
                timeZone = GMT_TIME_ZONE_MAP.get(timeZoneId);
            } else {
                timeZone = timeZoneId.startsWith("GMT") ? TimeZone.getTimeZone(timeZoneId) : TimeZone.getTimeZone("GMT" + timeZoneId);
                if (timeZone != null && timeZone.getRawOffset() != 0) {
                    GMT_TIME_ZONE_MAP.put(timeZoneId, timeZone);
                }
            }
        }
        return timeZone;
    }

    protected static java.util.Date parseDate(long timeInMillis, Class<? extends java.util.Date> dateCls) {
        if (dateCls == java.util.Date.class) {
            return new java.util.Date(timeInMillis);
        }
        if (dateCls == Date.class) {
            return new Date(timeInMillis);
        }
        if (dateCls == Timestamp.class) {
            return new Timestamp(timeInMillis);
        }
        try {
            Constructor<? extends java.util.Date> constructor = dateCls.getConstructor(Long.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(timeInMillis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String printHexString(byte[] b, char splitChar) {
        StringBuilder returnValue = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            returnValue.append(hex.toUpperCase());
            if (splitChar <= '\u0000') continue;
            returnValue.append(splitChar);
        }
        return returnValue.toString();
    }

    protected static byte[] hexString2Bytes(char[] chars, int offset, int len) {
        byte[] bytes = new byte[len / 2];
        int byteLength = 0;
        int b = -1;
        int count = offset + len;
        for (int i = offset; i < count; ++i) {
            int numIndex;
            char ch = Character.toUpperCase(chars[i]);
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) continue;
            if (b == -1) {
                b = numIndex << 4;
                continue;
            }
            bytes[byteLength++] = (byte)(b += numIndex);
            b = -1;
        }
        if (byteLength == bytes.length) {
            return bytes;
        }
        byte[] buffer = new byte[byteLength];
        System.arraycopy(bytes, 0, buffer, 0, byteLength);
        return buffer;
    }

    protected static byte[] hexString2Bytes(byte[] buf, int offset, int len) {
        byte[] bytes = new byte[len / 2];
        int byteLength = 0;
        int b = -1;
        int count = offset + len;
        for (int i = offset; i < count; ++i) {
            int numIndex;
            char ch = Character.toUpperCase((char)buf[i]);
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) continue;
            if (b == -1) {
                b = numIndex << 4;
                continue;
            }
            bytes[byteLength++] = (byte)(b += numIndex);
            b = -1;
        }
        if (byteLength == bytes.length) {
            return bytes;
        }
        byte[] buffer = new byte[byteLength];
        System.arraycopy(bytes, 0, buffer, 0, byteLength);
        return buffer;
    }

    protected static char[] readInputStream(InputStream is, int maxLen) throws IOException {
        try {
            char[] buf = new char[maxLen];
            InputStreamReader streamReader = new InputStreamReader(is);
            int len = streamReader.read(buf);
            streamReader.close();
            if (len != maxLen) {
                char[] tmp = new char[len];
                System.arraycopy(buf, 0, tmp, 0, len);
                buf = tmp;
            }
            char[] cArray = buf;
            return cArray;
        }
        catch (RuntimeException rx) {
            throw rx;
        }
        finally {
            is.close();
        }
    }

    protected static int getPatternType(String pattern) {
        if (pattern != null) {
            if (pattern.equalsIgnoreCase("yyyy-MM-dd HH:mm:ss") || pattern.equalsIgnoreCase("yyyy/MM/dd HH:mm:ss")) {
                return 1;
            }
            if (pattern.equalsIgnoreCase("yyyy-MM-dd") || pattern.equalsIgnoreCase("yyyy/MM/dd")) {
                return 2;
            }
            if (pattern.equalsIgnoreCase("yyyyMMddHHmmss")) {
                return 3;
            }
            return 4;
        }
        return 0;
    }

    protected static Object collectionToArray(Collection<Object> collection, Class<?> componentType) {
        return UnsafeHelper.toArray(collection, componentType);
    }

    protected static Object getArrayValueAt(Object arr, int index) {
        return UnsafeHelper.arrayValueAt(arr, index);
    }

    protected static Collection createCollectionInstance(Class<?> collectionCls) {
        if (collectionCls.isInterface()) {
            if (collectionCls == List.class || collectionCls == Collection.class) {
                return new ArrayList();
            }
            if (collectionCls == Set.class) {
                return new HashSet();
            }
            throw new UnsupportedOperationException("Unsupported for collection type '" + collectionCls + "', Please specify an implementation class");
        }
        if (collectionCls == ArrayList.class || collectionCls == Object.class) {
            return new HashSet();
        }
        if (collectionCls == HashSet.class) {
            return new HashSet();
        }
        if (collectionCls == Vector.class) {
            return new Vector();
        }
        try {
            return (Collection)collectionCls.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("create Collection instance error, class " + collectionCls);
        }
    }

    static Map createMapInstance(Class<? extends Map> mapCls) {
        if (mapCls == Map.class || mapCls == null || mapCls == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (mapCls == HashMap.class) {
            return new HashMap();
        }
        if (mapCls == Hashtable.class) {
            return new Hashtable();
        }
        if (mapCls == AbstractMap.class) {
            return new LinkedHashMap();
        }
        if (mapCls == TreeMap.class) {
            return new TreeMap();
        }
        try {
            return mapCls.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("create map instance error, class " + mapCls);
        }
    }

    protected static String createErrorContextText(char[] buf, int at) {
        try {
            int len = buf.length;
            char[] text = new char[40];
            int begin = Math.max(at - 18, 0);
            int count = at - begin;
            System.arraycopy(buf, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 18);
            System.arraycopy(buf, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    protected static JSONStringWriter getContextWriter(JSONParseContext jsonParseContext) {
        JSONStringWriter jsonWriter = jsonParseContext.getContextWriter();
        if (jsonWriter == null) {
            jsonWriter = new JSONStringWriter();
            jsonParseContext.setContextWriter(jsonWriter);
        }
        return jsonWriter;
    }

    protected static char[] getChars(String value) {
        return UnsafeHelper.getChars(value);
    }

    static {
        String[] availableIDs;
        int i;
        NULL = new char[]{'n', 'u', 'l', 'l'};
        EMPTY_ARRAY = new char[]{'[', ']'};
        EMPTY_OBJECT = new char[]{'{', '}'};
        escapes = new String[160];
        needEscapes = new boolean[160];
        MONTH_ABBR = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        PositiveDecimalPower = new double[310];
        GMT_TIME_ZONE_MAP = new ConcurrentHashMap<String, TimeZone>();
        ZERO_TIME_ZONE = TimeZone.getTimeZone("GMT+00:00");
        CachedChars_20 = new ThreadLocal<char[]>(){

            @Override
            protected char[] initialValue() {
                return new char[20];
            }
        };
        CachedCharsDate_19 = new ThreadLocal<char[]>(){

            @Override
            protected char[] initialValue() {
                char[] chars = new char[21];
                chars[20] = 34;
                chars[0] = 34;
                chars[8] = 45;
                chars[5] = 45;
                chars[11] = 32;
                chars[17] = 58;
                chars[14] = 58;
                return chars;
            }
        };
        block11: for (i = 0; i < escapes.length; ++i) {
            switch (i) {
                case 10: {
                    JSONGeneral.escapes[i] = "\\n";
                    JSONGeneral.needEscapes[i] = true;
                    continue block11;
                }
                case 9: {
                    JSONGeneral.escapes[i] = "\\t";
                    JSONGeneral.needEscapes[i] = true;
                    continue block11;
                }
                case 13: {
                    JSONGeneral.escapes[i] = "\\r";
                    JSONGeneral.needEscapes[i] = true;
                    continue block11;
                }
                case 8: {
                    JSONGeneral.escapes[i] = "\\b";
                    JSONGeneral.needEscapes[i] = true;
                    continue block11;
                }
                case 12: {
                    JSONGeneral.escapes[i] = "\\f";
                    JSONGeneral.needEscapes[i] = true;
                    continue block11;
                }
                case 34: {
                    JSONGeneral.escapes[i] = "\\\"";
                    JSONGeneral.needEscapes[i] = true;
                    continue block11;
                }
                case 92: {
                    JSONGeneral.escapes[i] = "\\\\";
                    JSONGeneral.needEscapes[i] = true;
                    continue block11;
                }
                default: {
                    if (i < 32) {
                        JSONGeneral.escapes[i] = JSONGeneral.toEscapeString(i);
                        JSONGeneral.needEscapes[i] = true;
                        continue block11;
                    }
                    if (i > 126) {
                        JSONGeneral.escapes[i] = JSONGeneral.toEscapeString(i);
                        JSONGeneral.needEscapes[i] = true;
                        continue block11;
                    }
                    JSONGeneral.escapes[i] = String.valueOf((char)i);
                }
            }
        }
        int len = PositiveDecimalPower.length;
        for (i = 0; i < len; ++i) {
            JSONGeneral.PositiveDecimalPower[i] = Math.pow(10.0, i);
        }
        for (String availableID : availableIDs = TimeZone.getAvailableIDs()) {
            GMT_TIME_ZONE_MAP.put(availableID, TimeZone.getTimeZone(availableID));
        }
        TimeZone timeZone = ZERO_TIME_ZONE;
        GMT_TIME_ZONE_MAP.put("GMT+00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("+00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("-00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("+0", timeZone);
        GMT_TIME_ZONE_MAP.put("-0", timeZone);
        timeZone = TimeZone.getTimeZone("GMT+08:00");
        GMT_TIME_ZONE_MAP.put("+08:00", timeZone);
        GMT_TIME_ZONE_MAP.put("GMT+08:00", timeZone);
        long stringCoderOffset = UnsafeHelper.getStringCoderOffset();
        StringCoder = stringCoderOffset > -1L;
        float jdkVersion = 1.8f;
        try {
            String version = System.getProperty("java.specification.version");
            if (version != null) {
                jdkVersion = Float.parseFloat(version);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JDK_VERSION = jdkVersion;
        JDK_9_ABOVE = (double)JDK_VERSION > 1.8;
        JDK_17_ABOVE = JDK_VERSION >= 17.0f;
    }
}

