/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.AsciiStringSource;
import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.UTF16ByteArraySource;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.json.JSONByteArrayParser;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONNodeContext;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.options.Options;
import io.github.wycst.wast.json.options.ReadOption;
import io.github.wycst.wast.json.reflect.FieldDeserializer;
import io.github.wycst.wast.json.reflect.ObjectStructureWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONPojoDeserializer<T>
extends JSONTypeDeserializer {
    private final Class<? extends T> pojoClass;
    protected final ObjectStructureWrapper pojoStructureWrapper;

    public JSONPojoDeserializer(Class<? extends T> pojoClass) {
        pojoClass.getClass();
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(pojoClass);
        if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) {
            throw new UnsupportedOperationException("type not support for " + pojoClass);
        }
        this.pojoClass = pojoClass;
        this.pojoStructureWrapper = ObjectStructureWrapper.get(pojoClass);
        if (this.pojoStructureWrapper == null) {
            throw new UnsupportedOperationException("type not support for " + pojoClass);
        }
    }

    @Override
    protected final Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object entity, char endToken, JSONParseContext jsonParseContext) throws Exception {
        char beginChar = buf[fromIndex];
        switch (beginChar) {
            case '{': {
                return this.deserializePojo(charSource, buf, fromIndex, toIndex, parameterizedType, entity, endToken, jsonParseContext);
            }
            case 'n': {
                return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
        }
        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, fromIndex);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Object Type, expected '{' ");
    }

    @Override
    protected final Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object entity, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        byte beginByte = buf[fromIndex];
        char beginChar = (char)beginByte;
        switch (beginChar) {
            case '{': {
                return this.deserializePojo(charSource, buf, fromIndex, toIndex, parameterizedType, entity, beginByte, jsonParseContext);
            }
            case 'n': {
                return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
            }
        }
        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Object Type, expected '{' ");
    }

    protected Object pojo(Object value) {
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object deserializePojo(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object entity, char endToken, JSONParseContext jsonParseContext) throws Exception {
        if (entity == null) {
            entity = this.createPojo();
        }
        boolean empty = true;
        boolean allowComment = jsonParseContext.isAllowComment();
        int i = fromIndex + 1;
        while (true) {
            block43: {
                JSONTypeDeserializer deserializer;
                GenericParameterizedType valueType;
                Object defaultFieldValue;
                boolean isDeserialize;
                FieldDeserializer fieldDeserializer;
                char ch;
                block44: {
                    block45: {
                        block47: {
                            String className;
                            block48: {
                                Class<?> implClass;
                                block46: {
                                    String errorContextTextAt;
                                    if ((ch = buf[i]) <= ' ') {
                                        ++i;
                                        continue;
                                    }
                                    if (allowComment && ch == '/') {
                                        i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                        ch = buf[i];
                                    }
                                    int fieldKeyFrom = i;
                                    boolean isUnquotedFieldName = false;
                                    int hashValue = 0;
                                    if (ch == '\"') {
                                        while ((ch = buf[++i]) != '\"' || buf[i - 1] == '\\') {
                                            hashValue = hashValue * 31 + ch;
                                        }
                                        empty = false;
                                    } else {
                                        if (ch == '}') {
                                            if (!empty) {
                                                errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                                            }
                                            jsonParseContext.setEndIndex(i);
                                            return this.pojo(entity);
                                        }
                                        if (ch == '\'') {
                                            if (!jsonParseContext.isAllowSingleQuotes()) {
                                                errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                                            }
                                            while (i + 1 < toIndex && (ch = buf[++i]) != '\'') {
                                                hashValue = hashValue * 31 + ch;
                                            }
                                            empty = false;
                                            ++i;
                                        } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                                            while (i + 1 < toIndex && buf[++i] != ':') {
                                                if (ch <= ' ') continue;
                                                hashValue = hashValue * 31 + ch;
                                            }
                                            empty = false;
                                            isUnquotedFieldName = true;
                                        }
                                    }
                                    int fieldKeyTo = ++i;
                                    while ((ch = buf[i]) <= ' ') {
                                        ++i;
                                    }
                                    if (allowComment && ch == '/') {
                                        i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                        ch = buf[i];
                                    }
                                    if (ch != ':') {
                                        errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', token character ':' is expected.");
                                    }
                                    while (buf[++i] <= ' ') {
                                    }
                                    if (allowComment && (ch = buf[i]) == '/') {
                                        i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                    }
                                    isDeserialize = (fieldDeserializer = this.getFieldDeserializer(buf, fieldKeyFrom, fieldKeyTo, isUnquotedFieldName, hashValue)) != null;
                                    defaultFieldValue = null;
                                    valueType = null;
                                    deserializer = null;
                                    if (!isDeserialize) break block44;
                                    valueType = fieldDeserializer.getGenericParameterizedType();
                                    deserializer = fieldDeserializer.getDeserializer();
                                    if (deserializer != null) break block45;
                                    implClass = null;
                                    implClass = fieldDeserializer.getImplClass();
                                    if (implClass == null) break block46;
                                    valueType = valueType.copyAndReplaceActualType(implClass);
                                    deserializer = JSONPojoDeserializer.getTypeDeserializer(implClass);
                                    break block44;
                                }
                                ch = buf[i];
                                if (ch != '{') break block47;
                                className = this.parseObjectClassName(charSource, buf, i, toIndex, jsonParseContext);
                                if (className != null) break block48;
                                if (jsonParseContext.isUseDefaultFieldInstance()) {
                                    defaultFieldValue = fieldDeserializer.getDefaultFieldValue(entity);
                                    if (defaultFieldValue != null) {
                                        implClass = defaultFieldValue.getClass();
                                        valueType = valueType.copyAndReplaceActualType(implClass);
                                        deserializer = JSONPojoDeserializer.getTypeDeserializer(implClass);
                                    }
                                    break block44;
                                } else {
                                    isDeserialize = false;
                                }
                                break block44;
                            }
                            try {
                                Class<?> cls = JSONPojoDeserializer.getClassByName(className);
                                if (fieldDeserializer.isAvailableImpl(cls)) {
                                    valueType = valueType.copyAndReplaceActualType(cls);
                                    deserializer = JSONPojoDeserializer.getTypeDeserializer(cls);
                                    JSONPojoDeserializer fieldPojoDeserializer = (JSONPojoDeserializer)deserializer;
                                    i = jsonParseContext.getEndIndex();
                                    while ((ch = buf[++i]) <= ' ') {
                                    }
                                    Object value = null;
                                    if (ch == ',') {
                                        value = fieldPojoDeserializer.deserializePojo(charSource, buf, i, toIndex, valueType, null, '}', jsonParseContext);
                                        i = jsonParseContext.getEndIndex();
                                    } else {
                                        if (ch != '}') {
                                            String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
                                        }
                                        value = this.pojo(fieldPojoDeserializer.createPojo());
                                    }
                                    this.setFieldValue(entity, fieldDeserializer, value);
                                    while ((ch = buf[++i]) <= ' ') {
                                    }
                                    if (ch != ',') {
                                        if (ch == '}') {
                                            jsonParseContext.setEndIndex(i);
                                            return this.pojo(entity);
                                        }
                                        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
                                    }
                                    break block43;
                                }
                                isDeserialize = false;
                            }
                            catch (Throwable throwable) {
                                throw new JSONException(throwable.getMessage(), throwable);
                            }
                        }
                        Object value = ANY.deserialize(charSource, buf, i, toIndex, null, null, '}', jsonParseContext);
                        if (!fieldDeserializer.isInstance(value)) break block44;
                        this.setFieldValue(entity, fieldDeserializer, value);
                        i = jsonParseContext.getEndIndex();
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (ch != ',') {
                            if (ch == '}') {
                                jsonParseContext.setEndIndex(i);
                                return this.pojo(entity);
                            }
                            String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
                        }
                        break block43;
                    }
                    boolean camouflage = valueType.isCamouflage();
                    if (camouflage) {
                        valueType = this.getGenericValueType(parameterizedType, valueType);
                        if (!fieldDeserializer.isCustomDeserialize()) {
                            deserializer = JSONPojoDeserializer.getTypeDeserializer(valueType.getActualType());
                        }
                    }
                }
                if (isDeserialize) {
                    Object value = deserializer.deserialize(charSource, buf, i, toIndex, valueType, defaultFieldValue, '}', jsonParseContext);
                    this.setFieldValue(entity, fieldDeserializer, value);
                } else {
                    JSONTypeDeserializer.ANY.skip(charSource, buf, i, toIndex, '}', jsonParseContext);
                }
                i = jsonParseContext.getEndIndex();
                while ((ch = buf[++i]) <= ' ') {
                }
                if (ch != ',') {
                    if (ch == '}') {
                        jsonParseContext.setEndIndex(i);
                        return this.pojo(entity);
                    }
                    String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object deserializePojo(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object entity, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        if (entity == null) {
            entity = this.createPojo();
        }
        boolean empty = true;
        boolean allowComment = jsonParseContext.isAllowComment();
        int i = fromIndex + 1;
        while (true) {
            block43: {
                JSONTypeDeserializer deserializer;
                GenericParameterizedType valueType;
                Object defaultFieldValue;
                boolean isDeserialize;
                FieldDeserializer fieldDeserializer;
                byte b;
                block44: {
                    block45: {
                        block47: {
                            String className;
                            block48: {
                                Class<?> implClass;
                                block46: {
                                    String errorContextTextAt;
                                    if ((b = buf[i]) <= 32) {
                                        ++i;
                                        continue;
                                    }
                                    if (allowComment && b == 47) {
                                        i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                                        b = buf[i];
                                    }
                                    int fieldKeyFrom = i;
                                    boolean isUnquotedFieldName = false;
                                    int hashValue = 0;
                                    if (b == 34) {
                                        while ((b = buf[++i]) != 34 || buf[i - 1] == 92) {
                                            hashValue = hashValue * 31 + b;
                                        }
                                        empty = false;
                                    } else {
                                        if (b == 125) {
                                            if (!empty) {
                                                errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                                                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                                            }
                                            jsonParseContext.setEndIndex(i);
                                            return this.pojo(entity);
                                        }
                                        if (b == 39) {
                                            if (!jsonParseContext.isAllowSingleQuotes()) {
                                                errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                                                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                                            }
                                            while (i + 1 < toIndex && (b = buf[++i]) != 39) {
                                                hashValue = hashValue * 31 + b;
                                            }
                                            empty = false;
                                            ++i;
                                        } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                                            while (i + 1 < toIndex && buf[++i] != 58) {
                                                if (b <= 32) continue;
                                                hashValue = hashValue * 31 + b;
                                            }
                                            empty = false;
                                            isUnquotedFieldName = true;
                                        }
                                    }
                                    int fieldKeyTo = ++i;
                                    while ((b = buf[i]) <= 32) {
                                        ++i;
                                    }
                                    if (allowComment && b == 47) {
                                        i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                                        b = buf[i];
                                    }
                                    if (b != 58) {
                                        errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', token character ':' is expected.");
                                    }
                                    while (buf[++i] <= 32) {
                                    }
                                    if (allowComment && (b = buf[i]) == 47) {
                                        i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                                    }
                                    isDeserialize = (fieldDeserializer = this.getFieldDeserializer(buf, fieldKeyFrom, fieldKeyTo, isUnquotedFieldName, hashValue)) != null;
                                    defaultFieldValue = null;
                                    valueType = null;
                                    deserializer = null;
                                    if (!isDeserialize) break block44;
                                    valueType = fieldDeserializer.getGenericParameterizedType();
                                    deserializer = fieldDeserializer.getDeserializer();
                                    if (deserializer != null) break block45;
                                    implClass = null;
                                    implClass = fieldDeserializer.getImplClass();
                                    if (implClass == null) break block46;
                                    valueType = valueType.copyAndReplaceActualType(implClass);
                                    deserializer = JSONPojoDeserializer.getTypeDeserializer(implClass);
                                    break block44;
                                }
                                b = buf[i];
                                if (b != 123) break block47;
                                className = this.parseObjectClassName(charSource, buf, i, toIndex, jsonParseContext);
                                if (className != null) break block48;
                                if (jsonParseContext.isUseDefaultFieldInstance()) {
                                    defaultFieldValue = fieldDeserializer.getDefaultFieldValue(entity);
                                    if (defaultFieldValue != null) {
                                        implClass = defaultFieldValue.getClass();
                                        valueType = valueType.copyAndReplaceActualType(implClass);
                                        deserializer = JSONPojoDeserializer.getTypeDeserializer(implClass);
                                    }
                                    break block44;
                                } else {
                                    isDeserialize = false;
                                }
                                break block44;
                            }
                            try {
                                Class<?> cls = JSONPojoDeserializer.getClassByName(className);
                                if (fieldDeserializer.isAvailableImpl(cls)) {
                                    valueType = valueType.copyAndReplaceActualType(cls);
                                    deserializer = JSONPojoDeserializer.getTypeDeserializer(cls);
                                    JSONPojoDeserializer fieldPojoDeserializer = (JSONPojoDeserializer)deserializer;
                                    i = jsonParseContext.getEndIndex();
                                    while ((b = buf[++i]) <= 32) {
                                    }
                                    Object value = null;
                                    if (b == 44) {
                                        value = fieldPojoDeserializer.deserializePojo(charSource, buf, i, toIndex, valueType, null, (byte)125, jsonParseContext);
                                        i = jsonParseContext.getEndIndex();
                                    } else {
                                        if (b != 125) {
                                            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or '}'");
                                        }
                                        value = this.pojo(fieldPojoDeserializer.createPojo());
                                    }
                                    this.setFieldValue(entity, fieldDeserializer, value);
                                    while ((b = buf[++i]) <= 32) {
                                    }
                                    if (b != 44) {
                                        if (b == 125) {
                                            jsonParseContext.setEndIndex(i);
                                            return this.pojo(entity);
                                        }
                                        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or '}'");
                                    }
                                    break block43;
                                }
                                isDeserialize = false;
                            }
                            catch (Throwable throwable) {
                                throw new JSONException(throwable.getMessage(), throwable);
                            }
                        }
                        Object value = ANY.deserialize(charSource, buf, i, toIndex, null, null, (byte)125, jsonParseContext);
                        if (!fieldDeserializer.isInstance(value)) break block44;
                        this.setFieldValue(entity, fieldDeserializer, value);
                        i = jsonParseContext.getEndIndex();
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (b != 44) {
                            if (b == 125) {
                                jsonParseContext.setEndIndex(i);
                                return this.pojo(entity);
                            }
                            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or '}'");
                        }
                        break block43;
                    }
                    boolean camouflage = valueType.isCamouflage();
                    if (camouflage) {
                        valueType = this.getGenericValueType(parameterizedType, valueType);
                        if (!fieldDeserializer.isCustomDeserialize()) {
                            deserializer = JSONPojoDeserializer.getTypeDeserializer(valueType.getActualType());
                        }
                    }
                }
                if (isDeserialize) {
                    Object value = deserializer.deserialize(charSource, buf, i, toIndex, valueType, defaultFieldValue, (byte)125, jsonParseContext);
                    this.setFieldValue(entity, fieldDeserializer, value);
                } else {
                    JSONTypeDeserializer.ANY.skip(charSource, buf, i, toIndex, (byte)125, jsonParseContext);
                }
                i = jsonParseContext.getEndIndex();
                while ((b = buf[++i]) <= 32) {
                }
                if (b != 44) {
                    if (b == 125) {
                        jsonParseContext.setEndIndex(i);
                        return this.pojo(entity);
                    }
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or '}'");
                }
            }
            ++i;
        }
    }

    private FieldDeserializer getFieldDeserializer(char[] buf, int from, int to, boolean isUnquotedFieldName, int hashValue) {
        if (isUnquotedFieldName) {
            return this.getFieldDeserializer(buf, from, to, hashValue);
        }
        return this.getFieldDeserializer(buf, from + 1, to - 1, hashValue);
    }

    private FieldDeserializer getFieldDeserializer(byte[] buf, int from, int to, boolean isUnquotedFieldName, int hashValue) {
        if (isUnquotedFieldName) {
            return this.pojoStructureWrapper.getFieldDeserializer(buf, from, to, hashValue);
        }
        return this.pojoStructureWrapper.getFieldDeserializer(buf, from + 1, to - 1, hashValue);
    }

    protected FieldDeserializer getFieldDeserializer(char[] buf, int offset, int endIndex, int hashValue) {
        FieldDeserializer fieldDeserializer = this.pojoStructureWrapper.getFieldDeserializer(buf, offset, endIndex, hashValue);
        return fieldDeserializer;
    }

    private GenericParameterizedType getGenericValueType(GenericParameterizedType parameterizedType, GenericParameterizedType valueType) {
        if (parameterizedType != null) {
            Class<?> actualType = parameterizedType.getGenericClass(valueType.getGenericName());
            valueType = GenericParameterizedType.actualType(actualType);
        }
        return valueType;
    }

    public final T deserialize(String json, ReadOption ... options) {
        if (StringCoder) {
            byte coder = UnsafeHelper.getStringCoder(json);
            if (coder == 0) {
                AsciiStringSource charSource = AsciiStringSource.of(json);
                return this.deserialize((CharSource)charSource, charSource.byteArray(), options);
            }
            char[] chars = JSONPojoDeserializer.getChars(json);
            return this.deserialize((CharSource)UTF16ByteArraySource.of(json, chars), chars, options);
        }
        return this.deserialize(JSONPojoDeserializer.getChars(json), options);
    }

    public final T deserialize(char[] buf, ReadOption ... options) {
        return this.deserialize(null, buf, options);
    }

    private T deserialize(CharSource charSource, char[] buf, ReadOption ... options) {
        T entity;
        int fromIndex;
        int toIndex = buf.length;
        char beginChar = '\u0000';
        for (fromIndex = 0; fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' '; ++fromIndex) {
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
            --toIndex;
        }
        if (beginChar != '{') {
            throw new JSONException("The first non empty character is not '{'");
        }
        JSONNodeContext jsonParseContext = new JSONNodeContext();
        Options.readOptions(options, jsonParseContext);
        try {
            entity = this.createPojo();
            this.deserializePojo(charSource, buf, fromIndex, toIndex, this.getGenericParameterizedType(), entity, '}', (JSONParseContext)jsonParseContext);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            if (throwable instanceof IndexOutOfBoundsException) {
                String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, toIndex);
                throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.");
            }
            throw new JSONException(throwable.getMessage(), throwable);
        }
        return entity;
    }

    public final T deserialize(byte[] buf, ReadOption ... options) {
        return this.deserialize(null, buf, options);
    }

    private T deserialize(CharSource charSource, byte[] buf, ReadOption ... options) {
        T entity;
        int fromIndex;
        int toIndex = buf.length;
        byte beginByte = 0;
        for (fromIndex = 0; fromIndex < toIndex && (beginByte = buf[fromIndex]) <= 32; ++fromIndex) {
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= 32) {
            --toIndex;
        }
        if (beginByte != 123) {
            throw new JSONException("The first non empty character is not '{'");
        }
        JSONNodeContext jsonParseContext = new JSONNodeContext();
        Options.readOptions(options, jsonParseContext);
        try {
            entity = this.createPojo();
            this.deserializePojo(charSource, buf, fromIndex, toIndex, this.getGenericParameterizedType(), entity, (byte)125, (JSONParseContext)jsonParseContext);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            if (throwable instanceof IndexOutOfBoundsException) {
                String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, toIndex);
                throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.");
            }
            throw new JSONException(throwable.getMessage(), throwable);
        }
        return entity;
    }

    protected void setFieldValue(T entity, FieldDeserializer fieldDeserializer, Object value) {
        fieldDeserializer.invoke(entity, value);
    }

    protected T createPojo() throws Exception {
        return (T)this.pojoStructureWrapper.newInstance();
    }

    @Override
    protected final GenericParameterizedType getGenericParameterizedType() {
        return this.pojoStructureWrapper.getGenericType();
    }

    protected final FieldDeserializer getFieldDeserializer(int hashValue) {
        return this.pojoStructureWrapper.getFieldDeserializer(hashValue);
    }

    protected final boolean isCollision() {
        return this.pojoStructureWrapper.isCollision();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JSONRecordDeserializer<T>
    extends JSONPojoDeserializer {
        public JSONRecordDeserializer(Class<? extends T> recordClass) {
            super(recordClass);
        }

        protected Object createPojo() throws Exception {
            return this.pojoStructureWrapper.createConstructorArgs();
        }

        protected final void setFieldValue(Object entity, FieldDeserializer fieldDeserializer, Object value) {
            Object[] argValues = (Object[])entity;
            argValues[fieldDeserializer.getIndex()] = value;
        }

        @Override
        protected FieldDeserializer getFieldDeserializer(char[] buf, int offset, int endIndex, int hashValue) {
            if (!this.isCollision()) {
                return this.getFieldDeserializer(hashValue);
            }
            return super.getFieldDeserializer(buf, offset, endIndex, hashValue);
        }

        @Override
        protected final Object pojo(Object value) {
            try {
                return this.pojoStructureWrapper.newInstance((Object[])value);
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }
}

