/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.utils.IOUtils;
import java.io.CharArrayWriter;
import java.util.Arrays;

public class JSONStringWriter
extends CharArrayWriter {
    private static final int CACHE_CHAR_BUFFER_SIZE = 4096;
    private static final int CACHE_COUNT = 8;
    private static final CharBufCache[] BUF_CACHES = new CharBufCache[8];
    private static int availableCount = 8;
    private CharBufCache charBufCache = JSONStringWriter.getOrReturnCache(null);

    void setCharAt(int index, char c) {
        this.buf[index] = c;
    }

    void getChars(int s, int len, char[] chars, int t) {
        System.arraycopy(this.buf, s, chars, t, len);
    }

    int addLength(int size) {
        this.ensureCapacity(size);
        return this.count += size;
    }

    private static CharBufCache getArrayCache() {
        if (availableCount == 0) {
            return null;
        }
        CharBufCache charBufCache = BUF_CACHES[--availableCount];
        charBufCache.inUse = true;
        charBufCache.index = availableCount;
        return charBufCache;
    }

    private static void returnArrayCache(CharBufCache charBufCache) {
        charBufCache.inUse = false;
        CharBufCache oldCache = BUF_CACHES[availableCount];
        int oldIndex = charBufCache.index;
        JSONStringWriter.BUF_CACHES[JSONStringWriter.availableCount] = charBufCache;
        JSONStringWriter.BUF_CACHES[oldIndex] = oldCache;
        oldCache.index = oldIndex;
        charBufCache.index = availableCount++;
    }

    static synchronized CharBufCache getOrReturnCache(CharBufCache charBufCache) {
        if (charBufCache == null) {
            return JSONStringWriter.getArrayCache();
        }
        JSONStringWriter.returnArrayCache(charBufCache);
        return null;
    }

    JSONStringWriter() {
        if (this.charBufCache != null) {
            this.buf = this.charBufCache.cacheBuffers;
        }
    }

    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    char[] internal() {
        return this.buf;
    }

    void writeDirectly(int c) {
        this.buf[this.count++] = (char)c;
    }

    void writeDirectly(char ... chars) {
        int len = chars.length;
        System.arraycopy(chars, 0, this.buf, this.count, len);
        this.count += len;
    }

    public void write(char[] c, int off, int len) {
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(Math.max(this.buf.length << 1, this.buf.length + newcount));
        }
        if (len < 6) {
            int i = off;
            switch (len) {
                case 5: {
                    this.buf[this.count++] = c[i++];
                }
                case 4: {
                    this.buf[this.count++] = c[i++];
                }
                case 3: {
                    this.buf[this.count++] = c[i++];
                }
                case 2: {
                    this.buf[this.count++] = c[i++];
                }
                case 1: {
                    this.buf[this.count++] = c[i++];
                }
            }
            return;
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    void ensureCapacity(int increment) {
        int newcount = this.count + increment;
        if (newcount > this.buf.length) {
            this.expandCapacity(Math.max(this.buf.length << 1, this.buf.length + newcount));
        }
    }

    void expandCapacity(int capacity) {
        this.buf = Arrays.copyOf(this.buf, capacity);
        if (this.charBufCache != null) {
            JSONStringWriter.getOrReturnCache(this.charBufCache);
            this.charBufCache = null;
        }
    }

    void writeBytes(byte[] bytes, int offset, int len) {
        if (len == 0) {
            return;
        }
        String str = new String(bytes, offset, len);
        int newcount = this.count + (len = str.length());
        if (newcount > this.buf.length) {
            this.expandCapacity(Math.max(this.buf.length << 1, this.buf.length + newcount));
        }
        str.getChars(0, len, this.buf, this.count);
        this.count = newcount;
    }

    public void writeUTFBytes(byte[] bytes, int offset, int len) {
        if (len == 0) {
            return;
        }
        int maxCount = this.count + len;
        if (maxCount > this.buf.length) {
            this.expandCapacity(Math.max(this.buf.length << 1, this.buf.length + maxCount));
        }
        this.count = IOUtils.readUTF8Bytes(bytes, offset, len, this.buf, this.count);
    }

    void writeString(String source, int offset, int len) {
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(Math.max(this.buf.length << 1, this.buf.length + newcount));
        }
        source.getChars(offset, offset + len, this.buf, this.count);
        this.count = newcount;
    }

    public void write(String str, int off, int len) {
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(Math.max(this.buf.length << 1, this.buf.length + newcount));
        }
        if (len < 5) {
            int i = off;
            switch (len) {
                case 4: {
                    this.buf[this.count++] = str.charAt(i++);
                }
                case 3: {
                    this.buf[this.count++] = str.charAt(i++);
                }
                case 2: {
                    this.buf[this.count++] = str.charAt(i++);
                }
                case 1: {
                    this.buf[this.count++] = str.charAt(i++);
                }
            }
            return;
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    StringBuffer toStringBuffer() {
        StringBuffer stringBuffer = new StringBuffer(this.count);
        stringBuffer.append(this.buf, 0, this.count);
        return stringBuffer;
    }

    StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(this.count);
        stringBuilder.append(this.buf, 0, this.count);
        return stringBuilder;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public void reset() {
        super.reset();
        if (this.charBufCache != null) {
            JSONStringWriter.getOrReturnCache(this.charBufCache);
            this.charBufCache = null;
        }
    }

    static {
        for (int i = 0; i < 8; ++i) {
            CharBufCache charArrayCache = new CharBufCache(new char[4096]);
            charArrayCache.index = i;
            JSONStringWriter.BUF_CACHES[i] = charArrayCache;
        }
    }

    private static class CharBufCache {
        final char[] cacheBuffers;
        boolean inUse;
        int index;

        CharBufCache(char[] cacheBuffers) {
            this.cacheBuffers = cacheBuffers;
        }
    }
}

