/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.tools.Base64;
import io.github.wycst.wast.json.JSONByteArrayParser;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONPojoDeserializer;
import io.github.wycst.wast.json.JSONStringWriter;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.reflect.FieldDeserializer;
import io.github.wycst.wast.json.reflect.ObjectStructureWrapper;
import io.github.wycst.wast.json.util.FixedNameValueMap;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONTypeDeserializer
extends JSONGeneral {
    private static final int LENGTH = ReflectConsts.ClassCategory.values().length;
    static final JSONTypeDeserializer[] TYPE_DESERIALIZERS = new JSONTypeDeserializer[LENGTH];
    protected static final CharSequenceDeserializer STRING = new CharSequenceDeserializer();
    protected static final NumberDeserializer NUMBER = new NumberDeserializer();
    static final BooleanDeserializer BOOLEAN = new BooleanDeserializer();
    protected static final ArrayDeserializer ARRAY = new ArrayDeserializer();
    protected static final CollectionDeserializer COLLECTION = new CollectionDeserializer();
    protected static final MapDeserializer MAP = new MapDeserializer();
    protected static final ObjectDeserializer OBJECT = new ObjectDeserializer();
    protected static final JSONTypeDeserializer ANY = new ANYDeserializer();
    protected static final NULLDeserializer NULL = new NULLDeserializer();
    protected static final SerializableDeserializer SERIALIZABLE_DESERIALIZER = new SerializableDeserializer();
    private static final Map<Class<?>, JSONTypeDeserializer> classJSONTypeDeserializerMap = new ConcurrentHashMap();
    private static final Map<String, Class<?>> classNameMapping = new ConcurrentHashMap();

    private static void putTypeDeserializer(JSONTypeDeserializer typeDeserializer, Class ... types) {
        for (Class type : types) {
            classJSONTypeDeserializerMap.put(type, typeDeserializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONTypeDeserializer getTypeDeserializer(Class type) {
        if (type == null) {
            return ANY;
        }
        JSONTypeDeserializer typeDeserializer = classJSONTypeDeserializerMap.get(type);
        if (typeDeserializer != null) {
            return typeDeserializer;
        }
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(type);
        Class clazz = type;
        synchronized (clazz) {
            if (classJSONTypeDeserializerMap.containsKey(type)) {
                return classJSONTypeDeserializerMap.get(type);
            }
            switch (classCategory) {
                case ObjectCategory: {
                    typeDeserializer = JSONTypeDeserializer.createObjectDeserializer(type);
                    break;
                }
                case EnumCategory: {
                    typeDeserializer = new EnumDeserializer.EnumInstanceDeserializer(type);
                }
            }
            if (typeDeserializer == null && (typeDeserializer = TYPE_DESERIALIZERS[classCategory.ordinal()]) == null) {
                return null;
            }
            classJSONTypeDeserializerMap.put(type, typeDeserializer);
        }
        return typeDeserializer;
    }

    private static JSONTypeDeserializer createObjectDeserializer(Class type) {
        ObjectStructureWrapper objectStructureWrapper = ObjectStructureWrapper.get(type);
        if (objectStructureWrapper.isRecord()) {
            return new JSONPojoDeserializer.JSONRecordDeserializer(type);
        }
        if (objectStructureWrapper.isCollision()) {
            return new JSONPojoDeserializer(type){};
        }
        return new JSONPojoDeserializer(type){

            protected FieldDeserializer getFieldDeserializer(char[] buf, int offset, int endIndex, int hashValue) {
                return super.getFieldDeserializer(hashValue);
            }
        };
    }

    protected static JSONTypeDeserializer getFieldDeserializer(GenericParameterizedType genericParameterizedType, JsonProperty property) {
        if (genericParameterizedType == null || genericParameterizedType.getActualType() == null) {
            return ANY;
        }
        ReflectConsts.ClassCategory classCategory = genericParameterizedType.getActualClassCategory();
        switch (classCategory) {
            case CollectionCategory: {
                return new CollectionDeserializer.CollectionInstanceDeserializer(genericParameterizedType);
            }
            case DateCategory: {
                if (property != null) {
                    genericParameterizedType.setDatePattern(property.pattern().trim());
                    genericParameterizedType.setDateTimezone(property.timezone().trim());
                }
                return new DateDeserializer.DateInstanceDeserializer(genericParameterizedType);
            }
            case ObjectCategory: {
                ObjectStructureWrapper objectStructureWrapper = ObjectStructureWrapper.get(genericParameterizedType.getActualType());
                if (!objectStructureWrapper.isTemporal()) break;
                ClassStructureWrapper.ClassWrapperType classWrapperType = objectStructureWrapper.getClassWrapperType();
                if (property != null) {
                    genericParameterizedType.setDatePattern(property.pattern().trim());
                    genericParameterizedType.setDateTimezone(property.timezone().trim());
                }
                return JSONTemporalDeserializer.getTemporalDeserializerInstance(classWrapperType, genericParameterizedType);
            }
        }
        return JSONTypeDeserializer.getTypeDeserializer(genericParameterizedType.getActualType());
    }

    protected static Object doDeserialize(JSONTypeDeserializer deserializer, CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
        return deserializer.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
    }

    protected static Object doDeserialize(JSONTypeDeserializer deserializer, CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        return deserializer.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
    }

    protected GenericParameterizedType getGenericParameterizedType() {
        return null;
    }

    void skip(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    void skip(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract Object deserialize(CharSource var1, char[] var2, int var3, int var4, GenericParameterizedType var5, Object var6, char var7, JSONParseContext var8) throws Exception;

    protected abstract Object deserialize(CharSource var1, byte[] var2, int var3, int var4, GenericParameterizedType var5, Object var6, byte var7, JSONParseContext var8) throws Exception;

    private static GenericParameterizedType getGenericValueType(GenericParameterizedType parameterizedType, GenericParameterizedType valueType) {
        Class<?> actualType = parameterizedType.getGenericClass(valueType.getGenericName());
        return GenericParameterizedType.actualType(actualType);
    }

    protected final String parseObjectClassName(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        int i = fromIndex + 1;
        while ((ch = buf[i]) <= ' ') {
            ++i;
        }
        if (jsonParseContext.isAllowComment() && ch == '/') {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            ch = buf[i];
        }
        boolean matched = false;
        if (ch == '\"') {
            if (buf[++i] == '@' && buf[++i] == 'c' && buf[++i] == '\"') {
                matched = true;
                ++i;
            }
        } else {
            if (ch == '}') {
                return null;
            }
            if (ch == '\'') {
                if (buf[++i] == '@' && buf[++i] == 'c' && buf[++i] == '\'') {
                    matched = true;
                    ++i;
                }
            } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                char atChar = buf[i++];
                char cChar = buf[i++];
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (atChar == '@' && cChar == 'c' && ch == ':') {
                    matched = true;
                }
            }
        }
        if (!matched) {
            return null;
        }
        while ((ch = buf[i]) <= ' ') {
            ++i;
        }
        if (jsonParseContext.isAllowComment() && ch == '/') {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            ch = buf[i];
        }
        if (ch == ':') {
            Object value;
            while ((ch = buf[++i]) <= ' ') {
            }
            if (jsonParseContext.isAllowComment() && ch == '/') {
                i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                ch = buf[i];
            }
            if ((value = ANY.deserialize(charSource, buf, i, toIndex, null, null, '}', jsonParseContext)) instanceof String) {
                return (String)value;
            }
            return null;
        }
        String errorContextTextAt = JSONTypeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', Colon character ':' is expected.");
    }

    protected final String parseObjectClassName(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
        byte b;
        int i = fromIndex + 1;
        while ((b = buf[i]) <= 32) {
            ++i;
        }
        if (jsonParseContext.isAllowComment() && b == 47) {
            i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
            b = buf[i];
        }
        boolean matched = false;
        if (b == 34) {
            if (buf[++i] == 64 && buf[++i] == 99 && buf[++i] == 34) {
                matched = true;
                ++i;
            }
        } else {
            if (b == 125) {
                return null;
            }
            if (b == 39) {
                if (buf[++i] == 64 && buf[++i] == 99 && buf[++i] == 39) {
                    matched = true;
                    ++i;
                }
            } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                byte atChar = buf[i++];
                byte cChar = buf[i++];
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (atChar == 64 && cChar == 99 && b == 58) {
                    matched = true;
                }
            }
        }
        if (!matched) {
            return null;
        }
        while ((b = buf[i]) <= 32) {
            ++i;
        }
        if (jsonParseContext.isAllowComment() && b == 47) {
            i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
            b = buf[i];
        }
        if (b == 58) {
            Object value;
            while ((b = buf[++i]) <= 32) {
            }
            if (jsonParseContext.isAllowComment() && b == 47) {
                i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                b = buf[i];
            }
            if ((value = ANY.deserialize(charSource, buf, i, toIndex, null, null, (byte)125, jsonParseContext)) instanceof String) {
                return (String)value;
            }
            return null;
        }
        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', Colon character ':' is expected.");
    }

    protected static final Class<?> getClassByName(String className) throws ClassNotFoundException {
        Class<?> cls = classNameMapping.get(className);
        if (cls != null) {
            return cls;
        }
        cls = Class.forName(className);
        classNameMapping.put(className, cls);
        return cls;
    }

    static {
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.CharSequence.ordinal()] = STRING;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.NumberCategory.ordinal()] = NUMBER;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.BoolCategory.ordinal()] = BOOLEAN;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.DateCategory.ordinal()] = new DateDeserializer();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ClassCategory.ordinal()] = new ClassDeserializer();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.EnumCategory.ordinal()] = new EnumDeserializer();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.AnnotationCategory.ordinal()] = new AnnotationDeserializer();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.Binary.ordinal()] = new BinaryDeserializer();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ArrayCategory.ordinal()] = ARRAY;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.CollectionCategory.ordinal()] = COLLECTION;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.MapCategory.ordinal()] = MAP;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ObjectCategory.ordinal()] = OBJECT;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ANY.ordinal()] = ANY;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.NonInstance.ordinal()] = null;
        JSONTypeDeserializer.putTypeDeserializer(new NumberDeserializer.IntegerDeserializer(), Integer.TYPE, Integer.class);
        JSONTypeDeserializer.putTypeDeserializer(new NumberDeserializer.LongDeserializer(), Long.TYPE, Long.class);
    }

    private static class SerializableDeserializer
    extends JSONTypeDeserializer {
        private SerializableDeserializer() {
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            Object value = ANY.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            if (value instanceof Serializable) {
                return value;
            }
            return null;
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            Object value = ANY.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            if (value instanceof Serializable) {
                return value;
            }
            return null;
        }
    }

    static class NULLDeserializer
    extends JSONTypeDeserializer {
        NULLDeserializer() {
        }

        Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            return this.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, instance, '\u0000', jsonParseContext);
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            int endIndex = fromIndex + 3;
            if (buf[fromIndex + 1] == 'u' && buf[fromIndex + 2] == 'l' && buf[endIndex] == 'l') {
                jsonParseContext.setEndIndex(endIndex);
                return null;
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(buf, fromIndex, Math.min(toIndex - fromIndex + 1, 4)) + "'");
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            int endIndex = fromIndex + 3;
            if (buf[fromIndex + 1] == 117 && buf[fromIndex + 2] == 108 && buf[endIndex] == 108) {
                jsonParseContext.setEndIndex(endIndex);
                return null;
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(buf, fromIndex, Math.min(toIndex - fromIndex + 1, 4)) + "'");
        }
    }

    static class ANYDeserializer
    extends JSONTypeDeserializer {
        ANYDeserializer() {
        }

        void skip(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    MAP.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case '[': {
                    COLLECTION.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case '\"': {
                    STRING.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 'n': {
                    NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                    break;
                }
                case 't': {
                    BOOLEAN.deserializeTrue(buf, fromIndex, toIndex, null, jsonParseContext);
                    break;
                }
                case 'f': {
                    BOOLEAN.deserializeFalse(buf, fromIndex, toIndex, null, jsonParseContext);
                    break;
                }
                default: {
                    NUMBER.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.BigDecimalType, null, endToken, jsonParseContext);
                }
            }
        }

        void skip(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            switch (beginByte) {
                case 123: {
                    MAP.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 91: {
                    COLLECTION.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 34: {
                    STRING.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 110: {
                    JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 116: {
                    JSONByteArrayParser.parseTrue(buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 102: {
                    JSONByteArrayParser.parseFalse(buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                default: {
                    JSONByteArrayParser.parseDefaultNumber(buf, fromIndex, toIndex, endToken, jsonParseContext);
                }
            }
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    return JSONDefaultParser.parseJSONObject(charSource, buf, fromIndex, toIndex, new LinkedHashMap(), jsonParseContext);
                }
                case '[': {
                    return JSONDefaultParser.parseJSONArray(charSource, buf, fromIndex, toIndex, new ArrayList(), jsonParseContext);
                }
                case '\"': 
                case '\'': {
                    return JSONDefaultParser.parseJSONString(charSource, buf, fromIndex, toIndex, beginChar, jsonParseContext);
                }
                case 'n': {
                    return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
                case 't': {
                    return BOOLEAN.deserializeTrue(buf, fromIndex, toIndex, null, jsonParseContext);
                }
                case 'f': {
                    return BOOLEAN.deserializeFalse(buf, fromIndex, toIndex, null, jsonParseContext);
                }
            }
            return NUMBER.deserialize(charSource, buf, fromIndex, toIndex, jsonParseContext.isUseBigDecimalAsDefault() ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, endToken, jsonParseContext);
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '{': {
                    return JSONByteArrayParser.parseJSONObject(charSource == null ? null : charSource.input(), buf, fromIndex, toIndex, new LinkedHashMap(), jsonParseContext);
                }
                case '[': {
                    return JSONByteArrayParser.parseJSONArray(charSource == null ? null : charSource.input(), buf, fromIndex, toIndex, new ArrayList(), jsonParseContext);
                }
                case '\"': 
                case '\'': {
                    return JSONByteArrayParser.parseJSONString(charSource == null ? null : charSource.input(), buf, fromIndex, toIndex, beginByte, jsonParseContext);
                }
                case 'n': {
                    return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
                case 't': {
                    return JSONByteArrayParser.parseTrue(buf, fromIndex, toIndex, jsonParseContext);
                }
                case 'f': {
                    return JSONByteArrayParser.parseFalse(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            return JSONByteArrayParser.parseDefaultNumber(buf, fromIndex, toIndex, endToken, jsonParseContext);
        }
    }

    static class ObjectDeserializer
    extends JSONTypeDeserializer {
        ObjectDeserializer() {
        }

        /*
         * Enabled aggressive block sorting
         */
        Object deserializeObject(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType genericParameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            char ch;
            Class<?> clazz = genericParameterizedType.getActualType();
            ObjectStructureWrapper classStructureWrapper = ObjectStructureWrapper.get(clazz);
            Object entity = instance != null ? instance : classStructureWrapper.newInstance();
            boolean empty = true;
            int i = fromIndex + 1;
            while (true) {
                JSONTypeDeserializer deserializer;
                GenericParameterizedType valueType;
                boolean isDeserialize;
                Object defaultValue;
                FieldDeserializer fieldDeserializer;
                block28: {
                    block29: {
                        block30: {
                            String errorContextTextAt;
                            if ((ch = buf[i]) <= ' ') {
                                ++i;
                                continue;
                            }
                            if (jsonParseContext.isAllowComment() && ch == '/') {
                                i = ObjectDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                ch = buf[i];
                            }
                            int fieldKeyFrom = i;
                            boolean isUnquotedFieldName = false;
                            int hashValue = 0;
                            if (ch == '\"') {
                                while ((ch = buf[++i]) != '\"' || buf[i - 1] == '\\') {
                                    hashValue = hashValue * 31 + ch;
                                }
                                empty = false;
                            } else {
                                if (ch == '}') {
                                    if (!empty) {
                                        errorContextTextAt = ObjectDeserializer.createErrorContextText(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                                    }
                                    jsonParseContext.setEndIndex(i);
                                    return entity;
                                }
                                if (ch == '\'') {
                                    if (!jsonParseContext.isAllowSingleQuotes()) {
                                        errorContextTextAt = ObjectDeserializer.createErrorContextText(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                                    }
                                    while (i + 1 < toIndex && (ch = buf[++i]) != '\'') {
                                        hashValue = hashValue * 31 + ch;
                                    }
                                    empty = false;
                                    ++i;
                                } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                                    while (i + 1 < toIndex && buf[++i] != ':') {
                                        if (ch <= ' ') continue;
                                        hashValue = hashValue * 31 + ch;
                                    }
                                    empty = false;
                                    isUnquotedFieldName = true;
                                }
                            }
                            int fieldKeyTo = ++i;
                            while ((ch = buf[i]) <= ' ') {
                                ++i;
                            }
                            if (jsonParseContext.isAllowComment() && ch == '/') {
                                i = ObjectDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                ch = buf[i];
                            }
                            if (ch != ':') {
                                errorContextTextAt = ObjectDeserializer.createErrorContextText(buf, i);
                                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', Colon character ':' is expected.");
                            }
                            fieldDeserializer = this.getFieldDeserializer(classStructureWrapper, buf, fieldKeyFrom, fieldKeyTo, isUnquotedFieldName, hashValue);
                            while (buf[++i] <= ' ') {
                            }
                            defaultValue = null;
                            if (jsonParseContext.isAllowComment() && (ch = buf[i]) == '/') {
                                i = ObjectDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                            }
                            isDeserialize = fieldDeserializer != null;
                            valueType = null;
                            deserializer = null;
                            if (!isDeserialize) break block28;
                            valueType = fieldDeserializer.getGenericParameterizedType();
                            deserializer = fieldDeserializer.getDeserializer();
                            boolean nonInstanceType = fieldDeserializer.isNonInstanceType();
                            if (!nonInstanceType) break block29;
                            if (!jsonParseContext.isUseDefaultFieldInstance()) break block30;
                            defaultValue = fieldDeserializer.getDefaultFieldValue(instance);
                            if (defaultValue != null) {
                                Class<?> implClass = defaultValue.getClass();
                                valueType = valueType.copyAndReplaceActualType(implClass);
                                if (deserializer == null) {
                                    deserializer = ObjectDeserializer.getTypeDeserializer(implClass);
                                }
                            }
                            break block28;
                        }
                        isDeserialize = false;
                        break block28;
                    }
                    boolean camouflage = valueType.isCamouflage();
                    if (camouflage) {
                        valueType = JSONTypeDeserializer.getGenericValueType(genericParameterizedType, valueType);
                        if (!fieldDeserializer.isCustomDeserialize()) {
                            deserializer = ObjectDeserializer.getTypeDeserializer(valueType.getActualType());
                        }
                    }
                }
                if (isDeserialize) {
                    Object value = deserializer.deserialize(charSource, buf, i, toIndex, valueType, defaultValue, '}', jsonParseContext);
                    fieldDeserializer.invoke(entity, value);
                    i = jsonParseContext.getEndIndex();
                } else {
                    ANY.skip(charSource, buf, i, toIndex, '}', jsonParseContext);
                    i = jsonParseContext.getEndIndex();
                }
                while ((ch = buf[++i]) <= ' ') {
                }
                if (jsonParseContext.isAllowComment() && ch == '/') {
                    i = ObjectDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ',') break;
                ++i;
            }
            if (ch == '}') {
                jsonParseContext.setEndIndex(i);
                return entity;
            }
            String errorContextTextAt = ObjectDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
        }

        /*
         * Enabled aggressive block sorting
         */
        Object deserializeObject(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType genericParameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            byte b;
            Class<?> clazz = genericParameterizedType.getActualType();
            ObjectStructureWrapper classStructureWrapper = ObjectStructureWrapper.get(clazz);
            Object entity = instance != null ? instance : classStructureWrapper.newInstance();
            boolean empty = true;
            int i = fromIndex + 1;
            while (true) {
                JSONTypeDeserializer deserializer;
                GenericParameterizedType valueType;
                boolean isDeserialize;
                Object defaultValue;
                FieldDeserializer fieldDeserializer;
                block28: {
                    block29: {
                        block30: {
                            String errorContextTextAt;
                            if ((b = buf[i]) <= 32) {
                                ++i;
                                continue;
                            }
                            if (jsonParseContext.isAllowComment() && b == 47) {
                                i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                                b = buf[i];
                            }
                            int fieldKeyFrom = i;
                            boolean isUnquotedFieldName = false;
                            int hashValue = 0;
                            if (b == 34) {
                                while ((b = buf[++i]) != 34 || buf[i - 1] == 92) {
                                    hashValue = hashValue * 31 + b;
                                }
                                empty = false;
                            } else {
                                if (b == 125) {
                                    if (!empty) {
                                        errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                                    }
                                    jsonParseContext.setEndIndex(i);
                                    return entity;
                                }
                                if (b == 39) {
                                    if (!jsonParseContext.isAllowSingleQuotes()) {
                                        errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                                    }
                                    while (i + 1 < toIndex && (b = buf[++i]) != 39) {
                                        hashValue = hashValue * 31 + b;
                                    }
                                    empty = false;
                                    ++i;
                                } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                                    while (i + 1 < toIndex && buf[++i] != 58) {
                                        if (b <= 32) continue;
                                        hashValue = hashValue * 31 + b;
                                    }
                                    empty = false;
                                    isUnquotedFieldName = true;
                                }
                            }
                            int fieldKeyTo = ++i;
                            while ((b = buf[i]) <= 32) {
                                ++i;
                            }
                            if (jsonParseContext.isAllowComment() && b == 47) {
                                i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                                b = buf[i];
                            }
                            if (b != 58) {
                                errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + (char)b + "', Colon character ':' is expected.");
                            }
                            fieldDeserializer = this.getFieldDeserializer(classStructureWrapper, buf, fieldKeyFrom, fieldKeyTo, isUnquotedFieldName, hashValue);
                            while (buf[++i] <= 32) {
                            }
                            defaultValue = null;
                            if (jsonParseContext.isAllowComment() && (b = buf[i]) == 47) {
                                i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                            }
                            isDeserialize = fieldDeserializer != null;
                            valueType = null;
                            deserializer = null;
                            if (!isDeserialize) break block28;
                            valueType = fieldDeserializer.getGenericParameterizedType();
                            deserializer = fieldDeserializer.getDeserializer();
                            boolean nonInstanceType = fieldDeserializer.isNonInstanceType();
                            if (!nonInstanceType) break block29;
                            if (!jsonParseContext.isUseDefaultFieldInstance()) break block30;
                            defaultValue = fieldDeserializer.getDefaultFieldValue(instance);
                            if (defaultValue != null) {
                                Class<?> implClass = defaultValue.getClass();
                                valueType = valueType.copyAndReplaceActualType(implClass);
                                if (deserializer == null) {
                                    deserializer = ObjectDeserializer.getTypeDeserializer(implClass);
                                }
                            }
                            break block28;
                        }
                        isDeserialize = false;
                        break block28;
                    }
                    boolean camouflage = valueType.isCamouflage();
                    if (camouflage) {
                        valueType = JSONTypeDeserializer.getGenericValueType(genericParameterizedType, valueType);
                        if (!fieldDeserializer.isCustomDeserialize()) {
                            deserializer = ObjectDeserializer.getTypeDeserializer(valueType.getActualType());
                        }
                    }
                }
                if (isDeserialize) {
                    Object value = deserializer.deserialize(charSource, buf, i, toIndex, valueType, defaultValue, (byte)125, jsonParseContext);
                    fieldDeserializer.invoke(entity, value);
                    i = jsonParseContext.getEndIndex();
                } else {
                    ANY.skip(charSource, buf, i, toIndex, (byte)125, jsonParseContext);
                    i = jsonParseContext.getEndIndex();
                }
                while ((b = buf[++i]) <= 32) {
                }
                if (jsonParseContext.isAllowComment() && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b != 44) break;
                ++i;
            }
            if (b == 125) {
                jsonParseContext.setEndIndex(i);
                return entity;
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + (char)b + "', expected ',' or '}'");
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType genericParameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    return this.deserializeObject(charSource, buf, fromIndex, toIndex, genericParameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
            }
            String errorContextTextAt = ObjectDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Object Type, expected '{' ");
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType genericParameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '{': {
                    return this.deserializeObject(charSource, buf, fromIndex, toIndex, genericParameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Object Type, expected '{' ");
        }

        private FieldDeserializer getFieldDeserializer(ObjectStructureWrapper pojoStructureWrapper, char[] buf, int from, int to, boolean isUnquotedFieldName, int hashValue) {
            if (isUnquotedFieldName) {
                return this.getFieldDeserializer(pojoStructureWrapper, buf, from, to, hashValue);
            }
            return this.getFieldDeserializer(pojoStructureWrapper, buf, from + 1, to - 1, hashValue);
        }

        private FieldDeserializer getFieldDeserializer(ObjectStructureWrapper pojoStructureWrapper, byte[] buf, int from, int to, boolean isUnquotedFieldName, int hashValue) {
            if (isUnquotedFieldName) {
                return pojoStructureWrapper.getFieldDeserializer(buf, from, to, hashValue);
            }
            return pojoStructureWrapper.getFieldDeserializer(buf, from + 1, to - 1, hashValue);
        }

        private FieldDeserializer getFieldDeserializer(ObjectStructureWrapper pojoStructureWrapper, char[] buf, int from, int to, int hashValue) {
            FieldDeserializer fieldDeserializer = pojoStructureWrapper.getFieldDeserializer(buf, from, to, hashValue);
            return fieldDeserializer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapDeserializer
    extends JSONTypeDeserializer {
        MapDeserializer() {
        }

        /*
         * Enabled aggressive block sorting
         */
        void skip(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            char ch;
            boolean empty = true;
            int i = fromIndex + 1;
            while (true) {
                if (i >= toIndex) {
                    throw new JSONException("Syntax error, the closing symbol '}' is not found ");
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (jsonParseContext.isAllowComment() && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == '\"') {
                    while (i + 1 < toIndex && ((ch = buf[++i]) != '\"' || buf[i - 1] == '\\')) {
                    }
                    empty = false;
                    if (ch != '\"') {
                        String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, util pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '\"' is not found ");
                    }
                    ++i;
                } else {
                    if (ch == '}') {
                        if (!empty) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.setEndIndex(i);
                        return;
                    }
                    if (ch == '\'') {
                        if (!jsonParseContext.isAllowSingleQuotes()) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                        }
                        while (i + 1 < toIndex && buf[++i] != '\'') {
                        }
                        empty = false;
                        ++i;
                    } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        empty = false;
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (jsonParseContext.isAllowComment() && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ':') {
                    String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', Colon character ':' is expected.");
                }
                while ((ch = buf[++i]) <= ' ') {
                }
                if (jsonParseContext.isAllowComment() && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                }
                ANY.skip(charSource, buf, i, toIndex, '}', jsonParseContext);
                i = jsonParseContext.getEndIndex();
                while ((ch = buf[++i]) <= ' ') {
                }
                if (jsonParseContext.isAllowComment() && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ',') break;
                ++i;
            }
            if (ch == '}') {
                jsonParseContext.setEndIndex(i);
                return;
            }
            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
        }

        /*
         * Enabled aggressive block sorting
         */
        void skip(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            byte b;
            boolean empty = true;
            int i = fromIndex + 1;
            while (true) {
                if (i >= toIndex) {
                    throw new JSONException("Syntax error, the closing symbol '}' is not found ");
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (jsonParseContext.isAllowComment() && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 34) {
                    while (i + 1 < toIndex && ((b = buf[++i]) != 34 || buf[i - 1] == 92)) {
                    }
                    empty = false;
                    if (b != 34) {
                        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                        throw new JSONException("Syntax error, util pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '\"' is not found ");
                    }
                    ++i;
                } else {
                    if (b == 125) {
                        if (!empty) {
                            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.setEndIndex(i);
                        return;
                    }
                    if (b == 39) {
                        if (!jsonParseContext.isAllowSingleQuotes()) {
                            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                        }
                        while (i + 1 < toIndex && buf[++i] != 39) {
                        }
                        empty = false;
                        ++i;
                    } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                        while (i + 1 < toIndex && buf[++i] != 58) {
                        }
                        empty = false;
                    }
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (jsonParseContext.isAllowComment() && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b != 58) {
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', Colon character ':' is expected.");
                }
                while ((b = buf[++i]) <= 32) {
                }
                if (jsonParseContext.isAllowComment() && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                }
                ANY.skip(charSource, buf, i, toIndex, (byte)125, jsonParseContext);
                i = jsonParseContext.getEndIndex();
                while ((b = buf[++i]) <= 32) {
                }
                if (jsonParseContext.isAllowComment() && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b != 44) break;
                ++i;
            }
            if (b == 125) {
                jsonParseContext.setEndIndex(i);
                return;
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or '}'");
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    return this.deserializeMap(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
            }
            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Map Type, expected '{' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '{': {
                    return this.deserializeMap(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Map Type, expected '{' ");
        }

        protected static Object mapKeyToType(Serializable mapKey, Class<?> keyType) {
            if (mapKey == null || keyType == null || keyType == String.class || keyType == CharSequence.class) {
                return mapKey;
            }
            int paramClassType = ReflectConsts.getParamClassType(keyType);
            switch (paramClassType) {
                case 201: {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(mapKey.toString());
                    return buffer;
                }
                case 202: {
                    StringBuilder builder = new StringBuilder();
                    builder.append(mapKey.toString());
                    return builder;
                }
                case 100: {
                    String key = mapKey.toString();
                    return NumberDeserializer.parseNumberValue(key.toCharArray(), 0, key.length(), ReflectConsts.getParamClassNumberType(keyType));
                }
            }
            throw new UnsupportedOperationException("Not Supported type '" + keyType + "' for map key ");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object deserializeMap(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object obj, JSONParseContext jsonParseContext) throws Exception {
            Map instance;
            ReflectConsts.ClassCategory actualClassCategory;
            GenericParameterizedType valueType = parameterizedType.getValueType();
            ReflectConsts.ClassCategory classCategory = actualClassCategory = valueType == null ? ReflectConsts.ClassCategory.ANY : ReflectConsts.getClassCategory(valueType.getActualType());
            if (obj != null) {
                instance = (Map)obj;
            } else {
                Class<?> mapClass = parameterizedType.getActualType();
                instance = MapDeserializer.createMapInstance(mapClass);
            }
            boolean empty = true;
            boolean disableCacheMapKey = jsonParseContext.isDisableCacheMapKey();
            boolean allowComment = jsonParseContext.isAllowComment();
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                String mapKey;
                char ch;
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                int fieldKeyFrom = i;
                if (ch == '\"') {
                    mapKey = disableCacheMapKey ? JSONDefaultParser.parseMapKey(buf, i, toIndex, '\"', jsonParseContext) : JSONDefaultParser.parseMapKeyByCache(buf, i, toIndex, '\"', jsonParseContext);
                    i = jsonParseContext.getEndIndex();
                    empty = false;
                    ++i;
                } else {
                    if (ch == '}') {
                        if (!empty) {
                            throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.setEndIndex(i);
                        return instance;
                    }
                    if (ch == '\'') {
                        if (!jsonParseContext.isAllowSingleQuotes()) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                        while (i + 1 < toIndex && (buf[++i] != '\'' || buf[i - 1] == '\\')) {
                        }
                        empty = false;
                        mapKey = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                    } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        empty = false;
                        mapKey = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                    } else {
                        int j = i++;
                        boolean isNullKey = false;
                        mapKey = null;
                        if (ch == 'n' && buf[i] == 'u' && buf[++i] == 'l' && buf[++i] == 'l') {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                        }
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ':') {
                    Class<?> mapKeyClass = parameterizedType == null ? null : parameterizedType.getMapKeyClass();
                    Object key = MapDeserializer.mapKeyToType((Serializable)((Object)mapKey), mapKeyClass);
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                    int ordinal = actualClassCategory.ordinal();
                    Object value = TYPE_DESERIALIZERS[ordinal].deserialize(charSource, buf, i, toIndex, valueType, null, '}', jsonParseContext);
                    instance.put(key, value);
                    i = jsonParseContext.getEndIndex();
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                    if (ch == ',') continue;
                    if (ch == '}') {
                        jsonParseContext.setEndIndex(i);
                        return instance;
                    }
                    String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
                }
                String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', Colon character ':' is expected.");
            }
            throw new JSONException("Syntax error, the closing symbol '}' is not found ");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object deserializeMap(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object obj, JSONParseContext jsonParseContext) throws Exception {
            Map instance;
            ReflectConsts.ClassCategory actualClassCategory;
            GenericParameterizedType valueType = parameterizedType.getValueType();
            ReflectConsts.ClassCategory classCategory = actualClassCategory = valueType == null ? ReflectConsts.ClassCategory.ANY : ReflectConsts.getClassCategory(valueType.getActualType());
            if (obj != null) {
                instance = (Map)obj;
            } else {
                Class<?> mapClass = parameterizedType.getActualType();
                instance = MapDeserializer.createMapInstance(mapClass);
            }
            boolean empty = true;
            boolean disableCacheMapKey = jsonParseContext.isDisableCacheMapKey();
            boolean allowComment = jsonParseContext.isAllowComment();
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                String mapKey;
                byte b;
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                int fieldKeyFrom = i;
                if (b == 34) {
                    mapKey = disableCacheMapKey ? JSONByteArrayParser.parseMapKey(buf, i, toIndex, '\"', jsonParseContext) : JSONByteArrayParser.parseMapKeyByCache(buf, i, toIndex, '\"', jsonParseContext);
                    i = jsonParseContext.getEndIndex();
                    empty = false;
                    ++i;
                } else {
                    if (b == 125) {
                        if (!empty) {
                            throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.setEndIndex(i);
                        return instance;
                    }
                    if (b == 39) {
                        if (!jsonParseContext.isAllowSingleQuotes()) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                        while (i + 1 < toIndex && (buf[++i] != 39 || buf[i - 1] == 92)) {
                        }
                        empty = false;
                        mapKey = JSONByteArrayParser.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                    } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                        while (i + 1 < toIndex && buf[++i] != 58) {
                        }
                        empty = false;
                        mapKey = JSONByteArrayParser.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                    } else {
                        int j = i++;
                        boolean isNullKey = false;
                        mapKey = null;
                        if (b == 110 && buf[i] == 117 && buf[++i] == 108 && buf[++i] == 108) {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected token character '" + (char)b + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                        }
                    }
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 58) {
                    Class<?> mapKeyClass = parameterizedType == null ? null : parameterizedType.getMapKeyClass();
                    Object key = MapDeserializer.mapKeyToType((Serializable)((Object)mapKey), mapKeyClass);
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                    int ordinal = actualClassCategory.ordinal();
                    Object value = TYPE_DESERIALIZERS[ordinal].deserialize(charSource, buf, i, toIndex, valueType, null, (byte)125, jsonParseContext);
                    instance.put(key, value);
                    i = jsonParseContext.getEndIndex();
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                    if (b == 44) continue;
                    if (b == 125) {
                        jsonParseContext.setEndIndex(i);
                        return instance;
                    }
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or '}'");
                }
                String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', Colon character ':' is expected.");
            }
            throw new JSONException("Syntax error, the closing symbol '}' is not found ");
        }
    }

    static class CollectionDeserializer
    extends JSONTypeDeserializer {
        CollectionDeserializer() {
        }

        void skip(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            int size = 0;
            boolean allowComment = jsonParseContext.isAllowComment();
            for (int i = beginIndex; i < toIndex; ++i) {
                char ch;
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (size > 0) {
                        String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return;
                }
                ++size;
                ANY.skip(charSource, buf, i, toIndex, ']', jsonParseContext);
                i = jsonParseContext.getEndIndex();
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ',') continue;
                if (ch == ']') {
                    jsonParseContext.setEndIndex(i);
                    return;
                }
                String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or ']'");
            }
            throw new JSONException("Syntax error, cannot find closing symbol ']' matching '['");
        }

        void skip(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            int size = 0;
            boolean allowComment = jsonParseContext.isAllowComment();
            for (int i = beginIndex; i < toIndex; ++i) {
                byte b;
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (size > 0) {
                        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return;
                }
                ++size;
                ANY.skip(charSource, buf, i, toIndex, (byte)93, jsonParseContext);
                i = jsonParseContext.getEndIndex();
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 44) continue;
                if (b == 93) {
                    jsonParseContext.setEndIndex(i);
                    return;
                }
                String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or ']'");
            }
            throw new JSONException("Syntax error, cannot find closing symbol ']' matching '['");
        }

        protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
            Class<?> collectionCls = parameterizedType.getActualType();
            if (collectionCls == null || collectionCls == List.class || collectionCls == ArrayList.class) {
                return new ArrayList();
            }
            return CollectionDeserializer.createCollectionInstance(collectionCls);
        }

        protected JSONTypeDeserializer getValueDeserializer(GenericParameterizedType valueGenType) {
            return JSONTypeDeserializer.getTypeDeserializer(valueGenType.getActualType());
        }

        Object deserializeCollection(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            Collection collection = instance != null ? (Collection)instance : this.createCollection(parameterizedType);
            GenericParameterizedType valueGenType = parameterizedType.getValueType();
            if (valueGenType == null) {
                valueGenType = GenericParameterizedType.AnyType;
            }
            JSONTypeDeserializer valueDeserializer = this.getValueDeserializer(valueGenType);
            boolean allowComment = jsonParseContext.isAllowComment();
            int beginIndex = fromIndex + 1;
            char ch = '\u0000';
            int i = beginIndex;
            while (true) {
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (allowComment && ch == '/') {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (collection.size() > 0) {
                        String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return collection;
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, toIndex, valueGenType, null, ']', jsonParseContext);
                collection.add(value);
                i = jsonParseContext.getEndIndex();
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ',') {
                    if (ch == ']') {
                        jsonParseContext.setEndIndex(i);
                        return collection;
                    }
                    String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        Object deserializeCollection(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            Collection collection = instance != null ? (Collection)instance : this.createCollection(parameterizedType);
            GenericParameterizedType valueGenType = parameterizedType.getValueType();
            if (valueGenType == null) {
                valueGenType = GenericParameterizedType.AnyType;
            }
            JSONTypeDeserializer valueDeserializer = this.getValueDeserializer(valueGenType);
            boolean allowComment = jsonParseContext.isAllowComment();
            int beginIndex = fromIndex + 1;
            byte b = 0;
            int i = beginIndex;
            while (true) {
                if ((b = buf[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (allowComment && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (collection.size() > 0) {
                        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return collection;
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, toIndex, valueGenType, null, (byte)93, jsonParseContext);
                collection.add(value);
                i = jsonParseContext.getEndIndex();
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b != 44) {
                    if (b == 93) {
                        jsonParseContext.setEndIndex(i);
                        return collection;
                    }
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '[': {
                    return this.deserializeCollection(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
            }
            String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', expected token character '[', but found '" + beginChar + "' for Collection Type ");
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '[': {
                    return this.deserializeCollection(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', expected token character '[', but found '" + beginChar + "' for Collection Type ");
        }

        static class CollectionInstanceDeserializer
        extends CollectionDeserializer {
            private final GenericParameterizedType valueType;
            private final JSONTypeDeserializer valueDeserializer;
            private final boolean useArrayList;
            private final boolean useHashSet;
            private final Class<? extends Collection> constructionClass;

            CollectionInstanceDeserializer(GenericParameterizedType genericParameterizedType) {
                this.valueType = genericParameterizedType.getValueType();
                this.valueDeserializer = this.valueType == null ? ANY : CollectionInstanceDeserializer.getTypeDeserializer(this.valueType.getActualType());
                Class<AbstractCollection> actualType = genericParameterizedType.getActualType();
                boolean useArrayList = false;
                boolean useHashSet = false;
                Class<AbstractCollection> constructionClass = null;
                if (actualType == List.class || actualType == ArrayList.class || actualType.isAssignableFrom(ArrayList.class)) {
                    useArrayList = true;
                } else if (actualType == Set.class || actualType == HashSet.class || actualType.isAssignableFrom(HashSet.class)) {
                    useHashSet = true;
                } else {
                    if (actualType.isInterface() || Modifier.isAbstract(actualType.getModifiers())) {
                        throw new UnsupportedOperationException("Unsupported for collection type '" + actualType + "', Please specify an implementation class");
                    }
                    constructionClass = actualType;
                }
                this.useArrayList = useArrayList;
                this.useHashSet = useHashSet;
                this.constructionClass = constructionClass;
            }

            protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
                if (this.useArrayList) {
                    return new ArrayList();
                }
                if (this.useHashSet) {
                    return new HashSet();
                }
                return this.constructionClass.newInstance();
            }

            protected JSONTypeDeserializer getValueDeserializer(GenericParameterizedType valueGenType) {
                return this.valueDeserializer;
            }
        }
    }

    static class ArrayDeserializer
    extends JSONTypeDeserializer {
        ArrayDeserializer() {
        }

        Object deserializeArray(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            char ch = '\u0000';
            Class<?> arrayCls = parameterizedType.getActualType();
            GenericParameterizedType<?> valueType = parameterizedType.getValueType();
            Class<?> elementCls = null;
            if (valueType == null) {
                elementCls = arrayCls.getComponentType();
                valueType = GenericParameterizedType.actualType(elementCls);
            } else {
                elementCls = valueType.getActualType();
            }
            ReflectConsts.ClassCategory actualClassCategory = valueType.getActualClassCategory();
            ArrayList<Object> collection = new ArrayList<Object>();
            boolean allowComment = jsonParseContext.isAllowComment();
            for (int i = beginIndex; i < toIndex; ++i) {
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = ArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (collection.size() > 0) {
                        String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return ArrayDeserializer.collectionToArray(collection, elementCls);
                }
                int ordinal = actualClassCategory.ordinal();
                Object value = TYPE_DESERIALIZERS[ordinal].deserialize(charSource, buf, i, toIndex, valueType, null, ']', jsonParseContext);
                collection.add(value);
                i = jsonParseContext.getEndIndex();
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = ArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ',') continue;
                if (ch == ']') {
                    jsonParseContext.setEndIndex(i);
                    return ArrayDeserializer.collectionToArray(collection, elementCls);
                }
                String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or ']'");
            }
            throw new JSONException("Syntax error, cannot find closing symbol ']' matching '['");
        }

        Object deserializeArray(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            byte b = 0;
            Class<?> arrayCls = parameterizedType.getActualType();
            GenericParameterizedType<?> valueType = parameterizedType.getValueType();
            Class<?> elementCls = null;
            if (valueType == null) {
                elementCls = arrayCls.getComponentType();
                valueType = GenericParameterizedType.actualType(elementCls);
            } else {
                elementCls = valueType.getActualType();
            }
            ReflectConsts.ClassCategory actualClassCategory = valueType.getActualClassCategory();
            ArrayList<Object> collection = new ArrayList<Object>();
            boolean allowComment = jsonParseContext.isAllowComment();
            for (int i = beginIndex; i < toIndex; ++i) {
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (collection.size() > 0) {
                        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return ArrayDeserializer.collectionToArray(collection, elementCls);
                }
                int ordinal = actualClassCategory.ordinal();
                Object value = TYPE_DESERIALIZERS[ordinal].deserialize(charSource, buf, i, toIndex, valueType, null, (byte)93, jsonParseContext);
                collection.add(value);
                i = jsonParseContext.getEndIndex();
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = JSONByteArrayParser.clearComments(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 44) continue;
                if (b == 93) {
                    jsonParseContext.setEndIndex(i);
                    return ArrayDeserializer.collectionToArray(collection, elementCls);
                }
                String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or ']'");
            }
            throw new JSONException("Syntax error, cannot find closing symbol ']' matching '['");
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '[': {
                    return this.deserializeArray(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, '\u0000', jsonParseContext);
                }
            }
            String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Collection Type ");
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '[': {
                    return this.deserializeArray(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Collection Type ");
        }
    }

    static class BinaryDeserializer
    extends JSONTypeDeserializer {
        BinaryDeserializer() {
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case 'n': {
                    return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
                case '\"': {
                    STRING.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    int endStringIndex = jsonParseContext.getEndIndex();
                    byte[] bytes = BinaryDeserializer.parseBytesOfBuf0(fromIndex, endStringIndex - fromIndex - 1, buf, jsonParseContext);
                    return bytes;
                }
                case '[': {
                    Byte[] target = (Byte[])ARRAY.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.arrayType(Byte.class), null, '\u0000', jsonParseContext);
                    byte[] bytes = new byte[target.length];
                    int len = bytes.length;
                    for (int i = 0; i < len; ++i) {
                        bytes[i] = target[i];
                    }
                    return bytes;
                }
            }
            throw new JSONException("Syntax error, from pos " + fromIndex + ", the beginChar '" + beginChar + "' mismatch type byte[] or Byte[] ");
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case 'n': {
                    return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
                case '\"': {
                    STRING.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    int endStringIndex = jsonParseContext.getEndIndex();
                    byte[] bytes = BinaryDeserializer.parseBytesOfBuf0(fromIndex, endStringIndex - fromIndex - 1, buf, jsonParseContext);
                    return bytes;
                }
                case '[': {
                    Byte[] target = (Byte[])ARRAY.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.arrayType(Byte.class), null, endToken, jsonParseContext);
                    byte[] bytes = new byte[target.length];
                    int len = bytes.length;
                    for (int i = 0; i < len; ++i) {
                        bytes[i] = target[i];
                    }
                    return bytes;
                }
            }
            throw new JSONException("Syntax error, from pos " + fromIndex + ", the beginChar '" + beginChar + "' mismatch type byte[] or Byte[] ");
        }

        private static byte[] parseBytesOfBuf0(int fromIndex, int len, char[] buf, JSONParseContext jsonParseContext) {
            if (jsonParseContext.isByteArrayFromHexString()) {
                return BinaryDeserializer.hexString2Bytes(buf, fromIndex + 1, len);
            }
            byte[] bytes = new byte[len];
            int offset = fromIndex + 1;
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)buf[offset + i];
            }
            return Base64.getDecoder().decode(bytes);
        }

        private static byte[] parseBytesOfBuf0(int fromIndex, int len, byte[] buf, JSONParseContext jsonParseContext) {
            if (jsonParseContext.isByteArrayFromHexString()) {
                return BinaryDeserializer.hexString2Bytes(buf, fromIndex + 1, len);
            }
            int offset = fromIndex + 1;
            byte[] bytes = Arrays.copyOfRange(buf, offset, offset + len);
            return Base64.getDecoder().decode(bytes);
        }
    }

    static class AnnotationDeserializer
    extends JSONTypeDeserializer {
        AnnotationDeserializer() {
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            ANY.skip(charSource, buf, fromIndex, toIndex, endToken, jsonParseContext);
            return null;
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            ANY.skip(charSource, buf, fromIndex, toIndex, endToken, jsonParseContext);
            return null;
        }
    }

    static class ClassDeserializer
    extends JSONTypeDeserializer {
        ClassDeserializer() {
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '\"': {
                    String name = (String)STRING.deserializeString(charSource, buf, fromIndex, toIndex, GenericParameterizedType.StringType, jsonParseContext);
                    return Class.forName(name);
                }
                case 'n': {
                    return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
            }
            String errorContextTextAt = ClassDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Class Type, expected '\"' ");
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            switch (beginByte) {
                case 34: {
                    String name = JSONByteArrayParser.parseJSONString(charSource == null ? null : charSource.input(), buf, fromIndex, toIndex, beginByte, jsonParseContext);
                    return Class.forName(name);
                }
                case 110: {
                    return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + (char)beginByte + "' for Class Type, expected '\"' ");
        }
    }

    static class EnumDeserializer
    extends JSONTypeDeserializer {
        EnumDeserializer() {
        }

        protected Object deserializeEnumName(CharSource charSource, char[] buf, int fromIndex, int toIndex, Class enumCls, JSONParseContext jsonParseContext) throws Exception {
            String name = (String)STRING.deserializeString(charSource, buf, fromIndex, toIndex, GenericParameterizedType.StringType, jsonParseContext);
            try {
                return Enum.valueOf(enumCls, name);
            }
            catch (RuntimeException exception) {
                if (jsonParseContext.isUnknownEnumAsNull()) {
                    return null;
                }
                throw exception;
            }
        }

        protected Object deserializeEnumName(CharSource charSource, byte[] buf, int fromIndex, int toIndex, Class enumCls, byte end, JSONParseContext jsonParseContext) throws Exception {
            String name = JSONByteArrayParser.parseJSONString(charSource == null ? null : charSource.input(), buf, fromIndex, toIndex, end, jsonParseContext);
            try {
                return Enum.valueOf(enumCls, name);
            }
            catch (RuntimeException exception) {
                if (jsonParseContext.isUnknownEnumAsNull()) {
                    return null;
                }
                throw exception;
            }
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            Class<?> clazz = parameterizedType.getActualType();
            switch (beginChar) {
                case 'n': {
                    return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
                case '\"': {
                    return this.deserializeEnumName(charSource, buf, fromIndex, toIndex, clazz, jsonParseContext);
                }
            }
            Integer ordinal = (Integer)NUMBER.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.IntType, null, endToken, jsonParseContext);
            Enum[] values = (Enum[])clazz.getEnumConstants();
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", ordinal " + ordinal + " cannot convert to Enum " + clazz + "");
        }

        protected Object getEnumConstants(Class clazz) {
            return clazz.getEnumConstants();
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            Class<?> clazz = parameterizedType.getActualType();
            switch (beginChar) {
                case 'n': {
                    return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
                case '\"': {
                    return this.deserializeEnumName(charSource, buf, fromIndex, toIndex, clazz, beginByte, jsonParseContext);
                }
            }
            int ordinal = JSONByteArrayParser.parseDefaultNumber(buf, fromIndex, toIndex, endToken, jsonParseContext).intValue();
            Enum[] values = (Enum[])this.getEnumConstants(clazz);
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", ordinal " + ordinal + " cannot convert to Enum " + clazz + "");
        }

        static class EnumInstanceDeserializer
        extends EnumDeserializer {
            private final Enum[] values;
            private final FixedNameValueMap<Enum> fixedNameValueMap;
            private final boolean collision;

            protected EnumInstanceDeserializer(Class enumType) {
                this.values = (Enum[])enumType.getEnumConstants();
                this.fixedNameValueMap = new FixedNameValueMap(this.values.length);
                HashSet<Integer> hashValueSet = new HashSet<Integer>();
                boolean collision = false;
                for (Enum value : this.values) {
                    this.fixedNameValueMap.putValue(value.name(), value);
                    if (hashValueSet.add(value.name().hashCode())) continue;
                    collision = true;
                }
                this.collision = collision;
                hashValueSet.clear();
            }

            protected Object getEnumConstants(Class clazz) {
                return this.values;
            }

            protected Object deserializeEnumName(CharSource charSource, char[] buf, int fromIndex, int toIndex, Class enumCls, JSONParseContext jsonParseContext) throws Exception {
                int i = fromIndex;
                int hashValue = 0;
                char ch = '\u0000';
                while ((ch = buf[++i]) != '\"' || buf[i - 1] == '\\') {
                    hashValue = hashValue * 31 + ch;
                }
                jsonParseContext.setEndIndex(i);
                Enum value = this.collision ? this.fixedNameValueMap.getValue(buf, fromIndex + 1, i, hashValue) : this.fixedNameValueMap.getValueByHash(hashValue);
                if (value == null) {
                    if (jsonParseContext.isUnknownEnumAsNull()) {
                        return null;
                    }
                    String errorContextTextAt = EnumInstanceDeserializer.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unknown Enum name '" + new String(buf, fromIndex + 1, i - fromIndex - 1) + "' of EnumType " + enumCls);
                }
                return value;
            }

            protected Object deserializeEnumName(CharSource charSource, byte[] buf, int fromIndex, int toIndex, Class enumCls, byte end, JSONParseContext jsonParseContext) throws Exception {
                int i = fromIndex;
                int hashValue = 0;
                byte b = 0;
                while ((b = buf[++i]) != 34 || buf[i - 1] == 92) {
                    hashValue = hashValue * 31 + b;
                }
                jsonParseContext.setEndIndex(i);
                Enum value = this.collision ? this.fixedNameValueMap.getValue(buf, fromIndex + 1, i, hashValue) : this.fixedNameValueMap.getValueByHash(hashValue);
                if (value == null) {
                    if (jsonParseContext.isUnknownEnumAsNull()) {
                        return null;
                    }
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unknown Enum name '" + new String(buf, fromIndex + 1, i - fromIndex - 1) + "' of EnumType " + enumCls);
                }
                return value;
            }
        }
    }

    static class DateDeserializer
    extends JSONTypeDeserializer {
        protected String pattern;
        protected int patternType;
        protected DateTemplate dateTemplate;
        protected String timezone;

        DateDeserializer() {
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '\"': {
                    STRING.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    int endStringIndex = jsonParseContext.getEndIndex();
                    Class<?> dateCls = parameterizedType.getActualType();
                    return DateDeserializer.parseDateValueOfString(buf, fromIndex, endStringIndex + 1, this.pattern, this.patternType, this.dateTemplate, this.timezone, dateCls);
                }
                case 'n': {
                    return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
                case '{': {
                    return OBJECT.deserializeObject(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
            }
            long timestamp = (Long)NUMBER.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.LongType, null, endToken, jsonParseContext);
            return DateDeserializer.parseDate(timestamp, parameterizedType.getActualType());
        }

        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = bytes[fromIndex];
            switch (beginByte) {
                case 34: {
                    STRING.skip(charSource, bytes, fromIndex, toIndex, jsonParseContext);
                    int endStringIndex = jsonParseContext.getEndIndex();
                    Class<?> dateCls = parameterizedType.getActualType();
                    return DateDeserializer.parseDateValueOfString(bytes, fromIndex, endStringIndex + 1, this.pattern, this.patternType, this.dateTemplate, this.timezone, dateCls);
                }
                case 110: {
                    return JSONByteArrayParser.parseNull(bytes, fromIndex, toIndex, jsonParseContext);
                }
                case 123: {
                    return OBJECT.deserializeObject(charSource, bytes, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
            }
            long timestamp = (Long)NUMBER.deserialize(charSource, bytes, fromIndex, toIndex, GenericParameterizedType.LongType, null, endToken, jsonParseContext);
            return DateDeserializer.parseDate(timestamp, parameterizedType.getActualType());
        }

        static class DateInstanceDeserializer
        extends DateDeserializer {
            public DateInstanceDeserializer(GenericParameterizedType genericParameterizedType) {
                genericParameterizedType.getClass();
                this.timezone = genericParameterizedType.getDateTimezone();
                this.pattern = genericParameterizedType.getDatePattern();
                this.patternType = DateInstanceDeserializer.getPatternType(this.pattern);
                if (this.patternType == 4) {
                    this.dateTemplate = new DateTemplate(this.pattern);
                }
            }
        }
    }

    static class BooleanDeserializer
    extends JSONTypeDeserializer {
        BooleanDeserializer() {
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case 't': {
                    return this.deserializeTrue(buf, fromIndex, toIndex, parameterizedType, jsonParseContext);
                }
                case 'f': {
                    return this.deserializeFalse(buf, fromIndex, toIndex, parameterizedType, jsonParseContext);
                }
            }
            String errorContextTextAt = BooleanDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Boolean Type, expected 't' or 'f'");
        }

        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            switch (beginByte) {
                case 116: {
                    return JSONByteArrayParser.parseTrue(buf, fromIndex, toIndex, jsonParseContext);
                }
                case 102: {
                    return JSONByteArrayParser.parseFalse(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + (char)beginByte + "' for Boolean Type, expected 't' or 'f'");
        }

        Object deserializeTrue(char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) throws Exception {
            int endIndex = fromIndex + 3;
            if (buf[fromIndex + 1] == 'r' && buf[fromIndex + 2] == 'u' && buf[endIndex] == 'e') {
                jsonParseContext.setEndIndex(endIndex);
                return true;
            }
            int len = Math.min(toIndex - fromIndex + 1, 4);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'true' because it starts with 't', but found text '" + new String(buf, fromIndex, len) + "'");
        }

        Object deserializeFalse(char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) throws Exception {
            int endIndex = fromIndex + 4;
            if (buf[fromIndex + 1] == 'a' && buf[fromIndex + 2] == 'l' && buf[fromIndex + 3] == 's' && buf[endIndex] == 'e') {
                jsonParseContext.setEndIndex(endIndex);
                return false;
            }
            int len = Math.min(toIndex - fromIndex + 1, 5);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'false' because it starts with 'f', but found text '" + new String(buf, fromIndex, len) + "'");
        }
    }

    static class NumberDeserializer
    extends JSONTypeDeserializer {
        protected NumberDeserializer() {
        }

        Number deserializeDefault0(char[] buf, int fromIndex, int toIndex, int offset, long val, int valueLen, boolean negative, char endToken, JSONParseContext jsonParseContext) throws Exception {
            int numberLen = valueLen;
            double value = val;
            int decimalCount = 0;
            int radix = 10;
            int expValue = 0;
            boolean expNegative = false;
            int mode = 0;
            int specifySuffix = 0;
            int i = offset;
            while (true) {
                char ch;
                int digit;
                if ((digit = NumberDeserializer.digitDecimal(ch = buf[i])) == -1) {
                    if (ch == ',' || ch == endToken) break;
                    if (ch == '.') {
                        if (mode != 0) {
                            throw new JSONException("For input string: \"" + new String(buf, fromIndex, i + 1 - fromIndex) + "\"");
                        }
                        mode = 1;
                        ch = buf[++i];
                        digit = NumberDeserializer.digitDecimal(ch);
                    } else if (ch == 'E' || ch == 'e') {
                        if (mode == 2) {
                            throw new JSONException("For input string: \"" + new String(buf, fromIndex, i + 1 - fromIndex) + "\"");
                        }
                        mode = 2;
                        if ((ch = buf[++i]) == '-') {
                            expNegative = true;
                            ch = buf[++i];
                        }
                        digit = NumberDeserializer.digitDecimal(ch);
                    }
                }
                if (digit == -1) {
                    boolean breakLoop = false;
                    switch (ch) {
                        case 'L': 
                        case 'l': {
                            if (specifySuffix == 0) {
                                specifySuffix = 1;
                                while ((ch = buf[++i]) <= ' ') {
                                }
                                if (ch == ',' || ch == endToken) {
                                    breakLoop = true;
                                    break;
                                }
                            }
                            String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                        }
                        case 'F': 
                        case 'f': {
                            if (specifySuffix == 0) {
                                specifySuffix = 2;
                                while ((ch = buf[++i]) <= ' ') {
                                }
                                if (ch == ',' || ch == endToken) {
                                    breakLoop = true;
                                    break;
                                }
                            }
                            String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                        }
                        case 'D': 
                        case 'd': {
                            if (specifySuffix == 0) {
                                specifySuffix = 3;
                                while ((ch = buf[++i]) <= ' ') {
                                }
                                if (ch == ',' || ch == endToken) {
                                    breakLoop = true;
                                    break;
                                }
                            }
                            String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                        }
                        default: {
                            if (ch > ' ') break;
                            while ((ch = buf[++i]) <= ' ') {
                            }
                            if (ch == ',' || ch == endToken) {
                                breakLoop = true;
                                break;
                            }
                            String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                        }
                    }
                    if (breakLoop) break;
                    String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", at pos " + i + ", context text by '" + contextErrorAt + "'");
                }
                ++numberLen;
                switch (mode) {
                    case 0: {
                        value *= 10.0;
                        value += (double)digit;
                        break;
                    }
                    case 1: {
                        value *= 10.0;
                        value += (double)digit;
                        ++decimalCount;
                        break;
                    }
                    case 2: {
                        expValue = (expValue << 3) + (expValue << 1);
                        expValue += digit;
                    }
                }
                ++i;
            }
            jsonParseContext.setEndIndex(i - 1);
            if (mode == 0) {
                if (numberLen > 18) {
                    int endIndex = i - 1;
                    while (buf[endIndex] <= ' ') {
                        --endIndex;
                    }
                    return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                }
                double d = value = negative ? -value : value;
                if (specifySuffix > 0) {
                    switch (specifySuffix) {
                        case 1: {
                            return (long)value;
                        }
                        case 2: {
                            return Float.valueOf((float)value);
                        }
                    }
                    return value;
                }
                if (value <= 2.147483647E9 && value > -2.147483648E9) {
                    return (int)value;
                }
                if (value <= 9.223372036854776E18 && value > -9.223372036854776E18) {
                    return (long)value;
                }
                return value;
            }
            int n = expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
            if (expValue > 0) {
                double powValue = NumberDeserializer.getDecimalPowerValue(expValue);
                value *= powValue;
            } else if (expValue < 0) {
                double powValue = NumberDeserializer.getDecimalPowerValue(-expValue);
                value /= powValue;
            }
            double d = value = negative ? -value : value;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return (long)value;
                    }
                    case 2: {
                        return Float.valueOf((float)value);
                    }
                }
                return value;
            }
            return value;
        }

        Number deserializeDefault(char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext jsonParseContext) throws Exception {
            boolean negative = false;
            int i = fromIndex;
            char ch = buf[fromIndex];
            if (ch == '-') {
                negative = true;
                ++i;
            } else if (ch == '+') {
                ++i;
            }
            return this.deserializeDefault0(buf, fromIndex, toIndex, i, 0L, 0, negative, endToken, jsonParseContext);
        }

        Object deserializeOfString(char[] buf, int fromIndex, int toIndex, char endToken, int numberType, JSONParseContext jsonParseContext) {
            int endIndex;
            char ch;
            int i = fromIndex;
            while ((ch = buf[i + 1]) != ',' && ch != endToken) {
                ++i;
            }
            jsonParseContext.setEndIndex(i);
            for (endIndex = i + 1; endIndex > fromIndex && buf[endIndex - 1] <= ' '; --endIndex) {
            }
            int len = endIndex - fromIndex;
            switch (numberType) {
                case 109: {
                    return new BigDecimal(buf, fromIndex, len);
                }
                case 110: {
                    return new BigInteger(new String(buf, fromIndex, len));
                }
            }
            return Double.parseDouble(new String(buf, fromIndex, len));
        }

        Object deserializeOfString(CharSource charSource, byte[] bytes, int fromIndex, int toIndex, byte endToken, int numberType, JSONParseContext jsonParseContext) {
            int endIndex;
            byte b;
            int i = fromIndex;
            while ((b = bytes[i + 1]) != 44 && b != endToken) {
                ++i;
            }
            jsonParseContext.setEndIndex(i);
            for (endIndex = i + 1; endIndex > fromIndex && bytes[endIndex - 1] <= 32; --endIndex) {
            }
            int len = endIndex - fromIndex;
            String value = charSource == null ? new String(bytes, fromIndex, len) : charSource.getString(fromIndex, len);
            switch (numberType) {
                case 109: {
                    return new BigDecimal(value);
                }
                case 110: {
                    return new BigInteger(value);
                }
            }
            return Double.parseDouble(value);
        }

        protected Number deserializeInteger(char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext jsonParseContext) throws Exception {
            long value = 0L;
            boolean negative = false;
            int radix = 10;
            boolean empty = true;
            int i = fromIndex;
            char ch = buf[fromIndex];
            if (ch == '-') {
                negative = true;
                ++i;
            } else if (ch == '+') {
                ++i;
            }
            block3: while (true) {
                ch = buf[i];
                switch (ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int digit = ch - 48;
                        empty = false;
                        value *= (long)radix;
                        value += (long)digit;
                        ++i;
                        continue block3;
                    }
                }
                break;
            }
            if (ch == ',' || ch == endToken) {
                return this.number(buf, i - 1, negative ? -value : value, empty, jsonParseContext);
            }
            if (ch <= ' ') {
                while ((ch = buf[++i]) <= ' ') {
                }
                if (ch == ',' || ch == endToken) {
                    return this.number(buf, i - 1, negative ? -value : value, empty, jsonParseContext);
                }
                String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
            }
            return this.deserializeDefault0(buf, fromIndex, toIndex, i, value, 0, negative, endToken, jsonParseContext);
        }

        private Number number(char[] buf, int endIndex, Number value, boolean empty, JSONParseContext jsonParseContext) {
            if (empty) {
                String contextErrorAt = NumberDeserializer.createErrorContextText(buf, endIndex + 1);
                throw new JSONException("For input empty number, at pos " + (endIndex + 1) + ", context text by '" + contextErrorAt + "'");
            }
            jsonParseContext.setEndIndex(endIndex);
            return value;
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            if (parameterizedType == GenericParameterizedType.AnyType || parameterizedType == null) {
                return this.deserializeDefault(buf, fromIndex, toIndex, endToken, jsonParseContext);
            }
            char beginChar = buf[fromIndex];
            if (beginChar == 'n') {
                return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
            int numberType = parameterizedType.getParamClassNumberType();
            switch (numberType) {
                case 101: {
                    return this.deserializeInteger(buf, fromIndex, toIndex, endToken, jsonParseContext).byteValue();
                }
                case 102: {
                    return this.deserializeInteger(buf, fromIndex, toIndex, endToken, jsonParseContext).shortValue();
                }
                case 103: {
                    return this.deserializeInteger(buf, fromIndex, toIndex, endToken, jsonParseContext).intValue();
                }
                case 104: {
                    return this.deserializeInteger(buf, fromIndex, toIndex, endToken, jsonParseContext).longValue();
                }
                case 105: {
                    return Float.valueOf(this.deserializeDefault(buf, fromIndex, toIndex, endToken, jsonParseContext).floatValue());
                }
                case 106: {
                    if (jsonParseContext.isUseNativeDoubleParser()) {
                        return this.deserializeOfString(buf, fromIndex, toIndex, endToken, numberType, jsonParseContext);
                    }
                    return this.deserializeDefault(buf, fromIndex, toIndex, endToken, jsonParseContext).doubleValue();
                }
                case 107: {
                    return new AtomicInteger(this.deserializeInteger(buf, fromIndex, toIndex, endToken, jsonParseContext).intValue());
                }
                case 108: {
                    return new AtomicLong(this.deserializeInteger(buf, fromIndex, toIndex, endToken, jsonParseContext).longValue());
                }
                case 109: 
                case 110: {
                    return this.deserializeOfString(buf, fromIndex, toIndex, endToken, numberType, jsonParseContext);
                }
            }
            this.deserializeDefault(buf, fromIndex, toIndex, endToken, jsonParseContext);
            return null;
        }

        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            if (parameterizedType == GenericParameterizedType.AnyType || parameterizedType == null) {
                return JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext);
            }
            byte beginByte = bytes[fromIndex];
            if (beginByte == 110) {
                return JSONByteArrayParser.parseNull(bytes, fromIndex, toIndex, jsonParseContext);
            }
            int numberType = parameterizedType.getParamClassNumberType();
            switch (numberType) {
                case 101: {
                    return JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext).byteValue();
                }
                case 102: {
                    return JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext).shortValue();
                }
                case 103: {
                    return JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext).intValue();
                }
                case 104: {
                    return JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext).longValue();
                }
                case 105: {
                    return Float.valueOf(JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext).floatValue());
                }
                case 106: {
                    if (jsonParseContext.isUseNativeDoubleParser()) {
                        return this.deserializeOfString(charSource, bytes, fromIndex, toIndex, endToken, numberType, jsonParseContext);
                    }
                    return JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext).doubleValue();
                }
                case 107: {
                    return new AtomicInteger(JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext).intValue());
                }
                case 108: {
                    return new AtomicLong(JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext).longValue());
                }
                case 109: 
                case 110: {
                    return this.deserializeOfString(charSource, bytes, fromIndex, toIndex, endToken, numberType, jsonParseContext);
                }
            }
            JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext);
            return null;
        }

        static Object parseNumberValue(char[] buf, int fromIndex, int endIndex, int numberType) {
            char beginChar = buf[fromIndex];
            char endChar = '\u0000';
            while (endIndex > fromIndex && (endChar = buf[endIndex - 1]) <= ' ') {
                --endIndex;
            }
            int len = endIndex - fromIndex;
            if (beginChar == 'n' && len == 4 && buf[fromIndex + 1] == 'u' && buf[fromIndex + 2] == 'l' && endChar == 'l') {
                return null;
            }
            switch (numberType) {
                case 103: {
                    return Integer.parseInt(new String(buf, fromIndex, len));
                }
                case 105: {
                    return Float.valueOf(Float.parseFloat(new String(buf, fromIndex, len)));
                }
                case 104: {
                    return Long.parseLong(new String(buf, fromIndex, len));
                }
                case 106: {
                    return Double.parseDouble(new String(buf, fromIndex, len));
                }
                case 109: {
                    return new BigDecimal(buf, fromIndex, len);
                }
                case 101: {
                    return Byte.parseByte(new String(buf, fromIndex, len));
                }
                case 107: {
                    return new AtomicInteger(Integer.parseInt(new String(buf, fromIndex, len)));
                }
                case 108: {
                    return new AtomicLong(Long.parseLong(new String(buf, fromIndex, len)));
                }
                case 110: {
                    return new BigInteger(new String(buf, fromIndex, len));
                }
            }
            return null;
        }

        static class LongDeserializer
        extends NumberDeserializer {
            LongDeserializer() {
            }

            protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
                char beginChar = buf[fromIndex];
                if (beginChar == 'n') {
                    NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                    if (parameterizedType.getActualType() == Long.TYPE) {
                        return 0L;
                    }
                    return null;
                }
                return this.deserializeInteger(buf, fromIndex, toIndex, endToken, jsonParseContext).longValue();
            }
        }

        static class IntegerDeserializer
        extends NumberDeserializer {
            IntegerDeserializer() {
            }

            protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
                char beginChar = buf[fromIndex];
                if (beginChar == 'n') {
                    NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                    if (parameterizedType.getActualType() == Integer.TYPE) {
                        return 0;
                    }
                    return null;
                }
                return this.deserializeInteger(buf, fromIndex, toIndex, endToken, jsonParseContext).intValue();
            }
        }
    }

    static class CharSequenceDeserializer
    extends JSONTypeDeserializer {
        CharSequenceDeserializer() {
        }

        protected void skip(CharSource source, char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            char endCh = '\"';
            if (source != null && JDK_9_ABOVE) {
                int endIndex = source.indexOf(endCh, beginIndex);
                char prev = buf[endIndex - 1];
                if (prev == '\\') {
                    while ((prev = buf[(endIndex = source.indexOf(endCh, endIndex + 1)) - 1]) == '\\') {
                    }
                }
                jsonParseContext.setEndIndex(endIndex);
                return;
            }
            int i = fromIndex + 1;
            while (buf[i] != '\"' || buf[i - 1] == '\\') {
                ++i;
            }
            jsonParseContext.setEndIndex(i);
        }

        protected void skip(CharSource source, byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            char endCh = '\"';
            if (source != null && JDK_9_ABOVE) {
                int endIndex = source.indexOf(endCh, beginIndex);
                byte prev = buf[endIndex - 1];
                if (prev == 92) {
                    while ((prev = buf[(endIndex = source.indexOf(endCh, endIndex + 1)) - 1]) == 92) {
                    }
                }
                jsonParseContext.setEndIndex(endIndex);
                return;
            }
            int i = fromIndex + 1;
            while (buf[i] != 34 || buf[i - 1] == 92) {
                ++i;
            }
            jsonParseContext.setEndIndex(i);
        }

        Object deserializeString(CharSource source, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
            int beginIndex = fromIndex + 1;
            int paramClassType = parameterizedType.getParamClassType();
            boolean isCharArray = paramClassType == 203;
            JSONStringWriter writer = null;
            char ch = '\u0000';
            char next = '\u0000';
            int i = beginIndex;
            boolean escape = false;
            while (true) {
                if ((ch = buf[i]) != '\\' && ch != '\"') {
                    ++i;
                    continue;
                }
                if (ch == '\\') {
                    if (i < toIndex - 1) {
                        next = buf[i + 1];
                    }
                    if (writer == null) {
                        writer = CharSequenceDeserializer.getContextWriter(jsonParseContext);
                        escape = true;
                    }
                } else {
                    jsonParseContext.setEndIndex(i);
                    int len = i - beginIndex;
                    if (escape) {
                        writer.write(buf, beginIndex, len);
                        if (isCharArray) {
                            int charLen = writer.size();
                            char[] chars = new char[charLen];
                            writer.getChars(0, charLen, chars, 0);
                            return chars;
                        }
                        return this.getCharSequence(writer, paramClassType);
                    }
                    if (isCharArray) {
                        char[] chars = new char[len];
                        System.arraycopy(buf, beginIndex, chars, 0, len);
                        return chars;
                    }
                    return this.getCharSequence(source, buf, beginIndex, len, paramClassType);
                }
                beginIndex = CharSequenceDeserializer.escapeNext(buf, next, i, beginIndex, writer, jsonParseContext);
                i = jsonParseContext.getEndIndex();
                ++i;
            }
        }

        Object deserializeString(CharSource source, byte[] buf, int fromIndex, int toIndex, byte endByte, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
            int paramClassType = parameterizedType.getParamClassType();
            String value = JSONByteArrayParser.parseJSONString(source == null ? null : source.input(), buf, fromIndex, toIndex, endByte, jsonParseContext);
            if (paramClassType == 200) {
                return value;
            }
            switch (paramClassType) {
                case 201: {
                    return new StringBuffer(value);
                }
                case 202: {
                    return new StringBuilder(value);
                }
                case 203: {
                    return value.toCharArray();
                }
            }
            return null;
        }

        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            boolean isStringType;
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '\"': {
                    return this.deserializeString(charSource, buf, fromIndex, toIndex, parameterizedType, jsonParseContext);
                }
                case 'n': {
                    return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
            }
            boolean bl = isStringType = parameterizedType.getActualType() == String.class;
            if (isStringType) {
                try {
                    NUMBER.deserializeOfString(buf, fromIndex, toIndex, endToken, 106, jsonParseContext);
                    return new String(buf, fromIndex, jsonParseContext.getEndIndex() + 1 - fromIndex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String errorContextTextAt = CharSequenceDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for CharSequence, expected '\"' ");
        }

        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            boolean isStringType;
            byte beginByte = bytes[fromIndex];
            switch (beginByte) {
                case 34: {
                    return this.deserializeString(charSource, bytes, fromIndex, toIndex, beginByte, parameterizedType, jsonParseContext);
                }
                case 110: {
                    return JSONByteArrayParser.parseNull(bytes, fromIndex, toIndex, jsonParseContext);
                }
            }
            boolean bl = isStringType = parameterizedType.getActualType() == String.class;
            if (isStringType) {
                try {
                    JSONByteArrayParser.parseDefaultNumber(bytes, fromIndex, toIndex, endToken, jsonParseContext);
                    return charSource == null ? new String(bytes, fromIndex, jsonParseContext.getEndIndex() + 1 - fromIndex) : charSource.getString(fromIndex, jsonParseContext.getEndIndex() + 1 - fromIndex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + (char)beginByte + "' for CharSequence, expected '\"' ");
        }

        private CharSequence getCharSequence(CharSource charSource, char[] buf, int beginIndex, int len, int paramClassType) {
            if (paramClassType == 200) {
                return len < 1024 || charSource == null ? new String(buf, beginIndex, len) : charSource.substring(beginIndex, beginIndex + len);
            }
            switch (paramClassType) {
                case 201: {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (len > 0) {
                        stringBuffer.append(buf, beginIndex, len);
                    }
                    return stringBuffer;
                }
                case 202: {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (len > 0) {
                        stringBuilder.append(buf, beginIndex, len);
                    }
                    return stringBuilder;
                }
            }
            return null;
        }

        private CharSequence getCharSequence(JSONStringWriter writer, int paramClassType) {
            if (paramClassType == 200) {
                return writer.toString();
            }
            switch (paramClassType) {
                case 201: {
                    return writer.toStringBuffer();
                }
                case 202: {
                    return writer.toStringBuilder();
                }
            }
            return null;
        }
    }
}

