/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.reflect;

import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.annotations.JsonSerialize;
import io.github.wycst.wast.json.custom.JsonSerializer;
import io.github.wycst.wast.json.options.JsonConfig;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class FieldSerializer
extends JSONTypeSerializer {
    private final GetterInfo getterInfo;
    private final JsonProperty jsonProperty;
    private String name;
    private final ReflectConsts.ClassCategory classCategory;
    private String pattern;
    private String timezone;
    private boolean writeDateAsTime;
    private JsonSerializer jsonSerializer;
    private boolean customSerialize = false;
    public JSONTypeSerializer serializer;
    private char[] fixedFieldName;
    private static final Map<Class<? extends JsonSerializer>, JsonSerializer> customSerializers = new HashMap<Class<? extends JsonSerializer>, JsonSerializer>();

    FieldSerializer(GetterInfo getterInfo, String name) {
        JsonProperty jsonProperty;
        this.getterInfo = getterInfo;
        this.classCategory = getterInfo.getClassCategory();
        this.name = name;
        this.fixed();
        this.jsonProperty = jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            this.writeDateAsTime = jsonProperty.asTimestamp();
            this.pattern = jsonProperty.pattern();
            this.timezone = jsonProperty.timezone();
        }
    }

    void initSerializer() {
        if (this.serializer == null) {
            this.serializer = this.createSerializer();
        }
    }

    private JSONTypeSerializer createSerializer() {
        JsonSerialize jsonSerialize = (JsonSerialize)this.getterInfo.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null) {
            Class<? extends JsonSerializer> jsonSerializerClass = jsonSerialize.value();
            this.customSerialize = true;
            try {
                if (jsonSerialize.singleton()) {
                    JsonSerializer jsonSerializer = customSerializers.get(jsonSerializerClass);
                    if (jsonSerializer == null) {
                        jsonSerializer = jsonSerializerClass.newInstance();
                        customSerializers.put(jsonSerializerClass, jsonSerializer);
                    }
                    return jsonSerializer;
                }
                return jsonSerializerClass.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        Class<?> returnType = this.getterInfo.getReturnType();
        if (this.classCategory != ReflectConsts.ClassCategory.ObjectCategory && this.classCategory == ReflectConsts.ClassCategory.NumberCategory) {
            return JSONTypeSerializer.getTypeSerializer(returnType);
        }
        return JSONTypeSerializer.getFieldTypeSerializer(this.classCategory, returnType, this.jsonProperty);
    }

    private void fixed() {
        int len = this.name.length();
        this.fixedFieldName = new char[len + 9];
        this.fixedFieldName[0] = 44;
        this.fixedFieldName[1] = 34;
        this.name.getChars(0, len, this.fixedFieldName, 2);
        this.fixedFieldName[len + 2] = 34;
        this.fixedFieldName[len + 3] = 58;
        this.fixedFieldName[len + 4] = 110;
        this.fixedFieldName[len + 5] = 117;
        this.fixedFieldName[len + 6] = 108;
        this.fixedFieldName[len + 7] = 108;
        this.fixedFieldName[len + 8] = 44;
    }

    public GetterInfo getGetterInfo() {
        return this.getterInfo;
    }

    public char[] getFixedFieldName() {
        return this.fixedFieldName;
    }

    public JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    public JSONTypeSerializer getSerializer() {
        return this.serializer;
    }

    protected void serialize(Object value, Writer writer, JsonConfig jsonConfig, int indent) throws Exception {
    }
}

