/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.reflect;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.reflect.FieldDeserializer;
import io.github.wycst.wast.json.reflect.FieldSerializer;
import io.github.wycst.wast.json.util.FixedNameValueMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStructureWrapper {
    private static Map<Class<?>, ObjectStructureWrapper> objectStructureWarppers = new ConcurrentHashMap();
    private final ClassStructureWrapper classStructureWrapper;
    private ClassStructureWrapper.ClassWrapperType classWrapperType;
    private final GenericParameterizedType genericType;
    private final FixedNameValueMap<FieldDeserializer> fieldDeserializerMap;
    private List<FieldDeserializer> fieldDeserializers = new ArrayList<FieldDeserializer>();
    private FieldSerializer[] getterMethodSerializers;
    private FieldSerializer[] getterFieldSerializers;
    private final boolean collision;
    private boolean forceUseFields;

    private ObjectStructureWrapper(ClassStructureWrapper classStructureWrapper) {
        classStructureWrapper.getClass();
        this.classStructureWrapper = classStructureWrapper;
        this.classWrapperType = classStructureWrapper.getClassWrapperType();
        this.forceUseFields = classStructureWrapper.isForceUseFields();
        List<GetterInfo> getterInfos = classStructureWrapper.getGetterInfos();
        ArrayList<FieldSerializer> fieldSerializers = new ArrayList<FieldSerializer>();
        for (GetterInfo getterInfo : getterInfos) {
            JsonProperty jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
            String name = getterInfo.getName();
            if (jsonProperty != null) {
                if (!jsonProperty.serialize()) continue;
                String aliasName = jsonProperty.name().trim();
                if (aliasName.length() > 0) {
                    name = aliasName;
                }
            }
            FieldSerializer fieldSerializer = new FieldSerializer(getterInfo, name);
            fieldSerializers.add(fieldSerializer);
        }
        this.getterMethodSerializers = fieldSerializers.toArray(new FieldSerializer[fieldSerializers.size()]);
        fieldSerializers.clear();
        List<GetterInfo> getterByFieldInfos = classStructureWrapper.getGetterInfos(true);
        for (GetterInfo getterInfo : getterByFieldInfos) {
            JsonProperty jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
            String name = getterInfo.getName();
            if (jsonProperty != null) {
                if (!jsonProperty.serialize()) continue;
                String aliasName = jsonProperty.name().trim();
                if (aliasName.length() > 0) {
                    name = aliasName;
                }
            }
            FieldSerializer fieldSerializer = new FieldSerializer(getterInfo, name);
            fieldSerializers.add(fieldSerializer);
        }
        this.getterFieldSerializers = fieldSerializers.toArray(new FieldSerializer[fieldSerializers.size()]);
        this.fieldDeserializerMap = new FixedNameValueMap(classStructureWrapper.setterNames().size());
        this.genericType = GenericParameterizedType.actualType(classStructureWrapper.getSourceClass());
        Set<String> set = classStructureWrapper.setterNames();
        for (String setterName : set) {
            SetterInfo setterInfo = classStructureWrapper.getSetterInfo(setterName);
            JsonProperty jsonProperty = (JsonProperty)setterInfo.getAnnotation(JsonProperty.class);
            String mapperName = null;
            if (jsonProperty != null) {
                if (!jsonProperty.deserialize()) continue;
                mapperName = jsonProperty.name();
            }
            FieldDeserializer fieldDeserializer = new FieldDeserializer(setterName, setterInfo, jsonProperty);
            this.fieldDeserializerMap.putValue(setterName, fieldDeserializer);
            this.fieldDeserializers.add(fieldDeserializer);
            if (mapperName == null || (mapperName = mapperName.trim()).length() <= 0 || mapperName.equals(setterName)) continue;
            fieldDeserializer = new FieldDeserializer(mapperName, setterInfo, jsonProperty);
            this.fieldDeserializerMap.putValue(mapperName, fieldDeserializer);
            this.fieldDeserializers.add(fieldDeserializer);
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        Collections.sort(this.fieldDeserializers, new Comparator<FieldDeserializer>(){

            @Override
            public int compare(FieldDeserializer o1, FieldDeserializer o2) {
                Integer h2;
                Integer h1 = o1.getHash();
                int r = h1.compareTo(h2 = Integer.valueOf(o2.getHash()));
                if (r == 0) {
                    atomicBoolean.set(true);
                }
                return r;
            }
        });
        this.collision = atomicBoolean.get();
    }

    private void init() {
        for (FieldDeserializer fieldDeserializer : this.fieldDeserializers) {
            fieldDeserializer.initDeserializer();
        }
        for (FieldSerializer fieldSerializer : this.getterMethodSerializers) {
            fieldSerializer.initSerializer();
        }
        for (FieldSerializer fieldSerializer : this.getterFieldSerializers) {
            fieldSerializer.initSerializer();
        }
    }

    public Class<?> getSourceClass() {
        return this.classStructureWrapper.getSourceClass();
    }

    public boolean isRecord() {
        return this.classStructureWrapper.isRecord();
    }

    public boolean isTemporal() {
        return this.classStructureWrapper.isTemporal();
    }

    public int getFieldCount() {
        return this.classStructureWrapper.getFieldCount();
    }

    public ClassStructureWrapper.ClassWrapperType getClassWrapperType() {
        return this.classWrapperType;
    }

    public Object[] createConstructorArgs() {
        return this.classStructureWrapper.createConstructorArgs();
    }

    public FieldDeserializer getFieldDeserializer(char[] buf, int beginIndex, int endIndex, int hashValue) {
        return this.fieldDeserializerMap.getValue(buf, beginIndex, endIndex, hashValue);
    }

    public FieldDeserializer getFieldDeserializer(byte[] buf, int beginIndex, int endIndex, int hashValue) {
        return this.fieldDeserializerMap.getValue(buf, beginIndex, endIndex, hashValue);
    }

    public FieldDeserializer getFieldDeserializer(String field) {
        return this.fieldDeserializerMap.getValue(field);
    }

    public FieldDeserializer getFieldDeserializer(int hashValue) {
        return this.fieldDeserializerMap.getValueByHash(hashValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectStructureWrapper get(Class<?> pojoClass) {
        if (pojoClass == null) {
            throw new IllegalArgumentException("pojoClass is null");
        }
        ObjectStructureWrapper objectWrapper = objectStructureWarppers.get(pojoClass);
        if (objectWrapper != null) {
            return objectWrapper;
        }
        Class<?> clazz = pojoClass;
        synchronized (clazz) {
            if (objectStructureWarppers.containsKey(pojoClass)) {
                return objectStructureWarppers.get(pojoClass);
            }
            ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(pojoClass);
            if (classStructureWrapper == null) {
                throw new IllegalArgumentException("pojoClass " + pojoClass + " is not supported !");
            }
            objectWrapper = new ObjectStructureWrapper(classStructureWrapper);
            objectStructureWarppers.put(pojoClass, objectWrapper);
            objectWrapper.init();
        }
        return objectWrapper;
    }

    public Object newInstance() throws Exception {
        return this.classStructureWrapper.newInstance();
    }

    public Object newInstance(Object[] constructorArgs) throws Exception {
        return this.classStructureWrapper.newInstance(constructorArgs);
    }

    public GenericParameterizedType getGenericType() {
        return this.genericType;
    }

    public boolean isCollision() {
        return this.collision;
    }

    public boolean isAssignableFromMap() {
        return this.classStructureWrapper.isAssignableFromMap();
    }

    public FieldSerializer[] getFieldSerializers(boolean useFields) {
        return useFields || this.forceUseFields ? this.getterFieldSerializers : this.getterMethodSerializers;
    }
}

