/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.supports;

import io.github.wycst.wast.json.JSON;
import io.github.wycst.wast.json.options.ReadOption;
import io.github.wycst.wast.json.options.WriteOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private WriteOption[] writeOptions;
    private ReadOption[] readOptions;

    public JSONHttpMessageConverter() {
        this.initOptions();
    }

    public JSONHttpMessageConverter(Charset defaultCharset, MediaType ... supportedMediaTypes) {
        super(defaultCharset, supportedMediaTypes);
        this.initOptions();
    }

    public JSONHttpMessageConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
        this.initOptions();
    }

    private void initOptions() {
        this.writeOptions = new WriteOption[0];
        this.readOptions = new ReadOption[0];
    }

    protected boolean supports(Class<?> aClass) {
        return true;
    }

    public List<MediaType> getSupportedMediaTypes() {
        List supportedMediaTypes = super.getSupportedMediaTypes();
        if (supportedMediaTypes != null && supportedMediaTypes.size() > 0) {
            return supportedMediaTypes;
        }
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_JSON);
        return mediaTypes;
    }

    public void setWriteOptions(WriteOption ... writeOptions) {
        this.writeOptions = writeOptions;
    }

    public void setReadOptions(ReadOption ... readOptions) {
        this.readOptions = readOptions;
    }

    protected Object readInternal(Class<?> aClass, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        InputStream is = httpInputMessage.getBody();
        return JSON.read(is, aClass, this.readOptions);
    }

    protected void writeInternal(Object o, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        OutputStream os = httpOutputMessage.getBody();
        JSON.writeJsonTo(o, os, this.writeOptions);
    }
}

