/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;

public class TemporalLocalDateTimeDeserializer
extends JSONTemporalDeserializer {
    public TemporalLocalDateTimeDeserializer(GenericParameterizedType genericParameterizedType) {
        super(genericParameterizedType);
    }

    protected void checkClass(GenericParameterizedType genericParameterizedType) {
        if (genericParameterizedType.getActualType() != TemporalAloneInvoker.localDateTimeClass) {
            throw new UnsupportedOperationException("Not Support for class " + genericParameterizedType.getActualType());
        }
    }

    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        if (this.patternType == 0) {
            int year = TemporalLocalDateTimeDeserializer.parseInt4(buf, fromIndex + 1);
            int month = TemporalLocalDateTimeDeserializer.parseInt2(buf, fromIndex + 6);
            int day = TemporalLocalDateTimeDeserializer.parseInt2(buf, fromIndex + 9);
            int hour = TemporalLocalDateTimeDeserializer.parseInt2(buf, fromIndex + 12);
            int minute = TemporalLocalDateTimeDeserializer.parseInt2(buf, fromIndex + 15);
            int second = TemporalLocalDateTimeDeserializer.parseInt2(buf, fromIndex + 18);
            return TemporalAloneInvoker.ofLocalDateTime(year, month, day, hour, minute, second, 0);
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, null);
        return TemporalAloneInvoker.ofLocalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        if (this.patternType == 0) {
            int year = NumberUtils.parseInt4(buf, fromIndex + 1);
            int month = NumberUtils.parseInt2(buf, fromIndex + 6);
            int day = NumberUtils.parseInt2(buf, fromIndex + 9);
            int hour = NumberUtils.parseInt2(buf, fromIndex + 12);
            int minute = NumberUtils.parseInt2(buf, fromIndex + 15);
            int second = NumberUtils.parseInt2(buf, fromIndex + 18);
            return TemporalAloneInvoker.ofLocalDateTime(year, month, day, hour, minute, second, 0);
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, null);
        return TemporalAloneInvoker.ofLocalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }
}

