/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;

public class TemporalZonedDateTimeDeserializer
extends JSONTemporalDeserializer {
    public TemporalZonedDateTimeDeserializer(GenericParameterizedType genericParameterizedType) {
        super(genericParameterizedType);
    }

    protected void checkClass(GenericParameterizedType genericParameterizedType) {
        if (genericParameterizedType.getActualType() != TemporalAloneInvoker.zonedDateTimeClass) {
            throw new UnsupportedOperationException("Not Support for class " + genericParameterizedType.getActualType());
        }
    }

    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        if (this.patternType == 0) {
            return this.autoMatchZoneDateTime(buf, fromIndex, endIndex, jsonParseContext);
        }
        String zoneId = null;
        int j = endIndex;
        while (j > fromIndex + 20 && (ch = buf[--j]) != '.') {
            if (ch == '+' || ch == '-' || ch == 'Z') {
                zoneId = new String(buf, j, endIndex - j);
                endIndex = j;
                break;
            }
            if (ch != '[' || buf[endIndex - 1] != ']') continue;
            zoneId = new String(buf, j + 1, endIndex - j - 2);
            endIndex = j;
            break;
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, null);
        Object zoneObject = zoneId == null ? TemporalAloneInvoker.getDefaultZoneId() : TemporalAloneInvoker.ofZoneId(zoneId);
        return TemporalAloneInvoker.ofZonedDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
    }

    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        byte ch;
        if (this.patternType == 0) {
            return this.autoMatchZoneDateTime(buf, fromIndex, endIndex, jsonParseContext);
        }
        String zoneId = null;
        int j = endIndex;
        while (j > fromIndex + 20 && (ch = buf[--j]) != 46) {
            if (ch == 43 || ch == 45 || ch == 90) {
                zoneId = new String(buf, j, endIndex - j);
                endIndex = j;
                break;
            }
            if (ch != 91 || buf[endIndex - 1] != 93) continue;
            zoneId = new String(buf, j + 1, endIndex - j - 2);
            endIndex = j;
            break;
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, null);
        Object zoneObject = zoneId == null ? TemporalAloneInvoker.getDefaultZoneId() : TemporalAloneInvoker.ofZoneId(zoneId);
        return TemporalAloneInvoker.ofZonedDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
    }

    private Object autoMatchZoneDateTime(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        int len = endIndex - fromIndex - 1;
        if (len == 19) {
            GeneralDate generalDate = GeneralDate.parseGeneralDate_Standard_19(buf, fromIndex + 1, null);
            Object zoneObject = TemporalAloneInvoker.getDefaultZoneId();
            return TemporalAloneInvoker.ofZonedDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
        }
        return TemporalAloneInvoker.parseZonedDateTime(new String(buf, fromIndex + 1, endIndex - fromIndex - 1));
    }

    private Object autoMatchZoneDateTime(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        int len = endIndex - fromIndex - 1;
        if (len == 19) {
            GeneralDate generalDate = GeneralDate.parseGeneralDate_Standard_19(buf, fromIndex + 1, null);
            Object zoneObject = TemporalAloneInvoker.getDefaultZoneId();
            return TemporalAloneInvoker.ofZonedDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
        }
        return TemporalAloneInvoker.parseZonedDateTime(new String(buf, fromIndex + 1, endIndex - fromIndex - 1));
    }
}

