/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.log;

import io.github.wycst.wast.log.ConsoleFormatter;
import io.github.wycst.wast.log.ConsoleHandler;
import io.github.wycst.wast.log.FileHandlerHolder;
import io.github.wycst.wast.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerManagerHandler {
    private static final Map<String, String> properties = new HashMap<String, String>();
    private static final String LEVEL_KEY = "logger.level";
    private static Level level;
    private static Map<String, FileHandlerHolder> fileHandlerHolders;
    private static Map<String, Level> levelMap;
    private static ConsoleHandler consoleHandler;
    private static final Map<String, String> loggerProperties;
    private static String consolePackages;

    static void init() {
        InputStream is = LogFactory.class.getResourceAsStream("/logging.properties");
        if (is != null) {
            Properties properties = new Properties();
            try {
                properties.load(is);
                LoggerManagerHandler.parseLoggerHandlers(properties);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void parseLoggerHandlers(Properties properties) {
        String loggerFileHandlers;
        consolePackages = properties.getProperty("logger.console.packages");
        consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new ConsoleFormatter());
        Level consoleLevel = LoggerManagerHandler.getLevelProperty(properties, "logger.console.level", null);
        if (consoleLevel != null) {
            consoleHandler.setLevel(consoleLevel);
        }
        if ((loggerFileHandlers = properties.getProperty("logger.file.handlers")) != null) {
            String[] fileHandleNames = loggerFileHandlers.split(",");
            for (String fileHandleName : new HashSet<String>(Arrays.asList(fileHandleNames))) {
                String handlerPackages = properties.getProperty("logger.handler." + fileHandleName + ".packages");
                String handlerPattern = properties.getProperty("logger.handler." + fileHandleName + ".pattern");
                int limit = LoggerManagerHandler.getIntProperty(properties, "logger.handler." + fileHandleName + ".limit", Integer.MAX_VALUE);
                int count = LoggerManagerHandler.getIntProperty(properties, "logger.handler." + fileHandleName + ".count", 1);
                Level level = LoggerManagerHandler.getLevelProperty(properties, "logger.handler." + fileHandleName + ".level", null);
                if (handlerPattern == null) continue;
                try {
                    FileHandlerHolder fileHandlerHolder = new FileHandlerHolder(fileHandleName, handlerPattern, limit, count);
                    if (level != null) {
                        fileHandlerHolder.setLevel(level);
                    }
                    fileHandlerHolder.setPackages(handlerPackages);
                    fileHandlerHolders.put(fileHandleName, fileHandlerHolder);
                }
                catch (IOException iOException) {}
            }
        }
        for (String key : properties.stringPropertyNames()) {
            if (!key.endsWith(".level")) continue;
            String customPackageLevel = key.substring(0, key.length() - 6);
            Level level = LoggerManagerHandler.getLevelProperty(properties, key, null);
            if (level == null) continue;
            levelMap.put(customPackageLevel, level);
        }
    }

    static List<Handler> matchHandlers(Class<?> logCls) {
        ArrayList<Handler> fileHandlers = new ArrayList<Handler>();
        String logClassName = logCls.getName();
        if (LoggerManagerHandler.matchPackages(logClassName, consolePackages)) {
            fileHandlers.add(consoleHandler);
        }
        for (FileHandlerHolder fileHandlerHolder : fileHandlerHolders.values()) {
            FileHandler fileHandler = fileHandlerHolder.getFileHandler();
            String packages = fileHandlerHolder.getPackages();
            if (!LoggerManagerHandler.matchPackages(logClassName, packages)) continue;
            fileHandlers.add(fileHandler);
        }
        return fileHandlers;
    }

    static Level matchLevel(Class<?> logCls) {
        String logClassName = logCls.getName();
        for (String pk : levelMap.keySet()) {
            if (!logClassName.startsWith(pk) && !logClassName.matches(pk)) continue;
            return levelMap.get(pk);
        }
        return null;
    }

    private static boolean matchPackages(String logClassName, String packages) {
        String[] pcks;
        if (packages == null || packages.length() == 0) {
            return true;
        }
        for (String pck : pcks = packages.split(",")) {
            if (!logClassName.startsWith(pck)) continue;
            return true;
        }
        return false;
    }

    private static Level getLevelProperty(Properties properties, String levelKey, Level level) {
        String levelName = properties.getProperty(levelKey);
        if (levelName == null || levelName.length() == 0) {
            return level;
        }
        return Level.parse(levelName);
    }

    private static int getIntProperty(Properties properties, String key, int i) {
        try {
            return Integer.parseInt(properties.getProperty(key));
        }
        catch (Throwable throwable) {
            return i;
        }
    }

    public static void putAll(Map<String, String> logProps) {
        if (logProps != null) {
            properties.putAll(logProps);
        }
    }

    static Set<String> logKeySet() {
        return properties.keySet();
    }

    static void putLogProperty(String key, String value) {
        properties.put(key, value);
    }

    static String getLogProperty(String key) {
        return properties.get(key);
    }

    public static void clear() {
        properties.clear();
        levelMap.clear();
        for (FileHandlerHolder handlerHolder : fileHandlerHolders.values()) {
            handlerHolder.clear();
        }
        fileHandlerHolders.clear();
    }

    public static Level getLogLevel() {
        String levelName = properties.get(LEVEL_KEY);
        if (levelName == null) {
            return null;
        }
        if (level != null && levelName.equals(level.getName())) {
            return level;
        }
        try {
            level = Level.parse(levelName);
            return level;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    static {
        fileHandlerHolders = new ConcurrentHashMap<String, FileHandlerHolder>();
        levelMap = new HashMap<String, Level>();
        loggerProperties = new HashMap<String, String>();
    }
}

