/*
 * Decompiled with CFR 0.152.
 */
package com.billy.cc.core.component;

import a.b;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Log;
import com.billy.cc.core.component.CCMonitor;
import com.billy.cc.core.component.CCResult;
import com.billy.cc.core.component.CCUtil;
import com.billy.cc.core.component.ComponentManager;
import com.billy.cc.core.component.GlobalCCInterceptorManager;
import com.billy.cc.core.component.ICCInterceptor;
import com.billy.cc.core.component.IComponentCallback;
import com.billy.cc.core.component.IDynamicComponent;
import com.billy.cc.core.component.IGlobalCCInterceptor;
import com.billy.cc.core.component.RemoteCCInterceptor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

@SuppressLint(value={"PrivateApi"})
public class CC {
    private static final String TAG = "ComponentCaller";
    private static final String VERBOSE_TAG = "ComponentCaller_VERBOSE";
    public static final String CC_NULL_KEY = "CC_NULL_KEY";
    private static final long DEFAULT_TIMEOUT = 2000L;
    public static boolean DEBUG = false;
    public static boolean VERBOSE_LOG = false;
    private static boolean REMOTE_CC_ENABLED = false;
    private static Application application;
    private static final b<Builder, String> BUILDER_POOL;
    private static String prefix;
    private static AtomicInteger index;
    private volatile CCResult result;
    private final byte[] wait4resultLock = new byte[0];
    public WeakReference<Activity> cancelOnDestroyActivity;
    public WeakReference<Fragment> cancelOnDestroyFragment;
    private volatile boolean waiting;
    private WeakReference<Context> context;
    private String componentName;
    private String actionName;
    private final Map<String, Object> params = new HashMap<String, Object>();
    private IComponentCallback callback;
    private boolean async;
    private final List<ICCInterceptor> interceptors = new ArrayList<ICCInterceptor>();
    private boolean callbackOnMainThread;
    private long timeout = -1L;
    public long timeoutAt;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private String callId;
    private volatile boolean canceled = false;
    private volatile boolean timeoutStatus = false;
    private boolean withoutGlobalInterceptor = false;

    public static synchronized void init(Application application) {
        CC.init(application, false, false);
    }

    public static synchronized void init(Application application, boolean bl, boolean bl2) {
        if (CC.application == null && application != null) {
            CC.application = application;
            if (Build.VERSION.SDK_INT >= 14) {
                CC.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new CCMonitor.ActivityMonitor());
            }
        }
        if (bl) {
            ComponentManager.init();
        }
        if (bl2) {
            GlobalCCInterceptorManager.init();
        }
    }

    private CC(String string) {
        this.componentName = string;
    }

    public static Builder obtainBuilder(String string) {
        return BUILDER_POOL.get(string);
    }

    public static Application getApplication() {
        return application;
    }

    private String processCallAsync(IComponentCallback iComponentCallback) {
        if (iComponentCallback != null) {
            this.callback = iComponentCallback;
        }
        this.async = true;
        if (this.timeout < 0L) {
            this.timeout = 0L;
        }
        CC cC = this;
        cC.setTimeoutAt();
        cC.callId = cC.nextCallId();
        cC.canceled = false;
        cC.timeoutStatus = false;
        if (VERBOSE_LOG) {
            CC.verboseLog(this.callId, "start to callAsync:" + this, new Object[0]);
        }
        CC cC2 = this;
        ComponentManager.call(cC2);
        return cC2.callId;
    }

    private void setTimeoutAt() {
        this.timeoutAt = this.timeout > 0L ? SystemClock.elapsedRealtime() + this.timeout : 0L;
    }

    private boolean markFinished() {
        return this.finished.compareAndSet(false, true);
    }

    public static void cancel(String object) {
        String string = object;
        CC.verboseLog(string, "call CC.cancel()", new Object[0]);
        object = CCMonitor.getById(string);
        if (object != null) {
            ((CC)object).cancel();
        }
    }

    public static void timeout(String object) {
        String string = object;
        CC.verboseLog(string, "call CC.cancel()", new Object[0]);
        object = CCMonitor.getById(string);
        if (object != null) {
            ((CC)object).timeout();
        }
    }

    public static void sendCCResult(String string, CCResult cCResult) {
        CC cC;
        if (VERBOSE_LOG) {
            CC.verboseLog(string, "CCResult received by CC.sendCCResult(...).CCResult:" + cCResult, new Object[0]);
        }
        if ((cC = CCMonitor.getById(string)) != null) {
            if (cC.markFinished()) {
                if (cCResult == null) {
                    cCResult = CCResult.defaultNullResult();
                    CC.logError("CC.sendCCResult called, But ccResult is null, set it to CCResult.defaultNullResult(). ComponentName=" + cC.getComponentName(), new Object[0]);
                }
                cC.setResult4Waiting(cCResult);
            } else {
                CC.logError("CC.sendCCResult called, But ccResult is null. ComponentName=" + cC.getComponentName(), new Object[0]);
            }
        } else {
            CC.log("CCResult received, but cannot found callId:" + string, new Object[0]);
        }
    }

    @Deprecated
    public static void invokeCallback(String string, CCResult cCResult) {
        CC.sendCCResult(string, cCResult);
    }

    public static boolean hasComponent(String string) {
        return ComponentManager.hasComponent(string);
    }

    public static void registerComponent(IDynamicComponent iDynamicComponent) {
        if (iDynamicComponent == null) {
            return;
        }
        ComponentManager.registerComponent(iDynamicComponent);
        String string = CCUtil.getCurProcessName();
        if (!CC.isMainProcess()) {
            CC.obtainBuilder("internal.cc.dynamicComponentOption").setActionName("registerDynamicComponent").addParam("componentName", iDynamicComponent.getName()).addParam("processName", string).build().callAsync();
        }
    }

    public static void unregisterComponent(IDynamicComponent iDynamicComponent) {
        if (iDynamicComponent == null) {
            return;
        }
        ComponentManager.unregisterComponent(iDynamicComponent);
        if (!CC.isMainProcess()) {
            CC.obtainBuilder("internal.cc.dynamicComponentOption").setActionName("unregisterDynamicComponent").addParam("componentName", iDynamicComponent.getName()).build().callAsync();
        }
    }

    public static void registerGlobalInterceptor(IGlobalCCInterceptor iGlobalCCInterceptor) {
        GlobalCCInterceptorManager.registerGlobalInterceptor(iGlobalCCInterceptor);
    }

    public static void unregisterGlobalInterceptor(Class<? extends IGlobalCCInterceptor> clazz) {
        GlobalCCInterceptorManager.unregisterGlobalInterceptor(clazz);
    }

    private String nextCallId() {
        if (!TextUtils.isEmpty((CharSequence)((CC)((Object)string)).callId)) {
            return ((CC)((Object)string)).callId;
        }
        if (TextUtils.isEmpty((CharSequence)prefix)) {
            String string = CCUtil.getCurProcessName();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                prefix = (String)string + ":";
            } else {
                return ":::" + index.getAndIncrement();
            }
        }
        return prefix + index.getAndIncrement();
    }

    public static void verboseLog(String string, String string2, Object ... objectArray) {
        if (VERBOSE_LOG) {
            Log.i((String)VERBOSE_TAG, (String)("(" + CCUtil.getCurProcessName() + ")(" + Thread.currentThread().getName() + ")" + string + " >>>> " + CC.format(string2, objectArray)));
        }
    }

    public static void log(String string, Object ... objectArray) {
        if (DEBUG) {
            Log.i((String)TAG, (String)CC.format(string, objectArray));
        }
    }

    public static void logError(String string, Object ... objectArray) {
        if (DEBUG) {
            Log.e((String)TAG, (String)CC.format(string, objectArray));
        }
    }

    private static String format(String string, Object ... objectArray) {
        block4: {
            if (objectArray != null) {
                if (objectArray.length <= 0) break block4;
                try {
                    string = String.format(string, objectArray);
                }
                catch (Exception exception) {
                    CCUtil.printStackTrace(exception);
                }
            }
        }
        return string;
    }

    public static void enableVerboseLog(boolean bl) {
        VERBOSE_LOG = bl;
    }

    public static void enableDebug(boolean bl) {
        DEBUG = bl;
    }

    public static void enableRemoteCC(boolean bl) {
        REMOTE_CC_ENABLED = bl;
        if (REMOTE_CC_ENABLED && application != null) {
            RemoteCCInterceptor.getInstance().enableRemoteCC();
        }
    }

    public static boolean isRemoteCCEnabled() {
        return REMOTE_CC_ENABLED;
    }

    public static boolean isMainProcess() {
        return CCUtil.isMainProcess();
    }

    public static boolean isDebugMode() {
        return DEBUG;
    }

    public static /* synthetic */ WeakReference access$102(CC cC, WeakReference weakReference) {
        cC.context = weakReference;
        return weakReference;
    }

    public static /* synthetic */ long access$202(CC cC, long l2) {
        cC.timeout = l2;
        return l2;
    }

    public static /* synthetic */ String access$302(CC cC, String string) {
        cC.actionName = string;
        return string;
    }

    public static /* synthetic */ boolean access$402(CC cC, boolean bl) {
        cC.withoutGlobalInterceptor = bl;
        return bl;
    }

    public static /* synthetic */ String access$702(CC cC, String string) {
        cC.callId = string;
        return string;
    }

    public /* synthetic */ CC(String string, 1 var2_2) {
        this(string);
    }

    static {
        Application application = CCUtil.initApplication();
        if (application != null) {
            CC.init(application);
        }
        BUILDER_POOL = new b<Builder, String>(){

            @Override
            public Builder newInstance(String string) {
                return new Builder(null);
            }
        };
        index = new AtomicInteger(1);
    }

    public String toString() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        CCUtil.put(jSONObject2, "callId", this.callId);
        CCUtil.put(jSONObject2, "context", this.getContext());
        CCUtil.put(jSONObject2, "componentName", this.componentName);
        CCUtil.put(jSONObject2, "actionName", this.actionName);
        CCUtil.put(jSONObject2, "timeout", this.timeout);
        CCUtil.put(jSONObject2, "withoutGlobalInterceptor", this.withoutGlobalInterceptor);
        CCUtil.put(jSONObject2, "callbackOnMainThread", this.callbackOnMainThread);
        CCUtil.put(jSONObject2, "params", CCUtil.convertToJson(this.params));
        CCUtil.put(jSONObject2, "interceptors", this.interceptors);
        CCUtil.put(jSONObject, "callback", this.getCallback());
        return jSONObject.toString();
    }

    public Context getContext() {
        WeakReference<Context> weakReference = ((CC)((Object)weakReference)).context;
        if (weakReference != null && (weakReference = (Context)weakReference.get()) != null) {
            return weakReference;
        }
        return application;
    }

    public void forwardTo(String string) {
        this.componentName = string;
    }

    public String getActionName() {
        return this.actionName;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public <T> T getParamItemWithNoKey(T t2) {
        return this.getParamItem(CC_NULL_KEY, t2);
    }

    public <T> T getParamItemWithNoKey() {
        return this.getParamItem(CC_NULL_KEY);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getParamItem(String string, T t2) {
        void var1_2;
        T t3 = this.getParamItem((String)var1_2);
        if (t3 == null) {
            void var2_3;
            return var2_3;
        }
        return t3;
    }

    public <T> T getParamItem(String string) {
        try {
            return (T)this.params.get(string);
        }
        catch (Exception exception) {
            CCUtil.printStackTrace(exception);
            return null;
        }
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isCallbackOnMainThread() {
        return this.callbackOnMainThread;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getCallId() {
        return this.callId;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isStopped() {
        return this.canceled || this.timeoutStatus;
    }

    public boolean isTimeout() {
        return this.timeoutStatus;
    }

    public boolean isWithoutGlobalInterceptor() {
        return this.withoutGlobalInterceptor;
    }

    public CCResult getResult() {
        return this.result;
    }

    public void setResult(CCResult cCResult) {
        this.finished.set(true);
        this.result = cCResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setResult4Waiting(CCResult cCResult) {
        byte[] byArray = this.wait4resultLock;
        try {
            if (VERBOSE_LOG) {
                CC cC = this;
                String string = cC.callId;
                StringBuilder stringBuilder = new StringBuilder().append("setResult");
                String string2 = cC.waiting ? "4Waiting" : "";
                CC.verboseLog(string, stringBuilder.append(string2).append(". CCResult:").append(cCResult).toString(), new Object[0]);
            }
            CC cC = this;
            cC.setResult(cCResult);
            if (cC.waiting) {
                this.waiting = false;
                this.wait4resultLock.notifyAll();
            }
            // MONITOREXIT : byArray
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : byArray
            try {
                throw throwable;
            }
            catch (Exception exception) {
                CCUtil.printStackTrace(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait4Result() {
        CC cC = this;
        byte[] byArray = cC.wait4resultLock;
        synchronized (cC.wait4resultLock) {
            block6: {
                if (cC.isFinished()) break block6;
                try {
                    CC cC2 = this;
                    CC.verboseLog(cC2.callId, "start waiting for CC.sendCCResult(...)", new Object[0]);
                    cC2.waiting = true;
                    cC2.wait4resultLock.wait();
                    CC.verboseLog(cC2.callId, "end waiting for CC.sendCCResult(...)", new Object[0]);
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public IComponentCallback getCallback() {
        return this.callback;
    }

    public void cancelOnDestroy(Object object) {
        if (!this.isFinished()) {
            if (VERBOSE_LOG) {
                CC.verboseLog(this.callId, "call cancel on " + object + " destroyed", new Object[0]);
            }
            this.cancel();
        }
    }

    public void addCancelOnFragmentDestroyIfSet() {
        Object object = this.cancelOnDestroyFragment;
        if (object == null) {
            return;
        }
        if ((object = (Fragment)object.get()) == null) {
            return;
        }
        if ((object = object.getFragmentManager()) != null) {
            CCMonitor.FragmentMonitor fragmentMonitor;
            Fragment fragment = object;
            object = fragmentMonitor;
            fragmentMonitor = new CCMonitor.FragmentMonitor(this);
            fragment.registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)object, false);
        }
    }

    public String getComponentName() {
        return this.componentName;
    }

    public List<ICCInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public String callAsync() {
        return this.callAsync(null);
    }

    public String callAsync(IComponentCallback iComponentCallback) {
        this.callbackOnMainThread = false;
        return this.processCallAsync(iComponentCallback);
    }

    public String callAsyncCallbackOnMainThread(IComponentCallback iComponentCallback) {
        this.callbackOnMainThread = true;
        return this.processCallAsync(iComponentCallback);
    }

    public CCResult call() {
        this.callback = null;
        this.async = false;
        if (this.timeout == 0L && Looper.getMainLooper() == Looper.myLooper() || this.timeout < 0L) {
            this.timeout = 2000L;
        }
        CC cC = this;
        cC.setTimeoutAt();
        cC.callId = cC.nextCallId();
        cC.canceled = false;
        cC.timeoutStatus = false;
        if (VERBOSE_LOG) {
            CC.verboseLog(this.callId, "start to call:" + this, new Object[0]);
        }
        return ComponentManager.call(this);
    }

    public void cancel() {
        if (this.markFinished()) {
            CC cC = this;
            cC.canceled = true;
            cC.setResult4Waiting(CCResult.error(-8));
            CC.verboseLog(cC.callId, "call cancel()", new Object[0]);
        } else {
            CC.verboseLog(this.callId, "call cancel(). but this cc is already finished", new Object[0]);
        }
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public void timeout() {
        if (this.markFinished()) {
            CC cC = this;
            cC.timeoutStatus = true;
            cC.setResult4Waiting(CCResult.error(-9));
            CC.verboseLog(cC.callId, "timeout", new Object[0]);
        } else {
            CC.verboseLog(this.callId, "call timeout(). but this cc is already finished", new Object[0]);
        }
    }

    public boolean resultRequired() {
        return !this.async || this.callback != null;
    }

    public static class Builder
    implements b.b,
    b.a<String> {
        private CC cr;

        private Builder() {
        }

        public /* synthetic */ Builder(1 var1_1) {
            this();
        }

        public Builder setContext(Context context) {
            if (context != null) {
                CC.access$102(this.cr, new WeakReference<Context>(context));
            }
            return this;
        }

        public Builder setNoTimeout() {
            return this.setTimeout(0L);
        }

        public Builder setTimeout(long l2) {
            if (l2 >= 0L) {
                CC.access$202(this.cr, l2);
            } else {
                CC.logError("Invalid timeout value:" + l2 + ", timeout should >= 0. timeout will be set as default:" + 2000L, new Object[0]);
            }
            return this;
        }

        public Builder setActionName(String string) {
            Builder builder = this;
            CC.access$302(builder.cr, string);
            return builder;
        }

        public Builder withoutGlobalInterceptor() {
            Builder builder = this;
            CC.access$402(builder.cr, true);
            return builder;
        }

        public Builder setParams(Map<String, Object> map) {
            this.cr.params.clear();
            return this.addParams(map);
        }

        public Builder setParamWithNoKey(Object object) {
            return this.addParam(CC.CC_NULL_KEY, object);
        }

        public Builder addParams(Map<String, Object> map) {
            if (map != null) {
                for (String string : map.keySet()) {
                    this.addParam(string, map.get(string));
                }
            }
            return this;
        }

        public Builder addParam(String string, Object object) {
            Builder builder = this;
            builder.cr.params.put(string, object);
            return builder;
        }

        public Builder addInterceptor(ICCInterceptor iCCInterceptor) {
            if (iCCInterceptor != null) {
                this.cr.interceptors.add(iCCInterceptor);
            }
            return this;
        }

        public Builder cancelOnDestroyWith(Activity activity) {
            if (activity != null) {
                this.cr.cancelOnDestroyActivity = new WeakReference<Activity>(activity);
            }
            return this;
        }

        public Builder cancelOnDestroyWith(Fragment fragment) {
            if (fragment != null) {
                this.cr.cancelOnDestroyFragment = new WeakReference<Fragment>(fragment);
            }
            return this;
        }

        public Builder setCallId(String string) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                CC.access$702(this.cr, string);
            }
            return this;
        }

        public CC build() {
            CC cC = this.cr;
            BUILDER_POOL.put(this);
            if (TextUtils.isEmpty((CharSequence)cC.componentName)) {
                CC.logError("ComponentName is empty:" + cC.toString(), new Object[0]);
            }
            return cC;
        }

        @Override
        public void reset() {
            this.cr = null;
        }

        @Override
        public void init(String string) {
            CC cC;
            Builder builder = cC2;
            CC cC2 = cC;
            cC = new CC(string, null);
            builder.cr = cC2;
        }
    }
}

