/*
 * Decompiled with CFR 0.152.
 */
package com.billy.cc.core.component;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCResult;
import com.billy.cc.core.component.CCUtil;
import com.billy.cc.core.component.Chain;
import com.billy.cc.core.component.ChainProcessor;
import com.billy.cc.core.component.GlobalCCInterceptorManager;
import com.billy.cc.core.component.IComponent;
import com.billy.cc.core.component.IDynamicComponent;
import com.billy.cc.core.component.ValidateInterceptor;
import com.billy.cc.core.component.annotation.AllProcess;
import com.billy.cc.core.component.annotation.SubProcess;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class ComponentManager {
    private static final ConcurrentHashMap<String, IComponent> COMPONENTS;
    private static final ConcurrentHashMap<String, String> COMPONENT_PROCESS_NAMES;
    private static final String SUB_PROCESS_SEPARATOR = ":";
    private static final ThreadFactory THREAD_FACTORY;
    public static final ExecutorService CC_THREAD_POOL;
    public static final Handler MAIN_THREAD_HANDLER;
    public static final String COMPONENT_DYNAMIC_COMPONENT_OPTION = "internal.cc.dynamicComponentOption";
    public static final String ACTION_REGISTER = "registerDynamicComponent";
    public static final String ACTION_UNREGISTER = "unregisterDynamicComponent";
    public static final String ACTION_GET_PROCESS_NAME = "getDynamicComponentProcessName";
    public static final String KEY_COMPONENT_NAME = "componentName";
    public static final String KEY_PROCESS_NAME = "processName";

    public static void init() {
    }

    /*
     * Unable to fully structure code
     */
    public static void registerComponent(IComponent var0) {
        block9: {
            block10: {
                if (var0 == null) break block9;
                var1_1 = var0.getName();
                if (!TextUtils.isEmpty((CharSequence)var1_1)) ** GOTO lbl9
                CC.logError("component " + var0.getClass().getName() + " register with an empty name. abort this component.", new Object[0]);
                break block9;
lbl9:
                // 1 sources

                var2_2 = ComponentManager.getComponentProcessName(var0.getClass());
                ComponentManager.COMPONENT_PROCESS_NAMES.put(var1_1, (String)var2_2);
                if (var2_2.equals(CCUtil.getCurProcessName())) break block10;
                return;
            }
            var2_2 = ComponentManager.COMPONENTS.put(var1_1, var0);
            if (var2_2 == null) ** GOTO lbl23
            CC.logError("component (" + var0.getClass().getName() + ") with name:" + var1_1 + " has already exists, replaced:" + var2_2.getClass().getName(), new Object[0]);
            break block9;
lbl23:
            // 1 sources

            if (!CC.DEBUG) break block9;
            try {
                CC.log("register component success! component name = '" + var1_1 + "', class = " + var0.getClass().getName(), new Object[0]);
            }
            catch (Exception v0) {
                CCUtil.printStackTrace(v0);
            }
        }
    }

    private static String getComponentProcessName(Class<? extends IComponent> object) {
        if (IDynamicComponent.class.isAssignableFrom((Class<?>)object)) {
            return CCUtil.getCurProcessName();
        }
        Object object2 = CC.getApplication().getPackageName();
        if (((Class)object).getAnnotation(AllProcess.class) != null) {
            return CCUtil.getCurProcessName();
        }
        if ((object = ((Class)object).getAnnotation(SubProcess.class)) != null && !TextUtils.isEmpty((CharSequence)(object = object.value()))) {
            object2 = ((String)object).startsWith(SUB_PROCESS_SEPARATOR) ? (String)object2 + (String)object : object;
        }
        return object2;
    }

    public static void unregisterComponent(IComponent object) {
        if (object != null && ComponentManager.hasComponent((String)(object = object.getName()))) {
            COMPONENTS.remove(object);
        }
    }

    public static boolean hasComponent(String string) {
        return ComponentManager.getComponentByName(string) != null;
    }

    public static CCResult call(CC object) {
        ChainProcessor chainProcessor;
        Chain chain;
        CC cC = object;
        String string = cC.getCallId();
        Chain chain2 = chain;
        chain = new Chain((CC)object);
        if (!cC.isWithoutGlobalInterceptor()) {
            chain2.addInterceptors(GlobalCCInterceptorManager.INTERCEPTORS);
        }
        CC cC2 = object;
        Chain chain3 = chain2;
        chain3.addInterceptors(((CC)object).getInterceptors());
        chain3.addInterceptor(ValidateInterceptor.getInstance());
        object = chainProcessor;
        chainProcessor = new ChainProcessor(chain2);
        if (cC2.isAsync()) {
            if (CC.VERBOSE_LOG) {
                CC.verboseLog(string, "put into thread pool", new Object[0]);
            }
            CC_THREAD_POOL.submit(object);
            return null;
        }
        try {
            object = ((ChainProcessor)object).call();
        }
        catch (Exception exception) {
            object = CCResult.defaultExceptionResult(exception);
        }
        if (CC.VERBOSE_LOG) {
            CC.verboseLog(string, "cc finished.CCResult:" + object, new Object[0]);
        }
        return object;
    }

    public static IComponent getComponentByName(String string) {
        return COMPONENTS.get(string);
    }

    public static void mainThread(Runnable runnable) {
        MAIN_THREAD_HANDLER.post(runnable);
    }

    public static void threadPool(Runnable runnable) {
        if (runnable != null) {
            CC_THREAD_POOL.execute(runnable);
        }
    }

    public static String getComponentProcessName(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = COMPONENT_PROCESS_NAMES.get(string);
        if (TextUtils.isEmpty((CharSequence)string2) && !CCUtil.isMainProcess()) {
            string2 = CC.obtainBuilder(COMPONENT_DYNAMIC_COMPONENT_OPTION).setActionName(ACTION_GET_PROCESS_NAME).addParam(KEY_COMPONENT_NAME, string).build().call().getDataItem(KEY_PROCESS_NAME, null);
        }
        return string2;
    }

    static {
        SynchronousQueue<Runnable> synchronousQueue;
        ThreadFactory threadFactory;
        COMPONENTS = new ConcurrentHashMap();
        COMPONENT_PROCESS_NAMES = new ConcurrentHashMap();
        ThreadFactory threadFactory2 = threadFactory;
        THREAD_FACTORY = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread;
                Thread thread2 = thread;
                new Thread(runnable).setName("cc-pool-" + thread2.getId());
                return thread2;
            }
        };
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        CC_THREAD_POOL = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue2, threadFactory2);
        MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper());
        ComponentManager.registerComponent(new DynamicComponentOption());
    }

    public static class DynamicComponentOption
    implements IComponent {
        @Override
        public String getName() {
            return ComponentManager.COMPONENT_DYNAMIC_COMPONENT_OPTION;
        }

        @Override
        public boolean onCall(CC cC) {
            Object object = cC.getActionName();
            CC cC2 = cC;
            String string = cC2.getParamItem(ComponentManager.KEY_COMPONENT_NAME, null);
            String string2 = cC2.getParamItem(ComponentManager.KEY_PROCESS_NAME, null);
            object.getClass();
            int n2 = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 1851992582: {
                    if (!((String)object).equals(ComponentManager.ACTION_GET_PROCESS_NAME)) break;
                    n2 = 2;
                    break;
                }
                case 1176993857: {
                    if (!((String)object).equals(ComponentManager.ACTION_REGISTER)) break;
                    n2 = 1;
                    break;
                }
                case -348417062: {
                    if (!((String)object).equals(ComponentManager.ACTION_UNREGISTER)) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    CC.sendCCResult(cC.getCallId(), CCResult.error("unsupported action:" + (String)object));
                    break;
                }
                case 2: {
                    object = (String)COMPONENT_PROCESS_NAMES.get(string);
                    CC.sendCCResult(cC.getCallId(), CCResult.success(ComponentManager.KEY_PROCESS_NAME, object));
                    break;
                }
                case 1: {
                    COMPONENT_PROCESS_NAMES.put(string, string2);
                    CC.sendCCResult(cC.getCallId(), CCResult.success());
                    break;
                }
                case 0: {
                    COMPONENT_PROCESS_NAMES.remove(string);
                    CC.sendCCResult(cC.getCallId(), CCResult.success());
                }
            }
            return false;
        }
    }
}

