/*
 * Decompiled with CFR 0.152.
 */
package com.billy.cc.core.component;

import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCResult;
import com.billy.cc.core.component.CCUtil;
import com.billy.cc.core.component.Chain;
import com.billy.cc.core.component.ComponentManager;
import com.billy.cc.core.component.ICCInterceptor;
import com.billy.cc.core.component.RemoteCCService;
import com.billy.cc.core.component.remote.IRemoteCCService;
import com.billy.cc.core.component.remote.IRemoteCallback;
import com.billy.cc.core.component.remote.RemoteCC;
import com.billy.cc.core.component.remote.RemoteCCResult;
import java.util.concurrent.ConcurrentHashMap;

class SubProcessCCInterceptor
implements ICCInterceptor {
    private static final ConcurrentHashMap<String, IRemoteCCService> CONNECTIONS = new ConcurrentHashMap();

    public static SubProcessCCInterceptor getInstance() {
        return SubProcessCCInterceptorHolder.INSTANCE;
    }

    @Override
    public CCResult intercept(Chain chain) {
        Chain chain2 = chain;
        return this.multiProcessCall(chain2, ComponentManager.getComponentProcessName(chain2.getCC().getComponentName()), CONNECTIONS);
    }

    public CCResult multiProcessCall(Chain chain, String string, ConcurrentHashMap<String, IRemoteCCService> concurrentHashMap) {
        ProcessCrossTask processCrossTask;
        if (string == null) {
            return CCResult.error(-5);
        }
        CC cC = chain.getCC();
        boolean bl = !cC.isAsync() && Looper.getMainLooper() == Looper.myLooper();
        ProcessCrossTask processCrossTask2 = processCrossTask;
        ComponentManager.threadPool(new ProcessCrossTask(cC, string, concurrentHashMap, bl));
        if (!cC.isFinished()) {
            chain.proceed();
            if (cC.isCanceled()) {
                processCrossTask2.cancel();
            } else if (cC.isTimeout()) {
                processCrossTask2.timeout();
            }
        }
        return cC.getResult();
    }

    public IRemoteCCService getMultiProcessService(String string) {
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = string;
        CC.log("start to get RemoteService from process %s", object);
        object = RemoteCCService.get(string);
        String string2 = "get RemoteService from process %s %s!";
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string;
        int n2 = 1;
        String string3 = object != null ? "success" : "failed";
        objectArray3[n2] = string3;
        CC.log(string2, objectArray3);
        return object;
    }

    public class ProcessCrossTask
    implements Runnable {
        private final CC cc;
        private final String processName;
        private final ConcurrentHashMap<String, IRemoteCCService> connectionCache;
        private final boolean isMainThreadSyncCall;
        private IRemoteCCService service;

        public ProcessCrossTask(CC cC, String string, ConcurrentHashMap<String, IRemoteCCService> concurrentHashMap, boolean bl) {
            this.cc = cC;
            this.processName = string;
            this.connectionCache = concurrentHashMap;
            this.isMainThreadSyncCall = bl;
        }

        /*
         * Unable to fully structure code
         */
        private void call(RemoteCC var1_1) {
            block17: {
                v0 = this.connectionCache.get(this.processName);
                this.service = v0;
                if (v0 == null) {
                    var2_2 = SubProcessCCInterceptor.this.getMultiProcessService(this.processName);
                    this.service = var2_2;
                    if (var2_2 == null) break block17;
                    this.connectionCache.put(this.processName, var2_2);
                }
            }
            if (!this.cc.isFinished()) ** GOTO lbl26
            v1 = this.cc.getCallId();
            v2 = "cc is finished before call %s process";
            v3 = new Object[1];
            var2_3 = 0;
            v3[var2_3] = this.processName;
            CC.verboseLog(v1, v2, v3);
            return;
lbl26:
            // 1 sources

            if (this.service != null) ** GOTO lbl39
            v4 = this;
            v5 = v4;
            v6 = v4.cc.getCallId();
            v7 = "RemoteService is not found for process: %s";
            v8 = new Object[1];
            var2_4 = 0;
            v8[var2_4] = this.processName;
            CC.verboseLog(v6, v7, v8);
            v5.setResult(CCResult.error(-5));
            return;
lbl39:
            // 1 sources

            if (!CC.VERBOSE_LOG) ** GOTO lbl51
            v9 = this.cc.getCallId();
            v10 = "start to call process:%s, RemoteCC: %s";
            v11 = new Object[2];
            var2_5 = 0;
            v11[var2_5] = this.processName;
            var2_5 = 1;
            v11[var2_5] = var1_1.toString();
            CC.verboseLog(v9, v10, v11);
lbl51:
            // 2 sources

            v12 = this.service;
            v13 = var1_1;
            var2_6 = v14;
            try {
                v14 = new IRemoteCallback.Stub(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void callback(RemoteCCResult remoteCCResult) throws RemoteException {
                        try {
                            if (CC.VERBOSE_LOG) {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = ProcessCrossTask.this.processName;
                                int n2 = 1;
                                objectArray[n2] = remoteCCResult.toString();
                                CC.verboseLog(ProcessCrossTask.this.cc.getCallId(), "receive RemoteCCResult from process:%s, RemoteCCResult: %s", objectArray);
                            }
                            ProcessCrossTask.this.setResult(remoteCCResult.toCCResult());
                            return;
                        }
                        catch (Exception exception) {
                            CCUtil.printStackTrace(exception);
                            ProcessCrossTask.this.setResult(CCResult.error(-11));
                        }
                    }
                };
                v12.call(v13, var2_6);
            }
            catch (Exception v15) {
                CCUtil.printStackTrace(v15);
                this.setResult(CCResult.error(-11));
            }
            catch (DeadObjectException v16) {
                v17 = this;
                RemoteCCService.remove(v17.processName);
                v17.connectionCache.remove(this.processName);
                this.call(var1_1);
            }
        }

        @Override
        public void run() {
            RemoteCC remoteCC;
            ProcessCrossTask processCrossTask = cC;
            RemoteCC remoteCC2 = remoteCC;
            ProcessCrossTask processCrossTask2 = cC;
            CC cC = processCrossTask2.cc;
            remoteCC = new RemoteCC(cC, processCrossTask2.isMainThreadSyncCall);
            processCrossTask.call(remoteCC2);
        }

        public void setResult(CCResult cCResult) {
            this.cc.setResult4Waiting(cCResult);
        }

        public void cancel() {
            try {
                this.service.cancel(this.cc.getCallId());
            }
            catch (Exception exception) {
                CCUtil.printStackTrace(exception);
            }
        }

        public void timeout() {
            try {
                this.service.timeout(this.cc.getCallId());
            }
            catch (Exception exception) {
                CCUtil.printStackTrace(exception);
            }
        }
    }

    public static class SubProcessCCInterceptorHolder {
        private static final SubProcessCCInterceptor INSTANCE = new SubProcessCCInterceptor();

        private SubProcessCCInterceptorHolder() {
        }
    }
}

