/*
 * Decompiled with CFR 0.152.
 */
package com.billy.cc.core.component.remote;

import android.os.Parcel;
import android.os.Parcelable;
import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCUtil;
import com.billy.cc.core.component.remote.RemoteParamUtil;
import java.util.Map;
import org.json.JSONObject;

public class RemoteCC
implements Parcelable {
    public static final Parcelable.Creator<RemoteCC> CREATOR = new Parcelable.Creator<RemoteCC>(){

        public RemoteCC createFromParcel(Parcel parcel) {
            return new RemoteCC(parcel);
        }

        public RemoteCC[] newArray(int n2) {
            return new RemoteCC[n2];
        }
    };
    private Map<String, Object> params;
    private String componentName;
    private String actionName;
    private String callId;
    private boolean isMainThreadSyncCall;
    private Map<String, Object> localParams;

    public RemoteCC(CC cC) {
        this(cC, false);
    }

    public RemoteCC(CC cC, boolean bl) {
        this.componentName = cC.getComponentName();
        this.actionName = cC.getActionName();
        this.callId = cC.getCallId();
        this.params = RemoteParamUtil.toRemoteMap(cC.getParams());
        this.isMainThreadSyncCall = bl;
    }

    public RemoteCC(Parcel parcel) {
        this.componentName = parcel.readString();
        this.actionName = parcel.readString();
        this.callId = parcel.readString();
        boolean bl = parcel.readByte() != 0;
        this.isMainThreadSyncCall = bl;
        this.params = parcel.readHashMap(this.getClass().getClassLoader());
    }

    public Map<String, Object> getParams() {
        if (this.localParams == null) {
            this.localParams = RemoteParamUtil.toLocalMap(this.params);
        }
        return this.localParams;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.componentName);
        parcel.writeString(this.actionName);
        parcel.writeString(this.callId);
        parcel.writeByte((byte)(this.isMainThreadSyncCall ? 1 : 0));
        parcel.writeMap(this.params);
    }

    public String toString() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        CCUtil.put(jSONObject2, "componentName", this.componentName);
        CCUtil.put(jSONObject2, "actionName", this.actionName);
        CCUtil.put(jSONObject2, "callId", this.callId);
        CCUtil.put(jSONObject2, "isMainThreadSyncCall", this.isMainThreadSyncCall);
        CCUtil.put(jSONObject, "params", CCUtil.convertToJson(this.params));
        return jSONObject.toString();
    }

    public int describeContents() {
        return 0;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String string) {
        this.componentName = string;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String string) {
        this.actionName = string;
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String string) {
        this.callId = string;
    }

    public boolean isMainThreadSyncCall() {
        return this.isMainThreadSyncCall;
    }

    public void setMainThreadSyncCall(boolean bl) {
        this.isMainThreadSyncCall = bl;
    }
}

