/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.os.SystemClock;
import com.liulishuo.filedownloader.IDownloadSpeed;

public class DownloadSpeedMonitor
implements IDownloadSpeed.Monitor,
IDownloadSpeed.Lookup {
    private long mLastRefreshTime;
    private long mLastRefreshSofarBytes;
    private long mStartSofarBytes;
    private long mStartTime;
    private int mSpeed;
    private long mTotalBytes;
    private int mMinIntervalUpdateSpeed = 1000;

    @Override
    public void start(long l2) {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mStartSofarBytes = l2;
    }

    @Override
    public void end(long l2) {
        if (this.mStartTime <= 0L) {
            return;
        }
        this.mLastRefreshTime = 0L;
        long l3 = SystemClock.uptimeMillis() - this.mStartTime;
        this.mSpeed = l3 <= 0L ? (int)l2 : (int)((l2 -= this.mStartSofarBytes) / l3);
    }

    @Override
    public void update(long l2) {
        if (this.mMinIntervalUpdateSpeed <= 0) {
            return;
        }
        int n2 = 0;
        if (this.mLastRefreshTime == 0L) {
            n2 = 1;
        } else {
            long l3 = SystemClock.uptimeMillis() - this.mLastRefreshTime;
            if (l3 >= (long)this.mMinIntervalUpdateSpeed || this.mSpeed == 0 && l3 > 0L) {
                DownloadSpeedMonitor downloadSpeedMonitor = this;
                downloadSpeedMonitor.mSpeed = n2 = (int)((l2 - this.mLastRefreshSofarBytes) / l3);
                downloadSpeedMonitor.mSpeed = Math.max(0, n2);
                n2 = 1;
            }
        }
        if (n2 != 0) {
            DownloadSpeedMonitor downloadSpeedMonitor = this;
            downloadSpeedMonitor.mLastRefreshSofarBytes = l2;
            downloadSpeedMonitor.mLastRefreshTime = SystemClock.uptimeMillis();
        }
    }

    @Override
    public void reset() {
        DownloadSpeedMonitor downloadSpeedMonitor = this;
        downloadSpeedMonitor.mSpeed = 0;
        downloadSpeedMonitor.mLastRefreshTime = 0L;
    }

    @Override
    public int getSpeed() {
        return this.mSpeed;
    }

    @Override
    public void setMinIntervalUpdateSpeed(int n2) {
        this.mMinIntervalUpdateSpeed = n2;
    }
}

