/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.text.TextUtils;
import android.util.SparseArray;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadTaskHunter;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.ITaskHunter;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.util.ArrayList;

public class DownloadTask
implements BaseDownloadTask,
BaseDownloadTask.IRunningTask,
DownloadTaskHunter.ICaptureTask {
    public static final int DEFAULT_CALLBACK_PROGRESS_MIN_INTERVAL_MILLIS = 10;
    private final ITaskHunter mHunter;
    private final ITaskHunter.IMessageHandler mMessageHandler;
    private int mId;
    private ArrayList<BaseDownloadTask.FinishListener> mFinishListenerList;
    private final String mUrl;
    private String mPath;
    private String mFilename;
    private boolean mPathAsDirectory;
    private FileDownloadHeader mHeader;
    private FileDownloadListener mListener;
    private SparseArray<Object> mKeyedTags;
    private Object mTag;
    private int mAutoRetryTimes = 0;
    private boolean mSyncCallback = false;
    private boolean mIsWifiRequired = false;
    private int mCallbackProgressTimes = 100;
    private int mCallbackProgressMinIntervalMillis = 10;
    private boolean mIsForceReDownload = false;
    public volatile int mAttachKey = 0;
    private boolean mIsInQueueTask = false;
    private final Object mPauseLock;
    private final Object headerCreateLock;
    private volatile boolean mIsMarkedAdded2List;

    public DownloadTask(String object) {
        DownloadTaskHunter downloadTaskHunter;
        Object object2;
        Object object3;
        Object object4 = object3;
        object3 = new Object();
        this.headerCreateLock = object4;
        this.mIsMarkedAdded2List = false;
        this.mUrl = object;
        object = object2;
        object2 = new Object();
        this.mPauseLock = object;
        object4 = downloadTaskHunter;
        downloadTaskHunter = new DownloadTaskHunter(this, object);
        this.mHunter = object4;
        this.mMessageHandler = object4;
    }

    private int startTaskUnchecked() {
        if (this.isUsing()) {
            if (this.isRunning()) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = this.getId();
                throw new IllegalStateException(FileDownloadUtils.formatString("This task is running %d, if you want to start the same task, please create a new one by FileDownloader.create", objectArray2));
            }
            throw new IllegalStateException("This task is dirty to restart, If you want to reuse this task, please invoke #reuse method manually and retry to restart again." + this.mHunter.toString());
        }
        if (!this.isAttached()) {
            this.setAttachKeyDefault();
        }
        DownloadTask downloadTask = this;
        downloadTask.mHunter.intoLaunchPool();
        return downloadTask.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCreateHeader() {
        block5: {
            if (((DownloadTask)((Object)fileDownloadHeader2)).mHeader != null) break block5;
            DownloadTask downloadTask = fileDownloadHeader2;
            Object object = downloadTask.headerCreateLock;
            synchronized (object) {
                FileDownloadHeader fileDownloadHeader;
                if (downloadTask.mHeader != null) break block5;
                DownloadTask downloadTask2 = fileDownloadHeader2;
                FileDownloadHeader fileDownloadHeader2 = fileDownloadHeader;
                fileDownloadHeader = new FileDownloadHeader();
                downloadTask2.mHeader = fileDownloadHeader2;
            }
        }
    }

    public static /* synthetic */ boolean access$102(DownloadTask downloadTask, boolean bl) {
        downloadTask.mIsInQueueTask = bl;
        return bl;
    }

    @Override
    public BaseDownloadTask setMinIntervalUpdateSpeed(int n2) {
        DownloadTask downloadTask = this;
        downloadTask.mHunter.setMinIntervalUpdateSpeed(n2);
        return downloadTask;
    }

    @Override
    public BaseDownloadTask setPath(String string) {
        return this.setPath(string, false);
    }

    @Override
    public BaseDownloadTask setPath(String string, boolean bl) {
        this.mPath = string;
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            FileDownloadLog.d(this, "setPath %s", objectArray2);
        }
        this.mPathAsDirectory = bl;
        this.mFilename = bl ? null : new File(string).getName();
        return this;
    }

    @Override
    public BaseDownloadTask setListener(FileDownloadListener fileDownloadListener) {
        this.mListener = fileDownloadListener;
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = fileDownloadListener;
            FileDownloadLog.d(this, "setListener %s", objectArray2);
        }
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressTimes(int n2) {
        this.mCallbackProgressTimes = n2;
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressMinInterval(int n2) {
        this.mCallbackProgressMinIntervalMillis = n2;
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressIgnored() {
        return this.setCallbackProgressTimes(-1);
    }

    @Override
    public BaseDownloadTask setTag(Object object) {
        this.mTag = object;
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            FileDownloadLog.d(this, "setTag %s", objectArray2);
        }
        return this;
    }

    @Override
    public BaseDownloadTask setTag(int n2, Object object) {
        if (this.mKeyedTags == null) {
            SparseArray sparseArray;
            SparseArray sparseArray2 = sparseArray;
            sparseArray = new SparseArray(2);
            this.mKeyedTags = sparseArray2;
        }
        DownloadTask downloadTask = this;
        downloadTask.mKeyedTags.put(n2, object);
        return downloadTask;
    }

    @Override
    public BaseDownloadTask setForceReDownload(boolean bl) {
        this.mIsForceReDownload = bl;
        return this;
    }

    @Override
    public BaseDownloadTask setFinishListener(BaseDownloadTask.FinishListener finishListener) {
        DownloadTask downloadTask = this;
        downloadTask.addFinishListener(finishListener);
        return downloadTask;
    }

    @Override
    public BaseDownloadTask addFinishListener(BaseDownloadTask.FinishListener finishListener) {
        if (this.mFinishListenerList == null) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            this.mFinishListenerList = arrayList2;
        }
        if (!this.mFinishListenerList.contains(finishListener)) {
            this.mFinishListenerList.add(finishListener);
        }
        return this;
    }

    @Override
    public boolean removeFinishListener(BaseDownloadTask.FinishListener finishListener) {
        ArrayList<BaseDownloadTask.FinishListener> arrayList = ((DownloadTask)((Object)arrayList)).mFinishListenerList;
        return arrayList != null && arrayList.remove(finishListener);
    }

    @Override
    public BaseDownloadTask setAutoRetryTimes(int n2) {
        this.mAutoRetryTimes = n2;
        return this;
    }

    @Override
    public BaseDownloadTask addHeader(String string, String string2) {
        DownloadTask downloadTask = this;
        downloadTask.checkAndCreateHeader();
        downloadTask.mHeader.add(string, string2);
        return downloadTask;
    }

    @Override
    public BaseDownloadTask addHeader(String string) {
        DownloadTask downloadTask = this;
        downloadTask.checkAndCreateHeader();
        downloadTask.mHeader.add(string);
        return downloadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseDownloadTask removeAllHeaders(String string) {
        block4: {
            if (this.mHeader != null) break block4;
            DownloadTask downloadTask = this;
            Object object = downloadTask.headerCreateLock;
            synchronized (object) {
                if (downloadTask.mHeader != null) break block4;
                return this;
            }
        }
        DownloadTask downloadTask = this;
        downloadTask.mHeader.removeAll(string);
        return downloadTask;
    }

    @Override
    public BaseDownloadTask setSyncCallback(boolean bl) {
        this.mSyncCallback = bl;
        return this;
    }

    @Override
    public BaseDownloadTask setWifiRequired(boolean bl) {
        this.mIsWifiRequired = bl;
        return this;
    }

    @Override
    public int ready() {
        return this.asInQueueTask().enqueue();
    }

    @Override
    public BaseDownloadTask.InQueueTask asInQueueTask() {
        return new InQueueTaskImpl(this, null);
    }

    @Override
    public boolean reuse() {
        if (this.isRunning()) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.getId();
            FileDownloadLog.w(this, "This task[%d] is running, if you want start the same task, please create a new one by FileDownloader#create", objectArray2);
            return false;
        }
        this.mAttachKey = 0;
        this.mIsInQueueTask = false;
        this.mIsMarkedAdded2List = false;
        this.mHunter.reset();
        return true;
    }

    @Override
    public boolean isUsing() {
        return this.mHunter.getStatus() != 0;
    }

    @Override
    public boolean isRunning() {
        if (FileDownloader.getImpl().getLostConnectedHandler().isInWaitingList(this)) {
            return true;
        }
        return FileDownloadStatus.isIng(this.getStatus());
    }

    @Override
    public boolean isAttached() {
        return this.mAttachKey != 0;
    }

    @Override
    public int start() {
        if (!this.mIsInQueueTask) {
            return this.startTaskUnchecked();
        }
        throw new IllegalStateException("If you start the task manually, it means this task doesn't belong to a queue, so you must not invoke BaseDownloadTask#ready() or InQueueTask#enqueue() before you start() this method. For detail: If this task doesn't belong to a queue, what is just an isolated task, you just need to invoke BaseDownloadTask#start() to start this task, that's all. In other words, If this task doesn't belong to a queue, you must not invoke BaseDownloadTask#ready() method or InQueueTask#enqueue() method before invoke BaseDownloadTask#start(), If you do that and if there is the same listener object to start a queue in another thread, this task may be assembled by the queue, in that case, when you invoke BaseDownloadTask#start() manually to start this task or this task is started by the queue, there is an exception buried in there, because this task object is started two times without declare BaseDownloadTask#reuse() : 1. you invoke BaseDownloadTask#start() manually;  2. the queue start this task automatically.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pause() {
        DownloadTask downloadTask = object;
        Object object = downloadTask.mPauseLock;
        synchronized (object) {
            return downloadTask.mHunter.pause();
        }
    }

    @Override
    public boolean cancel() {
        return this.pause();
    }

    @Override
    public int getId() {
        int n2 = this.mId;
        if (n2 != 0) {
            return n2;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPath) && !TextUtils.isEmpty((CharSequence)this.mUrl)) {
            DownloadTask downloadTask = this;
            String string = downloadTask.mPath;
            this.mId = FileDownloadUtils.generateId(this.mUrl, string, downloadTask.mPathAsDirectory);
            return this.mId;
        }
        return 0;
    }

    @Override
    public int getDownloadId() {
        return this.getId();
    }

    @Override
    public String getUrl() {
        return this.mUrl;
    }

    @Override
    public int getCallbackProgressTimes() {
        return this.mCallbackProgressTimes;
    }

    @Override
    public int getCallbackProgressMinInterval() {
        return this.mCallbackProgressMinIntervalMillis;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    @Override
    public boolean isPathAsDirectory() {
        return this.mPathAsDirectory;
    }

    @Override
    public String getFilename() {
        return this.mFilename;
    }

    @Override
    public String getTargetFilePath() {
        DownloadTask downloadTask = this;
        boolean bl = downloadTask.isPathAsDirectory();
        return FileDownloadUtils.getTargetFilePath(this.getPath(), bl, downloadTask.getFilename());
    }

    @Override
    public FileDownloadListener getListener() {
        return this.mListener;
    }

    @Override
    public int getSoFarBytes() {
        return this.getSmallFileSoFarBytes();
    }

    @Override
    public int getSmallFileSoFarBytes() {
        if (this.mHunter.getSofarBytes() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.mHunter.getSofarBytes();
    }

    @Override
    public long getLargeFileSoFarBytes() {
        return this.mHunter.getSofarBytes();
    }

    @Override
    public int getTotalBytes() {
        return this.getSmallFileTotalBytes();
    }

    @Override
    public int getSmallFileTotalBytes() {
        if (this.mHunter.getTotalBytes() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.mHunter.getTotalBytes();
    }

    @Override
    public long getLargeFileTotalBytes() {
        return this.mHunter.getTotalBytes();
    }

    @Override
    public int getSpeed() {
        return this.mHunter.getSpeed();
    }

    @Override
    public byte getStatus() {
        return this.mHunter.getStatus();
    }

    @Override
    public boolean isForceReDownload() {
        return this.mIsForceReDownload;
    }

    @Override
    public Throwable getEx() {
        return this.getErrorCause();
    }

    @Override
    public Throwable getErrorCause() {
        return this.mHunter.getErrorCause();
    }

    @Override
    public boolean isReusedOldFile() {
        return this.mHunter.isReusedOldFile();
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    @Override
    public Object getTag(int n2) {
        SparseArray<Object> sparseArray = sparseArray.mKeyedTags;
        return sparseArray == null ? null : sparseArray.get(n2);
    }

    @Override
    public boolean isContinue() {
        return this.isResuming();
    }

    @Override
    public boolean isResuming() {
        return this.mHunter.isResuming();
    }

    @Override
    public String getEtag() {
        return this.mHunter.getEtag();
    }

    @Override
    public int getAutoRetryTimes() {
        return this.mAutoRetryTimes;
    }

    @Override
    public int getRetryingTimes() {
        return this.mHunter.getRetryingTimes();
    }

    @Override
    public boolean isSyncCallback() {
        return this.mSyncCallback;
    }

    @Override
    public boolean isLargeFile() {
        return this.mHunter.isLargeFile();
    }

    @Override
    public boolean isWifiRequired() {
        return this.mIsWifiRequired;
    }

    @Override
    public FileDownloadHeader getHeader() {
        return this.mHeader;
    }

    @Override
    public void markAdded2List() {
        this.mIsMarkedAdded2List = true;
    }

    @Override
    public void free() {
        this.mHunter.free();
        if (FileDownloadList.getImpl().isNotContains(this)) {
            this.mIsMarkedAdded2List = false;
        }
    }

    @Override
    public void startTaskByQueue() {
        this.startTaskUnchecked();
    }

    @Override
    public void startTaskByRescue() {
        this.startTaskUnchecked();
    }

    @Override
    public Object getPauseLock() {
        return this.mPauseLock;
    }

    @Override
    public boolean isContainFinishListener() {
        ArrayList<BaseDownloadTask.FinishListener> arrayList = ((DownloadTask)((Object)arrayList)).mFinishListenerList;
        return arrayList != null && arrayList.size() > 0;
    }

    @Override
    public boolean isMarkedAdded2List() {
        return this.mIsMarkedAdded2List;
    }

    @Override
    public BaseDownloadTask.IRunningTask getRunningTask() {
        return this;
    }

    @Override
    public void setFileName(String string) {
        this.mFilename = string;
    }

    @Override
    public ArrayList<BaseDownloadTask.FinishListener> getFinishListenerList() {
        return this.mFinishListenerList;
    }

    @Override
    public BaseDownloadTask getOrigin() {
        return this;
    }

    @Override
    public ITaskHunter.IMessageHandler getMessageHandler() {
        return this.mMessageHandler;
    }

    @Override
    public boolean is(int n2) {
        return this.getId() == n2;
    }

    @Override
    public boolean is(FileDownloadListener fileDownloadListener) {
        return this.getListener() == fileDownloadListener;
    }

    @Override
    public boolean isOver() {
        return FileDownloadStatus.isOver(this.getStatus());
    }

    @Override
    public int getAttachKey() {
        return this.mAttachKey;
    }

    @Override
    public void setAttachKeyByQueue(int n2) {
        this.mAttachKey = n2;
    }

    @Override
    public void setAttachKeyDefault() {
        int n2 = this.getListener() != null ? this.getListener().hashCode() : this.hashCode();
        this.mAttachKey = n2;
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getId();
        objectArray[1] = super.toString();
        return FileDownloadUtils.formatString("%d@%s", objectArray2);
    }

    public static final class InQueueTaskImpl
    implements BaseDownloadTask.InQueueTask {
        private final DownloadTask mTask;

        private InQueueTaskImpl(DownloadTask downloadTask) {
            this.mTask = downloadTask;
            DownloadTask.access$102(downloadTask, true);
        }

        public /* synthetic */ InQueueTaskImpl(DownloadTask downloadTask, 1 var2_2) {
            this(downloadTask);
        }

        @Override
        public int enqueue() {
            int n2 = this.mTask.getId();
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n2;
                FileDownloadLog.d(this, "add the task[%d] to the queue", objectArray2);
            }
            FileDownloadList.getImpl().addUnchecked(this.mTask);
            return n2;
        }
    }
}

