/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadSpeedMonitor;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloadMessenger;
import com.liulishuo.filedownloader.FileDownloadMonitor;
import com.liulishuo.filedownloader.FileDownloadServiceProxy;
import com.liulishuo.filedownloader.FileDownloadTaskLauncher;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.IDownloadSpeed;
import com.liulishuo.filedownloader.IFileDownloadMessenger;
import com.liulishuo.filedownloader.ILostServiceConnectedHandler;
import com.liulishuo.filedownloader.ITaskHunter;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotTaker;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class DownloadTaskHunter
implements ITaskHunter,
ITaskHunter.IStarter,
ITaskHunter.IMessageHandler,
BaseDownloadTask.LifeCycleCallback {
    private IFileDownloadMessenger mMessenger;
    private final Object mPauseLock;
    private final ICaptureTask mTask;
    private volatile byte mStatus;
    private Throwable mThrowable;
    private final IDownloadSpeed.Monitor mSpeedMonitor;
    private final IDownloadSpeed.Lookup mSpeedLookup;
    private long mSoFarBytes;
    private long mTotalBytes;
    private int mRetryingTimes;
    private boolean mIsLargeFile;
    private boolean mIsResuming;
    private String mEtag;
    private boolean mIsReusedOldFile;

    private void update(MessageSnapshot messageSnapshot) {
        int n2;
        BaseDownloadTask baseDownloadTask = this.mTask.getRunningTask().getOrigin();
        this.mStatus = n2 = messageSnapshot.getStatus();
        this.mIsLargeFile = messageSnapshot.isLargeFile();
        switch (n2) {
            default: {
                break;
            }
            case 6: {
                this.mMessenger.notifyStarted(messageSnapshot);
                break;
            }
            case 5: {
                DownloadTaskHunter downloadTaskHunter = this;
                this.mSoFarBytes = messageSnapshot.getLargeSofarBytes();
                this.mThrowable = messageSnapshot.getThrowable();
                downloadTaskHunter.mRetryingTimes = messageSnapshot.getRetryingTimes();
                downloadTaskHunter.mSpeedMonitor.reset();
                downloadTaskHunter.mMessenger.notifyRetry(messageSnapshot);
                break;
            }
            case 3: {
                DownloadTaskHunter downloadTaskHunter = this;
                downloadTaskHunter.mSoFarBytes = messageSnapshot.getLargeSofarBytes();
                downloadTaskHunter.mSpeedMonitor.update(messageSnapshot.getLargeSofarBytes());
                downloadTaskHunter.mMessenger.notifyProgress(messageSnapshot);
                break;
            }
            case 2: {
                this.mTotalBytes = messageSnapshot.getLargeTotalBytes();
                this.mIsResuming = messageSnapshot.isResuming();
                this.mEtag = messageSnapshot.getEtag();
                String string = messageSnapshot.getFileName();
                if (string != null) {
                    if (baseDownloadTask.getFilename() != null) {
                        Object[] objectArray = new Object[2];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = baseDownloadTask.getFilename();
                        objectArray[1] = string;
                        FileDownloadLog.w(this, "already has mFilename[%s], but assign mFilename[%s] again", objectArray2);
                    }
                    this.mTask.setFileName(string);
                }
                DownloadTaskHunter downloadTaskHunter = this;
                downloadTaskHunter.mSpeedMonitor.start(this.mSoFarBytes);
                downloadTaskHunter.mMessenger.notifyConnected(messageSnapshot);
                break;
            }
            case 1: {
                this.mSoFarBytes = messageSnapshot.getLargeSofarBytes();
                this.mTotalBytes = messageSnapshot.getLargeTotalBytes();
                this.mMessenger.notifyPending(messageSnapshot);
                break;
            }
            case -1: {
                this.mThrowable = messageSnapshot.getThrowable();
                this.mSoFarBytes = messageSnapshot.getLargeSofarBytes();
                FileDownloadList.getImpl().remove(this.mTask.getRunningTask(), messageSnapshot);
                break;
            }
            case -3: {
                this.mIsReusedOldFile = messageSnapshot.isReusedDownloadedFile();
                this.mSoFarBytes = messageSnapshot.getLargeTotalBytes();
                this.mTotalBytes = messageSnapshot.getLargeTotalBytes();
                FileDownloadList.getImpl().remove(this.mTask.getRunningTask(), messageSnapshot);
                break;
            }
            case -4: {
                this.mSpeedMonitor.reset();
                n2 = FileDownloadList.getImpl().count(baseDownloadTask.getId());
                int n3 = n2 <= 1 && baseDownloadTask.isPathAsDirectory() ? FileDownloadList.getImpl().count(FileDownloadUtils.generateId(baseDownloadTask.getUrl(), baseDownloadTask.getTargetFilePath())) : 0;
                if (n2 + n3 <= 1) {
                    n2 = FileDownloadServiceProxy.getImpl().getStatus(baseDownloadTask.getId());
                    Object[] objectArray = new Object[2];
                    Object[] objectArray3 = objectArray;
                    objectArray3[0] = baseDownloadTask.getId();
                    objectArray[1] = n2;
                    FileDownloadLog.w(this, "warn, but no mListener to receive, switch to pending %d %d", objectArray3);
                    if (FileDownloadStatus.isIng(n2)) {
                        long l2;
                        DownloadTaskHunter downloadTaskHunter = this;
                        this.mStatus = 1;
                        this.mTotalBytes = messageSnapshot.getLargeTotalBytes();
                        downloadTaskHunter.mSoFarBytes = l2 = messageSnapshot.getLargeSofarBytes();
                        downloadTaskHunter.mSpeedMonitor.start(l2);
                        downloadTaskHunter.mMessenger.notifyPending(((MessageSnapshot.IWarnMessageSnapshot)((Object)messageSnapshot)).turnToPending());
                        break;
                    }
                }
                FileDownloadList.getImpl().remove(this.mTask.getRunningTask(), messageSnapshot);
            }
        }
    }

    public DownloadTaskHunter(ICaptureTask iCaptureTask, Object object) {
        DownloadSpeedMonitor downloadSpeedMonitor;
        DownloadTaskHunter downloadTaskHunter = this;
        this.mStatus = 0;
        this.mThrowable = null;
        this.mIsReusedOldFile = false;
        this.mPauseLock = object;
        downloadTaskHunter.mTask = iCaptureTask;
        object = downloadSpeedMonitor;
        downloadTaskHunter.mSpeedMonitor = new DownloadSpeedMonitor();
        downloadTaskHunter.mSpeedLookup = object;
        downloadTaskHunter.mMessenger = new FileDownloadMessenger(iCaptureTask.getRunningTask(), this);
    }

    private void prepare() throws IOException {
        Object object;
        Object object2;
        block8: {
            block7: {
                File file;
                block6: {
                    File file2;
                    object2 = ((DownloadTaskHunter)object).mTask.getRunningTask().getOrigin();
                    if (object2.getPath() == null) {
                        BaseDownloadTask baseDownloadTask = object2;
                        baseDownloadTask.setPath(FileDownloadUtils.getDefaultSaveFilePath(baseDownloadTask.getUrl()));
                        if (FileDownloadLog.NEED_LOG) {
                            Object[] objectArray = object;
                            Object[] objectArray2 = new Object[1];
                            object = objectArray2;
                            objectArray2[0] = object2.getPath();
                            FileDownloadLog.d(objectArray, "save Path is null to %s", (Object[])object);
                        }
                    }
                    if (!object2.isPathAsDirectory()) break block6;
                    object = file2;
                    file2 = new File(object2.getPath());
                    break block7;
                }
                object = FileDownloadUtils.getParent(object2.getPath());
                if (object == null) break block8;
                object2 = file;
                file = new File((String)object);
                object = object2;
            }
            if (!(((File)object).exists() || ((File)object).mkdirs() || ((File)object).exists())) {
                Object[] objectArray = new Object[1];
                object2 = objectArray;
                objectArray[0] = ((File)object).getAbsolutePath();
                throw new IOException(FileDownloadUtils.formatString("Create parent directory failed, please make sure you have permission to create file or directory on the path: %s", object2));
            }
            return;
        }
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = object2.getPath();
        throw new InvalidParameterException(FileDownloadUtils.formatString("the provided mPath[%s] is invalid, can't find its directory", (Object[])object));
    }

    private int getId() {
        return this.mTask.getRunningTask().getOrigin().getId();
    }

    @Override
    public boolean updateKeepAhead(MessageSnapshot objectArray) {
        if (!FileDownloadStatus.isKeepAhead(this.getStatus(), objectArray.getStatus())) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray2 = new Object[3];
                objectArray = objectArray2;
                objectArray[0] = this.mStatus;
                objectArray[1] = this.getStatus();
                objectArray2[2] = this.getId();
                FileDownloadLog.d(this, "can't update mStatus change by keep ahead, %d, but the current mStatus is %d, %d", objectArray);
            }
            return false;
        }
        this.update((MessageSnapshot)objectArray);
        return true;
    }

    @Override
    public boolean updateKeepFlow(MessageSnapshot objectArray) {
        byte by = this.getStatus();
        byte by2 = objectArray.getStatus();
        if (-2 == by && FileDownloadStatus.isIng(by2)) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getId();
                FileDownloadLog.d(this, "High concurrent cause, callback pending, but has already be paused %d", objectArray);
            }
            return true;
        }
        if (!FileDownloadStatus.isKeepFlow(by, by2)) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray3 = new Object[3];
                objectArray = objectArray3;
                objectArray[0] = this.mStatus;
                objectArray[1] = this.getStatus();
                objectArray3[2] = this.getId();
                FileDownloadLog.d(this, "can't update mStatus change by keep flow, %d, but the current mStatus is %d, %d", objectArray);
            }
            return false;
        }
        this.update((MessageSnapshot)objectArray);
        return true;
    }

    @Override
    public boolean updateMoreLikelyCompleted(MessageSnapshot messageSnapshot) {
        if (!FileDownloadStatus.isMoreLikelyCompleted(this.mTask.getRunningTask().getOrigin())) {
            return false;
        }
        this.update(messageSnapshot);
        return true;
    }

    @Override
    public boolean updateSameFilePathTaskRunning(MessageSnapshot messageSnapshot) {
        if (!this.mTask.getRunningTask().getOrigin().isPathAsDirectory()) {
            return false;
        }
        if (messageSnapshot.getStatus() == -4 && this.getStatus() == 2) {
            this.update(messageSnapshot);
            return true;
        }
        return false;
    }

    @Override
    public IFileDownloadMessenger getMessenger() {
        return this.mMessenger;
    }

    @Override
    public MessageSnapshot prepareErrorMessage(Throwable throwable) {
        this.mStatus = (byte)-1;
        this.mThrowable = throwable;
        return MessageSnapshotTaker.catchException(this.getId(), this.getSofarBytes(), throwable);
    }

    @Override
    public void onBegin() {
        if (FileDownloadMonitor.isValid()) {
            FileDownloadMonitor.getMonitor().onTaskBegin(this.mTask.getRunningTask().getOrigin());
        }
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.toString();
            objectArray[1] = this.getStatus();
            FileDownloadLog.v(this, "filedownloader:lifecycle:start %s by %d ", objectArray2);
        }
    }

    @Override
    public void onIng() {
        if (FileDownloadMonitor.isValid() && this.getStatus() == 6) {
            FileDownloadMonitor.getMonitor().onTaskStarted(this.mTask.getRunningTask().getOrigin());
        }
    }

    @Override
    public void onOver() {
        Object[] objectArray;
        BaseDownloadTask baseDownloadTask = this.mTask.getRunningTask().getOrigin();
        if (FileDownloadMonitor.isValid()) {
            FileDownloadMonitor.getMonitor().onTaskOver(baseDownloadTask);
        }
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = this.toString();
            objectArray2[1] = this.getStatus();
            FileDownloadLog.v(this, "filedownloader:lifecycle:over %s by %d ", objectArray);
        }
        DownloadTaskHunter downloadTaskHunter = this;
        downloadTaskHunter.mSpeedMonitor.end(this.mSoFarBytes);
        if (downloadTaskHunter.mTask.getFinishListenerList() != null) {
            objectArray = (ArrayList)this.mTask.getFinishListenerList().clone();
            int n2 = objectArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((BaseDownloadTask.FinishListener)objectArray.get(i2)).over(baseDownloadTask);
            }
        }
        FileDownloader.getImpl().getLostConnectedHandler().taskWorkFine(this.mTask.getRunningTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void intoLaunchPool() {
        DownloadTaskHunter downloadTaskHunter = this;
        Object[] objectArray = downloadTaskHunter.mPauseLock;
        synchronized (downloadTaskHunter.mPauseLock) {
            if (downloadTaskHunter.mStatus != 0) {
                FileDownloadLog.w(this, "High concurrent cause, this task %d will not input to launch pool, because of the status isn't idle : %d", this.getId(), this.mStatus);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.mStatus = (byte)10;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            objectArray = this.mTask.getRunningTask();
            BaseDownloadTask baseDownloadTask = objectArray.getOrigin();
            if (FileDownloadMonitor.isValid()) {
                FileDownloadMonitor.getMonitor().onRequestStart(baseDownloadTask);
            }
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray2 = new Object[4];
                Object[] objectArray3 = objectArray2;
                objectArray3[0] = baseDownloadTask.getUrl();
                objectArray3[1] = baseDownloadTask.getPath();
                objectArray3[2] = baseDownloadTask.getListener();
                objectArray2[3] = baseDownloadTask.getTag();
                FileDownloadLog.v(this, "call start Url[%s], Path[%s] Listener[%s], Tag[%s]", objectArray3);
            }
            boolean bl = true;
            try {
                this.prepare();
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                FileDownloadList.getImpl().add((BaseDownloadTask.IRunningTask)objectArray);
                FileDownloadList.getImpl().remove((BaseDownloadTask.IRunningTask)objectArray, this.prepareErrorMessage(throwable));
                bl = bl2;
            }
            if (bl) {
                FileDownloadTaskLauncher.getImpl().launch(this);
            }
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.getId();
                FileDownloadLog.v(this, "the task[%d] has been into the launch pool.", objectArray);
            }
            return;
        }
    }

    @Override
    public boolean pause() {
        if (FileDownloadStatus.isOver(objectArray5.getStatus())) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = objectArray5.getStatus();
                objectArray[1] = objectArray5.mTask.getRunningTask().getOrigin().getId();
                FileDownloadLog.d(objectArray5, "High concurrent cause, Already is over, can't pause again, %d %d", objectArray2);
            }
            return false;
        }
        objectArray5.mStatus = (byte)-2;
        BaseDownloadTask.IRunningTask iRunningTask = objectArray5.mTask.getRunningTask();
        BaseDownloadTask baseDownloadTask = iRunningTask.getOrigin();
        FileDownloadTaskLauncher.getImpl().expire((ITaskHunter.IStarter)objectArray5);
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = objectArray5.getId();
            FileDownloadLog.v(objectArray5, "the task[%d] has been expired from the launch pool.", objectArray3);
        }
        if (!FileDownloader.getImpl().isServiceConnected()) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray5;
                Object[] objectArray4 = new Object[1];
                Object[] objectArray5 = objectArray4;
                objectArray4[0] = baseDownloadTask.getId();
                FileDownloadLog.d(objectArray, "request pause the task[%d] to the download service, but the download service isn't connected yet.", objectArray5);
            }
        } else {
            FileDownloadServiceProxy.getImpl().pause(baseDownloadTask.getId());
        }
        FileDownloadList.getImpl().add(iRunningTask);
        FileDownloadList.getImpl().remove(iRunningTask, MessageSnapshotTaker.catchPause(baseDownloadTask));
        FileDownloader.getImpl().getLostConnectedHandler().taskWorkFine(iRunningTask);
        return true;
    }

    @Override
    public byte getStatus() {
        return this.mStatus;
    }

    @Override
    public void reset() {
        DownloadTaskHunter downloadTaskHunter = this;
        downloadTaskHunter.mThrowable = null;
        downloadTaskHunter.mEtag = null;
        downloadTaskHunter.mIsResuming = false;
        downloadTaskHunter.mRetryingTimes = 0;
        downloadTaskHunter.mIsReusedOldFile = false;
        downloadTaskHunter.mIsLargeFile = false;
        downloadTaskHunter.mSoFarBytes = 0L;
        downloadTaskHunter.mTotalBytes = 0L;
        downloadTaskHunter.mSpeedMonitor.reset();
        if (FileDownloadStatus.isOver(downloadTaskHunter.mStatus)) {
            this.mMessenger.discard();
            this.mMessenger = new FileDownloadMessenger(this.mTask.getRunningTask(), this);
        } else {
            this.mMessenger.reAppointment(this.mTask.getRunningTask(), this);
        }
        this.mStatus = 0;
    }

    @Override
    public void setMinIntervalUpdateSpeed(int n2) {
        this.mSpeedLookup.setMinIntervalUpdateSpeed(n2);
    }

    @Override
    public int getSpeed() {
        return this.mSpeedLookup.getSpeed();
    }

    @Override
    public long getSofarBytes() {
        return this.mSoFarBytes;
    }

    @Override
    public long getTotalBytes() {
        return this.mTotalBytes;
    }

    @Override
    public Throwable getErrorCause() {
        return this.mThrowable;
    }

    @Override
    public int getRetryingTimes() {
        return this.mRetryingTimes;
    }

    @Override
    public boolean isReusedOldFile() {
        return this.mIsReusedOldFile;
    }

    @Override
    public boolean isResuming() {
        return this.mIsResuming;
    }

    @Override
    public String getEtag() {
        return this.mEtag;
    }

    @Override
    public boolean isLargeFile() {
        return this.mIsLargeFile;
    }

    @Override
    public void free() {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.getId();
            objectArray[1] = this.mStatus;
            FileDownloadLog.d(this, "free the task %d, when the status is %d", objectArray2);
        }
        this.mStatus = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void start() {
        boolean bl;
        ILostServiceConnectedHandler iLostServiceConnectedHandler;
        BaseDownloadTask.IRunningTask iRunningTask;
        block17: {
            if (this.mStatus != 10) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = this.getId();
                objectArray[1] = this.mStatus;
                FileDownloadLog.w(this, "High concurrent cause, this task %d will not start, because the of status isn't toLaunchPool: %d", objectArray2);
                return;
            }
            iRunningTask = this.mTask.getRunningTask();
            Object object = iRunningTask.getOrigin();
            iLostServiceConnectedHandler = FileDownloader.getImpl().getLostConnectedHandler();
            if (iLostServiceConnectedHandler.dispatchTaskStart(iRunningTask)) {
                return;
            }
            DownloadTaskHunter downloadTaskHunter = this;
            DownloadTaskHunter downloadTaskHunter2 = downloadTaskHunter;
            Object object2 = downloadTaskHunter.mPauseLock;
            if (downloadTaskHunter2.mStatus != 10) {
                FileDownloadLog.w(this, "High concurrent cause, this task %d will not start, the status can't assign to toFileDownloadService, because the status isn't toLaunchPool: %d", this.getId(), this.mStatus);
                // MONITOREXIT : object2
                return;
            }
            BaseDownloadTask baseDownloadTask = object;
            this.mStatus = (byte)11;
            // MONITOREXIT : object2
            {
                catch (Throwable throwable) {
                    // MONITOREXIT : object2
                    throw throwable;
                }
            }
            FileDownloadList.getImpl().add(iRunningTask);
            BaseDownloadTask baseDownloadTask2 = object;
            object2 = baseDownloadTask2.getTargetFilePath();
            if (FileDownloadHelper.inspectAndInflowDownloaded(baseDownloadTask.getId(), (String)object2, baseDownloadTask2.isForceReDownload(), true)) {
                return;
            }
            BaseDownloadTask baseDownloadTask3 = object;
            BaseDownloadTask baseDownloadTask4 = object;
            object = baseDownloadTask4.getUrl();
            object2 = baseDownloadTask4.getPath();
            boolean bl2 = baseDownloadTask4.isPathAsDirectory();
            int n2 = baseDownloadTask4.getCallbackProgressTimes();
            int n3 = baseDownloadTask4.getCallbackProgressMinInterval();
            int n4 = baseDownloadTask4.getAutoRetryTimes();
            boolean bl3 = baseDownloadTask4.isForceReDownload();
            FileDownloadHeader fileDownloadHeader = this.mTask.getHeader();
            boolean bl4 = baseDownloadTask3.isWifiRequired();
            bl = FileDownloadServiceProxy.getImpl().start((String)object, (String)object2, bl2, n2, n3, n4, bl3, fileDownloadHeader, bl4);
            if (this.mStatus != -2) break block17;
            boolean bl5 = bl;
            DownloadTaskHunter downloadTaskHunter3 = this;
            String string = "High concurrent cause, this task %d will be paused,because of the status is paused, so the pause action must be applied";
            Object[] objectArray = new Object[1];
            objectArray[0] = this.getId();
            FileDownloadLog.w(downloadTaskHunter3, string, objectArray);
            if (!bl5) return;
            FileDownloadServiceProxy.getImpl().pause(this.getId());
            return;
        }
        if (!bl) {
            if (iLostServiceConnectedHandler.dispatchTaskStart(iRunningTask)) return;
            MessageSnapshot messageSnapshot = this.prepareErrorMessage(new RuntimeException("Occur Unknown Error, when request to start maybe some problem in binder, maybe the process was killed in unexpected."));
            if (FileDownloadList.getImpl().isNotContains(iRunningTask)) {
                iLostServiceConnectedHandler.taskWorkFine(iRunningTask);
                FileDownloadList.getImpl().add(iRunningTask);
            }
            FileDownloadList.getImpl().remove(iRunningTask, messageSnapshot);
            return;
        }
        try {
            iLostServiceConnectedHandler.taskWorkFine(iRunningTask);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            FileDownloadList.getImpl().remove(iRunningTask, this.prepareErrorMessage(throwable));
        }
    }

    @Override
    public boolean equalListener(FileDownloadListener fileDownloadListener) {
        return this.mTask.getRunningTask().getOrigin().getListener() == fileDownloadListener;
    }

    public static interface ICaptureTask {
        public FileDownloadHeader getHeader();

        public BaseDownloadTask.IRunningTask getRunningTask();

        public void setFileName(String var1);

        public ArrayList<BaseDownloadTask.FinishListener> getFinishListenerList();
    }
}

