/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.liulishuo.filedownloader.IFileDownloadMessenger;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

public class FileDownloadMessageStation {
    public static final int HANDOVER_A_MESSENGER = 1;
    public static final int DISPOSE_MESSENGER_LIST = 2;
    public static final int DEFAULT_INTERVAL = 10;
    public static final int DEFAULT_SUB_PACKAGE_SIZE = 5;
    public static int INTERVAL = 10;
    public static int SUB_PACKAGE_SIZE = 5;
    private final Executor blockCompletedPool = FileDownloadExecutors.newDefaultThreadPool(5, "BlockCompleted");
    private final Handler handler;
    private final LinkedBlockingQueue<IFileDownloadMessenger> waitingQueue;
    private final Object queueLock = new Object();
    private final ArrayList<IFileDownloadMessenger> disposingList = new ArrayList();

    public static FileDownloadMessageStation getImpl() {
        return HolderClass.INSTANCE;
    }

    private FileDownloadMessageStation() {
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new UIHandlerCallback(null));
        this.waitingQueue = new LinkedBlockingQueue();
    }

    private void handoverInUIThread(IFileDownloadMessenger iFileDownloadMessenger) {
        Handler handler = this.handler;
        handler.sendMessage(handler.obtainMessage(1, (Object)iFileDownloadMessenger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(IFileDownloadMessenger iFileDownloadMessenger) {
        FileDownloadMessageStation fileDownloadMessageStation = this;
        Object object = fileDownloadMessageStation.queueLock;
        synchronized (object) {
            this.waitingQueue.offer(iFileDownloadMessenger);
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            fileDownloadMessageStation.push();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void push() {
        int n2;
        block9: {
            block8: {
                FileDownloadMessageStation fileDownloadMessageStation = fileDownloadMessageStation;
                Object object = fileDownloadMessageStation.queueLock;
                // MONITORENTER : object
                if (!fileDownloadMessageStation.disposingList.isEmpty()) {
                    // MONITOREXIT : object
                    return;
                }
                if (fileDownloadMessageStation.waitingQueue.isEmpty()) {
                    // MONITOREXIT : object
                    return;
                }
                if (FileDownloadMessageStation.isIntervalValid()) break block8;
                fileDownloadMessageStation.waitingQueue.drainTo(fileDownloadMessageStation.disposingList);
                n2 = 0;
                break block9;
            }
            n2 = INTERVAL;
            int n3 = Math.min(fileDownloadMessageStation.waitingQueue.size(), SUB_PACKAGE_SIZE);
            for (int i2 = 0; i2 < n3; ++i2) {
                fileDownloadMessageStation.disposingList.add((IFileDownloadMessenger)fileDownloadMessageStation.waitingQueue.remove());
            }
            {
                continue;
            }
        }
        // MONITOREXIT : object
        Handler handler = fileDownloadMessageStation.handler;
        FileDownloadMessageStation fileDownloadMessageStation = handler.obtainMessage(2, fileDownloadMessageStation.disposingList);
        long l2 = n2;
        handler.sendMessageDelayed((Message)fileDownloadMessageStation, l2);
    }

    public static boolean isIntervalValid() {
        return INTERVAL > 0;
    }

    public /* synthetic */ FileDownloadMessageStation(1 var1_1) {
        this();
    }

    public void requestEnqueue(IFileDownloadMessenger iFileDownloadMessenger) {
        this.requestEnqueue(iFileDownloadMessenger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestEnqueue(final IFileDownloadMessenger iFileDownloadMessenger, boolean bl) {
        if (iFileDownloadMessenger.handoverDirectly()) {
            iFileDownloadMessenger.handoverMessage();
            return;
        }
        if (iFileDownloadMessenger.isBlockingCompleted()) {
            this.blockCompletedPool.execute(new Runnable(){

                @Override
                public void run() {
                    iFileDownloadMessenger.handoverMessage();
                }
            });
            return;
        }
        if (!FileDownloadMessageStation.isIntervalValid() && !this.waitingQueue.isEmpty()) {
            FileDownloadMessageStation fileDownloadMessageStation = this;
            Object object = fileDownloadMessageStation.queueLock;
            synchronized (object) {
                if (!fileDownloadMessageStation.waitingQueue.isEmpty()) {
                    Iterator<IFileDownloadMessenger> iterator = this.waitingQueue.iterator();
                    while (iterator.hasNext()) {
                        this.handoverInUIThread(iterator.next());
                    }
                }
                this.waitingQueue.clear();
            }
        }
        if (FileDownloadMessageStation.isIntervalValid() && !bl) {
            this.enqueue(iFileDownloadMessenger);
            return;
        }
        this.handoverInUIThread(iFileDownloadMessenger);
    }

    public static class UIHandlerCallback
    implements Handler.Callback {
        private UIHandlerCallback() {
        }

        private void dispose(ArrayList<IFileDownloadMessenger> arrayList) {
            Iterator<IFileDownloadMessenger> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((IFileDownloadMessenger)iterator.next()).handoverMessage();
            }
            arrayList.clear();
        }

        public /* synthetic */ UIHandlerCallback(1 var1_1) {
            this();
        }

        public boolean handleMessage(Message message) {
            int n2 = message.what;
            if (n2 == 1) {
                ((IFileDownloadMessenger)message.obj).handoverMessage();
            } else if (n2 == 2) {
                this.dispose((ArrayList)message.obj);
                FileDownloadMessageStation.getImpl().push();
            }
            return true;
        }
    }

    public static final class HolderClass {
        private static final FileDownloadMessageStation INSTANCE = new FileDownloadMessageStation(null);

        private HolderClass() {
        }
    }
}

