/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadLargeFileListener;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloadMessageStation;
import com.liulishuo.filedownloader.FileDownloadMonitor;
import com.liulishuo.filedownloader.IFileDownloadMessenger;
import com.liulishuo.filedownloader.message.BlockCompleteMessage;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

class FileDownloadMessenger
implements IFileDownloadMessenger {
    private BaseDownloadTask.IRunningTask mTask;
    private BaseDownloadTask.LifeCycleCallback mLifeCycleCallback;
    private Queue<MessageSnapshot> parcelQueue;
    private boolean mIsDiscard;

    public FileDownloadMessenger(BaseDownloadTask.IRunningTask iRunningTask, BaseDownloadTask.LifeCycleCallback lifeCycleCallback) {
        FileDownloadMessenger fileDownloadMessenger = this;
        fileDownloadMessenger.mIsDiscard = false;
        fileDownloadMessenger.init(iRunningTask, lifeCycleCallback);
    }

    private void init(BaseDownloadTask.IRunningTask iRunningTask, BaseDownloadTask.LifeCycleCallback lifeCycleCallback) {
        LinkedBlockingQueue linkedBlockingQueue;
        FileDownloadMessenger fileDownloadMessenger = linkedBlockingQueue2;
        fileDownloadMessenger.mTask = iRunningTask;
        fileDownloadMessenger.mLifeCycleCallback = lifeCycleCallback;
        LinkedBlockingQueue linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue();
        fileDownloadMessenger.parcelQueue = linkedBlockingQueue2;
    }

    private void process(MessageSnapshot messageSnapshot) {
        BaseDownloadTask.IRunningTask iRunningTask = objectArray3.mTask;
        if (iRunningTask == null) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = objectArray2;
                objectArray3[0] = messageSnapshot.getId();
                objectArray2[1] = messageSnapshot.getStatus();
                FileDownloadLog.d(objectArray, "occur this case, it would be the host task of this messenger has been over(paused/warn/completed/error) on the other thread before receiving the snapshot(id[%d], status[%d])", objectArray3);
            }
            return;
        }
        if (!objectArray3.mIsDiscard && iRunningTask.getOrigin().getListener() != null) {
            objectArray3.parcelQueue.offer(messageSnapshot);
            FileDownloadMessageStation.getImpl().requestEnqueue((IFileDownloadMessenger)objectArray3);
        } else {
            if ((FileDownloadMonitor.isValid() || objectArray3.mTask.isContainFinishListener()) && messageSnapshot.getStatus() == 4) {
                objectArray3.mLifeCycleCallback.onOver();
            }
            super.inspectAndHandleOverStatus(messageSnapshot.getStatus());
        }
    }

    private void inspectAndHandleOverStatus(int n2) {
        if (FileDownloadStatus.isOver(n2)) {
            if (!this.parcelQueue.isEmpty()) {
                FileDownloadMessenger fileDownloadMessenger = this;
                MessageSnapshot messageSnapshot = fileDownloadMessenger.parcelQueue.peek();
                Object[] objectArray = new Object[4];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = this;
                objectArray2[1] = messageSnapshot.getId();
                objectArray2[2] = this.parcelQueue.size();
                objectArray[3] = messageSnapshot.getStatus();
                FileDownloadLog.w(fileDownloadMessenger, "the messenger[%s](with id[%d]) has already accomplished all his job, but there still are some messages in parcel queue[%d] queue-top-status[%d]", objectArray2);
            }
            this.mTask = null;
        }
    }

    @Override
    public boolean notifyBegin() {
        Object[] objectArray;
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.mTask;
            FileDownloadLog.d(this, "notify begin %s", objectArray);
        }
        if (this.mTask == null) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = this.parcelQueue.size();
            FileDownloadLog.w(this, "can't begin the task, the holder fo the messenger is nil, %d", objectArray);
            return false;
        }
        this.mLifeCycleCallback.onBegin();
        return true;
    }

    @Override
    public void notifyPending(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mTask;
            FileDownloadLog.d(this, "notify pending %s", objectArray2);
        }
        this.mLifeCycleCallback.onIng();
        this.process(messageSnapshot);
    }

    @Override
    public void notifyStarted(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mTask;
            FileDownloadLog.d(this, "notify started %s", objectArray2);
        }
        this.mLifeCycleCallback.onIng();
        this.process(messageSnapshot);
    }

    @Override
    public void notifyConnected(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mTask;
            FileDownloadLog.d(this, "notify connected %s", objectArray2);
        }
        this.mLifeCycleCallback.onIng();
        this.process(messageSnapshot);
    }

    @Override
    public void notifyProgress(MessageSnapshot objectArray) {
        BaseDownloadTask baseDownloadTask = this.mTask.getOrigin();
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray2 = new Object[3];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = baseDownloadTask;
            objectArray3[1] = baseDownloadTask.getLargeFileSoFarBytes();
            objectArray2[2] = baseDownloadTask.getLargeFileTotalBytes();
            FileDownloadLog.d(this, "notify progress %s %d %d", objectArray3);
        }
        if (baseDownloadTask.getCallbackProgressTimes() <= 0) {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.mTask;
                FileDownloadLog.d(this, "notify progress but client not request notify %s", objectArray);
            }
            return;
        }
        this.mLifeCycleCallback.onIng();
        this.process((MessageSnapshot)objectArray);
    }

    @Override
    public void notifyBlockComplete(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mTask;
            objectArray[1] = Thread.currentThread().getName();
            FileDownloadLog.d(this, "notify block completed %s %s", objectArray2);
        }
        this.mLifeCycleCallback.onIng();
        this.process(messageSnapshot);
    }

    @Override
    public void notifyRetry(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadMessenger fileDownloadMessenger = this;
            BaseDownloadTask baseDownloadTask = fileDownloadMessenger.mTask.getOrigin();
            Object[] objectArray = new Object[4];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mTask;
            objectArray2[1] = baseDownloadTask.getAutoRetryTimes();
            objectArray2[2] = baseDownloadTask.getRetryingTimes();
            objectArray[3] = baseDownloadTask.getErrorCause();
            FileDownloadLog.d(fileDownloadMessenger, "notify retry %s %d %d %s", objectArray2);
        }
        this.mLifeCycleCallback.onIng();
        this.process(messageSnapshot);
    }

    @Override
    public void notifyWarn(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mTask;
            FileDownloadLog.d(this, "notify warn %s", objectArray2);
        }
        this.mLifeCycleCallback.onOver();
        this.process(messageSnapshot);
    }

    @Override
    public void notifyError(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            BaseDownloadTask.IRunningTask iRunningTask = this.mTask;
            objectArray[0] = iRunningTask;
            objectArray[1] = iRunningTask.getOrigin().getErrorCause();
            FileDownloadLog.d(this, "notify error %s %s", objectArray2);
        }
        this.mLifeCycleCallback.onOver();
        this.process(messageSnapshot);
    }

    @Override
    public void notifyPaused(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mTask;
            FileDownloadLog.d(this, "notify paused %s", objectArray2);
        }
        this.mLifeCycleCallback.onOver();
        this.process(messageSnapshot);
    }

    @Override
    public void notifyCompleted(MessageSnapshot messageSnapshot) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.mTask;
            FileDownloadLog.d(this, "notify completed %s", objectArray2);
        }
        this.mLifeCycleCallback.onOver();
        this.process(messageSnapshot);
    }

    @Override
    public void handoverMessage() {
        if (((FileDownloadMessenger)object2).mIsDiscard) {
            return;
        }
        FileDownloadMessenger fileDownloadMessenger = object2;
        Object[] objectArray = fileDownloadMessenger.parcelQueue.poll();
        int n2 = objectArray.getStatus();
        Object object = fileDownloadMessenger.mTask;
        if (object != null) {
            BaseDownloadTask baseDownloadTask = object.getOrigin();
            FileDownloadListener fileDownloadListener = baseDownloadTask.getListener();
            object = object.getMessageHandler();
            ((FileDownloadMessenger)object2).inspectAndHandleOverStatus(n2);
            if (fileDownloadListener != null && !fileDownloadListener.isInvalid()) {
                if (n2 == 4) {
                    try {
                        fileDownloadListener.blockComplete(baseDownloadTask);
                        ((FileDownloadMessenger)object2).notifyCompleted(((BlockCompleteMessage)objectArray).transmitToCompleted());
                    }
                    catch (Throwable throwable) {
                        ((FileDownloadMessenger)object2).notifyError(object.prepareErrorMessage(throwable));
                    }
                } else {
                    Object object2 = null;
                    if (fileDownloadListener instanceof FileDownloadLargeFileListener) {
                        object2 = (FileDownloadLargeFileListener)fileDownloadListener;
                    }
                    switch (n2) {
                        default: {
                            break;
                        }
                        case 6: {
                            fileDownloadListener.started(baseDownloadTask);
                            break;
                        }
                        case 5: {
                            if (object2 != null) {
                                Object object3 = object2;
                                object2 = objectArray.getThrowable();
                                int n3 = objectArray.getRetryingTimes();
                                long l2 = objectArray.getLargeSofarBytes();
                                ((FileDownloadLargeFileListener)object3).retry(baseDownloadTask, (Throwable)object2, n3, l2);
                                break;
                            }
                            object2 = objectArray.getThrowable();
                            int n4 = objectArray.getRetryingTimes();
                            n2 = objectArray.getSmallSofarBytes();
                            fileDownloadListener.retry(baseDownloadTask, (Throwable)object2, n4, n2);
                            break;
                        }
                        case 3: {
                            if (object2 != null) {
                                long l3 = objectArray.getLargeSofarBytes();
                                long l4 = baseDownloadTask.getLargeFileTotalBytes();
                                ((FileDownloadLargeFileListener)object2).progress(baseDownloadTask, l3, l4);
                                break;
                            }
                            int n5 = objectArray.getSmallSofarBytes();
                            int n6 = baseDownloadTask.getSmallFileTotalBytes();
                            fileDownloadListener.progress(baseDownloadTask, n5, n6);
                            break;
                        }
                        case 2: {
                            if (object2 != null) {
                                Object object4 = object2;
                                object2 = objectArray.getEtag();
                                boolean bl = objectArray.isResuming();
                                long l5 = baseDownloadTask.getLargeFileSoFarBytes();
                                long l6 = objectArray.getLargeTotalBytes();
                                ((FileDownloadLargeFileListener)object4).connected(baseDownloadTask, (String)object2, bl, l5, l6);
                                break;
                            }
                            object2 = objectArray.getEtag();
                            boolean bl = objectArray.isResuming();
                            n2 = baseDownloadTask.getSmallFileSoFarBytes();
                            int n7 = objectArray.getSmallTotalBytes();
                            fileDownloadListener.connected(baseDownloadTask, (String)object2, bl, n2, n7);
                            break;
                        }
                        case 1: {
                            if (object2 != null) {
                                long l7 = objectArray.getLargeSofarBytes();
                                long l8 = objectArray.getLargeTotalBytes();
                                ((FileDownloadLargeFileListener)object2).pending(baseDownloadTask, l7, l8);
                                break;
                            }
                            int n8 = objectArray.getSmallSofarBytes();
                            int n9 = objectArray.getSmallTotalBytes();
                            fileDownloadListener.pending(baseDownloadTask, n8, n9);
                            break;
                        }
                        case -1: {
                            fileDownloadListener.error(baseDownloadTask, objectArray.getThrowable());
                            break;
                        }
                        case -2: {
                            if (object2 != null) {
                                long l9 = objectArray.getLargeSofarBytes();
                                long l10 = objectArray.getLargeTotalBytes();
                                ((FileDownloadLargeFileListener)object2).paused(baseDownloadTask, l9, l10);
                                break;
                            }
                            int n10 = objectArray.getSmallSofarBytes();
                            int n11 = objectArray.getSmallTotalBytes();
                            fileDownloadListener.paused(baseDownloadTask, n10, n11);
                            break;
                        }
                        case -3: {
                            fileDownloadListener.completed(baseDownloadTask);
                            break;
                        }
                        case -4: {
                            fileDownloadListener.warn(baseDownloadTask);
                        }
                    }
                }
                return;
            }
            return;
        }
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray[0] = n2;
        objectArray2[1] = ((FileDownloadMessenger)object2).parcelQueue.size();
        throw new IllegalArgumentException(FileDownloadUtils.formatString("can't handover the message, no master to receive this message(status[%d]) size[%d]", objectArray));
    }

    @Override
    public boolean handoverDirectly() {
        return this.mTask.getOrigin().isSyncCallback();
    }

    @Override
    public void reAppointment(BaseDownloadTask.IRunningTask iRunningTask, BaseDownloadTask.LifeCycleCallback lifeCycleCallback) {
        if (objectArray2.mTask == null) {
            objectArray2.init(iRunningTask, lifeCycleCallback);
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = iRunningTask;
        throw new IllegalStateException(FileDownloadUtils.formatString("the messenger is working, can't re-appointment for %s", objectArray2));
    }

    @Override
    public boolean isBlockingCompleted() {
        return this.parcelQueue.peek().getStatus() == 4;
    }

    @Override
    public void discard() {
        this.mIsDiscard = true;
    }

    public String toString() {
        String string = "%d:%s";
        Object[] objectArray = new Object[2];
        int n2 = 0;
        Object object = this.mTask;
        objectArray[n2] = object = Integer.valueOf(object == null ? -1 : object.getOrigin().getId());
        objectArray[1] = super.toString();
        return FileDownloadUtils.formatString(string, objectArray);
    }
}

