/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import java.util.ArrayList;
import java.util.List;

public class FileDownloadQueueSet {
    private FileDownloadListener target;
    private boolean isSerial;
    private List<BaseDownloadTask.FinishListener> taskFinishListenerList;
    private Integer autoRetryTimes;
    private Boolean syncCallback;
    private Boolean isForceReDownload;
    private Boolean isWifiRequired;
    private Integer callbackProgressTimes;
    private Integer callbackProgressMinIntervalMillis;
    private Object tag;
    private String directory;
    private BaseDownloadTask[] tasks;

    public FileDownloadQueueSet(FileDownloadListener fileDownloadListener) {
        if (fileDownloadListener != null) {
            this.target = fileDownloadListener;
            return;
        }
        throw new IllegalArgumentException("create FileDownloadQueueSet must with valid target!");
    }

    public FileDownloadQueueSet downloadTogether(BaseDownloadTask ... baseDownloadTaskArray) {
        this.isSerial = false;
        this.tasks = baseDownloadTaskArray;
        return this;
    }

    public FileDownloadQueueSet downloadTogether(List<BaseDownloadTask> list) {
        BaseDownloadTask[] baseDownloadTaskArray = baseDownloadTaskArray3;
        BaseDownloadTask[] baseDownloadTaskArray2 = baseDownloadTaskArray3;
        baseDownloadTaskArray3.isSerial = false;
        BaseDownloadTask[] baseDownloadTaskArray3 = new BaseDownloadTask[list.size()];
        baseDownloadTaskArray2.tasks = baseDownloadTaskArray3;
        list.toArray(baseDownloadTaskArray3);
        return baseDownloadTaskArray;
    }

    public FileDownloadQueueSet downloadSequentially(BaseDownloadTask ... baseDownloadTaskArray) {
        this.isSerial = true;
        this.tasks = baseDownloadTaskArray;
        return this;
    }

    public FileDownloadQueueSet downloadSequentially(List<BaseDownloadTask> list) {
        BaseDownloadTask[] baseDownloadTaskArray = baseDownloadTaskArray3;
        BaseDownloadTask[] baseDownloadTaskArray2 = baseDownloadTaskArray3;
        baseDownloadTaskArray3.isSerial = true;
        BaseDownloadTask[] baseDownloadTaskArray3 = new BaseDownloadTask[list.size()];
        baseDownloadTaskArray2.tasks = baseDownloadTaskArray3;
        list.toArray(baseDownloadTaskArray3);
        return baseDownloadTaskArray;
    }

    public void reuseAndStart() {
        BaseDownloadTask[] baseDownloadTaskArray = this.tasks;
        int n2 = this.tasks.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            baseDownloadTaskArray[i2].reuse();
        }
        this.start();
    }

    public void start() {
        BaseDownloadTask[] baseDownloadTaskArray = ((FileDownloadQueueSet)((Object)fileDownloadListener)).tasks;
        int n2 = ((FileDownloadQueueSet)((Object)fileDownloadListener)).tasks.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BaseDownloadTask baseDownloadTask = baseDownloadTaskArray[i2];
            baseDownloadTask.setListener(((FileDownloadQueueSet)((Object)fileDownloadListener)).target);
            Object object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).autoRetryTimes;
            if (object != null) {
                baseDownloadTask.setAutoRetryTimes((Integer)object);
            }
            if ((object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).syncCallback) != null) {
                baseDownloadTask.setSyncCallback((Boolean)object);
            }
            if ((object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).isForceReDownload) != null) {
                baseDownloadTask.setForceReDownload((Boolean)object);
            }
            if ((object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).callbackProgressTimes) != null) {
                baseDownloadTask.setCallbackProgressTimes((Integer)object);
            }
            if ((object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).callbackProgressMinIntervalMillis) != null) {
                baseDownloadTask.setCallbackProgressMinInterval((Integer)object);
            }
            if ((object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).tag) != null) {
                baseDownloadTask.setTag(object);
            }
            if ((object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).taskFinishListenerList) != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    baseDownloadTask.addFinishListener((BaseDownloadTask.FinishListener)object.next());
                }
            }
            if ((object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).directory) != null) {
                baseDownloadTask.setPath((String)object, true);
            }
            if ((object = ((FileDownloadQueueSet)((Object)fileDownloadListener)).isWifiRequired) != null) {
                baseDownloadTask.setWifiRequired((Boolean)object);
            }
            baseDownloadTask.asInQueueTask().enqueue();
        }
        FileDownloadQueueSet fileDownloadQueueSet = fileDownloadListener;
        FileDownloadListener fileDownloadListener = fileDownloadQueueSet.target;
        FileDownloader.getImpl().start(fileDownloadListener, fileDownloadQueueSet.isSerial);
    }

    public FileDownloadQueueSet setDirectory(String string) {
        this.directory = string;
        return this;
    }

    public FileDownloadQueueSet setAutoRetryTimes(int n2) {
        this.autoRetryTimes = n2;
        return this;
    }

    public FileDownloadQueueSet setSyncCallback(boolean bl) {
        this.syncCallback = bl;
        return this;
    }

    public FileDownloadQueueSet setForceReDownload(boolean bl) {
        this.isForceReDownload = bl;
        return this;
    }

    public FileDownloadQueueSet setCallbackProgressTimes(int n2) {
        this.callbackProgressTimes = n2;
        return this;
    }

    public FileDownloadQueueSet setCallbackProgressMinInterval(int n2) {
        this.callbackProgressMinIntervalMillis = n2;
        return this;
    }

    public FileDownloadQueueSet ignoreEachTaskInternalProgress() {
        FileDownloadQueueSet fileDownloadQueueSet = this;
        fileDownloadQueueSet.setCallbackProgressTimes(-1);
        return fileDownloadQueueSet;
    }

    public FileDownloadQueueSet disableCallbackProgressTimes() {
        return this.setCallbackProgressTimes(0);
    }

    public FileDownloadQueueSet setTag(Object object) {
        this.tag = object;
        return this;
    }

    public FileDownloadQueueSet addTaskFinishListener(BaseDownloadTask.FinishListener finishListener) {
        if (this.taskFinishListenerList == null) {
            ArrayList<BaseDownloadTask.FinishListener> arrayList;
            ArrayList<BaseDownloadTask.FinishListener> arrayList2 = arrayList;
            arrayList = new ArrayList<BaseDownloadTask.FinishListener>();
            this.taskFinishListenerList = arrayList2;
        }
        FileDownloadQueueSet fileDownloadQueueSet = this;
        fileDownloadQueueSet.taskFinishListenerList.add(finishListener);
        return fileDownloadQueueSet;
    }

    public FileDownloadQueueSet setWifiRequired(boolean bl) {
        this.isWifiRequired = bl;
        return this;
    }
}

