/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.app.Notification;
import android.os.IBinder;
import android.os.RemoteException;
import com.liulishuo.filedownloader.i.IFileDownloadIPCCallback;
import com.liulishuo.filedownloader.i.IFileDownloadIPCService;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.services.BaseFileServiceUIGuard;
import com.liulishuo.filedownloader.services.FileDownloadService;
import com.liulishuo.filedownloader.util.DownloadServiceNotConnectedHelper;

class FileDownloadServiceUIGuard
extends BaseFileServiceUIGuard<FileDownloadServiceCallback, IFileDownloadIPCService> {
    public FileDownloadServiceUIGuard() {
        super(FileDownloadService.SeparateProcessService.class);
    }

    @Override
    public FileDownloadServiceCallback createCallback() {
        return new FileDownloadServiceCallback();
    }

    @Override
    public IFileDownloadIPCService asInterface(IBinder iBinder) {
        return IFileDownloadIPCService.Stub.asInterface(iBinder);
    }

    @Override
    public void registerCallback(IFileDownloadIPCService iFileDownloadIPCService, FileDownloadServiceCallback fileDownloadServiceCallback) throws RemoteException {
        iFileDownloadIPCService.registerCallback(fileDownloadServiceCallback);
    }

    @Override
    public void unregisterCallback(IFileDownloadIPCService iFileDownloadIPCService, FileDownloadServiceCallback fileDownloadServiceCallback) throws RemoteException {
        iFileDownloadIPCService.unregisterCallback(fileDownloadServiceCallback);
    }

    @Override
    public boolean start(String string, String string2, boolean bl, int n2, int n3, int n4, boolean bl2, FileDownloadHeader fileDownloadHeader, boolean bl3) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.start(string, string2, bl);
        }
        try {
            ((IFileDownloadIPCService)this.getService()).start(string, string2, bl, n2, n3, n4, bl2, fileDownloadHeader, bl3);
            return true;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean pause(int n2) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.pause(n2);
        }
        try {
            return ((IFileDownloadIPCService)this.getService()).pause(n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isDownloading(String string, String string2) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.isDownloading(string, string2);
        }
        try {
            return ((IFileDownloadIPCService)this.getService()).checkDownloading(string, string2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return false;
        }
    }

    @Override
    public long getSofar(int n2) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getSofar(n2);
        }
        long l2 = 0L;
        try {
            l2 = ((IFileDownloadIPCService)this.getService()).getSofar(n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return l2;
    }

    @Override
    public long getTotal(int n2) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getTotal(n2);
        }
        long l2 = 0L;
        try {
            l2 = ((IFileDownloadIPCService)this.getService()).getTotal(n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return l2;
    }

    @Override
    public byte getStatus(int n2) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getStatus(n2);
        }
        byte by = 0;
        try {
            by = ((IFileDownloadIPCService)this.getService()).getStatus(n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return by;
    }

    @Override
    public void pauseAllTasks() {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.pauseAllTasks();
            return;
        }
        try {
            ((IFileDownloadIPCService)this.getService()).pauseAllTasks();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    @Override
    public boolean isIdle() {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.isIdle();
        }
        try {
            ((IFileDownloadIPCService)this.getService()).isIdle();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return true;
    }

    @Override
    public void startForeground(int n2, Notification notification) {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.startForeground(n2, notification);
            return;
        }
        try {
            ((IFileDownloadIPCService)this.getService()).startForeground(n2, notification);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stopForeground(boolean bl) {
        Throwable throwable2;
        block5: {
            if (!this.isConnected()) {
                DownloadServiceNotConnectedHelper.stopForeground(bl);
                return;
            }
            ((IFileDownloadIPCService)this.getService()).stopForeground(bl);
            this.runServiceForeground = false;
            return;
            {
                catch (Throwable throwable2) {
                    break block5;
                }
                catch (RemoteException remoteException) {}
                {
                    remoteException.printStackTrace();
                    this.runServiceForeground = false;
                }
            }
            return;
        }
        this.runServiceForeground = false;
        throw throwable2;
    }

    @Override
    public boolean setMaxNetworkThreadCount(int n2) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.setMaxNetworkThreadCount(n2);
        }
        try {
            return ((IFileDownloadIPCService)this.getService()).setMaxNetworkThreadCount(n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean clearTaskData(int n2) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.clearTaskData(n2);
        }
        try {
            return ((IFileDownloadIPCService)this.getService()).clearTaskData(n2);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return false;
        }
    }

    @Override
    public void clearAllTaskData() {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.clearAllTaskData();
            return;
        }
        try {
            ((IFileDownloadIPCService)this.getService()).clearAllTaskData();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public static class FileDownloadServiceCallback
    extends IFileDownloadIPCCallback.Stub {
        @Override
        public void callback(MessageSnapshot messageSnapshot) throws RemoteException {
            MessageSnapshotFlow.getImpl().inflow(messageSnapshot);
        }
    }
}

