/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.ITaskHunter;
import com.liulishuo.filedownloader.MessageSnapshotGate;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

class FileDownloadTaskLauncher {
    private final LaunchTaskPool mLaunchTaskPool;

    public FileDownloadTaskLauncher() {
        LaunchTaskPool launchTaskPool;
        LaunchTaskPool launchTaskPool2 = launchTaskPool;
        launchTaskPool = new LaunchTaskPool();
        v1.mLaunchTaskPool = launchTaskPool2;
    }

    public static FileDownloadTaskLauncher getImpl() {
        return HolderClass.INSTANCE;
    }

    public synchronized void launch(ITaskHunter.IStarter iStarter) {
        this.mLaunchTaskPool.asyncExecute(iStarter);
    }

    public synchronized void expireAll() {
        this.mLaunchTaskPool.expireAll();
    }

    public synchronized void expire(ITaskHunter.IStarter iStarter) {
        this.mLaunchTaskPool.expire(iStarter);
    }

    public synchronized void expire(FileDownloadListener fileDownloadListener) {
        this.mLaunchTaskPool.expire(fileDownloadListener);
    }

    public static class LaunchTaskRunnable
    implements Runnable {
        private final ITaskHunter.IStarter mTaskStarter;
        private boolean mExpired;

        public LaunchTaskRunnable(ITaskHunter.IStarter iStarter) {
            this.mTaskStarter = iStarter;
            this.mExpired = false;
        }

        @Override
        public void run() {
            if (this.mExpired) {
                return;
            }
            this.mTaskStarter.start();
        }

        public boolean isSameListener(FileDownloadListener fileDownloadListener) {
            ITaskHunter.IStarter iStarter = ((LaunchTaskRunnable)((Object)iStarter)).mTaskStarter;
            return iStarter != null && iStarter.equalListener(fileDownloadListener);
        }

        public boolean equals(Object object) {
            return super.equals(object) || object == this.mTaskStarter;
        }

        public void expire() {
            this.mExpired = true;
        }
    }

    public static class LaunchTaskPool {
        private ThreadPoolExecutor mPool;
        private LinkedBlockingQueue<Runnable> mWorkQueue;

        public LaunchTaskPool() {
            LaunchTaskPool launchTaskPool = this;
            launchTaskPool.init();
        }

        private void init() {
            LinkedBlockingQueue linkedBlockingQueue;
            LaunchTaskPool launchTaskPool = linkedBlockingQueue2;
            LinkedBlockingQueue linkedBlockingQueue2 = linkedBlockingQueue;
            launchTaskPool.mWorkQueue = new LinkedBlockingQueue();
            launchTaskPool.mPool = FileDownloadExecutors.newDefaultThreadPool(3, linkedBlockingQueue2, "LauncherTask");
        }

        public void asyncExecute(ITaskHunter.IStarter iStarter) {
            this.mPool.execute(new LaunchTaskRunnable(iStarter));
        }

        public void expire(ITaskHunter.IStarter iStarter) {
            this.mWorkQueue.remove(iStarter);
        }

        public void expire(FileDownloadListener object) {
            ArrayList<Runnable> arrayList;
            if (object == null) {
                FileDownloadLog.w(this, "want to expire by listener, but the listener provided is null", new Object[0]);
                return;
            }
            Object object2 = arrayList;
            arrayList = new ArrayList<Runnable>();
            for (Runnable runnable : this.mWorkQueue) {
                LaunchTaskRunnable launchTaskRunnable = (LaunchTaskRunnable)runnable;
                if (!launchTaskRunnable.isSameListener((FileDownloadListener)object)) continue;
                launchTaskRunnable.expire();
                ((ArrayList)object2).add(runnable);
            }
            if (((ArrayList)object2).isEmpty()) {
                return;
            }
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = ((ArrayList)object2).size();
                objectArray[1] = object;
                FileDownloadLog.d(this, "expire %d tasks with listener[%s]", objectArray2);
            }
            object = ((ArrayList)object2).iterator();
            while (object.hasNext()) {
                object2 = (Runnable)object.next();
                this.mPool.remove((Runnable)object2);
            }
        }

        public void expireAll() {
            if (FileDownloadLog.NEED_LOG) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = this.mWorkQueue.size();
                FileDownloadLog.d(this, "expire %d tasks", objectArray2);
            }
            LaunchTaskPool launchTaskPool = this;
            launchTaskPool.mPool.shutdownNow();
            launchTaskPool.init();
        }
    }

    public static class HolderClass {
        private static final FileDownloadTaskLauncher INSTANCE = new FileDownloadTaskLauncher();

        private HolderClass() {
        }

        static {
            MessageSnapshotFlow.getImpl().setReceiver(new MessageSnapshotGate());
        }
    }
}

