/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.app.Application;
import android.app.Notification;
import android.content.Context;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadTask;
import com.liulishuo.filedownloader.FileDownloadConnectListener;
import com.liulishuo.filedownloader.FileDownloadEventPool;
import com.liulishuo.filedownloader.FileDownloadLine;
import com.liulishuo.filedownloader.FileDownloadLineAsync;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloadMessageStation;
import com.liulishuo.filedownloader.FileDownloadServiceProxy;
import com.liulishuo.filedownloader.FileDownloadTaskLauncher;
import com.liulishuo.filedownloader.ILostServiceConnectedHandler;
import com.liulishuo.filedownloader.IQueuesHandler;
import com.liulishuo.filedownloader.LostServiceConnectedHandler;
import com.liulishuo.filedownloader.PauseAllMarker;
import com.liulishuo.filedownloader.QueuesHandler;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.model.FileDownloadTaskAtom;
import com.liulishuo.filedownloader.services.DownloadMgrInitialParams;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class FileDownloader {
    private static final Object INIT_QUEUES_HANDLER_LOCK = new Object();
    private static final Object INIT_LOST_CONNECTED_HANDLER_LOCK = new Object();
    private IQueuesHandler mQueuesHandler;
    private ILostServiceConnectedHandler mLostConnectedHandler;

    public static void setup(Context context) {
        FileDownloadHelper.holdContext(context.getApplicationContext());
    }

    public static DownloadMgrInitialParams.InitCustomMaker setupOnApplicationOnCreate(Application object) {
        DownloadMgrInitialParams.InitCustomMaker initCustomMaker;
        FileDownloadHelper.holdContext(object.getApplicationContext());
        object = initCustomMaker;
        initCustomMaker = new DownloadMgrInitialParams.InitCustomMaker();
        CustomComponentHolder.getImpl().setInitCustomMaker((DownloadMgrInitialParams.InitCustomMaker)object);
        return initCustomMaker;
    }

    public static void init(Context context) {
        if (context != null) {
            FileDownloader.setup(context);
            return;
        }
        throw new IllegalArgumentException("the provided context must not be null!");
    }

    public static void init(Context context, DownloadMgrInitialParams.InitCustomMaker initCustomMaker) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = context;
            objectArray[1] = initCustomMaker;
            FileDownloadLog.d(FileDownloader.class, "init Downloader with params: %s %s", objectArray2);
        }
        if (context != null) {
            FileDownloadHelper.holdContext(context.getApplicationContext());
            CustomComponentHolder.getImpl().setInitCustomMaker(initCustomMaker);
            return;
        }
        throw new IllegalArgumentException("the provided context must not be null!");
    }

    public static FileDownloader getImpl() {
        return HolderClass.INSTANCE;
    }

    public static void setGlobalPost2UIInterval(int n2) {
        FileDownloadMessageStation.INTERVAL = n2;
    }

    public static void setGlobalHandleSubPackageSize(int n2) {
        if (n2 > 0) {
            FileDownloadMessageStation.SUB_PACKAGE_SIZE = n2;
            return;
        }
        throw new IllegalArgumentException("sub package size must more than 0");
    }

    public static void enableAvoidDropFrame() {
        FileDownloader.setGlobalPost2UIInterval(10);
    }

    public static void disableAvoidDropFrame() {
        FileDownloader.setGlobalPost2UIInterval(-1);
    }

    public static boolean isEnabledAvoidDropFrame() {
        return FileDownloadMessageStation.isIntervalValid();
    }

    public BaseDownloadTask create(String string) {
        return new DownloadTask(string);
    }

    public boolean start(FileDownloadListener fileDownloadListener, boolean bl) {
        if (fileDownloadListener == null) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = bl;
            FileDownloadLog.w(objectArray, "Tasks with the listener can't start, because the listener provided is null: [null, %B]", objectArray3);
            return false;
        }
        return bl ? objectArray3.getQueuesHandler().startQueueSerial(fileDownloadListener) : objectArray3.getQueuesHandler().startQueueParallel(fileDownloadListener);
    }

    public void pause(FileDownloadListener fileDownloadListener) {
        FileDownloadTaskLauncher.getImpl().expire(fileDownloadListener);
        Iterator<BaseDownloadTask.IRunningTask> iterator = FileDownloadList.getImpl().copy(fileDownloadListener).iterator();
        while (iterator.hasNext()) {
            ((BaseDownloadTask.IRunningTask)iterator.next()).getOrigin().pause();
        }
    }

    public void pauseAll() {
        FileDownloadTaskLauncher.getImpl().expireAll();
        BaseDownloadTask.IRunningTask[] iRunningTaskArray = FileDownloadList.getImpl().copy();
        int n2 = iRunningTaskArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            iRunningTaskArray[i2].getOrigin().pause();
        }
        if (FileDownloadServiceProxy.getImpl().isConnected()) {
            FileDownloadServiceProxy.getImpl().pauseAllTasks();
        } else {
            PauseAllMarker.createMarker();
        }
    }

    public int pause(int n2) {
        Object object;
        List<BaseDownloadTask.IRunningTask> list = FileDownloadList.getImpl().getDownloadingList(n2);
        if (list != null && !list.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                ((BaseDownloadTask.IRunningTask)object.next()).getOrigin().pause();
            }
            return list.size();
        }
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[1];
        object = objectArray2;
        objectArray2[0] = n2;
        FileDownloadLog.w(objectArray, "request pause but not exist %d", (Object[])object);
        return 0;
    }

    public boolean clear(int n2, String string) {
        ((FileDownloader)object).pause(n2);
        if (FileDownloadServiceProxy.getImpl().clearTaskData(n2)) {
            File file;
            File file2;
            Object object = file2;
            if (new File(FileDownloadUtils.getTempPath(string)).exists()) {
                ((File)object).delete();
            }
            object = file;
            if (new File(string).exists()) {
                ((File)object).delete();
            }
            return true;
        }
        return false;
    }

    public void clearAllTaskData() {
        this.pauseAll();
        FileDownloadServiceProxy.getImpl().clearAllTaskData();
    }

    public long getSoFar(int n2) {
        BaseDownloadTask.IRunningTask iRunningTask = FileDownloadList.getImpl().get(n2);
        if (iRunningTask == null) {
            return FileDownloadServiceProxy.getImpl().getSofar(n2);
        }
        return iRunningTask.getOrigin().getLargeFileSoFarBytes();
    }

    public long getTotal(int n2) {
        BaseDownloadTask.IRunningTask iRunningTask = FileDownloadList.getImpl().get(n2);
        if (iRunningTask == null) {
            return FileDownloadServiceProxy.getImpl().getTotal(n2);
        }
        return iRunningTask.getOrigin().getLargeFileTotalBytes();
    }

    public byte getStatusIgnoreCompleted(int n2) {
        return this.getStatus(n2, null);
    }

    public byte getStatus(String string, String string2) {
        return this.getStatus(FileDownloadUtils.generateId(string, string2), string2);
    }

    public byte getStatus(int n2, String string) {
        BaseDownloadTask.IRunningTask iRunningTask = FileDownloadList.getImpl().get(n2);
        int n3 = iRunningTask == null ? FileDownloadServiceProxy.getImpl().getStatus(n2) : iRunningTask.getOrigin().getStatus();
        if (string != null && n3 == 0 && FileDownloadUtils.isFilenameConverted(FileDownloadHelper.getAppContext()) && new File(string).exists()) {
            n3 = -3;
        }
        return (byte)n3;
    }

    public int replaceListener(String string, FileDownloadListener fileDownloadListener) {
        String string2 = string;
        return this.replaceListener(string2, FileDownloadUtils.getDefaultSaveFilePath(string2), fileDownloadListener);
    }

    public int replaceListener(String string, String string2, FileDownloadListener fileDownloadListener) {
        return this.replaceListener(FileDownloadUtils.generateId(string, string2), fileDownloadListener);
    }

    public int replaceListener(int n2, FileDownloadListener fileDownloadListener) {
        BaseDownloadTask.IRunningTask iRunningTask = FileDownloadList.getImpl().get(n2);
        if (iRunningTask == null) {
            return 0;
        }
        BaseDownloadTask.IRunningTask iRunningTask2 = iRunningTask;
        iRunningTask2.getOrigin().setListener(fileDownloadListener);
        return iRunningTask2.getOrigin().getId();
    }

    public void bindService() {
        if (!this.isServiceConnected()) {
            FileDownloadServiceProxy.getImpl().bindStartByContext(FileDownloadHelper.getAppContext());
        }
    }

    public void bindService(Runnable runnable) {
        if (this.isServiceConnected()) {
            runnable.run();
        } else {
            FileDownloadServiceProxy.getImpl().bindStartByContext(FileDownloadHelper.getAppContext(), runnable);
        }
    }

    public void unBindService() {
        if (this.isServiceConnected()) {
            FileDownloadServiceProxy.getImpl().unbindByContext(FileDownloadHelper.getAppContext());
        }
    }

    public boolean unBindServiceIfIdle() {
        if (!this.isServiceConnected()) {
            return false;
        }
        if (FileDownloadList.getImpl().isEmpty() && FileDownloadServiceProxy.getImpl().isIdle()) {
            this.unBindService();
            return true;
        }
        return false;
    }

    public boolean isServiceConnected() {
        return FileDownloadServiceProxy.getImpl().isConnected();
    }

    public void addServiceConnectListener(FileDownloadConnectListener fileDownloadConnectListener) {
        FileDownloadEventPool.getImpl().addListener("event.service.connect.changed", fileDownloadConnectListener);
    }

    public void removeServiceConnectListener(FileDownloadConnectListener fileDownloadConnectListener) {
        FileDownloadEventPool.getImpl().removeListener("event.service.connect.changed", fileDownloadConnectListener);
    }

    public void startForeground(int n2, Notification notification) {
        FileDownloadServiceProxy.getImpl().startForeground(n2, notification);
    }

    public void stopForeground(boolean bl) {
        FileDownloadServiceProxy.getImpl().stopForeground(bl);
    }

    public boolean setTaskCompleted(String string, String string2, long l2) {
        FileDownloadLog.w(this, "If you invoked this method, please remove it directly feel free, it doesn't need any longer", new Object[0]);
        return true;
    }

    public boolean setTaskCompleted(List<FileDownloadTaskAtom> list) {
        FileDownloadLog.w(this, "If you invoked this method, please remove it directly feel free, it doesn't need any longer", new Object[0]);
        return true;
    }

    public boolean setMaxNetworkThreadCount(int n2) {
        if (!FileDownloadList.getImpl().isEmpty()) {
            FileDownloadLog.w(this, "Can't change the max network thread count, because there are actively executing tasks in FileDownloader, please try again after all actively executing tasks are completed or invoking FileDownloader#pauseAll directly.", new Object[0]);
            return false;
        }
        return FileDownloadServiceProxy.getImpl().setMaxNetworkThreadCount(n2);
    }

    public FileDownloadLine insureServiceBind() {
        return new FileDownloadLine();
    }

    public FileDownloadLineAsync insureServiceBindAsync() {
        return new FileDownloadLineAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQueuesHandler getQueuesHandler() {
        block5: {
            if (this.mQueuesHandler != null) break block5;
            Object object = INIT_QUEUES_HANDLER_LOCK;
            synchronized (object) {
                QueuesHandler queuesHandler;
                if (this.mQueuesHandler != null) break block5;
                FileDownloader fileDownloader = this;
                QueuesHandler queuesHandler2 = queuesHandler;
                queuesHandler = new QueuesHandler();
                fileDownloader.mQueuesHandler = queuesHandler2;
            }
        }
        return this.mQueuesHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILostServiceConnectedHandler getLostConnectedHandler() {
        block5: {
            if (this.mLostConnectedHandler != null) break block5;
            Object object = INIT_LOST_CONNECTED_HANDLER_LOCK;
            synchronized (object) {
                LostServiceConnectedHandler lostServiceConnectedHandler;
                if (this.mLostConnectedHandler != null) break block5;
                FileDownloader fileDownloader = this;
                FileDownloader fileDownloader2 = fileDownloader;
                FileDownloader fileDownloader3 = fileDownloader;
                LostServiceConnectedHandler lostServiceConnectedHandler2 = lostServiceConnectedHandler;
                fileDownloader2.mLostConnectedHandler = new LostServiceConnectedHandler();
                fileDownloader3.addServiceConnectListener(lostServiceConnectedHandler2);
            }
        }
        return this.mLostConnectedHandler;
    }

    public static final class HolderClass {
        private static final FileDownloader INSTANCE = new FileDownloader();

        private HolderClass() {
        }
    }
}

