/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.connection;

import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public class FileDownloadUrlConnection
implements FileDownloadConnection {
    public URLConnection mConnection;

    public FileDownloadUrlConnection(String string, Configuration configuration) throws IOException {
        URL uRL;
        FileDownloadUrlConnection fileDownloadUrlConnection = uRL2;
        URL uRL2 = uRL;
        uRL = new URL(string);
        fileDownloadUrlConnection(uRL2, configuration);
    }

    public FileDownloadUrlConnection(URL uRL, Configuration configuration) throws IOException {
        this.mConnection = configuration != null && configuration.proxy != null ? uRL.openConnection(configuration.proxy) : uRL.openConnection();
        if (configuration != null) {
            if (configuration.readTimeout != null) {
                this.mConnection.setReadTimeout(configuration.readTimeout);
            }
            if (configuration.connectTimeout != null) {
                this.mConnection.setConnectTimeout(configuration.connectTimeout);
            }
        }
    }

    public FileDownloadUrlConnection(String string) throws IOException {
        this(string, null);
    }

    @Override
    public void addHeader(String string, String string2) {
        this.mConnection.addRequestProperty(string, string2);
    }

    @Override
    public boolean dispatchAddResumeOffset(String string, long l2) {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mConnection.getInputStream();
    }

    @Override
    public Map<String, List<String>> getRequestHeaderFields() {
        return this.mConnection.getRequestProperties();
    }

    @Override
    public Map<String, List<String>> getResponseHeaderFields() {
        return this.mConnection.getHeaderFields();
    }

    @Override
    public String getResponseHeaderField(String string) {
        return this.mConnection.getHeaderField(string);
    }

    @Override
    public boolean setRequestMethod(String string) throws ProtocolException {
        URLConnection uRLConnection = ((FileDownloadUrlConnection)((Object)uRLConnection)).mConnection;
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).setRequestMethod(string);
            return true;
        }
        return false;
    }

    @Override
    public void execute() throws IOException {
        this.mConnection.connect();
    }

    @Override
    public int getResponseCode() throws IOException {
        URLConnection uRLConnection = ((FileDownloadUrlConnection)((Object)uRLConnection)).mConnection;
        if (uRLConnection instanceof HttpURLConnection) {
            return ((HttpURLConnection)uRLConnection).getResponseCode();
        }
        return 0;
    }

    @Override
    public void ending() {
        try {
            this.mConnection.getInputStream().close();
        }
        catch (IOException iOException) {}
    }

    public static class Configuration {
        private Proxy proxy;
        private Integer readTimeout;
        private Integer connectTimeout;

        public Configuration proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Configuration readTimeout(int n2) {
            this.readTimeout = n2;
            return this;
        }

        public Configuration connectTimeout(int n2) {
            this.connectTimeout = n2;
            return this;
        }
    }

    public static class Creator
    implements FileDownloadHelper.ConnectionCreator {
        private final Configuration mConfiguration;

        public Creator() {
            this(null);
        }

        public Creator(Configuration configuration) {
            this.mConfiguration = configuration;
        }

        public FileDownloadConnection create(URL uRL) throws IOException {
            return new FileDownloadUrlConnection(uRL, this.mConfiguration);
        }

        @Override
        public FileDownloadConnection create(String string) throws IOException {
            return new FileDownloadUrlConnection(string, this.mConfiguration);
        }
    }
}

