/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.database;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.SparseArray;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.database.NoDatabaseImpl;
import com.liulishuo.filedownloader.database.SqliteDatabaseImpl;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class RemitDatabase
implements FileDownloadDatabase {
    private static final int WHAT_CLEAN_LOCK = 0;
    private final NoDatabaseImpl cachedDatabase;
    private final SqliteDatabaseImpl realDatabase;
    private Handler handler;
    private final long minInterval;
    private final List<Integer> freeToDBIdList = new ArrayList<Integer>();
    private AtomicInteger handlingId = new AtomicInteger();
    private volatile Thread parkThread;

    public RemitDatabase() {
        HandlerThread handlerThread;
        this.cachedDatabase = new NoDatabaseImpl();
        this.realDatabase = new SqliteDatabaseImpl();
        this.minInterval = FileDownloadProperties.getImpl().downloadMinProgressTime;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(FileDownloadUtils.getThreadPoolName("RemitHandoverToDB")).start();
        this.handler = new Handler(handlerThread2.getLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                1 v3;
                1 v2;
                int n2 = message.what;
                if (n2 == 0) {
                    if (RemitDatabase.this.parkThread != null) {
                        1 v0 = this;
                        LockSupport.unpark(v0.RemitDatabase.this.parkThread);
                        RemitDatabase.access$002(v0.RemitDatabase.this, null);
                    }
                    return false;
                }
                try {
                    1 v1 = this;
                    v2 = v1;
                    v3 = v1;
                    v1.RemitDatabase.this.handlingId.set(n2);
                    v1.RemitDatabase.this.syncCacheToDB(n2);
                    v1.RemitDatabase.this.freeToDBIdList.add(n2);
                }
                catch (Throwable throwable) {
                    1 v4 = this;
                    v4.RemitDatabase.this.handlingId.set(0);
                    if (v4.RemitDatabase.this.parkThread != null) {
                        1 v5 = this;
                        LockSupport.unpark(v5.RemitDatabase.this.parkThread);
                        RemitDatabase.access$002(v5.RemitDatabase.this, null);
                    }
                    throw throwable;
                }
                v3.RemitDatabase.this.handlingId.set(0);
                if (v2.RemitDatabase.this.parkThread != null) {
                    1 v6 = this;
                    LockSupport.unpark(v6.RemitDatabase.this.parkThread);
                    RemitDatabase.access$002(v6.RemitDatabase.this, null);
                }
                return false;
            }
        });
    }

    private void syncCacheToDB(int n2) {
        if (FileDownloadLog.NEED_LOG) {
            Object[] objectArray = new Object[1];
            Object[] object = objectArray;
            objectArray[0] = n2;
            FileDownloadLog.d(this, "sync cache to db %d", object);
        }
        RemitDatabase remitDatabase = this;
        remitDatabase.realDatabase.update(this.cachedDatabase.find(n2));
        List<ConnectionModel> list = remitDatabase.cachedDatabase.findConnectionModel(n2);
        this.realDatabase.removeConnections(n2);
        for (ConnectionModel connectionModel : list) {
            this.realDatabase.insertConnectionModel(connectionModel);
        }
    }

    private boolean isNoNeedUpdateToRealDB(int n2) {
        return this.freeToDBIdList.contains(n2) ^ true;
    }

    private void ensureCacheToDB(int n2) {
        RemitDatabase remitDatabase = this;
        remitDatabase.handler.removeMessages(n2);
        if (remitDatabase.handlingId.get() == n2) {
            this.parkThread = Thread.currentThread();
            this.handler.sendEmptyMessage(0);
            LockSupport.park();
        } else {
            this.syncCacheToDB(n2);
        }
    }

    public static /* synthetic */ Thread access$002(RemitDatabase remitDatabase, Thread thread) {
        remitDatabase.parkThread = thread;
        return thread;
    }

    @Override
    public void onTaskStart(int n2) {
        this.handler.sendEmptyMessageDelayed(n2, this.minInterval);
    }

    @Override
    public FileDownloadModel find(int n2) {
        return this.cachedDatabase.find(n2);
    }

    @Override
    public List<ConnectionModel> findConnectionModel(int n2) {
        return this.cachedDatabase.findConnectionModel(n2);
    }

    @Override
    public void removeConnections(int n2) {
        this.cachedDatabase.removeConnections(n2);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            return;
        }
        this.realDatabase.removeConnections(n2);
    }

    @Override
    public void insertConnectionModel(ConnectionModel connectionModel) {
        this.cachedDatabase.insertConnectionModel(connectionModel);
        if (this.isNoNeedUpdateToRealDB(connectionModel.getId())) {
            return;
        }
        this.realDatabase.insertConnectionModel(connectionModel);
    }

    @Override
    public void updateConnectionModel(int n2, int n3, long l2) {
        this.cachedDatabase.updateConnectionModel(n2, n3, l2);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            return;
        }
        this.realDatabase.updateConnectionModel(n2, n3, l2);
    }

    @Override
    public void updateProgress(int n2, long l2) {
        this.cachedDatabase.updateProgress(n2, l2);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            return;
        }
        this.realDatabase.updateProgress(n2, l2);
    }

    @Override
    public void updateConnectionCount(int n2, int n3) {
        this.cachedDatabase.updateConnectionCount(n2, n3);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            return;
        }
        this.realDatabase.updateConnectionCount(n2, n3);
    }

    @Override
    public void insert(FileDownloadModel fileDownloadModel) {
        this.cachedDatabase.insert(fileDownloadModel);
        if (this.isNoNeedUpdateToRealDB(fileDownloadModel.getId())) {
            return;
        }
        this.realDatabase.insert(fileDownloadModel);
    }

    @Override
    public void update(FileDownloadModel fileDownloadModel) {
        this.cachedDatabase.update(fileDownloadModel);
        if (this.isNoNeedUpdateToRealDB(fileDownloadModel.getId())) {
            return;
        }
        this.realDatabase.update(fileDownloadModel);
    }

    @Override
    public boolean remove(int n2) {
        RemitDatabase remitDatabase = this;
        remitDatabase.realDatabase.remove(n2);
        return remitDatabase.cachedDatabase.remove(n2);
    }

    @Override
    public void clear() {
        RemitDatabase remitDatabase = this;
        remitDatabase.cachedDatabase.clear();
        remitDatabase.realDatabase.clear();
    }

    @Override
    public void updateOldEtagOverdue(int n2, String string, long l2, long l3, int n3) {
        this.cachedDatabase.updateOldEtagOverdue(n2, string, l2, l3, n3);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            return;
        }
        this.realDatabase.updateOldEtagOverdue(n2, string, l2, l3, n3);
    }

    @Override
    public void updateConnected(int n2, long l2, String string, String string2) {
        this.cachedDatabase.updateConnected(n2, l2, string, string2);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            return;
        }
        this.realDatabase.updateConnected(n2, l2, string, string2);
    }

    @Override
    public void updatePending(int n2) {
        this.cachedDatabase.updatePending(n2);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            return;
        }
        this.realDatabase.updatePending(n2);
    }

    @Override
    public void updateRetry(int n2, Throwable throwable) {
        this.cachedDatabase.updateRetry(n2, throwable);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            return;
        }
        this.realDatabase.updateRetry(n2, throwable);
    }

    @Override
    public void updateError(int n2, Throwable throwable, long l2) {
        this.cachedDatabase.updateError(n2, throwable, l2);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            this.ensureCacheToDB(n2);
        }
        RemitDatabase remitDatabase = this;
        remitDatabase.realDatabase.updateError(n2, throwable, l2);
        remitDatabase.freeToDBIdList.remove((Object)n2);
    }

    @Override
    public void updateCompleted(int n2, long l2) {
        this.cachedDatabase.updateCompleted(n2, l2);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            RemitDatabase remitDatabase = this;
            remitDatabase.handler.removeMessages(n2);
            if (remitDatabase.handlingId.get() == n2) {
                RemitDatabase remitDatabase2 = this;
                remitDatabase2.parkThread = Thread.currentThread();
                remitDatabase2.handler.sendEmptyMessage(0);
                LockSupport.park();
                remitDatabase2.realDatabase.updateCompleted(n2, l2);
            }
        } else {
            this.realDatabase.updateCompleted(n2, l2);
        }
        this.freeToDBIdList.remove((Object)n2);
    }

    @Override
    public void updatePause(int n2, long l2) {
        this.cachedDatabase.updatePause(n2, l2);
        if (this.isNoNeedUpdateToRealDB(n2)) {
            this.ensureCacheToDB(n2);
        }
        RemitDatabase remitDatabase = this;
        remitDatabase.realDatabase.updatePause(n2, l2);
        remitDatabase.freeToDBIdList.remove((Object)n2);
    }

    @Override
    public FileDownloadDatabase.Maintainer maintainer() {
        NoDatabaseImpl noDatabaseImpl = sparseArray.cachedDatabase;
        SparseArray<FileDownloadModel> sparseArray = noDatabaseImpl.downloaderModelMap;
        return sparseArray.realDatabase.maintainer(sparseArray, noDatabaseImpl.connectionModelListMap);
    }

    public static class Maker
    implements FileDownloadHelper.DatabaseCustomMaker {
        @Override
        public FileDownloadDatabase customMake() {
            return new RemitDatabase();
        }
    }
}

