/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.SparseArray;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.database.SqliteDatabaseOpenHelper;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SqliteDatabaseImpl
implements FileDownloadDatabase {
    public static final String TABLE_NAME = "filedownloader";
    public static final String CONNECTION_TABLE_NAME = "filedownloaderConnection";
    private final SQLiteDatabase db = new SqliteDatabaseOpenHelper(FileDownloadHelper.getAppContext()).getWritableDatabase();

    public static Maker createMaker() {
        return new Maker();
    }

    private void update(int n2, ContentValues contentValues) {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = String.valueOf(n2);
        stringArray2.db.update(TABLE_NAME, contentValues, "_id = ? ", stringArray2);
    }

    private static FileDownloadModel createFromCursor(Cursor cursor) {
        FileDownloadModel fileDownloadModel;
        Cursor cursor2 = cursor;
        FileDownloadModel fileDownloadModel2 = fileDownloadModel;
        Cursor cursor3 = cursor;
        Cursor cursor4 = cursor;
        fileDownloadModel2();
        fileDownloadModel2.setId(cursor4.getInt(cursor4.getColumnIndex("_id")));
        fileDownloadModel.setUrl(cursor3.getString(cursor3.getColumnIndex("url")));
        String string = cursor2.getString(cursor2.getColumnIndex("path"));
        boolean bl = cursor2.getShort(cursor2.getColumnIndex("pathAsDirectory")) == 1;
        FileDownloadModel fileDownloadModel3 = fileDownloadModel2;
        Cursor cursor5 = cursor;
        Cursor cursor6 = cursor;
        Cursor cursor7 = cursor;
        Cursor cursor8 = cursor;
        Cursor cursor9 = cursor;
        Cursor cursor10 = cursor;
        Cursor cursor11 = cursor;
        fileDownloadModel2.setPath(string, bl);
        fileDownloadModel2.setStatus((byte)cursor11.getShort(cursor11.getColumnIndex("status")));
        fileDownloadModel2.setSoFar(cursor10.getLong(cursor10.getColumnIndex("sofar")));
        fileDownloadModel2.setTotal(cursor9.getLong(cursor9.getColumnIndex("total")));
        fileDownloadModel2.setErrMsg(cursor8.getString(cursor8.getColumnIndex("errMsg")));
        fileDownloadModel2.setETag(cursor7.getString(cursor7.getColumnIndex("etag")));
        fileDownloadModel2.setFilename(cursor6.getString(cursor6.getColumnIndex("filename")));
        fileDownloadModel3.setConnectionCount(cursor5.getInt(cursor5.getColumnIndex("connectionCount")));
        return fileDownloadModel3;
    }

    @Override
    public void onTaskStart(int n2) {
    }

    @Override
    public FileDownloadModel find(int n2) {
        block8: {
            Object[] objectArray;
            String string;
            SQLiteDatabase sQLiteDatabase;
            SqliteDatabaseImpl sqliteDatabaseImpl = sqliteDatabaseImpl2;
            SqliteDatabaseImpl sqliteDatabaseImpl2 = null;
            try {
                sQLiteDatabase = sqliteDatabaseImpl.db;
                string = "SELECT * FROM %s WHERE %s = ?";
                objectArray = new Object[2];
            }
            catch (Throwable throwable) {
                if (sqliteDatabaseImpl2 != null) {
                    sqliteDatabaseImpl2.close();
                }
                throw throwable;
            }
            objectArray[0] = TABLE_NAME;
            objectArray[1] = "_id";
            String string2 = FileDownloadUtils.formatString(string, objectArray);
            String[] stringArray = new String[1];
            int n3 = n2;
            n2 = 0;
            stringArray[n2] = Integer.toString(n3);
            sqliteDatabaseImpl2 = sQLiteDatabase.rawQuery(string2, stringArray);
            if (!sqliteDatabaseImpl2.moveToNext()) break block8;
            FileDownloadModel fileDownloadModel = SqliteDatabaseImpl.createFromCursor((Cursor)sqliteDatabaseImpl2);
            sqliteDatabaseImpl2.close();
            return fileDownloadModel;
        }
        sqliteDatabaseImpl2.close();
        return null;
    }

    @Override
    public List<ConnectionModel> findConnectionModel(int n2) {
        ArrayList arrayList;
        SqliteDatabaseImpl sqliteDatabaseImpl = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Cursor cursor = null;
        SQLiteDatabase sQLiteDatabase = sqliteDatabaseImpl.db;
        String string = "SELECT * FROM %s WHERE %s = ?";
        Object[] objectArray = new Object[2];
        objectArray[0] = CONNECTION_TABLE_NAME;
        objectArray[1] = "id";
        String string2 = FileDownloadUtils.formatString(string, objectArray);
        String[] stringArray = new String[1];
        int n3 = 0;
        try {
            stringArray[n3] = Integer.toString(n2);
            cursor = sQLiteDatabase.rawQuery(string2, stringArray);
        }
        catch (Throwable throwable) {
            if (cursor != null) {
                cursor.close();
            }
            throw throwable;
        }
        while (true) {
            ConnectionModel connectionModel;
            if (!cursor.moveToNext()) break;
            ArrayList arrayList3 = arrayList2;
            ConnectionModel connectionModel2 = connectionModel;
            Cursor cursor2 = cursor;
            Cursor cursor3 = cursor;
            Cursor cursor4 = cursor;
            Cursor cursor5 = cursor;
            connectionModel2();
            connectionModel2.setId(n2);
            connectionModel2.setIndex(cursor5.getInt(cursor5.getColumnIndex("connectionIndex")));
            connectionModel2.setStartOffset(cursor4.getLong(cursor4.getColumnIndex("startOffset")));
            connectionModel2.setCurrentOffset(cursor3.getLong(cursor3.getColumnIndex("currentOffset")));
            connectionModel.setEndOffset(cursor2.getLong(cursor2.getColumnIndex("endOffset")));
            arrayList3.add(connectionModel);
        }
        cursor.close();
        return arrayList2;
    }

    @Override
    public void removeConnections(int n2) {
        this.db.execSQL("DELETE FROM filedownloaderConnection WHERE id = " + n2);
    }

    @Override
    public void insertConnectionModel(ConnectionModel connectionModel) {
        SqliteDatabaseImpl sqliteDatabaseImpl = connectionModel.toContentValues();
        sqliteDatabaseImpl.db.insert(CONNECTION_TABLE_NAME, null, (ContentValues)sqliteDatabaseImpl);
    }

    @Override
    public void updateConnectionModel(int n2, int n3, long l2) {
        ContentValues contentValues;
        SqliteDatabaseImpl sqliteDatabaseImpl = sqliteDatabaseImpl2;
        SqliteDatabaseImpl sqliteDatabaseImpl2 = contentValues;
        sqliteDatabaseImpl2();
        contentValues.put("currentOffset", Long.valueOf(l2));
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray2[0] = Integer.toString(n2);
        stringArray[1] = Integer.toString(n3);
        sqliteDatabaseImpl.db.update(CONNECTION_TABLE_NAME, (ContentValues)sqliteDatabaseImpl2, "id = ? AND connectionIndex = ?", stringArray2);
    }

    @Override
    public void updateConnectionCount(int n2, int n3) {
        ContentValues contentValues;
        SqliteDatabaseImpl sqliteDatabaseImpl = sqliteDatabaseImpl2;
        SqliteDatabaseImpl sqliteDatabaseImpl2 = contentValues;
        sqliteDatabaseImpl2();
        contentValues.put("connectionCount", Integer.valueOf(n3));
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = Integer.toString(n2);
        sqliteDatabaseImpl.db.update(TABLE_NAME, (ContentValues)sqliteDatabaseImpl2, "_id = ? ", stringArray2);
    }

    @Override
    public void insert(FileDownloadModel fileDownloadModel) {
        SqliteDatabaseImpl sqliteDatabaseImpl = fileDownloadModel.toContentValues();
        sqliteDatabaseImpl.db.insert(TABLE_NAME, null, (ContentValues)sqliteDatabaseImpl);
    }

    @Override
    public void update(FileDownloadModel fileDownloadModel) {
        if (fileDownloadModel == null) {
            FileDownloadLog.w(sqliteDatabaseImpl2, "update but model == null!", new Object[0]);
            return;
        }
        if (sqliteDatabaseImpl2.find(fileDownloadModel.getId()) != null) {
            SqliteDatabaseImpl sqliteDatabaseImpl = sqliteDatabaseImpl2;
            SqliteDatabaseImpl sqliteDatabaseImpl2 = fileDownloadModel.toContentValues();
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = String.valueOf(fileDownloadModel.getId());
            sqliteDatabaseImpl.db.update(TABLE_NAME, (ContentValues)sqliteDatabaseImpl2, "_id = ? ", stringArray2);
        } else {
            sqliteDatabaseImpl2.insert(fileDownloadModel);
        }
    }

    @Override
    public boolean remove(int n2) {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = String.valueOf(n2);
        return stringArray2.db.delete(TABLE_NAME, "_id = ?", stringArray2) != 0;
    }

    @Override
    public void clear() {
        SqliteDatabaseImpl sqliteDatabaseImpl = this;
        sqliteDatabaseImpl.db.delete(TABLE_NAME, null, null);
        sqliteDatabaseImpl.db.delete(CONNECTION_TABLE_NAME, null, null);
    }

    @Override
    public void updateOldEtagOverdue(int n2, String string, long l2, long l3, int n3) {
        ContentValues contentValues;
        SqliteDatabaseImpl sqliteDatabaseImpl = this;
        SqliteDatabaseImpl sqliteDatabaseImpl2 = this = contentValues;
        this();
        this.put("sofar", l2);
        sqliteDatabaseImpl2.put("total", l3);
        sqliteDatabaseImpl2.put("etag", string);
        contentValues.put("connectionCount", Integer.valueOf(n3));
        sqliteDatabaseImpl.update(n2, (ContentValues)this);
    }

    @Override
    public void updateConnected(int n2, long l2, String string, String string2) {
        ContentValues contentValues;
        SqliteDatabaseImpl sqliteDatabaseImpl = this;
        SqliteDatabaseImpl sqliteDatabaseImpl2 = this = contentValues;
        sqliteDatabaseImpl2();
        sqliteDatabaseImpl2.put("status", (byte)2);
        contentValues.put("total", Long.valueOf(l2));
        contentValues.put("etag", string);
        contentValues.put("filename", string2);
        sqliteDatabaseImpl.update(n2, (ContentValues)this);
    }

    @Override
    public void updateProgress(int n2, long l2) {
        ContentValues contentValues;
        SqliteDatabaseImpl sqliteDatabaseImpl = this;
        SqliteDatabaseImpl sqliteDatabaseImpl2 = this = contentValues;
        sqliteDatabaseImpl2();
        sqliteDatabaseImpl2.put("status", (byte)3);
        contentValues.put("sofar", Long.valueOf(l2));
        sqliteDatabaseImpl.update(n2, (ContentValues)this);
    }

    @Override
    public void updateError(int n2, Throwable throwable, long l2) {
        ContentValues contentValues;
        SqliteDatabaseImpl sqliteDatabaseImpl = this;
        SqliteDatabaseImpl sqliteDatabaseImpl2 = this = contentValues;
        this();
        sqliteDatabaseImpl2.put("errMsg", throwable.toString());
        sqliteDatabaseImpl2.put("status", (byte)-1);
        contentValues.put("sofar", Long.valueOf(l2));
        sqliteDatabaseImpl.update(n2, (ContentValues)this);
    }

    @Override
    public void updateRetry(int n2, Throwable throwable) {
        ContentValues contentValues;
        SqliteDatabaseImpl sqliteDatabaseImpl = sqliteDatabaseImpl2;
        SqliteDatabaseImpl sqliteDatabaseImpl2 = contentValues;
        sqliteDatabaseImpl2();
        contentValues.put("errMsg", throwable.toString());
        contentValues.put("status", Byte.valueOf((byte)5));
        sqliteDatabaseImpl.update(n2, (ContentValues)sqliteDatabaseImpl2);
    }

    @Override
    public void updateCompleted(int n2, long l2) {
        this.remove(n2);
    }

    @Override
    public void updatePause(int n2, long l2) {
        ContentValues contentValues;
        SqliteDatabaseImpl sqliteDatabaseImpl = this;
        SqliteDatabaseImpl sqliteDatabaseImpl2 = this = contentValues;
        sqliteDatabaseImpl2();
        sqliteDatabaseImpl2.put("status", (byte)-2);
        contentValues.put("sofar", Long.valueOf(l2));
        sqliteDatabaseImpl.update(n2, (ContentValues)this);
    }

    @Override
    public void updatePending(int n2) {
    }

    @Override
    public FileDownloadDatabase.Maintainer maintainer() {
        return new Maintainer();
    }

    public FileDownloadDatabase.Maintainer maintainer(SparseArray<FileDownloadModel> sparseArray, SparseArray<List<ConnectionModel>> sparseArray2) {
        return new Maintainer(sparseArray, sparseArray2);
    }

    public static class Maker
    implements FileDownloadHelper.DatabaseCustomMaker {
        @Override
        public FileDownloadDatabase customMake() {
            return new SqliteDatabaseImpl();
        }
    }

    public class MaintainerIterator
    implements Iterator<FileDownloadModel> {
        private final Cursor c;
        private final List<Integer> needRemoveId = new ArrayList<Integer>();
        private int currentId;

        public MaintainerIterator() {
            this.c = SqliteDatabaseImpl.this.db.rawQuery("SELECT * FROM filedownloader", null);
        }

        @Override
        public boolean hasNext() {
            return this.c.moveToNext();
        }

        @Override
        public FileDownloadModel next() {
            FileDownloadModel fileDownloadModel = SqliteDatabaseImpl.createFromCursor(this.c);
            this.currentId = fileDownloadModel.getId();
            return fileDownloadModel;
        }

        @Override
        public void remove() {
            this.needRemoveId.add(this.currentId);
        }

        public void onFinishMaintain() {
            objectArray3.c.close();
            if (!objectArray3.needRemoveId.isEmpty()) {
                String string = TextUtils.join((CharSequence)", ", objectArray3.needRemoveId);
                if (FileDownloadLog.NEED_LOG) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = string;
                    FileDownloadLog.d(objectArray3, "delete %s", objectArray2);
                }
                Object[] objectArray = new Object[3];
                Object[] objectArray3 = objectArray;
                objectArray[0] = SqliteDatabaseImpl.TABLE_NAME;
                objectArray[1] = "_id";
                objectArray[2] = string;
                objectArray3.SqliteDatabaseImpl.this.db.execSQL(FileDownloadUtils.formatString("DELETE FROM %s WHERE %s IN (%s);", objectArray3));
                Object[] objectArray4 = new Object[3];
                objectArray3 = objectArray4;
                objectArray4[0] = SqliteDatabaseImpl.CONNECTION_TABLE_NAME;
                objectArray4[1] = "id";
                objectArray4[2] = string;
                objectArray3.SqliteDatabaseImpl.this.db.execSQL(FileDownloadUtils.formatString("DELETE FROM %s WHERE %s IN (%s);", objectArray3));
            }
        }
    }

    public class Maintainer
    implements FileDownloadDatabase.Maintainer {
        private final SparseArray<FileDownloadModel> needChangeIdList;
        private MaintainerIterator currentIterator;
        private final SparseArray<FileDownloadModel> downloaderModelMap;
        private final SparseArray<List<ConnectionModel>> connectionModelListMap;

        public Maintainer() {
            this(null, null);
        }

        public Maintainer(SparseArray<FileDownloadModel> sparseArray, SparseArray<List<ConnectionModel>> sparseArray2) {
            SparseArray sparseArray3;
            Maintainer maintainer = sparseArray3;
            sparseArray3 = new SparseArray();
            v1.needChangeIdList = maintainer;
            v1.downloaderModelMap = sparseArray;
            v1.connectionModelListMap = sparseArray2;
        }

        @Override
        public Iterator<FileDownloadModel> iterator() {
            this.currentIterator = new MaintainerIterator();
            return this.currentIterator;
        }

        @Override
        public void onFinishMaintain() {
            block32: {
                Object object;
                int n2;
                int n3;
                MaintainerIterator maintainerIterator = this.currentIterator;
                if (maintainerIterator != null) {
                    maintainerIterator.onFinishMaintain();
                }
                if ((n3 = this.needChangeIdList.size()) < 0) {
                    return;
                }
                SqliteDatabaseImpl.this.db.beginTransaction();
                block27: for (n2 = 0; n2 < n3; ++n2) {
                    Maintainer maintainer = this;
                    Maintainer maintainer2 = maintainer;
                    int n4 = maintainer.needChangeIdList.keyAt(n2);
                    object = (FileDownloadModel)maintainer2.needChangeIdList.get(n4);
                    Maintainer maintainer3 = this;
                    Maintainer maintainer4 = maintainer3;
                    SQLiteDatabase sQLiteDatabase = maintainer3.SqliteDatabaseImpl.this.db;
                    String string = SqliteDatabaseImpl.TABLE_NAME;
                    String string2 = "_id = ?";
                    String[] stringArray = new String[1];
                    int n5 = 0;
                    stringArray[n5] = String.valueOf(n4);
                    sQLiteDatabase.delete(string, string2, stringArray);
                    SQLiteDatabase sQLiteDatabase2 = maintainer4.SqliteDatabaseImpl.this.db;
                    Object object2 = object;
                    Object object3 = SqliteDatabaseImpl.TABLE_NAME;
                    String string3 = null;
                    ContentValues contentValues = ((FileDownloadModel)object2).toContentValues();
                    sQLiteDatabase2.insert((String)object3, string3, contentValues);
                    if (((FileDownloadModel)object).getConnectionCount() <= 1) continue;
                    object3 = SqliteDatabaseImpl.this.findConnectionModel(n4);
                    if (object3.size() <= 0) continue;
                    Object object4 = object3;
                    SQLiteDatabase sQLiteDatabase3 = SqliteDatabaseImpl.this.db;
                    String string4 = SqliteDatabaseImpl.CONNECTION_TABLE_NAME;
                    String string5 = "id = ?";
                    String[] stringArray2 = new String[1];
                    int n6 = n4;
                    n4 = 0;
                    stringArray2[n4] = String.valueOf(n6);
                    sQLiteDatabase3.delete(string4, string5, stringArray2);
                    Iterator iterator = object4.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block27;
                        Maintainer maintainer5 = this;
                        object3 = (ConnectionModel)iterator.next();
                        ((ConnectionModel)object3).setId(((FileDownloadModel)object).getId());
                        SQLiteDatabase sQLiteDatabase4 = maintainer5.SqliteDatabaseImpl.this.db;
                        Object object5 = object3;
                        object3 = SqliteDatabaseImpl.CONNECTION_TABLE_NAME;
                        string3 = null;
                        contentValues = ((ConnectionModel)object5).toContentValues();
                        sQLiteDatabase4.insert((String)object3, string3, contentValues);
                    }
                }
                SparseArray<FileDownloadModel> sparseArray = this.downloaderModelMap;
                if (sparseArray == null) break block32;
                if (this.connectionModelListMap == null) break block32;
                int n7 = sparseArray.size();
                for (n2 = 0; n2 < n7; ++n2) {
                    Maintainer maintainer = this;
                    Maintainer maintainer6 = maintainer;
                    int n8 = ((FileDownloadModel)maintainer.downloaderModelMap.valueAt(n2)).getId();
                    object = maintainer6.SqliteDatabaseImpl.this.findConnectionModel(n8);
                    if (object == null) continue;
                    if (object.size() <= 0) continue;
                    this.connectionModelListMap.put(n8, object);
                }
            }
            try {
                Maintainer maintainer = this;
                maintainer.SqliteDatabaseImpl.this.db.setTransactionSuccessful();
                maintainer.SqliteDatabaseImpl.this.db.endTransaction();
                return;
            }
            catch (Throwable throwable) {
                SqliteDatabaseImpl.this.db.endTransaction();
                throw throwable;
            }
        }

        @Override
        public void onRemovedInvalidData(FileDownloadModel fileDownloadModel) {
        }

        @Override
        public void onRefreshedValidData(FileDownloadModel fileDownloadModel) {
            SparseArray<FileDownloadModel> sparseArray = sparseArray.downloaderModelMap;
            if (sparseArray != null) {
                sparseArray.put(fileDownloadModel.getId(), (Object)fileDownloadModel);
            }
        }

        @Override
        public void changeFileDownloadModelId(int n2, FileDownloadModel fileDownloadModel) {
            this.needChangeIdList.put(n2, (Object)fileDownloadModel);
        }
    }
}

