/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;

public class SqliteDatabaseOpenHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "filedownloader.db";
    private static final int DATABASE_VERSION = 3;

    public SqliteDatabaseOpenHelper(Context context) {
        super(context, DATABASE_NAME, null, 3);
    }

    public void onOpen(SQLiteDatabase sQLiteDatabase) {
        super.onOpen(sQLiteDatabase);
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 16) {
            this.setWriteAheadLoggingEnabled(true);
        } else if (n2 >= 11) {
            sQLiteDatabase.enableWriteAheadLogging();
        }
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        sQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS filedownloader( _id INTEGER PRIMARY KEY, url VARCHAR, path VARCHAR, status TINYINT(7), sofar INTEGER, total INTEGER, errMsg VARCHAR, etag VARCHAR, pathAsDirectory TINYINT(1) DEFAULT 0, filename VARCHAR, connectionCount INTEGER DEFAULT 1)");
        sQLiteDatabase2.execSQL("CREATE TABLE IF NOT EXISTS filedownloaderConnection( id INTEGER, connectionIndex INTEGER, startOffset INTEGER, currentOffset INTEGER, endOffset INTEGER, PRIMARY KEY ( id, connectionIndex ))");
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
        if (n2 < 2) {
            SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
            sQLiteDatabase2.execSQL("ALTER TABLE filedownloader ADD COLUMN pathAsDirectory TINYINT(1) DEFAULT 0");
            sQLiteDatabase2.execSQL("ALTER TABLE filedownloader ADD COLUMN filename VARCHAR");
        }
        if (n2 < 3) {
            SQLiteDatabase sQLiteDatabase3 = sQLiteDatabase;
            sQLiteDatabase3.execSQL("ALTER TABLE filedownloader ADD COLUMN connectionCount INTEGER DEFAULT 1");
            sQLiteDatabase3.execSQL("CREATE TABLE IF NOT EXISTS filedownloaderConnection( id INTEGER, connectionIndex INTEGER, startOffset INTEGER, currentOffset INTEGER, endOffset INTEGER, PRIMARY KEY ( id, connectionIndex ))");
        }
    }

    public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        sQLiteDatabase2.delete("filedownloader", null, null);
        sQLiteDatabase2.delete("filedownloaderConnection", null, null);
    }
}

